/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.dispersionCoeff.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.wq.client.dispersionCoeff.client.DispersionCoefEditor;
import hec.rss.wq.client.dispersionCoeff.client.DispersionReachTableModel;
import hec.rss.wq.client.dispersionCoeff.client.ReachPanel$1;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.dispersion.ReachDispersionType;
import hec.wqenginecore.dispersion.ValueByReachType;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.TableModel;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJTable;

public class ReachPanel
extends AbstractEditorPanel {
    private static final Logger e = Logger.getLogger(DispersionCoefEditor.class.getName());
    protected static final int a = 0;
    protected static final int b = 1;
    protected static final int c = 2;
    protected static final int d = 3;
    private String _tabName;
    private JRadioButton _globalRadio;
    private RmaJDecimalField _globalCoefFld;
    private JRadioButton _byReachRadio;
    private EnabledJPanel _byReachPanel;
    private JRadioButton _constantRadio;
    private JRadioButton _interpolatedRadio;
    private RmaJTable _reachTable;
    private DispersionSetManager _currentDispersionSet;
    private DispersionReachTableModel _tableModel;
    private Integer _precision;
    private DispersionCoefEditor _editor;

    public ReachPanel(DispersionCoefEditor dispersionCoefEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = dispersionCoefEditor;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        Object object;
        this._precision = Integer.getInteger("Dispersion.Reach.Precision", 3);
        this._tabName = WqI18n.a("Dispersion.ReachPanel.TabName").getText();
        Object object2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)object2, gridBagConstraints);
        this._globalRadio = WqI18n.a("Dispersion.ReachPanel.Radio.Global").createJRadioButton();
        this._globalRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object2).add((Component)this._globalRadio, gridBagConstraints);
        this._globalCoefFld = new RmaJDecimalField();
        this._globalCoefFld.setPrecision(this._precision.intValue());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object2).add((Component)this._globalCoefFld, gridBagConstraints);
        this._byReachRadio = WqI18n.a("Dispersion.ReachPanel.Radio.ByReach").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ((Container)object2).add((Component)this._byReachRadio, gridBagConstraints);
        this._byReachPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)20, (int)0, (int)0);
        ((Container)object2).add((Component)this._byReachPanel, gridBagConstraints);
        object2 = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._byReachPanel.add((Component)object2, (Object)gridBagConstraints);
        EnabledJPanel enabledJPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._byReachPanel.add((Component)enabledJPanel, (Object)gridBagConstraints);
        String string = WqI18n.a("Dispersion.ReachPanel.Label.Equation").getText();
        ImageIcon imageIcon = null;
        try {
            object = ImageIO.read(((Object)((Object)this)).getClass().getClassLoader().getResource(string));
            imageIcon = new ImageIcon((Image)object);
        }
        catch (IOException | IllegalArgumentException exception) {
            e.log(Level.SEVERE, "Exception loading image " + string, exception);
        }
        object = new JLabel(imageIcon);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)55, (int)0, (int)5);
        enabledJPanel.add((Component)object, gridBagConstraints);
        this._constantRadio = WqI18n.a("Dispersion.ReachPanel.Radio.ReachConstant").createJRadioButton();
        this._constantRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ((Container)object2).add((Component)this._constantRadio, gridBagConstraints);
        this._interpolatedRadio = WqI18n.a("Dispersion.ReachPanel.Radio.ReachInterpolated").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ((Container)object2).add((Component)this._interpolatedRadio, gridBagConstraints);
        object2 = new String[]{WqI18n.a("Dispersion.ReachPanel.Header.Reach").getText(), WqI18n.a("Dispersion.ReachPanel.Header.Dispersion").getText(), WqI18n.a("Dispersion.ReachPanel.Header.LowerEnd").getText(), WqI18n.a("Dispersion.ReachPanel.Header.UpperEnd").getText()};
        ReachPanel reachPanel = this;
        this._reachTable = new ReachPanel$1(reachPanel, (Component)((Object)reachPanel), (Object[])object2);
        this._reachTable.setModel((TableModel)((Object)new DispersionReachTableModel(null)));
        this._reachTable.removePopupMenuInsertAppendOnly();
        this._reachTable.removePopupMenuSumOptions();
        this._reachTable.setRowHeight(this._reachTable.getRowHeight() + 5);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReachPanel reachPanel2 = this;
        reachPanel2.add(reachPanel2._reachTable.getScrollPane(), gridBagConstraints);
        object2 = new ButtonGroup();
        ((ButtonGroup)object2).add(this._byReachRadio);
        ((ButtonGroup)object2).add(this._globalRadio);
        object2 = new ButtonGroup();
        ((ButtonGroup)object2).add(this._constantRadio);
        ((ButtonGroup)object2).add(this._interpolatedRadio);
        this.radioAction();
        this._reachTable.repaint();
    }

    private void addListeners() {
        this._globalRadio.addActionListener(actionEvent -> this.radioAction());
        this._byReachRadio.addActionListener(actionEvent -> this.radioAction());
        this._constantRadio.addActionListener(actionEvent -> this.interpRadioAction());
        this._interpolatedRadio.addActionListener(actionEvent -> this.interpRadioAction());
    }

    private void interpRadioAction() {
        this._reachTable.commitEdit(true);
        this._reachTable.repaint();
    }

    private void radioAction() {
        boolean bl = this._globalRadio.isSelected();
        this._globalCoefFld.setEnabled(bl);
        this._byReachPanel.setEnabled(!bl);
        this._reachTable.repaint();
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType object) {
        this._currentDispersionSet = null;
        if (object instanceof ManagerProxyWrapper) {
            this.setEnabled(true);
            object = (ManagerProxyWrapper)((Object)object);
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            object = (DispersionSetManager)object.loadManager(null, null);
            if (object != null) {
                this._currentDispersionSet = object;
                if ((object = ((DispersionSetManager)object).getSet()) != null) {
                    ReachDispersionType reachDispersionType = (object = object.getReachSettings()).getDispersionType();
                    if (ReachDispersionType.BY_REACH == reachDispersionType) {
                        this._byReachRadio.doClick(0);
                    } else {
                        this._globalRadio.doClick(0);
                    }
                    reachDispersionType = object.getValueByReachType();
                    if (ValueByReachType.LINEAR_INTERP == reachDispersionType) {
                        this._interpolatedRadio.doClick(0);
                    } else {
                        this._constantRadio.doClick(0);
                    }
                    this.radioAction();
                    this._globalCoefFld.setValue(object.getGlobalValue());
                    this._tableModel = new DispersionReachTableModel(this._currentDispersionSet);
                    this._reachTable.setModel((TableModel)((Object)this._tableModel));
                    this.setTableEditors();
                    this.setModified(false);
                }
            }
        }
    }

    private void setTableEditors() {
        for (int i = 1; i < this._reachTable.getColumnCount(); ++i) {
            this._reachTable.setDoubleCellEditor(i);
            this._reachTable.setColumnPrecision(i, 3);
        }
        this._reachTable.setUnitsHeaderRenderer();
    }

    public boolean savePanel(NamedType namedType) {
        Object object = this._currentDispersionSet;
        if (namedType instanceof DispersionSetManager) {
            object = (DispersionSetManager)namedType;
        }
        if (object == null) {
            return true;
        }
        this._reachTable.commitEdit(true);
        namedType = ((DispersionSetManager)object).getSet();
        namedType = namedType.getReachSettings();
        if (this._byReachRadio.isSelected()) {
            namedType.setDispersionType(ReachDispersionType.BY_REACH);
        } else {
            namedType.setDispersionType(ReachDispersionType.GLOBAL);
        }
        if (this._interpolatedRadio.isSelected()) {
            namedType.setValueByReachType(ValueByReachType.LINEAR_INTERP);
        } else {
            namedType.setValueByReachType(ValueByReachType.CONSTANT);
        }
        namedType.setGlobalValue(this._globalCoefFld.getValue());
        object = this._tableModel.getReachValues();
        namedType.setReachValues((List)object);
        this.setModified(false);
        this._currentDispersionSet.setModified(true);
        return true;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.radioAction();
            this._reachTable.repaint();
        }
    }
}

