/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.dispersionCoeff.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.dispersionCoeff.client.DispersionCoefEditor;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$1;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$2;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$3;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$4;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$5;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$6;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$MixedLayerToleranceConvertableUnitsLabel;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel$WQSubDomainBoundaryRefWrapper;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.ui.TruncatedZerosDecimalField;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.dispersion.AlternateMixingMethod;
import hec.wqenginecore.dispersion.EntrainmentCalculationType;
import hec.wqenginecore.dispersion.MunkAndersonDispersionData;
import hec.wqenginecore.dispersion.ReservoirDispersionEntrainmentSettings;
import hec.wqenginecore.dispersion.ReservoirDispersionSettings;
import hec.wqenginecore.dispersion.ReservoirEntrainmentInflowSetting;
import hec.wqenginecore.dispersion.StabilityDispersionData;
import hec.wqenginecore.dispersion.VerticalMixingType;
import hec.wqenginecore.dispersion.WindDispersionData;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqengineimpl.dispersion.WQDispersionCoefSettings;
import hec.wqengineimpl.dispersion.WQReservoirDispersionEntrainmentSettingsBuilder;
import hec.wqengineimpl.dispersion.WQReservoirDispersionSettings;
import hec.wqengineimpl.dispersion.WQReservoirEntrainmentInflowSettingBuilder;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQGeoSubDomainBoundary;
import hec.wqengineimpl.geometry.WQGeometry;
import hec.wqengineimpl.geometry.WQSubDomainBoundaryRef;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.UnitsConversionException;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaNavigationPanel;
import rma.swing.list.RmaListModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ReservoirPanel
extends AbstractEditorPanel {
    public static final String MIXED_LAYER_TOLERANCE_ALLOW_UNIT_CONVERSION_PROPERTY = "Dispersion.ReservoirPanel.MixedLayerTolerance.AllowUnitConversion";
    private static final Logger a = Logger.getLogger(DispersionCoefEditor.class.getName());
    private static final int b = Parameter.getParameterForUnitsString((String)"deg").getParameterId();
    public static final String MIXED_TOL_UNITS_NUMERATOR_SI = "kgs";
    public static final String MIXED_TOL_UNITS_NUMERATOR_ENGLISH = "lbs";
    private final boolean _allowMixedLayerToleranceUnitConversion;
    private String _tabName;
    private DispersionCoefEditor _editor;
    private RmaJComboBox<SubDomain> _reservoirCombo;
    private JRadioButton _fromProfileRadio;
    private JRadioButton _alternateRadio;
    private EnabledJPanel _alternatePanel;
    private RmaJComboBox<String> _methodCombo;
    private JPanel _stabilityPanel;
    private RmaJDecimalField _stabilityEcritFld;
    private RmaJDecimalField _stabilityA1Fld;
    private RmaJDecimalField _stabilityA3Fld;
    private JPanel _windPanel;
    private RmaJDecimalField _windDzminFld;
    private RmaJDecimalField _windA1Fld;
    private RmaJDecimalField _windAzFld;
    private RmaJCheckBox _useWindDzmaxFlgCheckBox;
    private RmaJDecimalField _windDzmaxFld;
    private JPanel _munkAndersonPanel;
    private RmaJDecimalField _munkAndersonAFld;
    private RmaJDecimalField _munkAndersonBFld;
    private RmaJDecimalField _munkAndersonCFld;
    private RmaJDecimalField _munkAndersonDzminFld;
    private DispersionSetManager _currentDispersionSet;
    private Integer _defaultPrecision;
    private WQGeoSubDomain _currentRes;
    private Map<WQGeoSubDomain, WQReservoirDispersionSettings> _settingsMap = new HashMap<WQGeoSubDomain, WQReservoirDispersionSettings>();
    private RmaNavigationPanel _resNavPanel;
    private int _newUnitSystem = ClientApp.Workspace().getUnitSystem();
    private int _prevSystemUsed = ClientApp.Workspace().getUnitSystem();
    private RmaJCheckBox _sameSettingsForAllInflowsCheckbox;
    private RmaJComboBox<ReservoirPanel$WQSubDomainBoundaryRefWrapper> _inflowComboBox;
    private RmaNavigationPanel _inflowNavPanel;
    private RmaJRadioButton _useEntrainmentRadioButton;
    private RmaJRadioButton _dontUseEntrainmentRadioButton;
    private RmaJDecimalField _entrainmentInitialMixingRatioField;
    private RmaJDecimalField _entrainmentRateField;
    private RmaJDecimalField _entrainmentStreamSlopeField;
    private RmaJDecimalField _entrainmentStreamCrossSectionHalfAngleField;
    private RmaJCheckBox _useMaxInflowEnvelopeHeightCheckBox;
    private RmaJCheckBox _useMaxOutflowEnvelopeHeightCheckBox;
    private RmaJDecimalField _maxInflowEnvelopeHeightField;
    private RmaJDecimalField _maxOutflowEnvelopeHeightField;
    private RmaJComboBox<EntrainmentCalculationType> _entrainementRateCalculationTypeCombobox;
    private RmaJComboBox<EntrainmentCalculationType> _streamSlopeRateCalculationTypeCombobox;
    private List<WQGeoSubDomainBoundary> _currentInflows;
    private Map<Integer, ReservoirEntrainmentInflowSetting> _inflowIdToSettingMap = new HashMap<Integer, ReservoirEntrainmentInflowSetting>();
    private EnabledJPanel _lowerPanel;
    private EnabledJPanel _equationPanel;
    private TruncatedZerosDecimalField _mixedLayerToleranceField;

    public ReservoirPanel(DispersionCoefEditor dispersionCoefEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = dispersionCoefEditor;
        this._allowMixedLayerToleranceUnitConversion = Boolean.getBoolean(MIXED_LAYER_TOLERANCE_ALLOW_UNIT_CONVERSION_PROPERTY);
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("Dispersion.ReservoirPanel.TabName").getText();
        this._defaultPrecision = Integer.getInteger("Dispersion.Reservoir.Precision", 3);
        JLabel jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.Reservoir").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.add(jLabel, gridBagConstraints);
        this._reservoirCombo = new RmaJComboBox();
        jLabel.setLabelFor((Component)this._reservoirCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ReservoirPanel reservoirPanel = this;
        reservoirPanel.add((Component)reservoirPanel._reservoirCombo, gridBagConstraints);
        this._resNavPanel = new RmaNavigationPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ReservoirPanel reservoirPanel2 = this;
        reservoirPanel2.add((Component)reservoirPanel2._resNavPanel, gridBagConstraints);
        jLabel = new JLabel(" ");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.add(jLabel, gridBagConstraints);
        jLabel = this.buildVertDiffusionPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        jLabel = this.buildEntrainmentPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        jLabel = this.buildEnvelopeHeightLimitsPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.add(jLabel, gridBagConstraints);
        jLabel = this.buildMixedLayerTolerancePanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.add(jLabel, gridBagConstraints);
        this.methodComboChanged();
        this.radioAction();
        this._resNavPanel.fillForm(this._reservoirCombo);
    }

    private RmaJPanel buildMixedLayerTolerancePanel() {
        int n = ClientApp.Workspace().getUnitSystem();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)new TitledBorder(WqI18n.a("Dispersion.ReservoirPanel.MixedLayerTolerance.Border.Title").getText()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        Object object = WqI18n.a("Dispersion.ReservoirPanel.MixedLayerTolerance.DefaultLabel").createJLabel();
        if (this._allowMixedLayerToleranceUnitConversion) {
            object = new ReservoirPanel$MixedLayerToleranceConvertableUnitsLabel(WqI18n.a("Dispersion.ReservoirPanel.MixedLayerTolerance.Label").getText());
        }
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        rmaJPanel2.add((Component)object, (Object)gridBagConstraints);
        this._mixedLayerToleranceField = new TruncatedZerosDecimalField();
        if (this._allowMixedLayerToleranceUnitConversion) {
            this._mixedLayerToleranceField = new ReservoirPanel$1(this);
            this._mixedLayerToleranceField.setValue(new ParamDouble(0.0, Parameter.PARAMID_AREA, n, 3));
        }
        this._mixedLayerToleranceField.setName(((Component)object).getName());
        ((JLabel)object).setLabelFor((Component)((Object)this._mixedLayerToleranceField));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        rmaJPanel2.add((Component)((Object)this._mixedLayerToleranceField), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        rmaJPanel.add((Component)new JLabel(""), (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private RmaJPanel buildVertDiffusionPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)new TitledBorder(WqI18n.a("Dispersion.ReservoirPanel.VertDiffusion.Border.Title").getText()));
        Serializable serializable = new GridBagConstraints();
        this._lowerPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        EnabledJPanel enabledJPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._lowerPanel, (Object)serializable);
        Object object = WqI18n.a("Dispersion.ReservoirPanel.Label.Method").createJLabel();
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        enabledJPanel.add((Component)object, serializable);
        Object[] objectArray = new String[]{WqI18n.a("Dispersion.ReservoirPanel.Method.Stability").getText(), WqI18n.a("Dispersion.ReservoirPanel.Method.Wind").getText(), WqI18n.a("Dispersion.ReservoirPanel.Method.MunkAnderson").getText()};
        this._methodCombo = new RmaJComboBox(objectArray);
        this._methodCombo.setModifiable(true);
        ((JLabel)object).setLabelFor((Component)this._methodCombo);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        enabledJPanel.add((Component)this._methodCombo, serializable);
        this._alternatePanel = new EnabledJPanel((LayoutManager)new CardLayout());
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS0500;
        enabledJPanel.add((Component)this._alternatePanel, serializable);
        this._equationPanel = new EnabledJPanel((LayoutManager)new CardLayout());
        object = WqI18n.a("Dispersion.ReservoirPanel.StabilityEquation").getText();
        this._equationPanel.add(WqI18n.a("Dispersion.ReservoirPanel.Method.Stability").getText(), (Component)this.buildEquationPanel((String)object));
        object = WqI18n.a("Dispersion.ReservoirPanel.Label.WindEquation").getText();
        this._equationPanel.add(WqI18n.a("Dispersion.ReservoirPanel.Method.Wind").getText(), (Component)this.buildEquationPanel((String)object));
        object = WqI18n.a("Dispersion.ReservoirPanel.Label.MAEquation").getText();
        this._equationPanel.add(WqI18n.a("Dispersion.ReservoirPanel.Method.MunkAnderson").getText(), (Component)this.buildEquationPanel((String)object));
        this.buildStabilityPanel();
        this.buildWindPanel();
        this.buildMunkAndersonPanel();
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS0000;
        this._lowerPanel.add((Component)enabledJPanel, (Object)serializable);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS0000;
        this._lowerPanel.add((Component)this._equationPanel, (Object)serializable);
        this._alternatePanel.add((String)objectArray[0], (Component)this._stabilityPanel);
        this._alternatePanel.add((String)objectArray[1], (Component)this._windPanel);
        this._alternatePanel.add((String)objectArray[2], (Component)this._munkAndersonPanel);
        this._fromProfileRadio = WqI18n.a("Dispersion.ReservoirPanel.Radio.FromProfile").createJRadioButton();
        this._alternateRadio = WqI18n.a("Dispersion.ReservoirPanel.Radio.Alternate").createJRadioButton();
        this._alternateRadio.setSelected(true);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._alternateRadio);
        ((ButtonGroup)serializable).add(this._fromProfileRadio);
        return rmaJPanel;
    }

    private RmaJPanel buildEntrainmentPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)new TitledBorder(WqI18n.a("Dispersion.ReservoirPanel.Entrainment.Border.Title").getText()));
        this._sameSettingsForAllInflowsCheckbox = new RmaJCheckBox(WqI18n.a("Dispersion.ReservoirPanel.Entrainment.SameSettings.Label").getText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._sameSettingsForAllInflowsCheckbox, (Object)gridBagConstraints);
        Object object = new RmaJPanel((LayoutManager)new GridBagLayout());
        JLabel jLabel = WqI18n.a("Dispersion.ReservoirPanel.Entrainment.Inflow.Label").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)jLabel, (Object)gridBagConstraints);
        this._inflowComboBox = new RmaJComboBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._inflowComboBox, gridBagConstraints);
        this._inflowNavPanel = new RmaNavigationPanel();
        this._inflowNavPanel.fillForm(this._inflowComboBox);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._inflowNavPanel, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel2.add((Component)object, (Object)gridBagConstraints);
        object = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._useEntrainmentRadioButton = new RmaJRadioButton(WqI18n.a("Dispersion.ReservoirPanel.Entrainment.UseEntrainment.Label").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        object.add((Component)this._useEntrainmentRadioButton, (Object)gridBagConstraints);
        this._dontUseEntrainmentRadioButton = new RmaJRadioButton(WqI18n.a("Dispersion.ReservoirPanel.Entrainment.DontUseEntrainment.Label").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        object.add((Component)this._dontUseEntrainmentRadioButton, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel2.add((Component)object, (Object)gridBagConstraints);
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._useEntrainmentRadioButton);
        ((ButtonGroup)object).add((AbstractButton)this._dontUseEntrainmentRadioButton);
        this._useEntrainmentRadioButton.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)new JLabel(""), (Object)gridBagConstraints);
        rmaJPanel2 = this.buildInflowEntrainmentFieldsPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private RmaJPanel buildInflowEntrainmentFieldsPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        JLabel jLabel = WqI18n.a("Dispersion.ReservoirPanel.Entrainment.InitialMixingRatio.Label").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)jLabel, (Object)gridBagConstraints);
        this._entrainmentInitialMixingRatioField = new RmaJDecimalField();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._entrainmentInitialMixingRatioField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        jLabel = new RmaJPanel((LayoutManager)new GridBagLayout());
        JLabel jLabel2 = new JLabel(WqI18n.a("Dispersion.ReservoirPanel.Entrainment.StreamSlope.Label").getText() + "   ");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jLabel.add(jLabel2, gridBagConstraints);
        this._streamSlopeRateCalculationTypeCombobox = new RmaJComboBox();
        this._streamSlopeRateCalculationTypeCombobox.setModifiable(true);
        this._streamSlopeRateCalculationTypeCombobox.setPrototypeDisplayValue((Object)EntrainmentCalculationType.USER_DEFINED);
        jLabel2 = new RmaListModel();
        jLabel2.addAll(EntrainmentCalculationType.values());
        this._streamSlopeRateCalculationTypeCombobox.setModel((ComboBoxModel)((Object)jLabel2));
        this._streamSlopeRateCalculationTypeCombobox.setSelectedItem((Object)EntrainmentCalculationType.CALCULATED);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        jLabel.add((Component)this._streamSlopeRateCalculationTypeCombobox, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel2.add((Component)jLabel, (Object)gridBagConstraints);
        this._entrainmentStreamSlopeField = new RmaJDecimalField();
        this._entrainmentStreamSlopeField.setMinValue(1.0E-4);
        this._entrainmentStreamSlopeField.setMaxValue(0.1);
        this._entrainmentStreamSlopeField.setPrecision(4);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._entrainmentStreamSlopeField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        jLabel = new RmaJPanel((LayoutManager)new GridBagLayout());
        jLabel2 = WqI18n.a("Dispersion.ReservoirPanel.Entrainment.EntrainmentRate.Label").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jLabel.add(jLabel2, gridBagConstraints);
        this._entrainementRateCalculationTypeCombobox = new RmaJComboBox();
        this._entrainementRateCalculationTypeCombobox.setModifiable(true);
        this._entrainementRateCalculationTypeCombobox.setPrototypeDisplayValue((Object)EntrainmentCalculationType.USER_DEFINED);
        jLabel2 = new RmaListModel();
        jLabel2.addAll(EntrainmentCalculationType.values());
        this._entrainementRateCalculationTypeCombobox.setModel((ComboBoxModel)((Object)jLabel2));
        this._entrainementRateCalculationTypeCombobox.setSelectedItem((Object)EntrainmentCalculationType.CALCULATED);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jLabel.add((Component)this._entrainementRateCalculationTypeCombobox, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel2.add((Component)jLabel, (Object)gridBagConstraints);
        this._entrainmentRateField = new RmaJDecimalField();
        this._entrainmentRateField.setPrecision(6);
        this._entrainmentRateField.setMinValue(0.0);
        this._entrainmentRateField.setMaxValue(0.1);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._entrainmentRateField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0050;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        jLabel = new RmaJLabel(WqI18n.a("Dispersion.ReservoirPanel.Entrainment.StreamCrossSection.Label").getText());
        jLabel.setLabelFor((Component)this._entrainmentStreamCrossSectionHalfAngleField);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        rmaJPanel2.add((Component)jLabel, (Object)gridBagConstraints);
        this._entrainmentStreamCrossSectionHalfAngleField = new RmaJDecimalField();
        this._entrainmentStreamCrossSectionHalfAngleField.setMinValue(10.0);
        this._entrainmentStreamCrossSectionHalfAngleField.setMaxValue(89.0);
        jLabel.setLabelFor((Component)this._entrainmentStreamCrossSectionHalfAngleField);
        this._entrainmentStreamCrossSectionHalfAngleField.setValue(new ParamDouble(-3.4028234663852886E38, b, ClientApp.Workspace().getUnitSystem(), this._defaultPrecision.intValue()));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        rmaJPanel2.add((Component)this._entrainmentStreamCrossSectionHalfAngleField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0050;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private RmaJPanel buildEnvelopeHeightLimitsPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)new TitledBorder(WqI18n.a("Dispersion.ReservoirPanel.EnvelopeHeightLimits.Border.Title").getText()));
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._useMaxInflowEnvelopeHeightCheckBox = new RmaJCheckBox(WqI18n.a("Dispersion.ReservoirPanel.EnvelopeHeightLimits.MaxInflow.Label").getText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._useMaxInflowEnvelopeHeightCheckBox, (Object)gridBagConstraints);
        this._maxInflowEnvelopeHeightField = new RmaJDecimalField();
        this._useMaxInflowEnvelopeHeightCheckBox.setLabelFor((Component)this._maxInflowEnvelopeHeightField);
        this._maxInflowEnvelopeHeightField.setValue(new ParamDouble(-3.4028234663852886E38, Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem(), this._defaultPrecision.intValue()));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._maxInflowEnvelopeHeightField, (Object)gridBagConstraints);
        RmaJPanel rmaJPanel3 = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._useMaxOutflowEnvelopeHeightCheckBox = new RmaJCheckBox(WqI18n.a("Dispersion.ReservoirPanel.EnvelopeHeightLimits.MaxOutflow.Label").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel3.add((Component)this._useMaxOutflowEnvelopeHeightCheckBox, (Object)gridBagConstraints);
        this._maxOutflowEnvelopeHeightField = new RmaJDecimalField();
        this._useMaxOutflowEnvelopeHeightCheckBox.setLabelFor((Component)this._maxOutflowEnvelopeHeightField);
        this._maxOutflowEnvelopeHeightField.setValue(new ParamDouble(-3.4028234663852886E38, Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem(), this._defaultPrecision.intValue()));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel3.add((Component)this._maxOutflowEnvelopeHeightField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel3, (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private void buildStabilityPanel() {
        this._stabilityPanel = new JPanel(new GridBagLayout());
        int n = ClientApp.Workspace().getUnitSystem();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        this._stabilityPanel.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.StabilityEcrit").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._stabilityEcritFld = new ReservoirPanel$2(this);
        this._stabilityEcritFld.setValue(new ParamDouble(0.0, Parameter.PARAMID_LENGTH, n, this._defaultPrecision.intValue()));
        this._stabilityEcritFld.setName(jLabel.getName());
        this._stabilityEcritFld.setMinValue(0.0);
        this._stabilityEcritFld.setMaxValue(2.0E-4);
        jLabel.setLabelFor((Component)this._stabilityEcritFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._stabilityEcritFld, gridBagConstraints);
        jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.StabilityA1").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._stabilityA1Fld = new TruncatedZerosDecimalField();
        this._stabilityA1Fld.setValue(new ParamDouble(0.0, Parameter.PARAMID_STAGE, n, this._defaultPrecision.intValue()));
        this._stabilityA1Fld.setName(jLabel.getName());
        this._stabilityA1Fld.setMinValue(0.0);
        this._stabilityA1Fld.setMaxValue(0.003);
        jLabel.setLabelFor((Component)this._stabilityA1Fld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0555;
        jPanel.add((Component)this._stabilityA1Fld, gridBagConstraints);
        jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.StabilityA3").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._stabilityA3Fld = new TruncatedZerosDecimalField();
        this._stabilityA3Fld.setValue(0.0);
        this._stabilityA3Fld.setName(jLabel.getName());
        this._stabilityA3Fld.setMinValue(0.0);
        this._stabilityA3Fld.setMaxValue(4.0);
        jLabel.setLabelFor((Component)this._stabilityA3Fld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._stabilityA3Fld, gridBagConstraints);
        jLabel = new JLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
    }

    private String convertStabilityECritText(String string, double d) {
        double d2;
        if (string == null || string.isEmpty()) {
            string = String.format("%.7f", d);
        }
        if ((d2 = RMAIO.parseDouble((String)string)) == Double.NEGATIVE_INFINITY) {
            string = "";
        } else {
            try {
                if (this._prevSystemUsed != this._newUnitSystem) {
                    d2 = UnitUtil.convertUnits((double)d2, (int)Parameter.PARAMID_LENGTH, (int)this._newUnitSystem, (int)this._prevSystemUsed);
                    string = String.format("%.7f", d2);
                }
            }
            catch (UnitsConversionException unitsConversionException) {
                String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_LENGTH, (int)this._newUnitSystem);
                String string3 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_LENGTH, (int)this._prevSystemUsed);
                a.log(Level.WARNING, unitsConversionException, () -> "Failed to convert units from " + string2 + " to " + string3);
            }
        }
        return string;
    }

    private String convertMixedLayerToleranceText(String string, double d) {
        double d2;
        if (string == null || string.isEmpty()) {
            string = String.format("%.4f", d);
        }
        if ((d2 = RMAIO.parseDouble((String)string)) == Double.NEGATIVE_INFINITY) {
            string = "";
        } else {
            d2 = this._newUnitSystem == 2 ? (d2 *= 4.882423653736196) : (d2 *= 0.2048163106933103);
            string = String.format("%.4f", d2);
        }
        return string;
    }

    private void buildWindPanel() {
        this._windPanel = new JPanel(new GridBagLayout());
        int n = ClientApp.Workspace().getUnitSystem();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        this._windPanel.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.WindDzmin").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._windDzminFld = new TruncatedZerosDecimalField();
        this._windDzminFld.setValue(new ParamDouble(0.0, Parameter.PARAMID_STAGE, n));
        this._windDzminFld.setName(jLabel.getName());
        this._windDzminFld.setMinValue(0.0);
        this._windDzminFld.setPrecision(this._defaultPrecision.intValue());
        jLabel.setLabelFor((Component)this._windDzminFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._windDzminFld, gridBagConstraints);
        jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.WindA1").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._windA1Fld = new TruncatedZerosDecimalField();
        this._windA1Fld.setValue(new ParamDouble(0.0, Parameter.PARAMID_STAGE, n));
        this._windA1Fld.setMinValue(0.0);
        this._windA1Fld.setMaxValue(0.01);
        this._windA1Fld.setName(jLabel.getName());
        this._windA1Fld.setPrecision(this._defaultPrecision.intValue());
        jLabel.setLabelFor((Component)this._windA1Fld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._windA1Fld, gridBagConstraints);
        jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.WindA2").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._windAzFld = new TruncatedZerosDecimalField();
        this._windAzFld.setValue(0.0);
        this._windAzFld.setMinValue(0.0);
        this._windAzFld.setName(jLabel.getName());
        jLabel.setLabelFor((Component)this._windAzFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._windAzFld, gridBagConstraints);
        this._useWindDzmaxFlgCheckBox = new RmaJCheckBox(WqI18n.a("Dispersion.ReservoirPanel.Label.WindDzmax").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._useWindDzmaxFlgCheckBox, gridBagConstraints);
        this._windDzmaxFld = new TruncatedZerosDecimalField();
        this._windDzmaxFld.setValue(new ParamDouble(0.0, Parameter.PARAMID_STAGE, n));
        this._windDzmaxFld.setMinValue(0.0);
        this._useWindDzmaxFlgCheckBox.setLabelFor((Component)this._windDzmaxFld);
        jLabel.setLabelFor((Component)this._windDzmaxFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._windDzmaxFld, gridBagConstraints);
        jLabel = new JLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        WqI18n.a("Dispersion.ReservoirPanel.Label.WindEquation").getText();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0555;
    }

    private void buildMunkAndersonPanel() {
        this._munkAndersonPanel = new JPanel(new GridBagLayout());
        int n = ClientApp.Workspace().getUnitSystem();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        this._munkAndersonPanel.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.MunkAndersonA").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._munkAndersonAFld = new TruncatedZerosDecimalField();
        this._munkAndersonAFld.setValue(new ParamDouble(3.33, -1, n, this._defaultPrecision.intValue()));
        this._munkAndersonAFld.setName(jLabel.getName());
        this._munkAndersonAFld.setMinValue(0.0);
        jLabel.setLabelFor((Component)this._munkAndersonAFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._munkAndersonAFld, gridBagConstraints);
        jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.MunkAndersonB").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._munkAndersonBFld = new TruncatedZerosDecimalField();
        this._munkAndersonBFld.setValue(new ParamDouble(1.5, -1, n, this._defaultPrecision.intValue()));
        this._munkAndersonBFld.setMinValue(0.0);
        this._munkAndersonBFld.setName(jLabel.getName());
        jLabel.setLabelFor((Component)this._munkAndersonBFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._munkAndersonBFld, gridBagConstraints);
        jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.MunkAndersonC").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._munkAndersonCFld = new TruncatedZerosDecimalField();
        this._munkAndersonCFld.setValue(new ParamDouble(0.03, Parameter.PARAMID_ELEV, n, 5));
        this._munkAndersonCFld.setMinValue(0.0);
        this._munkAndersonCFld.setName(jLabel.getName());
        jLabel.setLabelFor((Component)this._munkAndersonCFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._munkAndersonCFld, gridBagConstraints);
        jLabel = WqI18n.a("Dispersion.ReservoirPanel.Label.MunkAndersonDzmin").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._munkAndersonDzminFld = new TruncatedZerosDecimalField();
        this._munkAndersonDzminFld.setValue(new ParamDouble(0.0, Parameter.PARAMID_STAGE, n, 7));
        this._munkAndersonDzminFld.setMinValue(0.0);
        jLabel.setLabelFor((Component)this._munkAndersonDzminFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._munkAndersonDzminFld, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
    }

    private JLabel buildEquationPanel(String string) {
        ImageIcon imageIcon = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(((Object)((Object)this)).getClass().getClassLoader().getResource(string));
            imageIcon = new ImageIcon(bufferedImage);
        }
        catch (IOException | IllegalArgumentException exception) {
            a.log(Level.SEVERE, "Exception loading image " + string, exception);
        }
        return new JLabel(imageIcon);
    }

    private JLabel buildEquationIconLabel(String string) {
        JLabel jLabel = new JLabel();
        ImageIcon imageIcon = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(((Object)((Object)this)).getClass().getClassLoader().getResource(string));
            int n = (int)((double)bufferedImage.getWidth() * 0.75);
            int n2 = (int)((double)bufferedImage.getHeight() * 0.75);
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, n, n2, null);
            imageIcon = new ImageIcon(bufferedImage2);
        }
        catch (IOException | IllegalArgumentException exception) {
            a.log(Level.SEVERE, "Exception loading image " + string, exception);
        }
        if (imageIcon != null) {
            jLabel = new JLabel(imageIcon);
        }
        return jLabel;
    }

    private void addListeners() {
        this._reservoirCombo.addItemListener(itemEvent -> {
            if (2 == itemEvent.getStateChange()) {
                return;
            }
            this.reservoirComboChanged();
        });
        this._fromProfileRadio.addActionListener(actionEvent -> this.radioAction());
        this._alternateRadio.addActionListener(actionEvent -> this.radioAction());
        this._methodCombo.addItemListener(itemEvent -> {
            if (2 == itemEvent.getStateChange()) {
                return;
            }
            this.methodComboChanged();
        });
        this._useWindDzmaxFlgCheckBox.addActionListener(actionEvent -> this._windDzmaxFld.setEnabled(this._useWindDzmaxFlgCheckBox.isSelected()));
        this._entrainementRateCalculationTypeCombobox.addActionListener(actionEvent -> this.updateEntrainment());
        this._useMaxInflowEnvelopeHeightCheckBox.addActionListener(actionEvent -> this._maxInflowEnvelopeHeightField.setEnabled(this._useMaxInflowEnvelopeHeightCheckBox.isSelected()));
        this._useMaxOutflowEnvelopeHeightCheckBox.addActionListener(actionEvent -> this._maxOutflowEnvelopeHeightField.setEnabled(this._useMaxOutflowEnvelopeHeightCheckBox.isSelected()));
        this._streamSlopeRateCalculationTypeCombobox.addActionListener(actionEvent -> this.updateStreamSlope());
        this._sameSettingsForAllInflowsCheckbox.addActionListener(actionEvent -> this.sameSettingsForAllInflowsChanged());
        this._useEntrainmentRadioButton.addActionListener(actionEvent -> this.useEntrainmentChanged());
        this._dontUseEntrainmentRadioButton.addActionListener(actionEvent -> this.useEntrainmentChanged());
        this._inflowComboBox.addItemListener(this::inflowComboChanged);
        this._entrainmentStreamCrossSectionHalfAngleField.addKeyListener((KeyListener)new ReservoirPanel$3(this));
        this._entrainmentStreamSlopeField.addKeyListener((KeyListener)new ReservoirPanel$4(this));
        this._entrainmentRateField.addFocusListener((FocusListener)new ReservoirPanel$5(this));
        this._entrainmentStreamSlopeField.addFocusListener((FocusListener)new ReservoirPanel$6(this));
    }

    private void validateEntrainment() {
        double d = this._entrainmentRateField.getHecDouble().value();
        if (!RMAConst.isValidValue((double)d)) {
            if (this._entrainementRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.USER_DEFINED) {
                this._entrainmentRateField.setValue(0.0);
                return;
            }
            this._entrainmentRateField.setValue(this.calculateEntrainmentRate());
        }
    }

    private void validateStreamSlope() {
        double d = this._entrainmentStreamSlopeField.getHecDouble().value();
        if (!RMAConst.isValidValue((double)d)) {
            if (this._streamSlopeRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.USER_DEFINED) {
                this._entrainmentStreamSlopeField.setValue(1.0E-4);
            } else {
                this._entrainmentStreamSlopeField.setValue(this.calculateStreamSlope());
            }
            this.updateEntrainment();
        }
    }

    private double calculateStreamSlope() {
        double d = 1.0E-4;
        ReservoirPanel$WQSubDomainBoundaryRefWrapper reservoirPanel$WQSubDomainBoundaryRefWrapper = (ReservoirPanel$WQSubDomainBoundaryRefWrapper)this._inflowComboBox.getSelectedItem();
        if (reservoirPanel$WQSubDomainBoundaryRefWrapper != null) {
            reservoirPanel$WQSubDomainBoundaryRefWrapper = reservoirPanel$WQSubDomainBoundaryRefWrapper.a();
            reservoirPanel$WQSubDomainBoundaryRefWrapper = this._currentInflows.stream().filter(arg_0 -> ReservoirPanel.b((WQSubDomainBoundaryRef)reservoirPanel$WQSubDomainBoundaryRefWrapper, arg_0)).findFirst().orElse(null);
            if (reservoirPanel$WQSubDomainBoundaryRefWrapper != null) {
                d = this.calculateStreamSlope((WQGeoSubDomainBoundary)reservoirPanel$WQSubDomainBoundaryRefWrapper);
            }
        }
        return d;
    }

    private void updateEntrainment() {
        if (this._entrainementRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.CALCULATED) {
            double d = this.calculateEntrainmentRate();
            this._entrainmentRateField.setValue(d);
        }
        this._entrainmentRateField.setEnabled(this._entrainementRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.USER_DEFINED);
    }

    private void inflowComboChanged(ItemEvent object) {
        if (2 == ((ItemEvent)object).getStateChange()) {
            if ((object = ((ItemEvent)object).getItem()) instanceof ReservoirPanel$WQSubDomainBoundaryRefWrapper) {
                object = ((ReservoirPanel$WQSubDomainBoundaryRefWrapper)object).a();
                this._currentInflows.stream().filter(arg_0 -> ReservoirPanel.a((WQSubDomainBoundaryRef)object, arg_0)).findFirst().ifPresent(arg_0 -> this.lambda$inflowComboChanged$15((WQSubDomainBoundaryRef)object, arg_0));
            }
            return;
        }
        if (1 == ((ItemEvent)object).getStateChange() && (object = ((ItemEvent)object).getItem()) instanceof ReservoirPanel$WQSubDomainBoundaryRefWrapper) {
            object = ((ReservoirPanel$WQSubDomainBoundaryRefWrapper)object).a();
            if ((object = this._inflowIdToSettingMap.get(object.getId())) != null) {
                this.fillInflowEntrainmentPanel((ReservoirEntrainmentInflowSetting)object);
            }
        }
    }

    private void useEntrainmentChanged() {
        boolean bl = this._useEntrainmentRadioButton.isSelected();
        this._entrainementRateCalculationTypeCombobox.setEnabled(bl);
        this._entrainmentInitialMixingRatioField.setEnabled(bl);
        this._entrainmentRateField.setEnabled(bl && this._entrainementRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.USER_DEFINED);
    }

    private void sameSettingsForAllInflowsChanged() {
        boolean bl = this._sameSettingsForAllInflowsCheckbox.isSelected();
        this._inflowComboBox.setEnabled(!bl);
        this._inflowNavPanel.setEnabled(!bl);
        for (Component component : this._inflowNavPanel.getComponents()) {
            component.setEnabled(!bl);
        }
    }

    private void updateStreamSlope() {
        if (this._streamSlopeRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.CALCULATED) {
            this._entrainmentStreamSlopeField.setValue(this.calculateStreamSlope());
        }
        this._entrainmentStreamSlopeField.setEnabled(this._streamSlopeRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.USER_DEFINED);
    }

    private void reservoirComboChanged() {
        SubDomain subDomain = (SubDomain)this._reservoirCombo.getSelectedItem();
        this.fillPanel((WQGeoSubDomain)subDomain);
    }

    private void methodComboChanged() {
        String string = (String)this._methodCombo.getSelectedItem();
        ((CardLayout)this._alternatePanel.getLayout()).show((Container)this._alternatePanel, string);
        ((CardLayout)this._equationPanel.getLayout()).show((Container)this._equationPanel, string);
    }

    private void radioAction() {
        boolean bl = this._alternateRadio.isSelected();
        this._lowerPanel.setEnabled(bl);
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType object) {
        this._currentDispersionSet = null;
        this._settingsMap.clear();
        this._currentRes = null;
        if (object instanceof ManagerProxyWrapper) {
            this.setEnabled(true);
            object = (ManagerProxyWrapper)((Object)object);
            object = object.getManagerProxy();
            object = (DispersionSetManager)object.loadManager(null, null);
            WqGeometry wqGeometry = object.getGeometry();
            this._currentDispersionSet = object;
            this.fillReservoirCombo(wqGeometry);
            this.setModified(false);
        }
    }

    private void fillPanel(WQGeoSubDomain object) {
        if (object == null) {
            return;
        }
        WQDispersionCoefSettings wQDispersionCoefSettings2 = this._currentDispersionSet.getSet();
        if (this._currentRes != null) {
            ReservoirPanel reservoirPanel = this;
            reservoirPanel.savePanel(reservoirPanel._currentRes);
        }
        this.setIgnoreModifiedEvents(true);
        try {
            List list;
            int n;
            this._currentRes = object;
            Object object2 = this._currentRes.getGeometry();
            if (object2 instanceof WQGeometry) {
                object2 = (RssWQGeometry)object2;
                n = this._currentRes.getId();
                list = object2.findUniqueUpstreamBoundaries(n);
                this._currentInflows = new ArrayList<WQGeoSubDomainBoundary>();
                if (list != null) {
                    this._currentInflows.addAll(list);
                }
            }
            if (wQDispersionCoefSettings2 != null) {
                ReservoirDispersionEntrainmentSettings reservoirDispersionEntrainmentSettings;
                object2 = (ReservoirDispersionSettings)this._settingsMap.get(this._currentRes);
                if (object2 == null) {
                    object2 = wQDispersionCoefSettings2.getReservoirSettings((SubDomainRef)object.getRef());
                }
                if (object2 == null) {
                    n = ClientApp.Workspace().getUnitSystem();
                    object2 = new WQReservoirDispersionSettings(n);
                }
                if ((list = (reservoirDispersionEntrainmentSettings = object2.getEntrainmentSettings()).getEntrainmentInflowSettings()).isEmpty()) {
                    for (WQGeoSubDomainBoundary wQGeoSubDomainBoundary : this._currentInflows) {
                        if (!(wQGeoSubDomainBoundary.getRef() instanceof WQSubDomainBoundaryRef)) continue;
                        list.add(new WQReservoirEntrainmentInflowSettingBuilder().withWQSubDomainBoundaryRef((WQSubDomainBoundaryRef)wQGeoSubDomainBoundary.getRef()).build());
                    }
                }
                if (reservoirDispersionEntrainmentSettings.getEntrainmentInflowSettings().isEmpty()) {
                    reservoirDispersionEntrainmentSettings = new WQReservoirDispersionEntrainmentSettingsBuilder().fromExisting(reservoirDispersionEntrainmentSettings).withInflowSettings(list).build();
                    object2.setEntrainmentSettings(reservoirDispersionEntrainmentSettings);
                }
                for (ReservoirEntrainmentInflowSetting reservoirEntrainmentInflowSetting : list) {
                    this._inflowIdToSettingMap.put(reservoirEntrainmentInflowSetting.getInflowId(), reservoirEntrainmentInflowSetting);
                }
                object = object2.getStabilityData();
                this._prevSystemUsed = this._newUnitSystem = ClientApp.Workspace().getUnitSystem();
                this.fillStabilityPanel((StabilityDispersionData)object);
                WindDispersionData windDispersionData = object2.getWindData();
                this.fillWindPanel(windDispersionData);
                object = object2.getMunkAndersonData();
                this.fillMunkAndersonPanel((MunkAndersonDispersionData)object);
                this._alternateRadio.doClick(0);
                object = object2.getAlternateMixingMethod();
                if (AlternateMixingMethod.STABILITY == object) {
                    this._methodCombo.setSelectedIndex(0);
                } else if (AlternateMixingMethod.WIND == object) {
                    this._methodCombo.setSelectedIndex(1);
                } else {
                    this._methodCombo.setSelectedIndex(2);
                }
                this.methodComboChanged();
                object2.getWindData();
                this.fillEntrainmentPanel(reservoirDispersionEntrainmentSettings);
                this.fillEnvelopeHeightsPanel((ReservoirDispersionSettings)object2);
                this.fillMixedLayerTolerancePanel((ReservoirDispersionSettings)object2);
            }
            return;
        }
        finally {
            this.setIgnoreModifiedEvents(false);
        }
    }

    private void fillMixedLayerTolerancePanel(ReservoirDispersionSettings reservoirDispersionSettings) {
        double d = this.validateDouble(reservoirDispersionSettings.getMixedLayerTolerance());
        if (this._allowMixedLayerToleranceUnitConversion) {
            int n = ClientApp.Workspace().getUnitSystem();
            if (n == 2) {
                d *= 4.882423653736196;
            }
            d = Double.parseDouble(String.format("%.4f", d));
            ParamDouble paramDouble = new ParamDouble(d, Parameter.PARAMID_AREA, n);
            this._mixedLayerToleranceField.setValue(paramDouble);
            return;
        }
        this._mixedLayerToleranceField.setValue(d);
    }

    private double calculateEntrainmentRate() {
        double d = this._entrainmentStreamSlopeField.getHecDouble().value();
        double d2 = this._entrainmentStreamCrossSectionHalfAngleField.getHecDouble().value();
        EntrainmentCalculationType entrainmentCalculationType = (EntrainmentCalculationType)this._entrainementRateCalculationTypeCombobox.getSelectedItem();
        return this.calculateEntrainmentRate(d, d2, entrainmentCalculationType);
    }

    private double calculateEntrainmentRate(double d, double d2, EntrainmentCalculationType entrainmentCalculationType) {
        Double d3 = null;
        if (entrainmentCalculationType == EntrainmentCalculationType.CALCULATED && RMAConst.isValidValue((double)d) && RMAConst.isValidValue((double)d2)) {
            double d4 = d2 / 180.0 * Math.PI;
            double d5 = Math.sin(d4) * Math.tan(d) / 0.04 / (1.0 - 0.85 * Math.sqrt(0.04) * Math.sin(d4));
            d3 = 1.6 * Math.pow(0.04, 1.5) * d5;
        }
        return this.validateDouble(d3);
    }

    private double calculateStreamSlope(WQGeoSubDomainBoundary object) {
        Double d = null;
        double d2 = object.getDistToResDam();
        object = this._currentDispersionSet.getGeometry();
        if (object != null && this._streamSlopeRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.CALCULATED) {
            RssSystem rssSystem = object.getNetwork();
            if (rssSystem != null) {
                int n = this._currentRes.getElementId();
                ReservoirElement reservoirElement = (ReservoirElement)rssSystem.getElement(n);
                if (reservoirElement != null) {
                    double d3 = RssWQGeometry.getReservoirMinElevation(reservoirElement);
                    double d4 = RssWQGeometry.getReservoirMaxElevation(reservoirElement);
                    double d5 = (d4 - d3) / d2;
                    d = Math.min(0.1, Math.max(1.0E-4, d5));
                    this._editor.setErrorMessage(null);
                } else {
                    String string = WqI18n.a("Dispersion.Editor.Msg.FailedToFindNetworkReservoir").format((Object)this._currentRes.getName());
                    this._editor.setErrorMessage(string);
                }
            } else {
                object = WqI18n.a("Dispersion.Editor.Msg.FailedToFindNetwork").format((Object)object.getName());
                this._editor.setErrorMessage((String)object);
            }
        } else if (object == null) {
            String string = WqI18n.a("Dispersion.Editor.Msg.FailedToFindGeometry").format((Object)((JsonManager)this._currentDispersionSet).getName());
            this._editor.setErrorMessage(string);
        }
        return this.validateDouble(d);
    }

    private void fillEnvelopeHeightsPanel(ReservoirDispersionSettings reservoirDispersionSettings) {
        this._useMaxInflowEnvelopeHeightCheckBox.setSelected(reservoirDispersionSettings.useMaxInflowEnvelopeHeight());
        if (this._useMaxInflowEnvelopeHeightCheckBox.isSelected()) {
            double d = this.validateDouble(reservoirDispersionSettings.getMaxInflowEnvelopeHeight());
            ParamDouble paramDouble = new ParamDouble(d, Parameter.PARAMID_ELEV, 1);
            paramDouble.convertToUnitSystem(this._newUnitSystem);
            this._maxInflowEnvelopeHeightField.setValue(paramDouble);
        } else {
            this._maxInflowEnvelopeHeightField.setValue(new ParamDouble(-3.4028234663852886E38, Parameter.PARAMID_ELEV, this._newUnitSystem));
        }
        SwingUtilities.invokeLater(() -> this._maxInflowEnvelopeHeightField.setEnabled(reservoirDispersionSettings.useMaxInflowEnvelopeHeight()));
        this._useMaxOutflowEnvelopeHeightCheckBox.setSelected(reservoirDispersionSettings.useMaxOutflowEnvelopeHeight());
        if (this._useMaxOutflowEnvelopeHeightCheckBox.isSelected()) {
            double d = this.validateDouble(reservoirDispersionSettings.getMaxOutflowEnvelopeHeight());
            ParamDouble paramDouble = new ParamDouble(d, Parameter.PARAMID_ELEV, 1);
            paramDouble.convertToUnitSystem(this._newUnitSystem);
            this._maxOutflowEnvelopeHeightField.setValue(paramDouble);
        } else {
            this._maxOutflowEnvelopeHeightField.setValue(new ParamDouble(-3.4028234663852886E38, Parameter.PARAMID_ELEV, this._newUnitSystem));
        }
        SwingUtilities.invokeLater(() -> this._maxOutflowEnvelopeHeightField.setEnabled(reservoirDispersionSettings.useMaxOutflowEnvelopeHeight()));
    }

    private void fillEntrainmentPanel(ReservoirDispersionEntrainmentSettings reservoirDispersionEntrainmentSettings) {
        this._sameSettingsForAllInflowsCheckbox.setSelected(reservoirDispersionEntrainmentSettings.useSameSettingsForAllInflows());
        RmaListModel rmaListModel = new RmaListModel(true);
        for (WQGeoSubDomainBoundary wQGeoSubDomainBoundary : this._currentInflows) {
            if (!(wQGeoSubDomainBoundary.getRef() instanceof WQSubDomainBoundaryRef)) continue;
            rmaListModel.addElement((Object)new ReservoirPanel$WQSubDomainBoundaryRefWrapper((WQSubDomainBoundaryRef)wQGeoSubDomainBoundary.getRef()));
        }
        this._inflowComboBox.setModel((ComboBoxModel)rmaListModel);
        if (!rmaListModel.isEmpty()) {
            this._inflowComboBox.setSelectedIndex(0);
        }
        this.fillInflowEntrainmentPanel(reservoirDispersionEntrainmentSettings);
        SwingUtilities.invokeLater(this::sameSettingsForAllInflowsChanged);
        SwingUtilities.invokeLater(this::useEntrainmentChanged);
    }

    private void fillInflowEntrainmentPanel(ReservoirDispersionEntrainmentSettings reservoirDispersionEntrainmentSettings) {
        ReservoirPanel$WQSubDomainBoundaryRefWrapper reservoirPanel$WQSubDomainBoundaryRefWrapper = (ReservoirPanel$WQSubDomainBoundaryRefWrapper)this._inflowComboBox.getSelectedItem();
        this.clearInflowPanel();
        if (reservoirPanel$WQSubDomainBoundaryRefWrapper != null) {
            reservoirPanel$WQSubDomainBoundaryRefWrapper = reservoirPanel$WQSubDomainBoundaryRefWrapper.a();
            reservoirDispersionEntrainmentSettings.getInflowSetting((SubDomainBoundaryRef)reservoirPanel$WQSubDomainBoundaryRefWrapper).ifPresent(this::fillInflowEntrainmentPanel);
        }
    }

    private void clearInflowPanel() {
        this._entrainementRateCalculationTypeCombobox.setSelectedItem((Object)EntrainmentCalculationType.CALCULATED);
        this._entrainmentStreamSlopeField.setValue(-3.4028234663852886E38);
        this._entrainmentStreamCrossSectionHalfAngleField.setValue(-3.4028234663852886E38);
        this._entrainmentInitialMixingRatioField.setValue(-3.4028234663852886E38);
        this._streamSlopeRateCalculationTypeCombobox.setSelectedItem((Object)EntrainmentCalculationType.CALCULATED);
        this._useEntrainmentRadioButton.doClick(0);
        this.updateEntrainment();
        this.updateStreamSlope();
    }

    private void fillInflowEntrainmentPanel(ReservoirEntrainmentInflowSetting reservoirEntrainmentInflowSetting) {
        Double d;
        Double d2 = this.validateDouble(reservoirEntrainmentInflowSetting.getStreamSlope());
        if (d2 == null || !RMAConst.isValidValue((double)d2)) {
            d2 = 1.0E-4;
        }
        if ((d = this.validateDouble(reservoirEntrainmentInflowSetting.getEntrainmentRate())) == null || !RMAConst.isValidValue((double)d)) {
            d = 0.0;
        }
        Double d3 = this.validateDouble(reservoirEntrainmentInflowSetting.getInitialMixingRatio());
        Double d4 = this.validateDouble(reservoirEntrainmentInflowSetting.getStreamCrossSectionHalfAngle());
        if (d4 == null || !RMAConst.isValidValue((double)d4)) {
            d4 = 10.0;
        }
        this._entrainementRateCalculationTypeCombobox.setSelectedItem((Object)reservoirEntrainmentInflowSetting.getEntrainmentRateType());
        this._entrainmentStreamSlopeField.setValue(d2.doubleValue());
        this._entrainmentRateField.setValue(d.doubleValue());
        this._entrainmentInitialMixingRatioField.setValue(d3.doubleValue());
        this._entrainmentStreamCrossSectionHalfAngleField.setValue(new ParamDouble(d4.doubleValue(), b, 1));
        this._streamSlopeRateCalculationTypeCombobox.setSelectedItem((Object)reservoirEntrainmentInflowSetting.getStreamSlopeType());
        if (reservoirEntrainmentInflowSetting.useEntrainment()) {
            this._useEntrainmentRadioButton.doClick(0);
        } else {
            this._dontUseEntrainmentRadioButton.doClick(0);
        }
        SwingUtilities.invokeLater(() -> {
            this.updateEntrainment();
            this.updateStreamSlope();
        });
    }

    private Double validateDouble(Double d) {
        return d == null ? -3.4028234663852886E38 : d;
    }

    private void fillReservoirCombo(WqGeometry object) {
        RssWQGeometry rssWQGeometry;
        RmaListModel rmaListModel = new RmaListModel(true);
        if (object != null && (rssWQGeometry = object.getRssWqGeometry()) != null) {
            object = object.getRssWqGeometry().getReservoirs();
            rmaListModel.addAll((Collection)object);
        }
        this._reservoirCombo.setModel((ComboBoxModel)rmaListModel);
        if (rmaListModel.size() > 0) {
            this._reservoirCombo.setSelectedIndex(0);
        }
    }

    private void fillStabilityPanel(StabilityDispersionData stabilityDispersionData) {
        int n = ClientApp.Workspace().getUnitSystem();
        this._stabilityEcritFld.setValue(new ParamDouble(stabilityDispersionData.getEcrit(), Parameter.PARAMID_LENGTH, n, 7));
        this._stabilityA1Fld.setValue(new ParamDouble(stabilityDispersionData.getA1(), Parameter.PARAMID_AREA, n, 7));
        this._stabilityA3Fld.setValue(new ParamDouble(stabilityDispersionData.getA3(), -1, n));
    }

    private void fillWindPanel(WindDispersionData windDispersionData) {
        int n = ClientApp.Workspace().getUnitSystem();
        this._windDzminFld.setValue(new ParamDouble(windDispersionData.getDzmin(), Parameter.PARAMID_AREA, n, 7));
        this._windA1Fld.setValue(new ParamDouble(windDispersionData.getA1(), Parameter.PARAMID_LENGTH, n, 7));
        this._windAzFld.setValue(new ParamDouble(windDispersionData.getA2(), -1, n));
        this._windDzmaxFld.setValue(new ParamDouble(windDispersionData.getDzmax(), Parameter.PARAMID_AREA, n, 7));
        this._useWindDzmaxFlgCheckBox.setSelected(windDispersionData.useDzMax());
        SwingUtilities.invokeLater(() -> this._windDzmaxFld.setEnabled(windDispersionData.useDzMax()));
    }

    private void fillMunkAndersonPanel(MunkAndersonDispersionData munkAndersonDispersionData) {
        int n = ClientApp.Workspace().getUnitSystem();
        this._munkAndersonAFld.setValue(new ParamDouble(munkAndersonDispersionData.getACoeff(), -1, n));
        this._munkAndersonBFld.setValue(new ParamDouble(munkAndersonDispersionData.getBCoeff(), -1, n));
        this._munkAndersonCFld.setValue(new ParamDouble(munkAndersonDispersionData.getCCoeff(), Parameter.PARAMID_LENGTH, n, 5));
        this._munkAndersonDzminFld.setValue(new ParamDouble(munkAndersonDispersionData.getDzmin(), Parameter.PARAMID_AREA, n, 7));
    }

    public boolean savePanel(NamedType object) {
        DispersionSetManager dispersionSetManager = this._currentDispersionSet;
        if (object instanceof DispersionSetManager) {
            dispersionSetManager = (DispersionSetManager)object;
        }
        if (dispersionSetManager == null) {
            return true;
        }
        if (this._currentRes != null) {
            ReservoirPanel reservoirPanel = this;
            reservoirPanel.savePanel(reservoirPanel._currentRes);
        }
        object = this._settingsMap.keySet();
        object = object.iterator();
        WQDispersionCoefSettings wQDispersionCoefSettings = dispersionSetManager.getSet();
        while (object.hasNext()) {
            WQGeoSubDomain wQGeoSubDomain = (WQGeoSubDomain)object.next();
            if (wQGeoSubDomain == null) continue;
            ReservoirDispersionSettings reservoirDispersionSettings = (ReservoirDispersionSettings)this._settingsMap.get(wQGeoSubDomain);
            wQDispersionCoefSettings.setReservoirSettings((SubDomainRef)wQGeoSubDomain.getRef(), (WQReservoirDispersionSettings)reservoirDispersionSettings);
        }
        this.setModified(false);
        dispersionSetManager.setModified(true);
        return true;
    }

    private void savePanel(WQGeoSubDomain wQGeoSubDomain) {
        int n = ClientApp.Workspace().getUnitSystem();
        WQReservoirDispersionSettings wQReservoirDispersionSettings = new WQReservoirDispersionSettings(n);
        wQReservoirDispersionSettings.setVerticalMixingType(VerticalMixingType.ALTERNATE_METHOD);
        int n2 = this._methodCombo.getSelectedIndex();
        if (n2 == 0) {
            wQReservoirDispersionSettings.setAlternateMixingMethod(AlternateMixingMethod.STABILITY);
        } else if (n2 == 1) {
            wQReservoirDispersionSettings.setAlternateMixingMethod(AlternateMixingMethod.WIND);
        } else {
            wQReservoirDispersionSettings.setAlternateMixingMethod(AlternateMixingMethod.MUNK_ANDERSON);
        }
        this.saveStabilityPanel(wQReservoirDispersionSettings.getStabilityData());
        this.saveWindPanel(wQReservoirDispersionSettings.getWindData());
        this.saveMunkAndersonPanel(wQReservoirDispersionSettings.getMunkAndersonData());
        this.saveEnvelopeHeightsPanel((ReservoirDispersionSettings)wQReservoirDispersionSettings);
        this.saveEntrainmentPanel((ReservoirDispersionSettings)wQReservoirDispersionSettings);
        this.saveMixedLayerTolerancePanel((ReservoirDispersionSettings)wQReservoirDispersionSettings);
        this._settingsMap.put(wQGeoSubDomain, wQReservoirDispersionSettings);
    }

    private void saveMixedLayerTolerancePanel(ReservoirDispersionSettings reservoirDispersionSettings) {
        double d;
        if (this._allowMixedLayerToleranceUnitConversion) {
            String string = this._mixedLayerToleranceField.getText();
            d = RMAIO.parseDouble((String)string);
            if (this._newUnitSystem == 2) {
                d = Double.parseDouble(String.format("%.4f", d *= 0.2048163106933103));
            }
        } else {
            d = this._mixedLayerToleranceField.getValue();
        }
        reservoirDispersionSettings.setMixedLayerTolerance(Double.valueOf(d));
    }

    private void saveEntrainmentPanel(ReservoirDispersionSettings reservoirDispersionSettings) {
        Object object;
        WQReservoirDispersionEntrainmentSettingsBuilder wQReservoirDispersionEntrainmentSettingsBuilder = new WQReservoirDispersionEntrainmentSettingsBuilder().withUseSameSettingsForAllInflows(this._sameSettingsForAllInflowsCheckbox.isSelected());
        if (this._sameSettingsForAllInflowsCheckbox.isSelected()) {
            for (WQGeoSubDomainBoundary object22 : this._currentInflows) {
                ReservoirEntrainmentInflowSetting reservoirEntrainmentInflowSetting = this.buildInflowSetting(object22);
                this._inflowIdToSettingMap.put(object22.getId(), reservoirEntrainmentInflowSetting);
            }
        } else {
            object = (ReservoirPanel$WQSubDomainBoundaryRefWrapper)this._inflowComboBox.getSelectedItem();
            if (object != null) {
                WQSubDomainBoundaryRef wQSubDomainBoundaryRef = ((ReservoirPanel$WQSubDomainBoundaryRefWrapper)object).a();
                this._currentInflows.stream().filter(arg_0 -> ReservoirPanel.a((SubDomainBoundaryRef)wQSubDomainBoundaryRef, arg_0)).findFirst().ifPresent(arg_0 -> this.lambda$saveEntrainmentPanel$21((SubDomainBoundaryRef)wQSubDomainBoundaryRef, arg_0));
            }
        }
        object = new ArrayList<ReservoirEntrainmentInflowSetting>();
        for (WQGeoSubDomainBoundary wQGeoSubDomainBoundary : this._currentInflows) {
            ReservoirEntrainmentInflowSetting reservoirEntrainmentInflowSetting = this._inflowIdToSettingMap.get(wQGeoSubDomainBoundary.getId());
            object.add(reservoirEntrainmentInflowSetting);
        }
        wQReservoirDispersionEntrainmentSettingsBuilder.withInflowSettings(object);
        ReservoirDispersionEntrainmentSettings reservoirDispersionEntrainmentSettings = wQReservoirDispersionEntrainmentSettingsBuilder.build();
        reservoirDispersionSettings.setEntrainmentSettings(reservoirDispersionEntrainmentSettings);
    }

    private ReservoirEntrainmentInflowSetting buildInflowSetting(WQGeoSubDomainBoundary wQGeoSubDomainBoundary) {
        WQReservoirEntrainmentInflowSettingBuilder wQReservoirEntrainmentInflowSettingBuilder = new WQReservoirEntrainmentInflowSettingBuilder().withWQSubDomainBoundaryRef((WQSubDomainBoundaryRef)wQGeoSubDomainBoundary.getRef());
        boolean bl = this._useEntrainmentRadioButton.isSelected();
        wQReservoirEntrainmentInflowSettingBuilder.withUseEntrainment(bl);
        if (bl) {
            wQReservoirEntrainmentInflowSettingBuilder.withEntrainmentRateType((EntrainmentCalculationType)this._entrainementRateCalculationTypeCombobox.getSelectedItem()).withEntrainmentRate(Double.valueOf(this.getEntrainmentRateForInflow(wQGeoSubDomainBoundary, this._sameSettingsForAllInflowsCheckbox.isSelected()))).withInitialMixingRatio(Double.valueOf(this._entrainmentInitialMixingRatioField.getHecDouble().value())).withStreamSlopeType((EntrainmentCalculationType)this._streamSlopeRateCalculationTypeCombobox.getSelectedItem()).withStreamSlope(Double.valueOf(this.getStreamSlopeForInflow(wQGeoSubDomainBoundary, this._sameSettingsForAllInflowsCheckbox.isSelected()))).withStreamCrossSectionHalfAngle(Double.valueOf(this._entrainmentStreamCrossSectionHalfAngleField.getHecDouble().value()));
        }
        return wQReservoirEntrainmentInflowSettingBuilder.build();
    }

    private double getStreamSlopeForInflow(WQGeoSubDomainBoundary wQGeoSubDomainBoundary, boolean bl) {
        double d = this._entrainmentStreamSlopeField.getHecDouble().value();
        if (bl && this._streamSlopeRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.CALCULATED) {
            d = this.calculateStreamSlope(wQGeoSubDomainBoundary);
        }
        return d;
    }

    private double getEntrainmentRateForInflow(WQGeoSubDomainBoundary wQGeoSubDomainBoundary, boolean bl) {
        double d = this._entrainmentRateField.getHecDouble().value();
        if (bl && this._entrainementRateCalculationTypeCombobox.getSelectedItem() == EntrainmentCalculationType.CALCULATED) {
            double d2 = this.getStreamSlopeForInflow(wQGeoSubDomainBoundary, bl);
            d = this.calculateEntrainmentRate(d2, this._entrainmentStreamCrossSectionHalfAngleField.getHecDouble().value(), EntrainmentCalculationType.CALCULATED);
        }
        return d;
    }

    private void saveEnvelopeHeightsPanel(ReservoirDispersionSettings reservoirDispersionSettings) {
        ParamDouble paramDouble;
        reservoirDispersionSettings.setUseMaxInflowEnvelopeHeight(this._useMaxInflowEnvelopeHeightCheckBox.isSelected());
        if (this._useMaxInflowEnvelopeHeightCheckBox.isSelected()) {
            paramDouble = this._maxInflowEnvelopeHeightField.getParamValue();
            paramDouble.convertToUnitSystem(1);
            reservoirDispersionSettings.setMaxInflowEnvelopeHeight(Double.valueOf(paramDouble.getValue()));
        } else {
            reservoirDispersionSettings.setMaxInflowEnvelopeHeight(null);
        }
        reservoirDispersionSettings.setUseMaxOutflowEnvelopeHeight(this._useMaxOutflowEnvelopeHeightCheckBox.isSelected());
        if (this._useMaxOutflowEnvelopeHeightCheckBox.isSelected()) {
            paramDouble = this._maxOutflowEnvelopeHeightField.getParamValue();
            paramDouble.convertToUnitSystem(1);
            reservoirDispersionSettings.setMaxOutflowEnvelopeHeight(Double.valueOf(paramDouble.getValue()));
            return;
        }
        reservoirDispersionSettings.setMaxOutflowEnvelopeHeight(null);
    }

    private void saveWindPanel(WindDispersionData windDispersionData) {
        windDispersionData.setDzmin(this._windDzminFld.getValue());
        windDispersionData.setA1(this._windA1Fld.getValue());
        windDispersionData.setA2(this._windAzFld.getValue());
        windDispersionData.setDzmax(this._windDzmaxFld.getValue());
    }

    private void saveStabilityPanel(StabilityDispersionData stabilityDispersionData) {
        try {
            double d = UnitUtil.convertUnits((double)RMAIO.parseDouble((String)this._stabilityEcritFld.getText()), (int)Parameter.PARAMID_LENGTH, (int)this._currentDispersionSet.getUnitSystem(), (int)this._newUnitSystem);
            stabilityDispersionData.setEcrit(d);
        }
        catch (UnitsConversionException unitsConversionException) {
            a.log(Level.WARNING, unitsConversionException, () -> "Error converting stability E-critical value to new unit system");
        }
        stabilityDispersionData.setA1(this._stabilityA1Fld.getValue());
        stabilityDispersionData.setA3(this._stabilityA3Fld.getValue());
    }

    private void saveMunkAndersonPanel(MunkAndersonDispersionData munkAndersonDispersionData) {
        munkAndersonDispersionData.setACoeff(this._munkAndersonAFld.getValue());
        munkAndersonDispersionData.setBCoeff(this._munkAndersonBFld.getValue());
        munkAndersonDispersionData.setCCoeff(this._munkAndersonCFld.getValue());
        munkAndersonDispersionData.setDzmin(this._munkAndersonDzminFld.getValue());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.radioAction();
            this.methodComboChanged();
        }
    }

    private /* synthetic */ void lambda$saveEntrainmentPanel$21(SubDomainBoundaryRef subDomainBoundaryRef, WQGeoSubDomainBoundary wQGeoSubDomainBoundary) {
        wQGeoSubDomainBoundary = this.buildInflowSetting(wQGeoSubDomainBoundary);
        this._inflowIdToSettingMap.put(subDomainBoundaryRef.getId(), (ReservoirEntrainmentInflowSetting)wQGeoSubDomainBoundary);
    }

    private static /* synthetic */ boolean a(SubDomainBoundaryRef subDomainBoundaryRef, WQGeoSubDomainBoundary wQGeoSubDomainBoundary) {
        return wQGeoSubDomainBoundary.getId() == subDomainBoundaryRef.getId();
    }

    private /* synthetic */ void lambda$inflowComboChanged$15(WQSubDomainBoundaryRef wQSubDomainBoundaryRef, WQGeoSubDomainBoundary wQGeoSubDomainBoundary) {
        wQGeoSubDomainBoundary = this.buildInflowSetting(wQGeoSubDomainBoundary);
        this._inflowIdToSettingMap.put(wQSubDomainBoundaryRef.getId(), (ReservoirEntrainmentInflowSetting)wQGeoSubDomainBoundary);
    }

    private static /* synthetic */ boolean a(WQSubDomainBoundaryRef wQSubDomainBoundaryRef, WQGeoSubDomainBoundary wQGeoSubDomainBoundary) {
        return wQGeoSubDomainBoundary.getId() == wQSubDomainBoundaryRef.getId();
    }

    private static /* synthetic */ boolean b(WQSubDomainBoundaryRef wQSubDomainBoundaryRef, WQGeoSubDomainBoundary wQGeoSubDomainBoundary) {
        return wQGeoSubDomainBoundary.getId() == wQSubDomainBoundaryRef.getId();
    }
}

