/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.plugins.waterquality.model.ReachCellLengthDefinition;
import hec.rss.plugins.waterquality.model.ReachCellLengthDefinitionType;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.geometry.CellLengthEditorPanel$1;
import hec.rss.wq.client.geometry.CellLengthEditorPanel$CellLengthTableModel;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.table.TableModel;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJTable;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class CellLengthEditorPanel
extends EnabledJPanel {
    private JRadioButton _globalRadio;
    private EnabledJPanel _globalPanel;
    private RmaJDecimalField _minFld;
    private RmaJDecimalField _maxFld;
    private JRadioButton _valByReachRadio;
    private RmaJTable _valByReachTable;
    private WqGeometry _geometry;
    private String[] _headers;

    public CellLengthEditorPanel(Window window) {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        int n = ClientApp.Workspace().getUnitSystem();
        this._globalRadio = WqI18n.a("Geo.CellLengthEditor.Radio.Global").createJRadioButton();
        this._globalRadio.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        CellLengthEditorPanel cellLengthEditorPanel = this;
        cellLengthEditorPanel.add(cellLengthEditorPanel._globalRadio, gridBagConstraints);
        this._globalPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)20, (int)0, (int)5);
        CellLengthEditorPanel cellLengthEditorPanel2 = this;
        cellLengthEditorPanel2.add((Component)cellLengthEditorPanel2._globalPanel, gridBagConstraints);
        JLabel jLabel = WqI18n.a("Geo.CellLengthEditor.Label.Min").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._globalPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._minFld = new RmaJDecimalField();
        this._minFld.setValue(new ParamDouble(Double.NEGATIVE_INFINITY, Parameter.PARAMID_LENGTH, n));
        jLabel.setLabelFor((Component)this._minFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._globalPanel.add((Component)this._minFld, (Object)gridBagConstraints);
        jLabel = WqI18n.a("Geo.CellLengthEditor.Label.Max").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._globalPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._maxFld = new RmaJDecimalField();
        this._maxFld.setValue(new ParamDouble(Double.NEGATIVE_INFINITY, Parameter.PARAMID_LENGTH, n));
        jLabel.setLabelFor((Component)this._maxFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._globalPanel.add((Component)this._maxFld, (Object)gridBagConstraints);
        this._valByReachRadio = WqI18n.a("Geo.CellLengthEditor.Radio.ValByReach").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        CellLengthEditorPanel cellLengthEditorPanel3 = this;
        cellLengthEditorPanel3.add(cellLengthEditorPanel3._valByReachRadio, gridBagConstraints);
        this._headers = new String[]{WqI18n.a("Geo.CellLengthEditor.Table.Reach").getText(), WqI18n.a("Geo.CellLengthEditor.Table.Min").getText(), WqI18n.a("Geo.CellLengthEditor.Table.Max").getText()};
        CellLengthEditorPanel cellLengthEditorPanel4 = this;
        this._valByReachTable = new CellLengthEditorPanel$1(cellLengthEditorPanel4, (Component)((Object)cellLengthEditorPanel4), this._headers);
        this._valByReachTable.setColumnParameters(new int[]{-1, Parameter.PARAMID_LENGTH, Parameter.PARAMID_LENGTH});
        this._valByReachTable.setUnitsHeaderRenderer();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)5);
        CellLengthEditorPanel cellLengthEditorPanel5 = this;
        cellLengthEditorPanel5.add(cellLengthEditorPanel5._valByReachTable.getScrollPane(), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._globalRadio);
        buttonGroup.add(this._valByReachRadio);
        this.lengthRadioAction();
    }

    private void addListeners() {
        this._globalRadio.addActionListener(actionEvent -> this.lengthRadioAction());
        this._valByReachRadio.addActionListener(actionEvent -> this.lengthRadioAction());
    }

    protected boolean savePanel() {
        this._valByReachTable.commitEdit(true);
        if (this._geometry == null) {
            return true;
        }
        Object object = this._geometry.getRssWqGeometry();
        object = ((RssWQGeometry)object).getReachLengthDefinition();
        if (this._globalRadio.isSelected()) {
            ((ReachCellLengthDefinition)object).setType(ReachCellLengthDefinitionType.Global);
        } else {
            ((ReachCellLengthDefinition)object).setType(ReachCellLengthDefinitionType.SubDomain);
        }
        double d = this._maxFld.getValueUndefined();
        ((ReachCellLengthDefinition)object).setGlobalMaximum(RMAConst.isValidValue((double)d) ? Double.valueOf(d) : null);
        double d2 = this._minFld.getValueUndefined();
        ((ReachCellLengthDefinition)object).setGlobalMinimum(RMAConst.isValidValue((double)d2) ? Double.valueOf(d2) : null);
        int n = this._valByReachTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            SubDomain subDomain = (SubDomain)this._valByReachTable.getValueAt(i, 0);
            if (subDomain == null) continue;
            Object object2 = this._valByReachTable.getValueAt(i, 1);
            Object object3 = this._valByReachTable.getValueAt(i, 2);
            WQSubDomainRef wQSubDomainRef = (WQSubDomainRef)subDomain.getRef();
            d2 = RMAIO.parseDouble((Object)object2);
            double d3 = RMAIO.parseDouble((Object)object3);
            ((ReachCellLengthDefinition)object).setMinimum(wQSubDomainRef, RMAConst.isValidValue((double)d2) ? Double.valueOf(d2) : null);
            ((ReachCellLengthDefinition)object).setMaximum(wQSubDomainRef, RMAConst.isValidValue((double)d3) ? Double.valueOf(d3) : null);
        }
        return true;
    }

    private void lengthRadioAction() {
        this._globalPanel.setEnabled(this._globalRadio.isSelected());
        this._valByReachTable.repaint();
    }

    public void fillPanel(WqGeometry object) {
        this._valByReachTable.deleteCells();
        if (object != null) {
            this._geometry = object;
            int n = ClientApp.Workspace().getUnitSystem();
            Integer.getInteger("CellLengthTable.Precision", 1).intValue();
            object = ((WqGeometry)((Object)object)).getRssWqGeometry();
            Object object2 = new CellLengthEditorPanel$CellLengthTableModel(this, (RssWQGeometry)object);
            this._valByReachTable.setModel((TableModel)object2);
            this._valByReachTable.setUnitsHeaderRenderer();
            this._valByReachTable.setDoubleCellEditor(1, 2);
            object = ((RssWQGeometry)object).getReachLengthDefinition();
            object2 = ((ReachCellLengthDefinition)object).getType();
            if (ReachCellLengthDefinitionType.Global == object2) {
                this._globalRadio.doClick(0);
                this._globalRadio.setSelected(true);
            } else {
                this._valByReachRadio.doClick(0);
                this._valByReachRadio.setSelected(true);
            }
            object2 = ((ReachCellLengthDefinition)object).getGlobalMaximum();
            object = ((ReachCellLengthDefinition)object).getGlobalMinimum();
            double d = object != null ? (Double)object : Double.NEGATIVE_INFINITY;
            double d2 = object2 != null ? (Double)object2 : Double.NEGATIVE_INFINITY;
            this._maxFld.setValue(new ParamDouble(d2, Parameter.PARAMID_LENGTH, n));
            this._minFld.setValue(new ParamDouble(d, Parameter.PARAMID_LENGTH, n));
        }
    }
}

