/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.plugins.waterquality.model.ReachCellLengthDefinition;
import hec.rss.plugins.waterquality.model.ReachCellLengthDefinitionType;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.geometry.GeometryEditorTab;
import hec.rss.wq.client.geometry.actions.AdjustCellsLengthAction;
import hec.rss.wq.client.geometry.actions.ReservoirLayerHeightAction;
import hec.rss.wq.client.geometry.actions.ShowTableCellLengthAction;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import rma.swing.RmaInsets;

public class CellsPanel
extends AbstractEditorPanel
implements GeometryEditorTab {
    private String _tabName;
    private JRadioButton _rasCellSpacingRadio;
    private JRadioButton _adjustCellSpacingRadio;
    private JButton _editLayersBtn;
    private JButton _showTableBtn;
    private JButton _editLengthsBtn;
    private ShowTableCellLengthAction _showTableAction;
    private GeometryEditor _editor;
    private WqGeometry _currentGeo;

    public CellsPanel(GeometryEditor geometryEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = geometryEditor;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("Geo.Cells.TabName").getText();
        Serializable serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder(WqI18n.a("Geo.Cells.Border.Cells").getText()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)serializable, gridBagConstraints);
        Serializable serializable2 = new JLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)serializable2, gridBagConstraints);
        this._rasCellSpacingRadio = WqI18n.a("Geo.Cells.Radio.RasCell").createJRadioButton();
        this._rasCellSpacingRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._rasCellSpacingRadio, gridBagConstraints);
        this._adjustCellSpacingRadio = WqI18n.a("Geo.Cells.Radio.Adjust").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ((Container)serializable).add(this._adjustCellSpacingRadio, gridBagConstraints);
        this._editLengthsBtn = WqI18n.a("Geo.Cells.Button.Edit").createJButton();
        serializable2 = new AdjustCellsLengthAction(this);
        this._editLengthsBtn.setAction((Action)((Object)serializable2));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ((Container)serializable).add(this._editLengthsBtn, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder(WqI18n.a("Geo.Cells.Border.Layers").getText()));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)serializable, gridBagConstraints);
        serializable2 = new JLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)serializable2, gridBagConstraints);
        this._editLayersBtn = WqI18n.a("Geo.Cells.Button.Edit").createJButton();
        serializable2 = new ReservoirLayerHeightAction(this);
        this._editLayersBtn.setAction((Action)((Object)serializable2));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ((Container)serializable).add(this._editLayersBtn, gridBagConstraints);
        this._showTableBtn = WqI18n.a("Geo.Cells.Button.ShowTable").createJButton();
        this._showTableAction = new ShowTableCellLengthAction(this._editor);
        this._showTableBtn.setAction(this._showTableAction);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        CellsPanel cellsPanel = this;
        cellsPanel.add(cellsPanel._showTableBtn, gridBagConstraints);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._rasCellSpacingRadio);
        ((ButtonGroup)serializable).add(this._adjustCellSpacingRadio);
        this.cellsRadioAction();
    }

    private void addListeners() {
        this._rasCellSpacingRadio.addActionListener(actionEvent -> this.cellsRadioAction());
        this._adjustCellSpacingRadio.addActionListener(actionEvent -> this.cellsRadioAction());
    }

    private void cellsRadioAction() {
        this._editLengthsBtn.setEnabled(this._adjustCellSpacingRadio.isSelected());
    }

    public String getTabname() {
        return this._tabName;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.cellsRadioAction();
    }

    public void fillPanel(NamedType object) {
        if (object instanceof ManagerProxyWrapper) {
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            this._currentGeo = (WqGeometry)object.loadManager(null, null);
        }
        if (this._currentGeo != null) {
            object = this._currentGeo.getRssWqGeometry();
            if (object != null) {
                object = object.getReachLengthDefinition();
                if (ReachCellLengthDefinitionType.RAS == (object = object.getType())) {
                    this._rasCellSpacingRadio.setSelected(true);
                } else {
                    this._adjustCellSpacingRadio.setSelected(true);
                }
            }
            this.cellsRadioAction();
        }
    }

    public boolean savePanel(NamedType object) {
        WqGeometry wqGeometry = this._currentGeo;
        if (object instanceof WqGeometry) {
            wqGeometry = (WqGeometry)((Object)object);
        }
        if (wqGeometry == null) {
            return true;
        }
        if (wqGeometry != null) {
            object = wqGeometry.getRssWqGeometry().getReachLengthDefinition();
            if (this._rasCellSpacingRadio.isSelected()) {
                ((ReachCellLengthDefinition)object).setType(ReachCellLengthDefinitionType.RAS);
            }
        }
        return true;
    }

    public int getTabMnemonic() {
        return WqI18n.a("Geo.Cells.TabName").getMnemonic();
    }

    public WqGeometry getGeometry() {
        return this._currentGeo;
    }

    @Override
    public void tabChanged() {
        this._showTableAction.closeDialog();
    }
}

