/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.gui.AbstractEditorPanel;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.lang.NamedType;
import hec.map.MapIdentifier;
import hec.map.aishape.AiShapeMap;
import hec.rss.plugins.waterquality.model.Connection;
import hec.rss.plugins.waterquality.model.ConnectionSet;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.WqUiUtils;
import hec.rss.wq.client.geometry.ConnectionsPanel$1;
import hec.rss.wq.client.geometry.ConnectionsPanel$2;
import hec.rss.wq.client.geometry.ConnectionsPanel$CrossSectionDefaulter;
import hec.rss.wq.client.geometry.ConnectionsPanel$LoadTableRunnable;
import hec.rss.wq.client.geometry.ConnectionsPanel$RiverReachStation;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.geometry.GeometryEditorTab;
import hec.rss.wq.map.CrossSectionManagerGlyph;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.util.AnimatedWaitGlassPane;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class ConnectionsPanel
extends AbstractEditorPanel
implements GeometryEditorTab {
    private GeometryEditor _editor;
    private String _tabName;
    private RmaJTable _reachTable;
    private WqGeometry _currentGeo;
    private ConnectionsPanel$RiverReachStation _emptyRrs;
    private File _shapeFile;
    private AiShapeMap _map;
    private SortedSet<ConnectionsPanel$RiverReachStation> _columnValues;
    private final ReentrantLock _mapLock = new ReentrantLock();

    public ConnectionsPanel(GeometryEditor geometryEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = geometryEditor;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("Geo.Connections.TabName").getText();
        Object object = new String[]{WqI18n.a("Geo.Connections.Table.Reach").getText(), WqI18n.a("Geo.Connections.Table.UpstreamXsection").getText(), WqI18n.a("Geo.Connections.Table.DownstreamXSection").getText()};
        ConnectionsPanel connectionsPanel = this;
        this._reachTable = new ConnectionsPanel$1(connectionsPanel, (Component)((Object)connectionsPanel), (Object[])object);
        this._reachTable.setRowHeight(this._reachTable.getRowHeight() + 5);
        this._reachTable.setComboBoxEditor(1, new Object[0]);
        this._reachTable.setComboBoxEditor(2, new Object[0]);
        this._reachTable.removePopupMenuRowEditingOptions();
        this._reachTable.removePopupMenuSumOptions();
        this._reachTable.removePopuMenuFillOptions();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        ConnectionsPanel connectionsPanel2 = this;
        connectionsPanel2.add(connectionsPanel2._reachTable.getScrollPane(), object);
    }

    private void addListeners() {
        this._reachTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.selectElementInMapWindow());
        this.addMouseListener(new ConnectionsPanel$2(this));
    }

    protected void displayPopupMenu(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = WqI18n.a("Geo.Connections.Menu.SetCrossSections").createMenuItem();
        jMenuItem.addActionListener(actionEvent -> this.selectDefaultCrossSections());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show((Component)((Object)this), point.x, point.y);
    }

    protected void selectElementInMapWindow() {
        int n = this._reachTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        Object object = this._reachTable.getValueAt(n, 0);
        if (object instanceof SubDomain) {
            WqUiUtils.a((SubDomain)object, this._currentGeo);
        }
        if ((object = (CrossSectionManagerGlyph)ClientApp.frame().getMapPanel().findGlyphOfClass(CrossSectionManagerGlyph.class.getName())) != null) {
            AiShapeMap cfr_ignored_0 = (AiShapeMap)object.getMap();
            ConnectionsPanel$RiverReachStation cfr_ignored_1 = (ConnectionsPanel$RiverReachStation)this._reachTable.getValueAt(n, 1);
            ConnectionsPanel$RiverReachStation cfr_ignored_2 = (ConnectionsPanel$RiverReachStation)this._reachTable.getValueAt(n, 1);
        }
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType object) {
        Object object2;
        Object object3;
        this._reachTable.deleteCells();
        this._map = null;
        if (object instanceof ManagerProxyWrapper) {
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            this._currentGeo = (WqGeometry)object.loadManager(null, null);
        }
        if (this._currentGeo == null) {
            return;
        }
        object = this._currentGeo.getRssWqGeometry();
        if (object != null) {
            object3 = object.getReaches();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                SubDomain subDomain = (SubDomain)object2.next();
                object3 = new Vector<SubDomain>(3);
                ((Vector)object3).add(subDomain);
                ((Vector)object3).add(this.getCrossSection((RssWQGeometry)object, subDomain, true));
                ((Vector)object3).add(this.getCrossSection((RssWQGeometry)object, subDomain, false));
                this._reachTable.appendRow((Vector)object3);
            }
        }
        if ((object3 = this._currentGeo.getCrossSectionManager()) == null) {
            return;
        }
        object3 = new ConnectionsPanel$LoadTableRunnable(this, ((CrossSectionManager)((Object)object3)).getRasFile(), ((CrossSectionManager)((Object)object3)).getRiverColumn(), ((CrossSectionManager)((Object)object3)).getReachColumn(), ((CrossSectionManager)((Object)object3)).getStationColumn());
        object2 = new Thread((Runnable)object3);
        ((Thread)object2).start();
    }

    private ConnectionsPanel$RiverReachStation getCrossSection(RssWQGeometry object, SubDomain subDomain, boolean bl) {
        object = ((RssWQGeometry)object).getConnectionSet();
        subDomain = (WQSubDomainRef)subDomain.getRef();
        object = bl ? ((ConnectionSet)object).getUpstream((WQSubDomainRef)subDomain) : ((ConnectionSet)object).getDownstream((WQSubDomainRef)subDomain);
        if (object != null) {
            object = new ConnectionsPanel$RiverReachStation(((Connection)object).getRiver(), ((Connection)object).getReach(), ((Connection)object).getStation());
            return object;
        }
        return null;
    }

    public boolean savePanel(NamedType object) {
        WqGeometry wqGeometry = this._currentGeo;
        if (object instanceof WqGeometry) {
            wqGeometry = (WqGeometry)((Object)object);
        }
        if (wqGeometry == null) {
            return true;
        }
        if (wqGeometry != null) {
            if (!this.isValidPanel()) {
                return false;
            }
            object = wqGeometry.getRssWqGeometry();
            object = ((RssWQGeometry)object).getConnectionSet();
            int n = this._reachTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                SubDomain subDomain = (SubDomain)this._reachTable.getValueAt(i, 0);
                Object object2 = (ConnectionsPanel$RiverReachStation)this._reachTable.getValueAt(i, 1);
                ConnectionsPanel$RiverReachStation connectionsPanel$RiverReachStation = (ConnectionsPanel$RiverReachStation)this._reachTable.getValueAt(i, 2);
                if (object2 != null && object2 != this._emptyRrs) {
                    object2 = new Connection(((ConnectionsPanel$RiverReachStation)object2).a(), ((ConnectionsPanel$RiverReachStation)object2).b(), ((ConnectionsPanel$RiverReachStation)object2).c());
                    ((ConnectionSet)object).setUpstream((WQSubDomainRef)subDomain.getRef(), (Connection)object2);
                }
                if (connectionsPanel$RiverReachStation == null || connectionsPanel$RiverReachStation == this._emptyRrs) continue;
                object2 = new Connection(connectionsPanel$RiverReachStation.a(), connectionsPanel$RiverReachStation.b(), connectionsPanel$RiverReachStation.c());
                ((ConnectionSet)object).setDownstream((WQSubDomainRef)subDomain.getRef(), (Connection)object2);
            }
        }
        wqGeometry.setModified(true);
        this.setModified(false);
        return true;
    }

    public AiShapeMap getAiShapeMap() {
        if (this._map != null) {
            return this._map;
        }
        if (this._shapeFile == null || !this._shapeFile.exists()) {
            return null;
        }
        this._map = new AiShapeMap();
        String string = this._shapeFile.getAbsolutePath();
        this._map.setMapIdentifier(new MapIdentifier(string, (HecFile)new HecFileImpl(new FilePath(string))));
        try {
            this._map.load();
        }
        catch (IOException iOException) {
            this._map = null;
            return null;
        }
        return this._map;
    }

    private boolean isValidPanel() {
        int n = this._reachTable.getRowCount();
        ArrayList<SubDomain> arrayList = new ArrayList<SubDomain>();
        for (int i = 0; i < n; ++i) {
            SubDomain subDomain = (SubDomain)this._reachTable.getValueAt(i, 0);
            ConnectionsPanel$RiverReachStation connectionsPanel$RiverReachStation = (ConnectionsPanel$RiverReachStation)this._reachTable.getValueAt(i, 1);
            ConnectionsPanel$RiverReachStation connectionsPanel$RiverReachStation2 = (ConnectionsPanel$RiverReachStation)this._reachTable.getValueAt(i, 2);
            if (connectionsPanel$RiverReachStation == null || connectionsPanel$RiverReachStation2 == null || connectionsPanel$RiverReachStation.a().equals(connectionsPanel$RiverReachStation2.a())) continue;
            arrayList.add(subDomain);
        }
        if (!arrayList.isEmpty()) {
            String string = "The following reaches have cross sections that upstream and downstream aren't on the same river.";
            String string2 = ((Object)arrayList).toString();
            string2 = RMAIO.removeChar((String)string2, (char)'[');
            string2 = RMAIO.removeChar((String)string2, (char)']');
            string2 = string2.replace(',', '\n');
            string = string.concat("\n").concat(string2);
            string2 = "River mismatch";
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), string, string2, 1);
            return false;
        }
        return true;
    }

    public int getTabMnemonic() {
        return WqI18n.a("Geo.Connections.TabName").getMnemonic();
    }

    public void selectDefaultCrossSections() {
        Object object = this.getAiShapeMap();
        if (object == null) {
            return;
        }
        AnimatedWaitGlassPane animatedWaitGlassPane = new AnimatedWaitGlassPane();
        animatedWaitGlassPane.setColor(Color.BLACK);
        Component component = this._editor.getGlassPane();
        animatedWaitGlassPane.setCursor(Cursor.getPredefinedCursor(3));
        this._editor.setGlassPane((Component)animatedWaitGlassPane);
        animatedWaitGlassPane.setVisible(true);
        animatedWaitGlassPane.setActive(true);
        object = new ConnectionsPanel$CrossSectionDefaulter(this, (AiShapeMap)object, component, animatedWaitGlassPane);
        object.execute();
    }
}

