/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.geometry.ExtentDrawPropData;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaJColorComboBox;

public class ExtentDrawPropDataPanel
extends JPanel {
    private ExtentDrawPropData _extentDrawPropData;
    private final int _scale;
    RmaJColorComboBox _extentColorComboBox;

    public ExtentDrawPropDataPanel(ExtentDrawPropData extentDrawPropData, int n) {
        this._scale = n;
        this._extentDrawPropData = extentDrawPropData;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(WqI18n.a("WqDrawingPropertiesEditor.Tab.Extent.Label.OutsideExtentColor").getText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this._extentColorComboBox = new RmaJColorComboBox();
        this._extentColorComboBox.setModifiable(true);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ExtentDrawPropDataPanel extentDrawPropDataPanel = this;
        extentDrawPropDataPanel.add((Component)extentDrawPropDataPanel._extentColorComboBox, gridBagConstraints);
    }

    private void fillPanel() {
        if (this._extentDrawPropData == null) {
            return;
        }
        this._extentColorComboBox.setSelectedColor(this._extentDrawPropData.getColor());
    }

    public void savePanel() {
        if (this._extentDrawPropData == null) {
            return;
        }
        this._extentDrawPropData.setColor(this._extentColorComboBox.getSelectedColor());
        this._extentDrawPropData.save(this._scale);
    }

    public void setToDefaults() {
        ((WaterQualityDPData)this._extentDrawPropData).setDefaults();
        this.fillPanel();
    }

    public ExtentDrawPropData copyData(int n) {
        return ExtentDrawPropData.a(n, this._extentDrawPropData);
    }

    public void fillPanel(ExtentDrawPropData extentDrawPropData) {
        this._extentDrawPropData = extentDrawPropData;
        this.fillPanel();
    }
}

