/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.SelectorPanelEditor;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.map.WorldLine;
import hec.map.aishape.AiShapeMap;
import hec.rss.model.ReachElement;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.ConnectionMap;
import hec.rss.plugins.waterquality.model.ReachCellLengthDefinition;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.geometry.CellsPanel;
import hec.rss.wq.client.geometry.ConnectionsPanel;
import hec.rss.wq.client.geometry.ExtentsPanel;
import hec.rss.wq.client.geometry.GeometryEditorTab;
import hec.rss.wq.client.geometry.GeometryMapGlyph;
import hec.rss.wq.client.geometry.GeometryUpdater;
import hec.rss.wq.client.geometry.MetStationsPanel;
import hec.rss.wq.client.geometry.MissingCrossSectionFileDialog;
import hec.rss.wq.client.geometry.RegionsPanel;
import hec.rss.wq.client.geometry.actions.DeleteGeoAction;
import hec.rss.wq.client.geometry.actions.NewGeoAction;
import hec.rss.wq.client.geometry.actions.RenameGeoAction;
import hec.rss.wq.client.geometry.actions.SaveGeoAsAction;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.ui.FileChooserField;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.WQException;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;
import rma.util.RMAFilenameFilter;

public class GeometryEditor
extends SelectorPanelEditor {
    public static final Logger logger = Logger.getLogger(GeometryEditor.class.getName());
    protected boolean _canceled;
    private ExtentsPanel _extentsPanel;
    private ConnectionsPanel _connectionsPanel;
    private CellsPanel _cellsPanel;
    private RegionsPanel _regionsPanel;
    private MetStationsPanel _metStationsPanel;
    private NewGeoAction _newAction;
    private RenameGeoAction _renameAction;
    private DeleteGeoAction _deleteAction;
    private RmaJTextField _networkFld;
    private RmaJTextField _rasGeoFld;
    private FileChooserField _rasSteadyFlowFld;
    private String _title;
    private WqGeometry _selectedGeo;
    private JMenu _wqMenu;
    private ManagerProxyListContainer _wksp;
    private GeometryEditorTab _selectedTab;
    private JButton _updateButton;
    private boolean _initialized = false;
    private JPanel _msgPanel;
    private RmaJTextField _msgText;

    public GeometryEditor(Frame frame) {
        super(frame, false);
        this.createControls();
        this.createMenus();
        this.addListeners();
        this.pack();
        GeometryEditor geometryEditor = this;
        geometryEditor.setMinimumSize(geometryEditor.getSize());
        this.setLocationRelativeTo(frame);
    }

    private void createControls() {
        this._title = WqI18n.a("Geo.Editor.Title").getText();
        GeometryEditor geometryEditor = this;
        geometryEditor.setTitle(geometryEditor._title);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        Serializable serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jPanel.add((Component)serializable, gridBagConstraints);
        Object object = WqI18n.a("Geo.Editor.Label.Network").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)object, gridBagConstraints);
        this._networkFld = new RmaJTextField();
        this._networkFld.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._networkFld, gridBagConstraints);
        this._updateButton = WqI18n.a("Geo.Editor.Button.UpdateGeometry").createJButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ((Container)serializable).add(this._updateButton, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jPanel.add((Component)serializable, gridBagConstraints);
        object = WqI18n.a("Geo.Editor.Label.RasGeometry").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)object, gridBagConstraints);
        this._rasGeoFld = new RmaJTextField();
        this._rasGeoFld.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._rasGeoFld, gridBagConstraints);
        object = WqI18n.a("Geo.Editor.Label.RasSteadyFlow").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)object, gridBagConstraints);
        this._rasSteadyFlowFld = new FileChooserField();
        this._rasSteadyFlowFld.setHasAcceptAllFilter(false);
        serializable = new ArrayList();
        object = new ArrayList<String>();
        object.add(".*.u[0-9][0-9]");
        object = WqI18n.a("Geo.Editor.Filter.RasProfile").getText();
        object = new RMAFilenameFilter("txt", (String)object);
        object.setAcceptDirectories(true);
        serializable.add(object);
        this._rasSteadyFlowFld.setFilters((List)((Object)serializable));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)((Object)this._rasSteadyFlowFld), gridBagConstraints);
        this._extentsPanel = new ExtentsPanel(this);
        GeometryEditor geometryEditor2 = this;
        geometryEditor2.addPanel(geometryEditor2._extentsPanel);
        this._connectionsPanel = new ConnectionsPanel(this);
        GeometryEditor geometryEditor3 = this;
        geometryEditor3.addPanel(geometryEditor3._connectionsPanel);
        this.getTabbedPane().setMnemonicAt(0, this._extentsPanel.getTabMnemonic());
        this.getTabbedPane().setMnemonicAt(1, this._connectionsPanel.getTabMnemonic());
        this._cellsPanel = new CellsPanel(this);
        GeometryEditor geometryEditor4 = this;
        geometryEditor4.addPanel(geometryEditor4._cellsPanel);
        this.getTabbedPane().setMnemonicAt(2, this._cellsPanel.getTabMnemonic());
        this._regionsPanel = new RegionsPanel(this);
        GeometryEditor geometryEditor5 = this;
        geometryEditor5.addPanel(geometryEditor5._regionsPanel);
        this.getTabbedPane().setMnemonicAt(3, this._regionsPanel.getTabMnemonic());
        this._metStationsPanel = new MetStationsPanel(this);
        GeometryEditor geometryEditor6 = this;
        geometryEditor6.addPanel(geometryEditor6._metStationsPanel);
        this.getTabbedPane().setMnemonicAt(4, this._metStationsPanel.getTabMnemonic());
        this._msgPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this._msgPanel, gridBagConstraints);
        this._msgText = new RmaJTextField();
        this._msgText.setEditable(false);
        this._msgText.setBorder(null);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._msgPanel.add((Component)this._msgText, gridBagConstraints);
        this.setPanelsEnabled(false);
    }

    private void createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this._wqMenu = WqI18n.a("Geo.Editor.Menu.Geometry").createMenu();
        jMenuBar.add(this._wqMenu);
        this._newAction = new NewGeoAction(this);
        this._wqMenu.add(new JMenuItem(this._newAction));
        JMenuItem jMenuItem = WqI18n.a("Geo.Editor.MenuItem.SaveAs").createMenuItem();
        jMenuItem.addActionListener(actionEvent -> this.saveGeometryAsAction());
        this._wqMenu.add(jMenuItem);
        this._renameAction = new RenameGeoAction(this);
        if (Boolean.getBoolean("WqEditors.HasRename")) {
            this._wqMenu.add(new JMenuItem(this._renameAction));
        }
        this._deleteAction = new DeleteGeoAction(this);
        this._wqMenu.add(new JMenuItem(this._deleteAction));
        this.setJMenuBar(jMenuBar);
    }

    private void saveGeometryAsAction() {
        Object object;
        boolean bl;
        WqGeometry wqGeometry;
        boolean bl2;
        Identifier identifier;
        RmiFileManager rmiFileManager;
        block21: {
            Object object2 = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
            if (object2 == null) {
                return;
            }
            object2 = object2.getManagerProxy();
            object2 = (WqGeometry)object2.loadManager(null, null);
            Object object3 = this._selectedGeo.getIdentifier();
            object3 = object3.getPath();
            object3 = object3.concat(".temp");
            rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            object3 = new Identifier((String)object3);
            identifier = null;
            try {
                identifier = rmiFileManager.newFile(UserId.getUserId(), object3);
                if (identifier == null) {
                    identifier = rmiFileManager.openFile(UserId.getUserId(), object3);
                }
            }
            catch (RemoteException remoteException) {
                object3 = remoteException;
                remoteException.printStackTrace();
            }
            bl2 = this.isModified();
            wqGeometry = this._selectedGeo;
            if (identifier != null) {
                this._selectedGeo.writeFile(identifier);
                if (this.isModified()) {
                    if (!super.saveForm()) {
                        return;
                    }
                    this._selectedGeo.setModified(true);
                }
            }
            bl = false;
            if (!bl2 || object2 == null) break block21;
            object2 = WqI18n.a("Geo.Editor.Msg.SaveMgr").format(object2);
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), object2, (String)(object = WqI18n.a("Geo.Editor.Msg.SaveMgr.Title").getText()), 1);
            if (n == 0) {
                bl = true;
                break block21;
            }
            if (2 != n) break block21;
            wqGeometry.readFile(identifier);
            this._wksp.saveManager("rss", (Manager)wqGeometry);
            try {
                rmiFileManager.deleteFile(identifier.getPath());
            }
            catch (RemoteException remoteException) {
                logger.log(Level.WARNING, "saveGeometryAsAction: exception deleting file " + identifier.getPath() + " error:" + String.valueOf(remoteException));
            }
            EventQueue.invokeLater(() -> this.setCursor(Cursor.getDefaultCursor()));
            return;
        }
        try {
            Object object4 = new SaveGeoAsAction((Dialog)((Object)this));
            object = ((SaveGeoAsAction)object4).a(this._selectedGeo, this.getSelectorPanel().getDescription());
            if (object != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (bl2) {
                    this._wksp.saveManager("rss", (Manager)this._selectedGeo);
                }
                object4 = ((JsonManager)((Object)object)).getName();
                String string = ((JsonManager)((Object)object)).getDescription();
                int n = ((JsonManager)((Object)object)).getIndex();
                ((JsonManager)((Object)object)).readFile(this._selectedGeo.getIdentifier());
                object.setName((String)object4);
                object.setDescription(string);
                object.setIndex(n);
                this._wksp.saveManager("rss", (Manager)object);
                this.setModified(false);
                object4 = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
                this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object4), true);
                NewGeoAction.a((WqGeometry)((Object)object));
            }
            return;
        }
        finally {
            if (!bl) {
                wqGeometry.readFile(identifier);
                this._wksp.saveManager("rss", (Manager)wqGeometry);
            }
            try {
                rmiFileManager.deleteFile(identifier.getPath());
            }
            catch (RemoteException remoteException) {
                logger.log(Level.WARNING, "saveGeometryAsAction: exception deleting file " + identifier.getPath() + " error:" + String.valueOf(remoteException));
            }
            EventQueue.invokeLater(() -> this.setCursor(Cursor.getDefaultCursor()));
        }
    }

    private void addListeners() {
        this.getTabbedPane().addChangeListener(changeEvent -> this.tabChanged());
        this._updateButton.addActionListener(actionEvent -> this.updateGeometryFromNetwork());
    }

    private void updateGeometryFromNetwork() {
        Object object = this.getSystem();
        if (this._selectedGeo == null || object == null) {
            return;
        }
        GeometryEditor geometryEditor = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)geometryEditor), "<html>Confirm updating Geometry <b>" + geometryEditor._selectedGeo.getName() + "</b> from the Network <b>" + object.getName() + "</b>?</html>", "Confirm Update", 0);
        if (n != 0) {
            return;
        }
        object = new GeometryUpdater(this._selectedGeo, (RssSystem)object, (Component)((Object)this));
        ((GeometryUpdater)object).a(this._wksp);
    }

    private void tabChanged() {
        if (this._selectedTab != null) {
            this._selectedTab.tabChanged();
        }
        this._selectedTab = (GeometryEditorTab)((Object)this.getTabbedPane().getSelectedComponent());
    }

    private void setPanelsEnabled(boolean bl) {
        int n = this.getTabbedPane().getTabCount();
        for (int i = 0; i < n; ++i) {
            this.getTabbedPane().getComponentAt(i).setEnabled(bl);
        }
    }

    public void setSelectedGeometry(WqGeometry object) {
        object = object.getProxyList().getManagerProxy(object.getIdentifier());
        object = new ManagerProxyWrapper((ManagerProxy)object);
        this.selectorPanel.setSelectedItem(object);
        if (this._initialized) {
            this.refresh();
        }
    }

    public void fillForm(NamedType object) {
        WqGeometry wqGeometry = null;
        int n = 0;
        if (object instanceof ManagerProxyWrapper) {
            ManagerProxy managerProxy = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            wqGeometry = (WqGeometry)managerProxy.loadManager(null, null);
            n = wqGeometry != null ? 1 : 0;
        }
        this._selectedGeo = wqGeometry;
        super.fillForm(object);
        this.setPanelsEnabled(n != 0);
        if (n != 0) {
            ManagerProxy managerProxy;
            n = wqGeometry.getNetworkId();
            object = this._wksp.getManagerProxy("rss", RssSystem.class.getName(), n);
            if (object != null) {
                this._networkFld.setText(object.getName());
                this._networkFld.setToolTipText(object.getDescription());
                this.setErrorMessage(null);
            } else {
                this._networkFld.setText("");
                this._networkFld.setToolTipText(null);
                object = WqI18n.a("Geo.Editor.Msg.FailedToFindNetwork").format((Object)wqGeometry.getName());
                this.setErrorMessage((String)object);
            }
            this._rasGeoFld.setText("");
            this._rasGeoFld.setToolTipText(null);
            int n2 = wqGeometry.getCrossSectionManagerId();
            if (n2 != -1 && (managerProxy = this._wksp.getManagerProxy("rss", CrossSectionManager.class.getName(), n2)) != null) {
                this._rasGeoFld.setText(managerProxy.getName());
                this._rasGeoFld.setToolTipText(managerProxy.getDescription());
                EventQueue.invokeLater(() -> this.checkForMissingCrossSectionFile(managerProxy));
            }
            this._connectionsPanel.setEnabled(this.hasAiShapeMap());
            Object object2 = wqGeometry.getSteadyFlowPath();
            if (object2 != null) {
                this._rasSteadyFlowFld.setText(object2.toString());
            } else {
                this._rasSteadyFlowFld.clearPerformed();
            }
            object2 = ClientApp.frame().getCurrentMode();
            if (this.isVisible() && object2 instanceof WaterQualityMode) {
                object2 = (WaterQualityMode)object2;
                ((WaterQualityMode)object2).setGeometry(wqGeometry);
            }
        }
    }

    public boolean hasAiShapeMap() {
        AiShapeMap aiShapeMap = this.getAiShapeMap();
        return aiShapeMap != null;
    }

    public AiShapeMap getAiShapeMap() {
        ManagerProxy managerProxy;
        int n;
        CrossSectionManager crossSectionManager = null;
        if (this._selectedGeo != null && (n = this._selectedGeo.getCrossSectionManagerId()) != -1 && (managerProxy = this._wksp.getManagerProxy("rss", CrossSectionManager.class.getName(), n)) != null && (managerProxy = managerProxy.loadManager(null, null)) instanceof CrossSectionManager) {
            crossSectionManager = (CrossSectionManager)managerProxy;
            crossSectionManager = crossSectionManager.getShapeMap();
        }
        return crossSectionManager;
    }

    private void checkForMissingCrossSectionFile(ManagerProxy object) {
        if (object == null) {
            this._connectionsPanel.setEnabled(false);
            this._cellsPanel.setEnabled(false);
            this._rasGeoFld.setForeground(Color.RED);
            return;
        }
        object = (CrossSectionManager)object.loadManager(null, null);
        String string = object.getRasFile();
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            if (!rmiFileManager.fileExists(string)) {
                if (!this.selectMissingCrossSectionFile((CrossSectionManager)((Object)object), string)) {
                    this._connectionsPanel.setEnabled(false);
                    this._cellsPanel.setEnabled(false);
                    this._rasGeoFld.setForeground(Color.RED);
                    this._rasGeoFld.setToolTipText("<html>Missing Cross Section Shape File:<br>" + string);
                    return;
                }
                this._connectionsPanel.fillPanel((NamedType)this.selectorPanel.getSelectedItem());
            }
        }
        catch (RemoteException remoteException) {}
        this._connectionsPanel.setEnabled(true);
        this._cellsPanel.setEnabled(true);
        this._rasGeoFld.setToolTipText("Using Cross Section Shape File:<br>" + string);
        this._rasGeoFld.setForeground(UIManager.getColor("Textfield.foreground"));
    }

    private boolean selectMissingCrossSectionFile(CrossSectionManager crossSectionManager, String object) {
        object = new MissingCrossSectionFileDialog((JDialog)((Object)this), (String)object, crossSectionManager.getRiverColumn(), crossSectionManager.getReachColumn(), crossSectionManager.getStationColumn());
        ((MissingCrossSectionFileDialog)((Object)object)).setWorkspace(this._wksp);
        object.setVisible(true);
        if (((MissingCrossSectionFileDialog)((Object)object)).isCanceled()) {
            return false;
        }
        crossSectionManager.setRasFile(((MissingCrossSectionFileDialog)((Object)object)).getShapeFilePath().getAbsolutePath());
        crossSectionManager.setRiverColumn(((MissingCrossSectionFileDialog)((Object)object)).getRiverColumnName());
        crossSectionManager.setReachColumn(((MissingCrossSectionFileDialog)((Object)object)).getReachColumnName());
        crossSectionManager.setStationColumn(((MissingCrossSectionFileDialog)((Object)object)).getStreamStationColumnName());
        crossSectionManager.setModified(true);
        this._wksp.saveManager("rss", (Manager)crossSectionManager);
        return true;
    }

    public boolean saveForm(NamedType namedType) {
        Object object;
        Object object2 = this._selectedGeo;
        if (namedType instanceof ManagerProxyWrapper) {
            object = (ManagerProxyWrapper)namedType;
            object2 = (WqGeometry)object.getManagerProxy().loadManager(null, null);
        }
        if (object2 == null) {
            return true;
        }
        object = object2.getRssWqGeometry();
        try {
            object2.updateSteadyFlowPath(new File(this._rasSteadyFlowFld.getPath()).toPath(), ClientApp.Workspace().getUnitSystem());
        }
        catch (WQException wQException) {
            logger.log(Level.WARNING, "Exception updating RAS steady flow file " + wQException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), "Exception updating RAS steady flow file " + wQException.getMessage(), "Error", 0);
            return false;
        }
        object2.setModified(true);
        object.updateBoundariesForExtent();
        object.updateWQJunctionsForExtent();
        object2 = object2.getCrossSectionManager();
        if (object2 != null) {
            AiShapeMap aiShapeMap = ((CrossSectionManager)((Object)object2)).getShapeMap();
            this.updateXRAS((CrossSectionManager)((Object)object2), aiShapeMap);
            try {
                this.updateCells((RssWQGeometry)object);
            }
            catch (WQException wQException) {
                object2 = WqI18n.a("Geo.Editor.Msg.WQ.UpdateCellsError").getText();
                logger.log(Level.WARNING, () -> GeometryEditor.b((String)object2, wQException));
                JOptionPane.showMessageDialog((Component)((Object)this), (String)object2 + " " + wQException.getMessage(), WqI18n.a("Geo.Editor.Title.WQ.UpdateCellsError").getText(), 0);
                return false;
            }
        }
        return super.saveForm(namedType);
    }

    public boolean saveForm() {
        boolean bl = super.saveForm();
        if (this._selectedGeo != null) {
            Object object = this._selectedGeo.getRssWqGeometry();
            this._selectedGeo.setSteadyFlowPath(new File(this._rasSteadyFlowFld.getPath()).toPath());
            this._selectedGeo.setModified(true);
            object.updateBoundariesForExtent();
            object.updateWQJunctionsForExtent();
            CrossSectionManager crossSectionManager = this._selectedGeo.getCrossSectionManager();
            if (crossSectionManager != null) {
                AiShapeMap aiShapeMap = crossSectionManager.getShapeMap();
                this.updateXRAS(crossSectionManager, aiShapeMap);
                try {
                    this.updateCells((RssWQGeometry)object);
                }
                catch (WQException wQException) {
                    object = WqI18n.a("Geo.Editor.Msg.WQ.UpdateCellsError").getText();
                    logger.log(Level.WARNING, () -> GeometryEditor.a((String)object, wQException));
                    JOptionPane.showMessageDialog((Component)((Object)this), (String)object + " " + wQException.getMessage(), WqI18n.a("Geo.Editor.Title.WQ.UpdateCellsError").getText(), 0);
                    return false;
                }
            }
        }
        return bl;
    }

    public void updateCells(RssWQGeometry object) throws WQException {
        RssSystem rssSystem = this.getSystem();
        ReachCellLengthDefinition reachCellLengthDefinition = ((RssWQGeometry)object).getReachLengthDefinition();
        for (SubDomain subDomain : object.getReaches()) {
            if (!(subDomain instanceof WQGeoSubDomain)) continue;
            subDomain = (WQGeoSubDomain)subDomain;
            this.updateCellsForReach(rssSystem, reachCellLengthDefinition, (WQGeoSubDomain)subDomain);
        }
    }

    public void updateCellsForReach(RssSystem object, ReachCellLengthDefinition list, WQGeoSubDomain wQGeoSubDomain) throws WQException {
        ReachElement reachElement = this.getReachElement((RssSystem)object, wQGeoSubDomain);
        if (reachElement != null) {
            Double d;
            double d2 = ConnectionMap.getReachElemLength(reachElement, (RssSystem)object);
            object = null;
            switch (((ReachCellLengthDefinition)((Object)list)).getType()) {
                case Global: {
                    d = ((ReachCellLengthDefinition)((Object)list)).getGlobalMaximum();
                    object = ((ReachCellLengthDefinition)((Object)list)).getGlobalMinimum();
                    list = DoubleStream.of(wQGeoSubDomain.getCellLength()).boxed().collect(Collectors.toCollection(ArrayList::new));
                    list = ConnectionMap.adjustLengths(list, (Double)object, d);
                    object = ConnectionMap.lengthsToBoundaryRatios(list);
                    object = object.stream().mapToDouble(Double::doubleValue).toArray();
                    break;
                }
                case RAS: {
                    object = ConnectionMap.findXFace(wQGeoSubDomain.getXRAS());
                    break;
                }
                case SubDomain: {
                    d = ((ReachCellLengthDefinition)((Object)list)).getMinimum(wQGeoSubDomain.getRef());
                    object = ((ReachCellLengthDefinition)((Object)list)).getMaximum(wQGeoSubDomain.getRef());
                    list = DoubleStream.of(wQGeoSubDomain.getCellLength()).boxed().collect(Collectors.toCollection(ArrayList::new));
                    list = ConnectionMap.adjustLengths(list, d, (Double)object);
                    object = ConnectionMap.lengthsToBoundaryRatios(list);
                    object = object.stream().mapToDouble(Double::doubleValue).toArray();
                    break;
                }
                default: {
                    logger.warning("Unrecognized reach type:" + String.valueOf((Object)((ReachCellLengthDefinition)((Object)list)).getType()));
                }
            }
            if (object != null && ((Object)object).length > 2) {
                d = ConnectionMap.getWorldLine(reachElement);
                ConnectionMap.updateCellDetails(wQGeoSubDomain, d2, (WorldLine)d, (double[])object);
                return;
            }
            if (object == null) {
                logger.warning("null xFace array was generated for reach:" + wQGeoSubDomain.getName());
                return;
            }
            if (((Object)object).length < 2) {
                logger.warning("Invalid xFace array with length <= 2 :" + Arrays.toString((double[])object) + " was generated for reach:" + wQGeoSubDomain.getName());
            }
        }
    }

    public void updateXRAS(CrossSectionManager object, AiShapeMap aiShapeMap) {
        if (aiShapeMap != null) {
            object = new ConnectionMap(((CrossSectionManager)((Object)object)).getRiverColumn(), ((CrossSectionManager)((Object)object)).getReachColumn(), ((CrossSectionManager)((Object)object)).getStationColumn());
            ((ConnectionMap)object).initialize(aiShapeMap);
            ((ConnectionMap)object).updateXRAS(this._selectedGeo);
            return;
        }
        logger.warning("Supplied a null AiShapeMap, xRAS unchanged");
    }

    public ReachElement getReachElement(RssSystem rssReturnStatusConstants, WQGeoSubDomain wQGeoSubDomain) {
        int n = wQGeoSubDomain.getElementId();
        ReachElement reachElement = null;
        if (rssReturnStatusConstants != null && (rssReturnStatusConstants = rssReturnStatusConstants.getElement(n)) instanceof ReachElement) {
            reachElement = (ReachElement)rssReturnStatusConstants;
        }
        return reachElement;
    }

    private RssSystem getSystem() {
        RssSystem rssSystem = this._selectedGeo.getNetwork();
        if (rssSystem == null) {
            logger.log(Level.WARNING, "Failed to find Reservoir Network for ID " + this._selectedGeo.getNetworkId());
        }
        return rssSystem;
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            GeometryEditor geometryEditor = this;
            geometryEditor.setTitle(geometryEditor._title.concat("*"));
            return;
        }
        GeometryEditor geometryEditor = this;
        geometryEditor.setTitle(geometryEditor._title);
    }

    public WqGeometry getSelectedGeometry() {
        return this._selectedGeo;
    }

    public void fillForm(ManagerProxyListContainer object) {
        this._wksp = object;
        this._wqMenu.setVisible(object instanceof ClientWorkspace);
        object = object.getManagerProxyList("rss", WqGeometry.class.getName());
        object = object.stream().map(managerProxy -> new ManagerProxyWrapper((ManagerProxy)managerProxy)).collect(Collectors.toList());
        this.getSelectorPanel().setSelectionList((Collection)object);
        this._initialized = true;
    }

    public ManagerProxyListContainer getWorkSpace() {
        return this._wksp;
    }

    public void geometryDeleted(ManagerProxyWrapper managerProxyWrapper) {
        Manager manager = managerProxyWrapper.getManagerProxy().loadManager(null, null);
        if (manager == this._selectedGeo) {
            this._selectedGeo = null;
            this.clearForm();
        }
        this.getSelectorPanel().removeSelectionItem((Object)managerProxyWrapper);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.getSelectorPanel().getSelectedItem() == null && this.getSelectorPanel().getSelectorItems().size() > 0) {
                this.getSelectorPanel().setSelectedIndex(0);
            }
            this.checkGeometryInMapWindow();
        }
        super.setVisible(bl);
    }

    private void checkGeometryInMapWindow() {
        if (this._selectedGeo == null) {
            return;
        }
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof WaterQualityMode) {
            clientMode = (WaterQualityMode)clientMode;
            GeometryMapGlyph geometryMapGlyph = (GeometryMapGlyph)ClientApp.frame().getMapPanel().findGlyphOfClass(GeometryMapGlyph.class.getName());
            WqGeometry wqGeometry = null;
            if (geometryMapGlyph != null) {
                wqGeometry = (WqGeometry)geometryMapGlyph.getMap();
            }
            if (wqGeometry != this._selectedGeo) {
                clientMode.setGeometry(this._selectedGeo);
            }
        }
    }

    public void showRegionPanel() {
        this.getTabbedPane().setSelectedComponent((Component)((Object)this._regionsPanel));
    }

    public void selectDefaultCrossSections() {
        this._connectionsPanel.selectDefaultCrossSections();
    }

    public void selectMetDataSet(ManagerProxy managerProxy) {
        this._metStationsPanel.selectMetStationSet(managerProxy);
    }

    private void refresh() {
        Object object = this.getSelectorPanel().getSelectedItem();
        if (object instanceof NamedType) {
            this.fillForm((NamedType)object);
        }
    }

    public void setErrorMessage(String string) {
        this._msgPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            logger.warning(string);
            this._msgText.setForeground(Color.RED);
            return;
        }
        this._msgText.setText("");
    }

    public void setMessage(String string) {
        this._msgPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            logger.info(string);
            this._msgText.setForeground(UIManager.getColor("TextField.foreground"));
            return;
        }
        this._msgText.setText("");
    }

    private static /* synthetic */ String a(String string, WQException wQException) {
        return string + " " + wQException.getMessage();
    }

    private static /* synthetic */ String b(String string, WQException wQException) {
        return string + " " + wQException.getMessage();
    }
}

