/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ManagerProxy;
import hec.lang.NamedType;
import hec.map.LayerSelectionFactory;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSetFactory;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.rss.client.RssDrawingAttributeSet;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.Element;
import hec.rss.model.ElementIndexFilter;
import hec.rss.model.GeometryContainsReservoirElementPredicate;
import hec.rss.model.GeometryContainsWorldLinePredicate;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.WaterQualityEditors;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.geometry.AddElementToRegionPanel;
import hec.rss.wq.client.geometry.CreateNewRegionPanel;
import hec.rss.wq.client.geometry.DeleteRegionPanel;
import hec.rss.wq.client.geometry.ExtentDrawPropData;
import hec.rss.wq.client.geometry.GeometryMapGlyph$1;
import hec.rss.wq.client.geometry.GeometryMapGlyph$2;
import hec.rss.wq.client.geometry.GeometryMapGlyph$3;
import hec.rss.wq.client.geometry.GeometryMapGlyph$4;
import hec.rss.wq.client.geometry.GeometryMapGlyph$5;
import hec.rss.wq.client.geometry.GeometryMapGlyph$6;
import hec.rss.wq.client.geometry.GeometryMapGlyph$7;
import hec.rss.wq.client.geometry.GeometryMapGlyph$SubdomainElementFilter;
import hec.rss.wq.client.geometry.GeometryMapGlyphSelection;
import hec.rss.wq.client.geometry.ReachCellsGlyph;
import hec.rss.wq.client.geometry.ReachCellsMapObject;
import hec.rss.wq.client.geometry.RegionsDrawPropData;
import hec.rss.wq.client.geometry.RemoveElementsFromRegionPanel;
import hec.rss.wq.client.geometry.RenameRegionPanel;
import hec.rss.wq.client.geometry.WaterQualityDrawPropData;
import hec.rss.wq.client.geometry.WqGeometryAttributeSet;
import hec.rss.wq.map.CrossSectionManagerGlyph;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.ui.OkCancelDialog;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Extent;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqengineimpl.geometry.SubDomainElementIdFilter;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQGeometry;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.region.WQDefaultRegion;
import hec.wqengineimpl.region.WQRegion;
import hec.wqengineimpl.region.WQRegionSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaJMenuLabel;
import rma.swing.event.ReflectMultiListener;
import rma.util.ColorContour;

public class GeometryMapGlyph
extends MapGlyph {
    RssSystem _rssSystem;
    RssSystemGlyph _systemGlyph;
    List<Element> _selectedElements = new ArrayList<Element>();
    RssDrawingAttributeSet _rssDas;
    private Vector<MapGlyph> _glyphVector;
    Element _elementAtPopupLocation;
    JPopupMenu _jPopupMenu;
    JPopupMenu _objectPopupMenu;
    private ReflectMultiListener _boundaryPopupMenuListener;
    ExtentDrawPropData _extentDrawPropData = null;
    List<JunctionElement> _junctionsNotInExtent = new ArrayList<JunctionElement>();

    public GeometryMapGlyph(MapPanel object, WqGeometry object2) {
        super(object, (MapObjectInterface)object2);
        ModeDrawingAttributeSet modeDrawingAttributeSet;
        new String();
        object = (WqGeometry)this.getMap();
        int n = object.getNetworkId();
        object2 = ClientApp.Workspace().getManagerProxyList("rss", RssSystem.class.getName());
        if (!((Vector)object2).isEmpty()) {
            modeDrawingAttributeSet = ((Vector)object2).iterator();
            while (modeDrawingAttributeSet.hasNext()) {
                ManagerProxy managerProxy = (ManagerProxy)modeDrawingAttributeSet.next();
                RssSystem rssSystem = (RssSystem)managerProxy.getManager();
                if (managerProxy.getIndex() != n) continue;
                this._rssSystem = rssSystem;
                break;
            }
            if (this._rssSystem == null) {
                this._rssSystem = (RssSystem)((ManagerProxy)((Vector)object2).get(0)).loadManager(RssSystem.class.getName(), ((ManagerProxy)((Vector)object2).get(0)).getId());
            }
            this._systemGlyph = new RssSystemGlyph(this.getMapPanel(), this._rssSystem);
        }
        if ((modeDrawingAttributeSet = ModeDrawingAttributeSet.getModeAttributeSet((String)AppDaddy.getFrame().getCurrentModule().toString())) != null) {
            this._rssDas = (RssDrawingAttributeSet)modeDrawingAttributeSet.getModelAttributeSet("Geometry");
            this._systemGlyph.setDrawingAttributeSet(this._rssDas);
        }
        this._junctionsNotInExtent = new ArrayList<JunctionElement>();
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        Object object;
        int n = WaterQualityDPData.b();
        this._extentDrawPropData = ExtentDrawPropData.b(n);
        WqGeometry wqGeometry = (WqGeometry)this.getMap();
        RssWQGeometry rssWQGeometry = wqGeometry.getRssWqGeometry();
        if (this.isShown() && this._systemGlyph != null) {
            Integer n2;
            WQRegionSet wQRegionSet = rssWQGeometry.getRegionSet();
            object = wQRegionSet.getRegions().stream().filter(wQRegion -> wQRegion != wQRegionSet.getDefaultRegion()).collect(Collectors.toList());
            object = object.stream().map(wQRegion -> wQRegion.getId()).collect(Collectors.toList());
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            object = object.iterator();
            while (object.hasNext()) {
                n2 = (Integer)object.next();
                n3 = Integer.min(n3, n2);
                n4 = Integer.max(n4, n2);
            }
            object = RegionsDrawPropData.b(n);
            n2 = ((RegionsDrawPropData)object).getColorContour();
            if (n4 - n3 == 0) {
                ++n4;
            }
            n2.setMaxValue(n4);
            n2.setMinValue(n3);
            WaterQualityDrawPropData waterQualityDrawPropData = new WaterQualityDrawPropData(wqGeometry, wQRegionSet, this._junctionsNotInExtent, (ColorContour)n2, (int)(255.0 * ((RegionsDrawPropData)object).getTransparency()));
            this._systemGlyph.setReservoirDataProvider(waterQualityDrawPropData);
            this._systemGlyph.setReachDataProvider(waterQualityDrawPropData);
            this._systemGlyph.setJunctionDataProvider(waterQualityDrawPropData);
            this._systemGlyph.draw(graphics, mapScale);
        }
        rssWQGeometry.getSubDomainList().stream().filter(subDomain -> subDomain instanceof WQGeoSubDomain).collect(Collectors.toList());
        object = this.getStreamAlignmentGlyph();
        object.getStreamAlignment();
        for (MapGlyph mapGlyph : this.glyphVector()) {
            if (!mapGlyph.isShown()) continue;
            mapGlyph.draw(graphics, mapScale);
        }
    }

    public boolean hasChildGlyphs() {
        return true;
    }

    public Vector<MapGlyph> glyphVector() {
        if (this._glyphVector == null) {
            String string;
            Vector<Object> vector = new Vector<Object>();
            vector.add((Object)new ReachCellsGlyph(this._mapPanel, new ReachCellsMapObject((WqGeometry)this.getMap())));
            CrossSectionManager crossSectionManager = ((WqGeometry)this.getMap()).getCrossSectionManager();
            if (crossSectionManager != null && (string = crossSectionManager.getRasFile()) != null && !string.isEmpty()) {
                RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
                try {
                    if (rmiFileManager.fileExists(string)) {
                        vector.add((Object)new CrossSectionManagerGlyph(this._mapPanel, crossSectionManager));
                    }
                }
                catch (RemoteException remoteException) {
                    Logger.getLogger(RssSystemGlyph.class.getName()).log(Level.FINE, "File '" + string + "' does not exist. Ignoring Cross Section glyph draw.", remoteException);
                }
            }
            this._glyphVector = vector;
        }
        return this._glyphVector;
    }

    public boolean isShown() {
        if (this._rssDas == null) {
            return false;
        }
        return this._rssDas.isShown();
    }

    public void setShown(boolean bl) {
        if (this._rssDas == null) {
            return;
        }
        this._rssDas.setShown(bl);
    }

    public void selectElements(com.vividsolutions.jts.geom.Geometry object) {
        if (this._rssSystem == null) {
            return;
        }
        List<ReachElement> list = this._rssSystem.findReaches(new GeometryContainsWorldLinePredicate((com.vividsolutions.jts.geom.Geometry)object, new GeometryFactory()));
        object = this._rssSystem.findReservoirs(new GeometryContainsReservoirElementPredicate((com.vividsolutions.jts.geom.Geometry)object, new GeometryFactory()));
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.addAll(list);
        arrayList.addAll((Collection<Element>)object);
        this._selectedElements.clear();
        this._selectedElements.addAll(arrayList);
        this._systemGlyph.addSelections(arrayList, true);
    }

    public ModelDrawingAttributeSet getAttributeSet() {
        return this._rssDas;
    }

    public NamedType objectSelect(LocalPt localPt, int n) {
        Object object = this.getMapPanel().scale((MapGlyph)this);
        GeometryFactory geometryFactory = new GeometryFactory();
        object = object.lp2wp(localPt);
        geometryFactory.createPoint(new Coordinate(object.e, object.n));
        n = GeometryMapGlyph.isControlDown((int)n) || GeometryMapGlyph.isShiftDown((int)n) ? 1 : 0;
        localPt = this._systemGlyph.findObject(localPt);
        if (localPt != null) {
            object = Collections.singletonList((Element)localPt);
            this._selectedElements.addAll((Collection<Element>)object);
            this._systemGlyph.addSelections((List<Element>)object, n == 0);
        } else {
            this._selectedElements.clear();
            this._systemGlyph.clearSelection();
        }
        return localPt;
    }

    public void editInitialConditions() {
        Object object = ClientApp.frame().getCurrentMode();
        if (object instanceof WaterQualityMode) {
            object = ((WaterQualityMode)object).getEditorLaucher();
            object.displayInitialConditionsEditor();
        }
    }

    public void editBoundaryConditions() {
        Object object = ClientApp.frame().getCurrentMode();
        if (object instanceof WaterQualityMode) {
            object = ((WaterQualityMode)object).getEditorLaucher();
            object.displayBoundaryConditionEditor();
        }
    }

    public ReservoirElement findReservoir(WorldPt worldPt) {
        double d;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph != null && (streamAlignmentGlyph = streamAlignmentGlyph.findReach(worldPt)) != null && (d = streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt)) != Double.NEGATIVE_INFINITY) {
            return this._rssSystem.findReservoir(streamAlignmentGlyph.getIndex(), d);
        }
        return this._rssSystem.findReservoir(worldPt);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean boundaryPopupMenu(LocalPt var1_1, int var2_2) {
        if (this._rssSystem == null) {
            return false;
        }
        var2_3 = this._mapPanel.scale((MapGlyph)this);
        var3_4 /* !! */  = var2_3.lp2wp(new LocalPt(var1_1.x, var1_1.y));
        var5_5 = var2_3.x2e(5) - var2_3.x2e(0);
        var2_3 = this._rssSystem.findReach(var3_4 /* !! */ , var5_5);
        var4_7 = this.findReservoir(var3_4 /* !! */ );
        this._jPopupMenu = new JPopupMenu();
        var3_4 /* !! */  = this._rssSystem.findJunction(var3_4 /* !! */ , var5_5);
        var5_6 = new JMenuItem(WqI18n.a("WqModule.DeleteAllRegions.MenuItem").getText());
        var5_6.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, lambda$boundaryPopupMenu$3(java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((GeometryMapGlyph)this));
        if (var2_3 == null && var4_7 == null && var3_4 /* !! */  == null) {
            this._jPopupMenu.add(var5_6);
            this._jPopupMenu.show(this._mapPanel.getViewportPanel(), var1_1.x, var1_1.y);
            return false;
        }
        var6_9 = new ArrayList();
        if (var2_3 != null && !this._selectedElements.contains(var2_3)) {
            var6_9.add(var2_3);
            this._selectedElements.add((Element)var2_3);
        }
        if (var3_4 /* !! */  != null) {
            var6_9.add(var3_4 /* !! */ );
        }
        if (var4_7 != null && !this._selectedElements.contains(var4_7)) {
            var6_9.add((Element)var4_7);
            this._selectedElements.add(var4_7);
        }
        this._systemGlyph.addSelections((List<Element>)var6_9, false);
        var6_9 = var2_3 != null ? var2_3 : var4_7;
        var7_10 /* !! */  = (WqGeometry)this.getMap();
        var7_10 /* !! */  = var7_10 /* !! */ .getRssWqGeometry();
        var8_11 = var7_10 /* !! */ .getRegionSet();
        if (var6_9 == null) {
            return false;
        }
        var6_9 = var7_10 /* !! */ .getSubDomainList().stream().filter(new SubDomainElementIdFilter(var6_9.getIndex())).collect(Collectors.toList());
        var6_9 = var6_9.isEmpty() == false ? (SubDomain)var6_9.get(0) : null;
        var6_9 = var8_11.getRegion((SubDomainRef)var7_10 /* !! */ .buildRef((SubDomain)var6_9));
        var7_10 /* !! */  = null;
        if (var6_9 != null) {
            var7_10 /* !! */  = var6_9.getName();
        }
        this._elementAtPopupLocation = var2_3 != null ? (var3_4 /* !! */  != null ? var3_4 /* !! */  : var2_3) : (var4_7 != null ? var4_7 : null);
        this._boundaryPopupMenuListener = new ReflectMultiListener();
        if (var7_10 /* !! */  != null) {
            this._jPopupMenu.add((JMenuItem)new RmaJMenuLabel((String)var7_10 /* !! */ ));
        }
        var2_3 = new RmaJMenuLabel("   Extent");
        var3_4 /* !! */  = var2_3.getFont().deriveFont(1);
        var2_3.setFont((Font)var3_4 /* !! */ );
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Replace...");
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "replaceExtent"));
        var2_3.setEnabled(this._selectedElements.isEmpty() == false);
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Add to...");
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "addToExtent"));
        var2_3.setEnabled(this.isAddToExtentEnabled());
        this._jPopupMenu.add((JMenuItem)var2_3);
        if (this._elementAtPopupLocation == null) ** GOTO lbl-1000
        if (this._elementAtPopupLocation instanceof JunctionElement) ** GOTO lbl-1000
        v0 = this;
        if (!v0.isAselectedElementNotInTheExtent(Collections.singletonList(v0._elementAtPopupLocation))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var4_8 = v1;
        var2_3 = new JMenuItem("      Remove Upstream Elements From...");
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "removeUpstreamElements"));
        var2_3.setEnabled(var4_8);
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Remove Downstream Elements From...");
        var2_3.setEnabled(var4_8);
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "removeDownstreamElements"));
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new RmaJMenuLabel("   Region");
        var2_3.setFont((Font)var3_4 /* !! */ );
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      View Report...");
        var2_3.setEnabled(this.isRegionReportEnabled());
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "viewReportRegion"));
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Create...");
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "createRegion"));
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Rename...");
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "renameRegion"));
        var2_3.setEnabled(this.isRenameRegionEnabled());
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Add to...");
        var2_3.setEnabled(this.getRegionCountExcludingDefault() > 0);
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "addToRegion"));
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Remove from...");
        var2_3.setEnabled(this.isASelectedElementsContainedInARegion());
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "removeFromRegion"));
        this._jPopupMenu.add((JMenuItem)var2_3);
        var2_3 = new JMenuItem("      Delete...");
        var2_3.setEnabled(this.isDeleteRegionEndabled());
        var2_3.addActionListener((ActionListener)this._boundaryPopupMenuListener.add((Object)this, var2_3, "deleteRegion"));
        this._jPopupMenu.add((JMenuItem)var2_3);
        this._jPopupMenu.addSeparator();
        this._jPopupMenu.add(var5_6);
        this._jPopupMenu.show(this._mapPanel.getViewportPanel(), var1_1.x, var1_1.y);
        return false;
    }

    private void deleteAllRegions() {
        int n = JOptionPane.showConfirmDialog(this._mapPanel.getViewportPanel(), WqI18n.a("WqModule.DeleteAllRegions.Message").getText(), WqI18n.a("WqModule.DeleteAllRegions.Title").getText(), 0);
        if (n == 0) {
            Object object = (WqGeometry)this.getMap();
            object = object.getRssWqGeometry();
            object = object.getRegionSet();
            Object object2 = object.getRegions().stream().filter(arg_0 -> GeometryMapGlyph.lambda$deleteAllRegions$4((WQRegionSet)object, arg_0)).collect(Collectors.toList());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                WQRegion wQRegion = (WQRegion)object2.next();
                object.delete(wQRegion);
            }
            this._mapPanel.paintMap();
        }
    }

    private boolean isDeleteRegionEndabled() {
        return this.isASelectedElementsContainedInARegion();
    }

    private boolean isRenameRegionEnabled() {
        return this.isASelectedElementsContainedInARegion();
    }

    private boolean isAddToRegionEnabled() {
        return this.isASelectedElementNotContainedInARegion();
    }

    private boolean isRegionReportEnabled() {
        return true;
    }

    private boolean isAddToExtentEnabled() {
        return this.isAselectedElementNotInTheExtent();
    }

    public void removeUpstreamElements() {
        if (this._elementAtPopupLocation == null) {
            return;
        }
        WqGeometry wqGeometry = (WqGeometry)this.getMap();
        RssWQGeometry rssWQGeometry = wqGeometry.getRssWqGeometry();
        WQRegionSet wQRegionSet = rssWQGeometry.getRegionSet();
        Object object = this._rssSystem.getUpstreamElements(this._elementAtPopupLocation);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (!((object2 = (Element)object2) instanceof JunctionElement)) {
                object2 = rssWQGeometry.getSubDomainList().stream().filter(new GeometryMapGlyph$SubdomainElementFilter(this, Collections.singletonList(object2))).collect(Collectors.toList());
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    SubDomain subDomain = (SubDomain)object2.next();
                    wQRegionSet.remove((SubDomainRef)rssWQGeometry.buildRef(subDomain));
                }
                continue;
            }
            this._junctionsNotInExtent.add((JunctionElement)object2);
        }
        rssWQGeometry.updateBoundariesForExtent();
        rssWQGeometry.updateWQJunctionsForExtent();
        wqGeometry.setModified(true);
        this._mapPanel.paintMap();
    }

    private boolean isConnected(Extent object, List<Element> list) {
        Object object2;
        object = object.getElements();
        Object object422 = (WqGeometry)this.getMap();
        Object object5 = ((WqGeometry)((Object)object422)).getNetwork();
        object422 = ((WqGeometry)((Object)object422)).getRssWqGeometry();
        Object object6 = new TreeSet();
        for (Element object32 : list) {
            object6.add(object32.getIndex());
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (SubDomainRef)iterator.next();
            object6 = object.getSubDomain((Geometry)object422);
            object2 = ((RssSystem)object5).getElement(object6.getElementId());
            hashSet.add(object2);
            List element = object6.getDownstreamElemIds();
            for (Object object3 : element) {
                object2 = ((RssSystem)object5).getElement((Integer)object3);
                hashSet.add(object2);
            }
        }
        MutableValueGraph mutableValueGraph = ValueGraphBuilder.undirected().build();
        object = hashSet.iterator();
        object6 = new ArrayList();
        while (object.hasNext()) {
            object2 = (Element)object.next();
            int set = object2.getIndex();
            object6.clear();
            ((Element)object2).getDownstreamNodes((List)object6);
            for (int i = 0; i < object6.size(); ++i) {
                Object object3;
                object3 = (RssNode)object6.get(i);
                object422 = ((RssNode)object3).getDownstreamElement();
                if (object422 == null) continue;
                object422 = ((Element)object422).getTopParent();
                mutableValueGraph.putEdgeValue((Object)set, (Object)object422.getIndex(), (Object)"");
            }
        }
        for (Element element : list) {
            mutableValueGraph.removeNode((Object)element.getIndex());
        }
        object2 = new HashMap();
        Set set = mutableValueGraph.nodes();
        if (set.isEmpty()) {
            return true;
        }
        int n2 = 0;
        for (Object object422 : set) {
            object = object2.values();
            boolean bl = false;
            object = object.iterator();
            while (object.hasNext()) {
                object5 = (Set)object.next();
                if (!object5.contains(object422)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object = object2.computeIfAbsent(n2, n -> new TreeSet());
            object.add(object422);
            this.addConnectedNodes((Integer)object422, (ValueGraph<Integer, String>)mutableValueGraph, (Set<Integer>)object);
            ++n2;
        }
        return object2.size() == 1;
    }

    private void addConnectedNodes(int n, ValueGraph<Integer, String> valueGraph, Set<Integer> set) {
        Object object = valueGraph.adjacentNodes((Object)n);
        object = object.iterator();
        while (object.hasNext()) {
            Integer n2 = (Integer)object.next();
            if (!set.add(n2)) continue;
            this.addConnectedNodes(n2, valueGraph, set);
        }
    }

    private void removeDownstreamElements() {
        if (this._elementAtPopupLocation == null) {
            return;
        }
        WqGeometry wqGeometry = (WqGeometry)this.getMap();
        RssWQGeometry rssWQGeometry = wqGeometry.getRssWqGeometry();
        WQRegionSet wQRegionSet = rssWQGeometry.getRegionSet();
        Object object = this._rssSystem.getDownstreamElements(this._elementAtPopupLocation);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if ((object2 = (Element)object2) instanceof JunctionElement) continue;
            object2 = rssWQGeometry.getSubDomainList().stream().filter(new GeometryMapGlyph$SubdomainElementFilter(this, Collections.singletonList(object2))).collect(Collectors.toList());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                SubDomain subDomain = (SubDomain)object2.next();
                wQRegionSet.remove((SubDomainRef)rssWQGeometry.buildRef(subDomain));
            }
        }
        rssWQGeometry.updateBoundariesForExtent();
        rssWQGeometry.updateWQJunctionsForExtent();
        wqGeometry.setModified(true);
        this._mapPanel.paintMap();
    }

    private boolean isASelectedElementsContainedInARegion() {
        Object object = (WqGeometry)this.getMap();
        object = object.getRssWqGeometry();
        Object object2 = object.getRegionSet();
        object2 = object2.getRegions().stream().filter(arg_0 -> GeometryMapGlyph.lambda$isASelectedElementsContainedInARegion$6((WQRegionSet)object2, arg_0)).collect(Collectors.toList());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = (WQRegion)object2.next();
            object3 = object3.getElements();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                SubDomainRef subDomainRef = (SubDomainRef)object3.next();
                subDomainRef = subDomainRef.getSubDomain((Geometry)object);
                long l = this._selectedElements.stream().filter(new ElementIndexFilter(subDomainRef.getElementId())).count();
                if (l <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    private int getRegionCountExcludingDefault() {
        Object object = (WqGeometry)this.getMap();
        object = object.getRssWqGeometry();
        object = object.getRegionSet();
        return (int)object.getRegions().stream().filter(arg_0 -> GeometryMapGlyph.lambda$getRegionCountExcludingDefault$7((WQRegionSet)object, arg_0)).count();
    }

    private boolean isASelectedElementNotContainedInARegion() {
        Object object = (WqGeometry)this.getMap();
        object = object.getRssWqGeometry();
        object = object.getRegionSet();
        object = object.getRegions().stream().filter(arg_0 -> GeometryMapGlyph.lambda$isASelectedElementNotContainedInARegion$8((WQRegionSet)object, arg_0)).collect(Collectors.toList());
        return this.isASelectedElementNotContainedInARegion((List<WQRegion>)object);
    }

    private boolean isAselectedElementNotInTheExtent(List<Element> list) {
        Object object = (WqGeometry)this.getMap();
        object = object.getRssWqGeometry();
        object = object.getRegionSet();
        object = object.getRegions();
        return this.isASelectedElementNotContainedInARegion(list, (List<WQRegion>)object);
    }

    private boolean isAselectedElementNotInTheExtent() {
        Object object = (WqGeometry)this.getMap();
        object = object.getRssWqGeometry();
        object = object.getRegionSet();
        object = object.getRegions();
        return this.isASelectedElementNotContainedInARegion((List<WQRegion>)object);
    }

    private boolean isASelectedElementNotContainedInARegion(List<WQRegion> list) {
        GeometryMapGlyph geometryMapGlyph = this;
        return geometryMapGlyph.isASelectedElementNotContainedInARegion(geometryMapGlyph._selectedElements, list);
    }

    private boolean isASelectedElementNotContainedInARegion(List<Element> list, List<WQRegion> object) {
        Object object2 = (WqGeometry)this.getMap();
        object2 = object2.getRssWqGeometry();
        object = object.iterator();
        while (object.hasNext()) {
            Object object3 = (WQRegion)object.next();
            object3 = object3.getElements();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                SubDomainRef subDomainRef = (SubDomainRef)object3.next();
                subDomainRef = subDomainRef.getSubDomain((Geometry)object2);
                long l = list.stream().filter(new ElementIndexFilter(subDomainRef.getElementId())).count();
                if (l <= 0L) continue;
                return false;
            }
        }
        return true;
    }

    private void replaceExtent() {
        String string = "Do you want to replace the Extent with the selected Network Elements?";
        int n = JOptionPane.showConfirmDialog((Component)this.getMapPanel(), string, "Warning", 2, 3);
        if (n != 0) {
            return;
        }
        WqGeometry wqGeometry = (WqGeometry)this.getMap();
        RssWQGeometry rssWQGeometry = wqGeometry.getRssWqGeometry();
        rssWQGeometry.getRegionSet();
        Extent extent = wqGeometry.getRssWqGeometry().getGeometryExtent();
        GeometryMapGlyph geometryMapGlyph = this;
        List list = rssWQGeometry.getSubDomainList(new GeometryMapGlyph$SubdomainElementFilter(geometryMapGlyph, geometryMapGlyph._selectedElements).negate());
        GeometryMapGlyph geometryMapGlyph2 = this;
        Iterator iterator = rssWQGeometry.getSubDomainList(new GeometryMapGlyph$SubdomainElementFilter(geometryMapGlyph2, geometryMapGlyph2._selectedElements));
        ArrayList<SubDomain> arrayList = new ArrayList<SubDomain>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SubDomain subDomain2 = (SubDomain)iterator.next();
            subDomain2 = rssWQGeometry.buildRef(subDomain2);
            arrayList.add(subDomain2);
        }
        list.stream().forEach(subDomain -> extent.remove((SubDomainRef)rssWQGeometry.buildRef((SubDomain)subDomain)));
        for (SubDomain subDomain2 : arrayList) {
            if (extent.contains((SubDomainRef)subDomain2)) continue;
            extent.add((SubDomainRef)subDomain2);
        }
        rssWQGeometry.updateBoundariesForExtent();
        rssWQGeometry.updateWQJunctionsForExtent();
        wqGeometry.setModified(true);
        this._mapPanel.paintMap();
    }

    private void addToExtent() {
        WqGeometry wqGeometry = (WqGeometry)this.getMap();
        RssWQGeometry rssWQGeometry = wqGeometry.getRssWqGeometry();
        rssWQGeometry.getRegionSet();
        Extent extent = wqGeometry.getRssWqGeometry().getGeometryExtent();
        GeometryMapGlyph geometryMapGlyph = this;
        List list = rssWQGeometry.getSubDomainList(new GeometryMapGlyph$SubdomainElementFilter(geometryMapGlyph, geometryMapGlyph._selectedElements));
        if (list.isEmpty()) {
            return;
        }
        for (Object object : list) {
            WQSubDomainRef wQSubDomainRef = rssWQGeometry.buildRef((SubDomain)object);
            if (extent.contains((SubDomainRef)wQSubDomainRef)) continue;
            extent.add((SubDomainRef)wQSubDomainRef);
        }
        Object object = "The following Sub Domains were added to the extent: ";
        for (WQSubDomainRef wQSubDomainRef : list) {
            object = (String)object + "\n\t" + wQSubDomainRef.getName();
        }
        JOptionPane.showMessageDialog((Component)this.getMapPanel(), object, "Extent", 1);
        rssWQGeometry.updateBoundariesForExtent();
        rssWQGeometry.updateWQJunctionsForExtent();
        wqGeometry.setModified(true);
        this._mapPanel.paintMap();
    }

    private void viewReportRegion() {
        Object object = ClientApp.frame().getCurrentMode();
        WaterQualityEditors waterQualityEditors = null;
        if (object instanceof WaterQualityMode) {
            waterQualityEditors = ((WaterQualityMode)object).getEditorLaucher();
        }
        if (waterQualityEditors == null) {
            return;
        }
        object = (WqGeometry)this.getMap();
        object = waterQualityEditors.displayGeometryEditor((WqGeometry)((Object)object));
        object.showRegionPanel();
    }

    /*
     * WARNING - void declaration
     */
    private void createRegion() {
        Object object2;
        Object object3;
        if (this._rssSystem == null) {
            return;
        }
        List list = this._rssSystem.getElementVector().stream().filter(object -> object instanceof ReservoirElement || object instanceof ReachElement).collect(Collectors.toList());
        WqGeometry wqGeometry = (WqGeometry)this.getMap();
        RssWQGeometry rssWQGeometry = wqGeometry.getRssWqGeometry();
        WQRegionSet wQRegionSet = rssWQGeometry.getRegionSet();
        ArrayList<SubDomain> arrayList = new ArrayList<SubDomain>();
        List list2 = wQRegionSet.getRegions();
        ArrayList<SubDomain> arrayList2 = new ArrayList<SubDomain>();
        ArrayList<SubDomain> arrayList3 = new ArrayList<SubDomain>();
        List list3 = rssWQGeometry.getSubDomainList();
        HashMap<SubDomain, WQSubDomainRef> hashMap = new HashMap<SubDomain, WQSubDomainRef>();
        for (Element n : this._selectedElements) {
            list.remove(n);
            object3 = new SubDomainElementIdFilter(n.getIndex());
            for (SubDomain subDomain : list3) {
                if (!object3.test(subDomain)) continue;
                boolean bl = false;
                WQSubDomainRef wQSubDomainRef = rssWQGeometry.buildRef(subDomain);
                hashMap.put(subDomain, wQSubDomainRef);
                for (WQRegion wQRegion : list2) {
                    if (wQRegion instanceof WQDefaultRegion || !wQRegion.contains((SubDomainRef)wQSubDomainRef)) continue;
                    arrayList.add(subDomain);
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList3.add(subDomain);
            }
        }
        for (Element element : list) {
            object3 = new SubDomainElementIdFilter(element.getIndex());
            List list4 = list3.stream().filter(object3).collect(Collectors.toList());
            arrayList2.addAll(list4);
            for (SubDomain subDomain : list4) {
                hashMap.put(subDomain, rssWQGeometry.buildRef(subDomain));
            }
        }
        if (!arrayList.isEmpty()) {
            void var12_19;
            object2 = WqI18n.a("network.elements.exist.in.region.messge").getText();
            String string = "";
            for (Object e : arrayList) {
                String string2 = (String)var12_19 + "         " + ((SubDomain)e).getName() + "\n";
            }
            object3 = MessageFormat.format((String)object2, var12_19);
            String string3 = WqI18n.a("network.elements.exist.in.region.title").getText();
            int n = JOptionPane.showConfirmDialog((Component)this.getMapPanel(), object3, string3, 1);
            if (n == 2) {
                return;
            }
            if (n == 1) {
                arrayList2.addAll(arrayList);
            } else {
                arrayList3.addAll(arrayList);
            }
        }
        object2 = new CreateNewRegionPanel();
        ((CreateNewRegionPanel)object2).setData(arrayList2, arrayList3);
        OkCancelDialog okCancelDialog = new OkCancelDialog(SwingUtilities.windowForComponent((Component)this.getMapPanel()), (JComponent)object2, Dialog.ModalityType.APPLICATION_MODAL);
        okCancelDialog.setTitle("Create New Region");
        okCancelDialog.addValidator(new GeometryMapGlyph$1((CreateNewRegionPanel)object2, wQRegionSet));
        okCancelDialog.addPropertyChangeListener(new GeometryMapGlyph$2(this, (CreateNewRegionPanel)object2, hashMap, wQRegionSet, wqGeometry));
        okCancelDialog.setSize(470, 410);
        okCancelDialog.setDefaultSize(470, 410);
        okCancelDialog.setMinimumSize(new Dimension(470, 410));
        okCancelDialog.setLocationRelativeTo((Component)this.getMapPanel());
        okCancelDialog.setVisible(true);
    }

    private void renameRegion() {
        Object object = (WqGeometry)this.getMap();
        object = object.getRssWqGeometry();
        object = object.getRegionSet();
        RenameRegionPanel renameRegionPanel = new RenameRegionPanel();
        renameRegionPanel.setRegionList(object.getRegions().stream().filter(arg_0 -> GeometryMapGlyph.lambda$renameRegion$11((WQRegionSet)object, arg_0)).collect(Collectors.toList()));
        OkCancelDialog okCancelDialog = new OkCancelDialog(SwingUtilities.windowForComponent((Component)this.getMapPanel()), renameRegionPanel, Dialog.ModalityType.APPLICATION_MODAL);
        okCancelDialog.setTitle("Rename Region");
        okCancelDialog.addValidator(new GeometryMapGlyph$3(renameRegionPanel, (WQRegionSet)object));
        okCancelDialog.addPropertyChangeListener(new GeometryMapGlyph$4(renameRegionPanel));
        okCancelDialog.setSize(450, 350);
        okCancelDialog.setMinimumSize(new Dimension(450, 350));
        okCancelDialog.setLocationRelativeTo((Component)this.getMapPanel());
        okCancelDialog.setVisible(true);
    }

    private List<SubDomain> elementsToSubDomains(WQGeometry wQGeometry, List<Element> object) {
        ArrayList<SubDomain> arrayList = new ArrayList<SubDomain>();
        object = object.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            if (element == null) continue;
            arrayList.addAll(wQGeometry.getSubDomainList((Predicate)new SubDomainElementIdFilter(element.getIndex())));
        }
        return arrayList;
    }

    private void addToRegion() {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        RssWQGeometry rssWQGeometry = ((WqGeometry)this.getMap()).getRssWqGeometry();
        Object object5 = rssWQGeometry.getRegionSet();
        Object object6 = this.elementsToSubDomains(rssWQGeometry, this._selectedElements);
        List<WQRegion> list = object5.getRegions().stream().filter(arg_0 -> GeometryMapGlyph.lambda$addToRegion$12((WQRegionSet)object5, arg_0)).collect(Collectors.toList());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> object72 = new ArrayList<Object>();
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            object4 = object7.next();
            object3 = rssWQGeometry.buildRef((SubDomain)object4);
            for (Object object22 : list) {
                if (!object22.contains((SubDomainRef)object3)) continue;
                arrayList.add(object4);
                object72.add(object4);
            }
        }
        object6.removeAll(object72);
        object7 = new ArrayList();
        object4 = new ArrayList<SubDomain>();
        object4.addAll(object6);
        if (!arrayList.isEmpty()) {
            object3 = WqI18n.a("network.elements.exist.in.region.title").getText();
            object = WqI18n.a("network.elements.exist.in.region.messge").getText();
            object22 = "";
            for (SubDomain subDomain : arrayList) {
                object22 = (String)object22 + "         " + subDomain.getName() + "\n";
            }
            object = MessageFormat.format((String)object, object22);
            int n = JOptionPane.showConfirmDialog((Component)this.getMapPanel(), object, (String)object3, 1);
            if (n == 2) {
                return;
            }
            if (n == 1) {
                object7.addAll(arrayList);
            } else {
                object4.addAll(arrayList);
            }
        }
        object3 = new AddElementToRegionPanel();
        object3.setData(list, (List<SubDomain>)object7, (List<SubDomain>)object4);
        object = SwingUtilities.windowForComponent((Component)this.getMapPanel());
        object22 = new OkCancelDialog((Window)object, (JComponent)object3, Dialog.ModalityType.APPLICATION_MODAL);
        object6 = WqI18n.a("AddToRegion.Title").getText();
        object22.setTitle((String)object6);
        Dimension dimension = new Dimension(620, 500);
        object22.setSize(dimension);
        object22.setMinimumSize(new Dimension(620, 500));
        object22.addPropertyChangeListener("ReturnStatus", (PropertyChangeListener)new GeometryMapGlyph$5((AddElementToRegionPanel)object3, (List)object4, rssWQGeometry, object5));
        object22.setLocationRelativeTo((Component)object);
        object22.setVisible(true);
        object5 = ((WQRegion)object5.getRegions().get(0)).getElements();
        ((SubDomainRef)object5.iterator().next()).getSubDomain((Geometry)rssWQGeometry);
        this._mapPanel.repaint();
    }

    private void removeFromRegion() {
        Object object;
        Cloneable cloneable;
        Object object22;
        Object object3;
        WQRegion wQRegion22;
        Object object4;
        Object object5 = (WqGeometry)this.getMap();
        object5 = object5.getRssWqGeometry();
        WQRegionSet wQRegionSet = object5.getRegionSet();
        List list = wQRegionSet.getRegions().stream().filter(wQRegion -> wQRegion != wQRegionSet.getDefaultRegion()).collect(Collectors.toList());
        Object object62 = this.elementsToSubDomains((WQGeometry)object5, this._selectedElements);
        WQRegion wQRegion3 = null;
        if (this._elementAtPopupLocation != null && !(object4 = this.elementsToSubDomains((WQGeometry)object5, Collections.singletonList(this._elementAtPopupLocation))).isEmpty()) {
            object4 = (SubDomain)object4.get(0);
            object4 = object5.buildRef((SubDomain)object4);
            for (WQRegion wQRegion22 : list) {
                if (!wQRegion22.contains((SubDomainRef)object4)) continue;
                wQRegion3 = wQRegion22;
                break;
            }
        }
        object4 = new HashMap();
        ArrayList arrayList = new ArrayList();
        for (Object object62 : object62) {
            object3 = object5.buildRef(object62);
            for (Object object22 : list) {
                if (!object22.contains((SubDomainRef)object3)) continue;
                cloneable = (ArrayList)object4.get(object22);
                if (cloneable == null) {
                    cloneable = new ArrayList();
                    cloneable.add(new ArrayList());
                    cloneable.add(new ArrayList());
                    object4.put(object22, cloneable);
                    object = object22.getElements();
                    object = object.iterator();
                    while (object.hasNext()) {
                        SubDomainRef subDomainRef = (SubDomainRef)object.next();
                        ((List)cloneable.get(0)).add(subDomainRef.getSubDomain((Geometry)object5));
                    }
                }
                ((List)cloneable.get(1)).add(object62);
                ((List)cloneable.get(0)).remove(object62);
                arrayList.add(object22);
            }
        }
        wQRegion22 = null;
        if (!arrayList.isEmpty()) {
            wQRegion22 = (WQRegion)arrayList.get(0);
        }
        object62 = new RemoveElementsFromRegionPanel();
        object62.setData(arrayList, wQRegion3 != null ? wQRegion3 : wQRegion22, (Map<WQRegion, List<List<SubDomain>>>)object4);
        object3 = SwingUtilities.windowForComponent((Component)this.getMapPanel());
        Object object7 = new OkCancelDialog((Window)object3, (JComponent)object62, Dialog.ModalityType.APPLICATION_MODAL);
        object22 = WqI18n.a("RemoveFromRegion.Title").getText();
        object7.setTitle((String)object22);
        cloneable = new Dimension(620, 500);
        object7.setSize((Dimension)cloneable);
        object7.setMinimumSize(new Dimension(620, 500));
        object7.addPropertyChangeListener("ReturnStatus", new GeometryMapGlyph$6(this, (RemoveElementsFromRegionPanel)object62, (RssWQGeometry)object5));
        object7.setLocationRelativeTo((Component)object3);
        object7.setVisible(true);
        object = ((WQRegion)wQRegionSet.getRegions().get(0)).getElements();
        ((SubDomainRef)object.iterator().next()).getSubDomain((Geometry)object5);
    }

    private void deleteRegion() {
        Object object = ((WqGeometry)this.getMap()).getRssWqGeometry();
        WQRegionSet wQRegionSet = object.getRegionSet();
        Object object2 = wQRegionSet.getRegions().stream().filter(wQRegion -> wQRegion != wQRegionSet.getDefaultRegion()).collect(Collectors.toList());
        WQSubDomainRef wQSubDomainRef = null;
        DeleteRegionPanel deleteRegionPanel = new DeleteRegionPanel();
        List list = object.getSubDomainList().stream().filter(new SubDomainElementIdFilter(this._elementAtPopupLocation.getIndex())).collect(Collectors.toList());
        if (!list.isEmpty()) {
            wQSubDomainRef = object.buildRef((SubDomain)list.get(0));
        }
        object = null;
        for (int i = 0; i < object2.size(); ++i) {
            if (!((WQRegion)object2.get(i)).contains((SubDomainRef)wQSubDomainRef)) continue;
            object = object2.get(i);
            break;
        }
        deleteRegionPanel.setData((List<WQRegion>)object2, (WQRegion)object);
        Window window = SwingUtilities.windowForComponent((Component)this.getMapPanel());
        object = new OkCancelDialog(window, deleteRegionPanel, Dialog.ModalityType.APPLICATION_MODAL);
        object2 = WqI18n.a("DeleteRegion.Title").getText();
        object.setTitle((String)object2);
        object2 = new Dimension(320, 110);
        object.setMinimumSize((Dimension)object2);
        object.setPreferredSize((Dimension)object2);
        object.pack();
        object.addPropertyChangeListener("ReturnStatus", new GeometryMapGlyph$7(deleteRegionPanel, wQRegionSet));
        object.setLocationRelativeTo(window);
        object.setVisible(true);
    }

    public RssSystemGlyph getSystemGlyph() {
        return this._systemGlyph;
    }

    public void clearSelection() {
        this._selectedElements.clear();
        this._systemGlyph.clearSelection();
    }

    protected StreamAlignmentGlyph getStreamAlignmentGlyph() {
        return (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
    }

    private static /* synthetic */ boolean lambda$addToRegion$12(WQRegionSet wQRegionSet, WQRegion wQRegion) {
        return wQRegion != wQRegionSet.getDefaultRegion();
    }

    private static /* synthetic */ boolean lambda$renameRegion$11(WQRegionSet wQRegionSet, WQRegion wQRegion) {
        return wQRegion != wQRegionSet.getDefaultRegion();
    }

    private static /* synthetic */ boolean lambda$isASelectedElementNotContainedInARegion$8(WQRegionSet wQRegionSet, WQRegion wQRegion) {
        return wQRegion != wQRegionSet.getDefaultRegion();
    }

    private static /* synthetic */ boolean lambda$getRegionCountExcludingDefault$7(WQRegionSet wQRegionSet, WQRegion wQRegion) {
        return wQRegion != wQRegionSet.getDefaultRegion();
    }

    private static /* synthetic */ boolean lambda$isASelectedElementsContainedInARegion$6(WQRegionSet wQRegionSet, WQRegion wQRegion) {
        return wQRegion != wQRegionSet.getDefaultRegion();
    }

    private static /* synthetic */ boolean lambda$deleteAllRegions$4(WQRegionSet wQRegionSet, WQRegion wQRegion) {
        return wQRegion != wQRegionSet.getDefaultRegion();
    }

    private /* synthetic */ void lambda$boundaryPopupMenu$3(ActionEvent actionEvent) {
        this.deleteAllRegions();
    }

    static /* synthetic */ MapPanel access$000(GeometryMapGlyph geometryMapGlyph) {
        return geometryMapGlyph._mapPanel;
    }

    static {
        LayerSelectionFactory.addMapping((String)GeometryMapGlyph.class.getName(), (String)GeometryMapGlyphSelection.class.getName());
        ModelDrawingAttributeSetFactory.addMapping((String)"Geometry", (String)WqGeometryAttributeSet.class.getName());
    }
}

