/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import hec.map.LocalPt;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.rss.wq.client.geometry.GeometryMapGlyph;
import hec.rss.wq.client.geometry.GeometryMouseAdapter$LassoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.RmaImage;

public class GeometryMouseAdapter
extends MapMouseAdapter {
    Cursor _mosueCursor;
    boolean _drawingLasso = false;
    Path2D _lassoPath = new Path2D.Float();
    List<LocalPt> _lassoPoints = new ArrayList<LocalPt>();
    private final GeometryMouseAdapter$LassoPanel _lassoPanel;
    public static final Color TRANSPARENT_COLOR = new Color(1, 255, 1, 0);
    BufferedImage img = null;

    public GeometryMouseAdapter(MapPanel object, MapCanvas mapCanvas) {
        super(object, mapCanvas);
        try {
            object = RmaImage.loadURLImage((Component)mapCanvas, (String)"Images/rss/wq/RegionToolCursor.gif");
            this._mosueCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), "Region Tool");
        }
        catch (Exception exception) {
            System.out.println("init:failed to find cursor image: Images/rss/wq/RegionToolCursor.gif. Error:" + String.valueOf(exception));
        }
        this._lassoPath = new Path2D.Float();
        this._lassoPanel = new GeometryMouseAdapter$LassoPanel(this);
    }

    public void init() {
        super.init();
        JPanel jPanel = this._mapPanel.getGlassPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._lassoPanel, "Center");
        jPanel.setVisible(true);
    }

    public void abort() {
        super.abort();
        JPanel jPanel = this._mapPanel.getGlassPane();
        jPanel.remove(this._lassoPanel);
        jPanel.setVisible(false);
    }

    public Cursor getCursor() {
        return this._mosueCursor;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this._lassoPoints.isEmpty() && this._drawingLasso) {
            ((Path2D.Float)this._lassoPath).lineTo(mouseEvent.getX(), mouseEvent.getY());
            this._lassoPoints.add(new LocalPt(mouseEvent.getX(), mouseEvent.getY()));
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            GeometryMapGlyph geometryMapGlyph = (GeometryMapGlyph)this._mapPanel.findGlyphOfClass(GeometryMapGlyph.class, true);
            if (geometryMapGlyph == null) {
                return;
            }
            this._lassoPath = new Path2D.Float();
            this._lassoPoints.clear();
            ((Path2D.Float)this._lassoPath).moveTo(mouseEvent.getX(), mouseEvent.getY());
            this._lassoPoints.add(new LocalPt(mouseEvent.getX(), mouseEvent.getY()));
            this._drawingLasso = true;
        }
        this._mapPanel.getGlassPane().paintImmediately(this._mapPanel.getVisibleRect());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        GeometryMapGlyph geometryMapGlyph = (GeometryMapGlyph)this._mapPanel.findGlyphOfClass(GeometryMapGlyph.class, true);
        if (geometryMapGlyph == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            geometryMapGlyph.boundaryPopupMenu(new LocalPt(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiers());
            return;
        }
        if (!this._drawingLasso) {
            if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                geometryMapGlyph.clearSelection();
            }
            geometryMapGlyph.objectSelect(new LocalPt(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiers());
            return;
        }
        mouseEvent = this._mapPanel.scale((MapGlyph)geometryMapGlyph);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        double[] cfr_ignored_0 = new double[2];
        WorldPt worldPt = new WorldPt();
        for (LocalPt localPt : this._lassoPoints) {
            mouseEvent.lp2wp(localPt, worldPt);
            arrayList.add(new Coordinate(worldPt.e, worldPt.n));
        }
        if (arrayList.size() > 0) {
            ArrayList<Coordinate> arrayList2 = arrayList;
            arrayList2.add((Coordinate)arrayList2.get(0));
        }
        if (arrayList.size() < 4) {
            this._drawingLasso = false;
            return;
        }
        Polygon polygon = new GeometryFactory().createPolygon(arrayList.toArray(new Coordinate[0]));
        this._lassoPath.reset();
        this._lassoPoints.clear();
        this._mapPanel.getGlassPane().paintImmediately(this._mapPanel.getVisibleRect());
        geometryMapGlyph.selectElements((Geometry)polygon);
        this._drawingLasso = false;
    }
}

