/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.rss.model.Element;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.geometry.GeometryUpdater$1;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.WQException;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public class GeometryUpdater {
    private WqGeometry a;
    private RssSystem b;
    private Component c;
    private ProgressMonitor d;
    private FluentLogger e = FluentLogger.forEnclosingClass();

    public GeometryUpdater(WqGeometry wqGeometry, RssSystem rssSystem, Component component) {
        this.a = wqGeometry;
        this.b = rssSystem;
        this.c = component;
    }

    protected void a() {
        RssWQGeometry rssWQGeometry = this.a.getRssWqGeometry();
        Object object = rssWQGeometry.getSubDomainList();
        object = object.iterator();
        while (object.hasNext()) {
            SubDomain subDomain = (SubDomain)object.next();
            if (subDomain.getType() != SubDomainType.RESERVOIR_1DV) continue;
            int n = subDomain.getElementId();
            Element element = this.b.getElement(n);
            if (element != null && element instanceof ReservoirElement) {
                ReservoirElement reservoirElement = (ReservoirElement)element;
                subDomain = (WQGeoSubDomain)subDomain;
                rssWQGeometry.setResOutletGeom(reservoirElement, (WQGeoSubDomain)subDomain);
                continue;
            }
            ((FluentLogger.Api)this.e.atSevere()).log("Can't find ResSim reservoir in network for WQ Subdomain " + subDomain.getName() + ", ResSim Element Id " + n);
        }
    }

    protected void b() {
        RssWQGeometry rssWQGeometry = this.a.getRssWqGeometry();
        Object object = rssWQGeometry.getSubDomainsInExtent();
        object = object.iterator();
        while (object.hasNext()) {
            SubDomain subDomain = (SubDomain)object.next();
            if (subDomain.getType() != SubDomainType.RESERVOIR_1DV) continue;
            ReservoirElement reservoirElement = (ReservoirElement)this.b.getElement(subDomain.getElementId());
            subDomain = (WQGeoSubDomain)subDomain;
            subDomain.clearWqControlDevices();
            rssWQGeometry.addWQControlDevices(reservoirElement, (WQGeoSubDomain)subDomain);
        }
    }

    protected void c() {
        RssWQGeometry rssWQGeometry = this.a.getRssWqGeometry();
        Object object = rssWQGeometry.getSubDomainsInExtent();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (SubDomain)object.next();
            if (object2.getType() != SubDomainType.RESERVOIR_1DV) continue;
            ReservoirElement reservoirElement = (ReservoirElement)this.b.getElement(object2.getElementId());
            double d = RssWQGeometry.getReservoirMaxElevation(reservoirElement);
            try {
                rssWQGeometry.setResStorageElevAreaData(reservoirElement, (WQGeoSubDomain)object2, d);
            }
            catch (WQException wQException) {
                object2 = wQException;
                object2 = wQException.getMessage();
                JOptionPane.showMessageDialog(this.c, object2, WqI18n.a("Geo.Editor.UpdateGeometry.Update.Status.Msg").getText(), 1);
            }
        }
    }

    protected void d() {
        RssWQGeometry rssWQGeometry = this.a.getRssWqGeometry();
        Object object = rssWQGeometry.getBoundariesList();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            SubDomainBoundary subDomainBoundary = (SubDomainBoundary)object.next();
            if (subDomainBoundary.getBoundaryType() != BoundaryType.LOCAL_INFLOW || (object2 = rssWQGeometry.getJunctionElement(this.b, subDomainBoundary)) == null) continue;
            String string = object2.getName() + " - ";
            int n = string.length();
            String string2 = subDomainBoundary.getName().substring(n);
            if ((object2 = object2.getLocalFlowVector()).size() != 1 || !((object2 = object2.get(0)) instanceof String[])) continue;
            object2 = object2;
            if ((object2 = object2[0]).equals(string2)) continue;
            bl = true;
            object2 = string + (String)object2;
            subDomainBoundary.setName((String)object2);
            stringBuilder.append(WqI18n.a("Geo.Editor.UpdateGeometry.LocalFlow.Msg").format(object2));
        }
        if (bl) {
            stringBuilder.append(WqI18n.a("Geo.Editor.UpdateGeometry.LocalFlow.Final.Msg").getText());
            JOptionPane.showMessageDialog(this.c, stringBuilder, WqI18n.a("Geo.Editor.UpdateGeometry.Update.Status.Msg").getText(), 1);
        }
    }

    public void a(ManagerProxyListContainer managerProxyListContainer) {
        Object object;
        if (this.c != null) {
            object = WqI18n.a("Geo.Editor.UpdateGeometry.ProgressMon.Msg").getText();
            String string = WqI18n.a("Geo.Editor.UpdateGeometry.ProgressMon.Note").getText();
            this.d = new ProgressMonitor(this.c, object, string, 0, 100);
            this.d.setMillisToDecideToPopup(0);
            this.d.setProgress(0);
        }
        object = new GeometryUpdater$1(this, managerProxyListContainer);
        ((SwingWorker)object).execute();
    }
}

