/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.rss.client.RSS;
import hec.rss.wq.map.MassInjectionManagerGlyph;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JOptionPane;
import rma.swing.RmaImage;

public class MassInjectionMouseAdapter
extends MapMouseAdapter {
    private Cursor _mouseCursor;
    private StreamAlignmentGlyph _alignGlyph;
    private MassInjectionManagerGlyph _sysglyph;
    private boolean _creatingRegion;
    private boolean _editingRegion;
    private WQMassInjectionSite _site;
    private boolean _moving;
    private LocalPt _selectedPt = null;
    private LocalPt _pt = new LocalPt();
    private LocalPt _pt0 = new LocalPt();
    private StreamElement _stream = null;
    private WorldPt _selectedWPt;
    private LocalRect _lrc = new LocalRect();
    private WorldRect _wrc = new WorldRect();
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public MassInjectionMouseAdapter(MapPanel object, MapCanvas mapCanvas) {
        super(object, mapCanvas);
        try {
            object = RmaImage.loadURLImage((Component)mapCanvas, (String)"Images/rss/wq/massInjectionCursor.gif");
            this._mouseCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), "Region Tool");
            return;
        }
        catch (Exception exception) {
            System.out.println("init:failed to find cursor image: Images/rss/wq/massInjectionCursor.gif. Error:" + String.valueOf(exception));
            return;
        }
    }

    public Cursor getCursor() {
        return this._mouseCursor;
    }

    public void init() {
        this.findSiteGlyph();
        this.findStreamGlyph();
    }

    public void abort() {
        this._creatingRegion = false;
        this._editingRegion = false;
        this._site = null;
    }

    boolean findSiteGlyph() {
        this._sysglyph = (MassInjectionManagerGlyph)this._mapPanel.findGlyphOfClass(MassInjectionManagerGlyph.class.getName());
        return this._sysglyph != null;
    }

    boolean findStreamGlyph() {
        this._alignGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        return this._alignGlyph != null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.findSiteGlyph()) {
            return;
        }
        if (this._moving && this._site != null) {
            mouseEvent = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._stream.getLine().getCoordAtLocation((WorldPt)mouseEvent);
            double d2 = this._stream.getStationByCoord(d);
            this._site = this._sysglyph.moveSite(this._site, (WorldPt)mouseEvent, this._stream, d, d2);
            this._moving = false;
            this._mapPanel.paintMap();
            return;
        }
        if (!(this._creatingRegion && mouseEvent.isControlDown() || this._creatingRegion && !mouseEvent.isControlDown())) {
            if (!this._editingRegion && !this._creatingRegion && mouseEvent.isControlDown()) {
                if (!this.findStreamGlyph()) {
                    RSS.app();
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create a Stream Alignment first");
                    return;
                }
                this._pt0.init(mouseEvent.getX(), mouseEvent.getY());
                this._pt.init(this._pt0);
                this._selectedWPt = this._mapPanel.scale().lp2wp(this._pt0);
                mouseEvent = this._alignGlyph.findReach(this._selectedWPt);
                if (mouseEvent == null) {
                    JOptionPane.showMessageDialog((Component)this._mapPanel, "Mass Injection Sites must be placed on a stream", "Cannot Create Mass Injection SIte", 1);
                    return;
                }
                mouseEvent.getStationByLocation(this._selectedWPt);
                this._site = this._sysglyph.createMassInjectionSite(this._pt, (StreamElement)mouseEvent);
                if (this._site == null) {
                    return;
                }
                this._sysglyph.getMassInjectionManager().setModified(true);
                this._mapPanel.paintMap();
                return;
            }
            if (this._selectedPt == null && (mouseEvent.isPopupTrigger() || MassInjectionMouseAdapter.pressedButton3((MouseEvent)mouseEvent)) && !this.findSiteGlyph()) {
                return;
            }
        }
    }

    public void mousePressed(MouseEvent object) {
        if (((MouseEvent)object).isPopupTrigger() || MassInjectionMouseAdapter.pressedButton3((MouseEvent)object)) {
            if (!this.findSiteGlyph()) {
                return;
            }
            object = new LocalPt(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            this._sysglyph.sitePopupMenu((LocalPt)object);
            return;
        }
        if (!this._creatingRegion && (this._creatingRegion || !((InputEvent)object).isControlDown()) && this._editingRegion && this._site != null && this._stream != null) {
            this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            this._pt0.init(this._pt);
            object = new LocalPt();
            Object object2 = this._sysglyph.getReferencePoint(this._site);
            this._mapPanel.scale().wp2lp((WorldPt)object2, (LocalPt)object);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            object2 = this._mapPanel.scale().lp2wp(this._pt);
            WorldLine worldLine = this._stream.getLine();
            double d = worldLine.getCoordAtLocation((WorldPt)object2);
            this._stream.getStationByCoord(d);
            object2 = new WorldPt();
            WorldPt worldPt = new WorldPt();
            boolean bl = worldLine.getSlopeAtCoord(d, worldPt, (WorldPt)object2);
            double d2 = !bl ? 1.5707963267948966 : (((WorldPt)object2).e == 0.0 ? 1.5707963267948966 : Math.atan(((WorldPt)object2).n / ((WorldPt)object2).e));
            object2 = this._sysglyph.getIcon();
            object2 = object2.getBounds2D();
            object2 = new Rectangle2D.Double(((RectangularShape)object2).getX() - 5.0, ((RectangularShape)object2).getY() - 5.0, ((RectangularShape)object2).getWidth() + 10.0, ((RectangularShape)object2).getHeight() + 10.0);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(((LocalPt)object).x, ((LocalPt)object).y);
            affineTransform.translate(-Math.sin(d2) * ((RectangularShape)object2).getMaxX(), -Math.cos(d2) * ((RectangularShape)object2).getMaxY());
            affineTransform.rotate(-d2);
            object = affineTransform.createTransformedShape((Shape)object2);
            object2 = this._mapCanvas.getGraphics();
            if (!object.contains(new Point2D.Double(this._pt.x, this._pt.y))) {
                return;
            }
            object = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(d));
            this._pt.init((LocalPt)object);
            ((Graphics)object2).setXORMode(new Color(255, 255, 255));
            ((Graphics)object2).fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            ((Graphics)object2).setPaintMode();
            ((Graphics)object2).dispose();
            this._moving = true;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._editingRegion && this._site != null && this._moving) {
            Graphics graphics = this._mapCanvas.getGraphics();
            graphics.setXORMode(new Color(255, 255, 255));
            graphics.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            mouseEvent = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
            mouseEvent = this._mapPanel.scale().lp2wp((LocalPt)mouseEvent);
            double d = this._stream.getLine().getCoordAtLocation((WorldPt)mouseEvent);
            this._stream.getStationByCoord(d);
            mouseEvent = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(d));
            this._pt.init((LocalPt)mouseEvent);
            graphics.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            graphics.setPaintMode();
            graphics.dispose();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this._creatingRegion && mouseEvent.getClickCount() == 2) {
            if (!this.findSiteGlyph()) {
                RSS.app();
                JOptionPane.showMessageDialog((Component)ClientApp.frame(), "No Mass Injection Site MapGlyph found");
                return;
            }
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            mouseEvent = this._sysglyph.selectSite(this._pt, false, false);
            if (mouseEvent != null) {
                this._sysglyph.selectSite(this._pt, false, true);
                this._editingRegion = true;
                this._stream = this.getStream((WQMassInjectionSite)mouseEvent);
            } else {
                this._editingRegion = false;
                this._stream = null;
            }
            this._site = mouseEvent;
            return;
        }
        if (!this._editingRegion) {
            if (!this.findSiteGlyph()) {
                return;
            }
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            mouseEvent = this._sysglyph.selectSite(this._pt, false, false);
            this._editingRegion = false;
            this._site = mouseEvent;
        }
    }

    private StreamElement getStream(WQMassInjectionSite wQMassInjectionSite) {
        if (wQMassInjectionSite == null) {
            return null;
        }
        return this._alignGlyph.findReach(wQMassInjectionSite.getStreamName());
    }

    void drawPt(LocalPt localPt, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        MassInjectionMouseAdapter._xpt[0] = localPt.x - 3;
        MassInjectionMouseAdapter._ypt[0] = localPt.y;
        MassInjectionMouseAdapter._xpt[1] = localPt.x;
        MassInjectionMouseAdapter._ypt[1] = localPt.y + 3;
        MassInjectionMouseAdapter._xpt[2] = localPt.x + 3;
        MassInjectionMouseAdapter._ypt[2] = localPt.y;
        MassInjectionMouseAdapter._xpt[3] = localPt.x;
        MassInjectionMouseAdapter._ypt[3] = localPt.y - 3;
        graphics.fillPolygon(_xpt, _ypt, 4);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawRegion(LocalRegion localRegion, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        bl = false;
        for (int i = 0; i < localRegion.pts.size() && i < 4000; ++i) {
            LocalPt localPt = (LocalPt)localRegion.pts.elementAt(i);
            if (localPt == null) continue;
            MassInjectionMouseAdapter._xpt[0] = localPt.x - 3;
            MassInjectionMouseAdapter._ypt[0] = localPt.y;
            MassInjectionMouseAdapter._xpt[1] = localPt.x;
            MassInjectionMouseAdapter._ypt[1] = localPt.y + 3;
            MassInjectionMouseAdapter._xpt[2] = localPt.x + 3;
            MassInjectionMouseAdapter._ypt[2] = localPt.y;
            MassInjectionMouseAdapter._xpt[3] = localPt.x;
            MassInjectionMouseAdapter._ypt[3] = localPt.y - 3;
            graphics.fillPolygon(_xpt, _ypt, 4);
            MassInjectionMouseAdapter._xp[bl] = localPt.x;
            MassInjectionMouseAdapter._yp[bl] = localPt.y;
            bl += 1;
        }
        graphics.drawPolygon(_xp, _yp, bl ? 1 : 0);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawSite(WQMassInjectionSite wQMassInjectionSite, boolean bl) {
        if (this._sysglyph == null || wQMassInjectionSite == null) {
            return;
        }
        Graphics graphics = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedSite(graphics, this._mapPanel.scale(), wQMassInjectionSite, bl, this._editingRegion);
        graphics.dispose();
    }
}

