/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ManagerProxy;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.geometry.GeometryEditorTab;
import hec.rss.wq.client.geometry.MetStationsPanel$1;
import hec.rss.wq.client.geometry.MetStationsPanel$2;
import hec.rss.wq.client.geometry.MetStationsPanel$3;
import hec.rss.wq.client.geometry.MetStationsPanel$4;
import hec.rss.wq.client.geometry.actions.FillNearestElementByMet;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.metstation.MetStation;
import hec.wqengineimpl.geometry.WQMetAssignmentSet;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.metstation.WQMetStationSet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;

public class MetStationsPanel
extends AbstractEditorPanel
implements GeometryEditorTab {
    private String _tabName;
    private RmaJTable _reachResTable;
    private GeometryEditor _editor;
    private RmaJComboBox<ManagerProxy> _metCombo;
    private JButton _fillNearestBtn;
    private FillNearestElementByMet _fillNearestAction;
    private WqGeometry _currentGeo;
    private WQMetStationSet _currentMetStationSet;

    public MetStationsPanel(GeometryEditor geometryEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = geometryEditor;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("Geo.MetStation.TabName").getText();
        Object[] objectArray = WqI18n.a("Geo.MetStation.Label.MetDataSet").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)objectArray, gridBagConstraints);
        this._metCombo = new RmaJComboBox();
        this._metCombo.setModifiable(true);
        objectArray.setLabelFor((Component)this._metCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MetStationsPanel metStationsPanel = this;
        metStationsPanel.add((Component)metStationsPanel._metCombo, gridBagConstraints);
        objectArray = new JLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)objectArray, gridBagConstraints);
        this._fillNearestBtn = WqI18n.a("Geo.MetStation.Button.FillNearest").createJButton();
        this._fillNearestAction = new FillNearestElementByMet(this);
        this._fillNearestBtn.setAction(this._fillNearestAction);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MetStationsPanel metStationsPanel2 = this;
        metStationsPanel2.add(metStationsPanel2._fillNearestBtn, gridBagConstraints);
        objectArray = new String[]{WqI18n.a("Geo.MetStation.Table.ReachRes").getText(), WqI18n.a("Geo.MetStation.Table.MetStation").getText()};
        MetStationsPanel metStationsPanel3 = this;
        this._reachResTable = new MetStationsPanel$1(metStationsPanel3, (Component)((Object)metStationsPanel3), objectArray);
        this._reachResTable.removePopuMenuFillOptions();
        this._reachResTable.removePopupMenuInsertAppendOnly();
        this._reachResTable.removePopupMenuSumOptions();
        this._reachResTable.setRowHeight(this._reachResTable.getRowHeight() + 5);
        this._reachResTable.setComboBoxEditor(1, new Object[0]);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MetStationsPanel metStationsPanel4 = this;
        metStationsPanel4.add(metStationsPanel4._reachResTable.getScrollPane(), gridBagConstraints);
    }

    private void addListeners() {
        this._metCombo.addItemListener(itemEvent -> {
            if (2 == itemEvent.getStateChange()) {
                return;
            }
            this.metDataSetComboChanged();
        });
        this._metCombo.addMouseListener((MouseListener)new MetStationsPanel$2(this));
        this._reachResTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.reachResTableSelected());
        MetStationsPanel$3 metStationsPanel$3 = new MetStationsPanel$3(this);
        this._metCombo.getActionMap().put("refresh", metStationsPanel$3);
        this._metCombo.getInputMap(0).put(KeyStroke.getKeyStroke(116, 0), "refresh");
    }

    protected void refreshMetCombo() {
        Object object = this._metCombo.getSelectedItem();
        this.fillMetCombo();
        this._metCombo.setSelectedItem(object);
    }

    private void reachResTableSelected() {
        int n = this._reachResTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        Object object = this._reachResTable.getValueAt(n, 0);
        if (object instanceof SubDomain) {
            object = new MetStationsPanel$4(this, "Select element in map", object);
            ((Thread)object).start();
        }
    }

    protected void displayMetComboPopup(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = WqI18n.a("WqModule.Menu.Edit").createMenuItem();
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionEvent -> this.displayMetStationEditor());
        jPopupMenu.show((Component)this._metCombo, (int)point.getX(), (int)point.getY());
    }

    private void displayMetStationEditor() {
        WaterQualityMode waterQualityMode = (WaterQualityMode)ClientApp.frame().getModeByClass(WaterQualityMode.class);
        waterQualityMode.displayMetDataSetEditor();
        this._metCombo.repaint();
    }

    private void metDataSetComboChanged() {
        this.saveSelections();
        Object object = (ManagerProxy)this._metCombo.getSelectedItem();
        if (object == null) {
            this._reachResTable.setComboBoxEditor(1, new Vector());
            this._currentMetStationSet = null;
            this._fillNearestBtn.setEnabled(false);
            return;
        }
        if ((object = (MetData)object.loadManager(null, null)) == null) {
            this._reachResTable.setComboBoxEditor(1, new Vector());
            this._currentMetStationSet = null;
            this._fillNearestBtn.setEnabled(false);
            return;
        }
        object = ((MetData)object).getMetStationSet();
        this._currentMetStationSet = object;
        object = object.getActiveStations();
        object = new Vector(object);
        this._reachResTable.setComboBoxEditor(1, (Vector)object);
        this._fillNearestBtn.setEnabled(!((Vector)object).isEmpty());
        this.fillTable();
    }

    private void saveSelections() {
        if (this._currentMetStationSet == null) {
            return;
        }
        int n = this._reachResTable.getRowCount();
        if (this._currentGeo != null) {
            WQMetAssignmentSet wQMetAssignmentSet = this._currentGeo.getRssWqGeometry().getMetAssignmentSet();
            for (int i = 0; i < n; ++i) {
                SubDomain subDomain = (SubDomain)this._reachResTable.getValueAt(i, 0);
                MetStation metStation = (MetStation)this._reachResTable.getValueAt(i, 1);
                if (metStation == null) continue;
                wQMetAssignmentSet.setMetStationId(this._currentMetStationSet.getId(), (WQSubDomainRef)subDomain.getRef(), Integer.valueOf(metStation.getId()));
            }
        }
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType namedType) {
        this.setIgnoreModifiedEvents(true);
        this._reachResTable.deleteCells();
        try {
            this.fillMetCombo();
            if (namedType instanceof ManagerProxyWrapper) {
                namedType = ((ManagerProxyWrapper)namedType).getManagerProxy();
                this._currentGeo = (WqGeometry)namedType.loadManager(null, null);
            }
            this.fillTable();
            if (this._metCombo.getSelectedIndex() != -1) {
                this.metDataSetComboChanged();
            }
        }
        finally {
            EventQueue.invokeLater(() -> this.setIgnoreModifiedEvents(false));
        }
        EventQueue.invokeLater(() -> this.setModified(false));
    }

    private boolean selectMetStation(Integer n) {
        int n2 = this._metCombo.getItemCount();
        for (int i = 0; i < n2; ++i) {
            ManagerProxy managerProxy = (ManagerProxy)this._metCombo.getItemAt(i);
            if (n.intValue() != managerProxy.getIndex()) continue;
            this._metCombo.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    private void fillTable() {
        this.setIgnoreModifiedEvents(true);
        try {
            this._reachResTable.setRowSorter(null);
            this._reachResTable.deleteCells();
            if (this._currentGeo != null) {
                RssSystem rssSystem = this._currentGeo.getNetwork();
                Object object = this._currentGeo.getRssWqGeometry();
                if (object != null) {
                    object = object.getSubDomainsInExtent();
                    for (int i = 0; i < object.size(); ++i) {
                        SubDomain subDomain = (SubDomain)object.get(i);
                        Vector<Object> vector = new Vector<Object>(2);
                        vector.add(subDomain);
                        vector.add(this.getMetStationSelection(subDomain, rssSystem));
                        this._reachResTable.appendRow(vector);
                    }
                }
            }
            this._reachResTable.setRowSorter(new TableRowSorter<TableModel>(this._reachResTable.getModel()));
            return;
        }
        finally {
            this.setIgnoreModifiedEvents(false);
        }
    }

    private MetStation getMetStationSelection(SubDomain object, RssSystem rssSystem) {
        if (this._currentGeo != null && this._currentMetStationSet != null && (object = (rssSystem = this._currentGeo.getRssWqGeometry().getMetAssignmentSet()).getMetStationId(this._currentMetStationSet.getId(), object.getRef())) != null && (object = this._currentMetStationSet.getStations(arg_0 -> MetStationsPanel.a((Integer)object, arg_0))) != null && object.size() > 0) {
            return (MetStation)object.get(0);
        }
        return null;
    }

    private void fillMetCombo() {
        Vector vector = this._editor.getWorkSpace().getManagerProxyList("rss", MetData.class.getName());
        vector = new RmaListModel(true, (Collection)vector);
        this._metCombo.setModel((ComboBoxModel)((Object)vector));
        if (vector.getSize() == 1) {
            this._metCombo.setSelectedIndex(0);
        } else {
            this._metCombo.setSelectedIndex(-1);
        }
        this.metDataSetComboChanged();
    }

    public boolean savePanel(NamedType namedType) {
        Object object = this._currentGeo;
        if (namedType instanceof WqGeometry) {
            object = (WqGeometry)namedType;
        }
        if (object == null) {
            return true;
        }
        this._reachResTable.commitEdit(true);
        int n = this._reachResTable.getRowCount();
        object = this._currentGeo.getRssWqGeometry();
        WQMetAssignmentSet wQMetAssignmentSet = object.getMetAssignmentSet();
        WQMetStationSet wQMetStationSet = this._currentMetStationSet;
        if (wQMetStationSet != null) {
            wQMetAssignmentSet.setMetStationMap(wQMetStationSet.getId(), new HashMap());
            for (int i = 0; i < n; ++i) {
                object = (SubDomain)this._reachResTable.getValueAt(i, 0);
                MetStation metStation = (MetStation)this._reachResTable.getValueAt(i, 1);
                if (metStation == null) continue;
                object = (WQSubDomainRef)object.getRef();
                wQMetAssignmentSet.setMetStationId(wQMetStationSet.getId(), (WQSubDomainRef)object, Integer.valueOf(metStation.getId()));
            }
        }
        return true;
    }

    public int getTabMnemonic() {
        return WqI18n.a("Geo.MetStation.TabName").getMnemonic();
    }

    public List<SubDomain> getSubdomainElements() {
        RssWQGeometry rssWQGeometry;
        if (this._currentGeo != null && (rssWQGeometry = this._currentGeo.getRssWqGeometry()) != null) {
            return rssWQGeometry.getSubDomainsInExtent();
        }
        return new ArrayList<SubDomain>();
    }

    public WQMetStationSet getSelectedMetStationSet() {
        return this._currentMetStationSet;
    }

    public WqGeometry getGeometry() {
        return this._currentGeo;
    }

    public void setMetStationFor(SubDomain subDomain, MetStation metStation) {
        int n = this._reachResTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            SubDomain subDomain2 = (SubDomain)this._reachResTable.getValueAt(i, 0);
            if (subDomain2 != subDomain) continue;
            this._reachResTable.setValueAt((Object)metStation, i, 1);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.metDataSetComboChanged();
        }
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
    }

    void selectMetStationSet(ManagerProxy managerProxy) {
        if (managerProxy == null) {
            this._metCombo.setSelectedIndex(-1);
            return;
        }
        this._metCombo.setSelectedItem((Object)managerProxy);
    }

    private static /* synthetic */ boolean a(Integer n, MetStation metStation) {
        return metStation.getId() == n.intValue();
    }
}

