/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.io.Identifier;
import hec.rss.wq.client.geometry.ImportShapefilePanel;
import hec.rss.wq.client.geometry.NewGeometryDialog$ToolTipComboBoxRenderer;
import hec.rss.wq.client.geometry.SaveGeometryDialog;
import hec.rss.wq.client.geometry.actions.NewCrossSectionManagerAction;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.ui.FileChooserField;
import hec.rss.wq.ui.OkCancelDialog;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class NewGeometryDialog
extends SaveGeometryDialog {
    private JLabel _rasGeoLabel;
    private RmaJComboBox<ManagerProxy> _rasGeoCombo;
    private JButton _importRasBtn;
    private JLabel _rasSteadyFlowLabel;
    private FileChooserField _rasSteadyFlowFld;
    private ImportShapefilePanel _shapefilePanel = new ImportShapefilePanel();

    public NewGeometryDialog(Dialog dialog, String string, String string2) {
        super(dialog, string, string2);
    }

    @Override
    protected void addAccessoryPanel() {
        this._rasGeoLabel = WqI18n.a("Geo.NewGeoDlg.Label.RasGeo").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._rasGeoLabel, gridBagConstraints);
        this._rasGeoCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
        NewGeometryDialog newGeometryDialog = this;
        this._rasGeoCombo.setRenderer((ListCellRenderer)new NewGeometryDialog$ToolTipComboBoxRenderer(newGeometryDialog, newGeometryDialog._rasGeoCombo.getRenderer()));
        this._rasGeoLabel.setLabelFor((Component)this._rasGeoCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._rasGeoCombo, gridBagConstraints);
        this._importRasBtn = WqI18n.a("Geo.NewGeoDlg.Button.ImportRAS").createJButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._importRasBtn, gridBagConstraints);
        this._rasSteadyFlowLabel = WqI18n.a("Geo.NewGeoDlg.Label.RasSteadyFlow").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._rasSteadyFlowLabel, gridBagConstraints);
        this._rasSteadyFlowFld = new FileChooserField();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = WqI18n.a("Geo.NewGeoDlg.Ras.FileFilter.Desc").getText();
        string = new RMAFilenameFilter("txt", string);
        string.setAcceptDirectories(true);
        arrayList.add(string);
        this._rasSteadyFlowFld.setFilters(arrayList);
        this._rasSteadyFlowLabel.setLabelFor((Component)((Object)this._rasSteadyFlowFld));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)((Object)this._rasSteadyFlowFld), gridBagConstraints);
        this.fillRasGeoCombo();
    }

    private void fillRasGeoCombo() {
        Vector vector = ClientApp.Workspace().getManagerProxyList("rss", CrossSectionManager.class.getName());
        vector = new RmaListModel(true, (Collection)vector);
        this._rasGeoCombo.setModel((ComboBoxModel)((Object)vector));
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this._importRasBtn.addActionListener(actionEvent -> this.selectRasAction());
    }

    private void importRasShapefile(PropertyChangeEvent object) {
        if (((PropertyChangeEvent)object).getNewValue().equals(1)) {
            Object object2;
            object = this._shapefilePanel.getShapefilePath();
            if (object == null) {
                return;
            }
            String string = this._shapefilePanel.getRiverColumnName();
            String string2 = this._shapefilePanel.getReachColumnName();
            String string3 = this._shapefilePanel.getStreamStationColumnName();
            String string4 = ((File)object).getName();
            string4 = RMAIO.getFileNameNoExtension((String)string4);
            RmaListModel rmaListModel = (RmaListModel)this._rasGeoCombo.getModel();
            for (int i = 0; i < rmaListModel.getSize(); ++i) {
                object2 = (ManagerProxy)rmaListModel.getElementAt(i);
                if (!object2.getName().contentEquals(string4)) continue;
                object2 = object2.getId();
                object2 = (CrossSectionManager)ClientApp.Workspace().loadManager("rss", CrossSectionManager.class.getName(), (Identifier)object2);
                if (object2 == null || !RMAIO.pathsEqual((String)(object2 = object2.getRasFile()), (String)((File)object).getAbsolutePath())) continue;
                object = WqI18n.a("Geo.NewGeoDlg.Msg.DuplicateRas").format(new Object[]{string4, object2});
                string = WqI18n.a("Geo.NewGeoDlg.Msg.DuplicateRas.Title").getText();
                JOptionPane.showMessageDialog((Component)((Object)this), object, string, 1);
                return;
            }
            CrossSectionManager crossSectionManager = new NewCrossSectionManagerAction((File)object).createCrossSectionManager();
            if (crossSectionManager != null) {
                crossSectionManager.setRiverColumn(string);
                crossSectionManager.setReachColumn(string2);
                crossSectionManager.setStationColumn(string3);
                crossSectionManager.setModified(true);
                ClientApp.Workspace().saveManager("rss", (Manager)crossSectionManager);
                object2 = ClientApp.Workspace().getManagerProxy("rss", crossSectionManager.getIdentifier());
                this._rasGeoCombo.addItem(object2);
                this._rasGeoCombo.setSelectedItem(object2);
            }
        }
    }

    private void selectRasAction() {
        Object object = ClientApp.Workspace().getWorkspacePath();
        this._shapefilePanel = new ImportShapefilePanel();
        this._shapefilePanel.setStartPath((String)object);
        NewGeometryDialog newGeometryDialog = this;
        object = new OkCancelDialog((Window)((Object)newGeometryDialog), newGeometryDialog._shapefilePanel, Dialog.ModalityType.APPLICATION_MODAL);
        object.addPropertyChangeListener("ReturnStatus", propertyChangeEvent -> this.importRasShapefile(propertyChangeEvent));
        object.setTitle(WqI18n.a("Geo.NewGeoDlg.Title.RasFileChooser").getText());
        object.pack();
        object.setSize(new Dimension(450, 220));
        object.setMinimumSize(new Dimension(450, 220));
        object.setLocationRelativeTo((Component)((Object)this));
        object.setVisible(true);
    }

    @Override
    protected boolean additionalValidation() {
        if (this._rasGeoCombo.getSelectedIndex() == -1) {
            String string = WqI18n.a("Geo.NewGeoDlg.Msg.SelectRasGeo").getText();
            String string2 = WqI18n.a("Geo.NewGeoDlg.Msg.SelectRasGeo.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this), string, string2, 1);
            return false;
        }
        return true;
    }

    @Override
    public void fillForm() {
        super.fillForm();
    }

    public int getCrossSectionManagerId() {
        ManagerProxy managerProxy = (ManagerProxy)this._rasGeoCombo.getSelectedItem();
        return managerProxy.getIndex();
    }

    public String getRasSteadyFlowFile() {
        return this._rasSteadyFlowFld.getPath();
    }
}

