/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.geometry.ReachCellDrawDataPanel$1;
import hec.rss.wq.client.geometry.ReachCellsDrawPropData;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.util.RMAUtil;

public final class ReachCellDrawDataPanel
extends RmaJPanel {
    public static final double MAX_WIDTH = 20.0;
    private ReachCellsDrawPropData _drawPropData;
    private final int _scale;
    private JSlider _transparencySlider;
    private RmaJDecimalField _transparencyField;
    private RmaJColorComboBox _color1Combobox;
    private RmaJColorComboBox _color2Combobox;
    private boolean _transparencyKeyTyped;
    private RmaJDecimalField _widthDecimalField;
    private RmaJColorComboBox _outlineColorCombo;

    public ReachCellDrawDataPanel(ReachCellsDrawPropData reachCellsDrawPropData, int n) {
        this.setLayout(new GridBagLayout());
        this._scale = n;
        this._drawPropData = reachCellsDrawPropData;
        this.buildControls();
        this.addListeners();
        this.fillPanel();
    }

    private void addListeners() {
        this._transparencySlider.addChangeListener(changeEvent -> {
            if (this._transparencyKeyTyped) {
                return;
            }
            this._transparencyField.setValue((double)this._transparencySlider.getValue() / 100.0);
            RMAUtil.setParentModified((Component)this._transparencySlider);
        });
        this._transparencyField.addKeyListener((KeyListener)new ReachCellDrawDataPanel$1(this));
    }

    private void buildControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)new RmaJLabel(WqI18n.a("ReachCellDrawDataPanel.Label.Transparency").getText()), (Object)gridBagConstraints);
        this._transparencySlider = new JSlider(0, 0, 100, 0);
        this._transparencySlider.setSize(this._transparencySlider.getPreferredSize());
        this._transparencySlider.setMinimumSize(this._transparencySlider.getPreferredSize());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._transparencySlider, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._transparencyField = new RmaJDecimalField();
        this._transparencyField.setMinValue(0.0);
        this._transparencyField.setMaxValue(1.0);
        this._transparencyField.setValue(0.0);
        this._transparencyField.setPreferredSize(new Dimension(30, this._transparencyField.getPreferredSize().height));
        this._transparencyField.setMinimumSize(this._transparencyField.getPreferredSize());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReachCellDrawDataPanel reachCellDrawDataPanel = this;
        reachCellDrawDataPanel.add((Component)reachCellDrawDataPanel._transparencyField, gridBagConstraints);
        rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)new TitledBorder(WqI18n.a("ReachCellDrawDataPanel.AlternatingFillColors.Title").getText()));
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)new RmaJLabel(WqI18n.a("ReachCellDrawDataPanel.Label.Color1").getText()), (Object)gridBagConstraints);
        this._color1Combobox = new RmaJColorComboBox();
        this._color1Combobox.setModifiable(true);
        this._color1Combobox.setAllowsCustomColor(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._color1Combobox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)new RmaJLabel(WqI18n.a("ReachCellDrawDataPanel.Label.Color2").getText()), (Object)gridBagConstraints);
        this._color2Combobox = new RmaJColorComboBox();
        this._color2Combobox.setModifiable(true);
        this._color2Combobox.setAllowsCustomColor(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)this._color2Combobox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)new RmaJLabel(WqI18n.a("ReachCellDrawDataPanel.Label.OutlineColor").getText()), (Object)gridBagConstraints);
        this._outlineColorCombo = new RmaJColorComboBox();
        this._outlineColorCombo.setModifiable(true);
        this._outlineColorCombo.setAllowsCustomColor(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._outlineColorCombo, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)new RmaJLabel(WqI18n.a("ReachCellDrawDataPanel.Label.Width").getText()), (Object)gridBagConstraints);
        this._widthDecimalField = new RmaJDecimalField();
        this._widthDecimalField.setMinValue(0.0);
        this._widthDecimalField.setMaxValue(20.0);
        this._widthDecimalField.setPreferredSize(new Dimension(50, this._widthDecimalField.getPreferredSize().height));
        this._widthDecimalField.setMinimumSize(this._widthDecimalField.getPreferredSize());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._widthDecimalField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)new JLabel(), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
    }

    private void fillPanel() {
        this._transparencySlider.setValue((int)(this._drawPropData.getTransparency() * 100.0));
        this._color1Combobox.setSelectedColor(this._drawPropData.getColor1());
        this._color2Combobox.setSelectedColor(this._drawPropData.getColor2());
        this._outlineColorCombo.setSelectedColor(this._drawPropData.getOutlineColor());
        this._widthDecimalField.setValue(this._drawPropData.getWidth());
        this.setModified(false);
    }

    public final void savePanel() {
        this._drawPropData.setTransparency(this._transparencyField.getValue());
        this._drawPropData.setColor1(this._color1Combobox.getSelectedColor());
        this._drawPropData.setColor2(this._color2Combobox.getSelectedColor());
        this._drawPropData.setOutlineColor(this._outlineColorCombo.getSelectedColor());
        this._drawPropData.setWidth(this._widthDecimalField.getValue());
        this._drawPropData.save(this._scale);
    }

    public final void setToDefaults() {
        ((WaterQualityDPData)this._drawPropData).setDefaults();
        this.fillPanel();
    }

    public final ReachCellsDrawPropData copyData(int n) {
        return ReachCellsDrawPropData.a(n, this._drawPropData);
    }

    public final void fillPanel(ReachCellsDrawPropData reachCellsDrawPropData) {
        this._drawPropData = reachCellsDrawPropData;
        this.fillPanel();
    }
}

