/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import com.google.common.flogger.FluentLogger;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.lang.NamedType;
import hec.map.LayerSelectionFactory;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSetFactory;
import hec.map.WorldPt;
import hec.model.StreamElement;
import hec.model.StreamPolyLine;
import hec.rss.model.Element;
import hec.rss.model.ReachElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.geometry.ReachCellsAttributeSet;
import hec.rss.wq.client.geometry.ReachCellsDrawPropData;
import hec.rss.wq.client.geometry.ReachCellsGlyphSelection;
import hec.rss.wq.client.geometry.ReachCellsMapObject;
import hec.rss.wq.client.geometry.RegionsDrawPropData;
import hec.rss.wq.client.geometry.WaterQualityDrawPropData;
import hec.rss.wq.model.ReachWaterQualitySegment;
import hec.rss.wq.model.WqGeometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.region.WQRegionSet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rma.lang.RmaMath;
import rma.util.ColorContour;

public class ReachCellsGlyph
extends MapGlyph {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final ReachCellsAttributeSet _rcDas;
    RssSystem _rssSystem = null;
    STRtree _streamSegmentTreeMap = new STRtree();
    Map<String, ReachWaterQualitySegment> _selectedSegments = new HashMap<String, ReachWaterQualitySegment>();
    Map<String, ReachWaterQualitySegment> _streamSegmentMap = new HashMap<String, ReachWaterQualitySegment>();

    public ReachCellsGlyph(MapPanel mapPanel, ReachCellsMapObject reachCellsMapObject) {
        super(mapPanel, (MapObjectInterface)reachCellsMapObject);
        this._rssSystem = reachCellsMapObject.a().getNetwork();
        this._rcDas = this.findAttributeSet();
    }

    public ModelDrawingAttributeSet getAttributeSet() {
        return this._rcDas;
    }

    private ReachCellsAttributeSet findAttributeSet() {
        Object object = AppDaddy.getFrame().getCurrentModule();
        object = object != null ? object.toString() : " ";
        if ((object = ModeDrawingAttributeSet.getModeAttributeSet((String)object)) == null) {
            return null;
        }
        return (ReachCellsAttributeSet)object.getModelAttributeSet("Reach Cells");
    }

    public boolean objectPopupMenu(LocalPt localPt, int n) {
        NamedType[] namedTypeArray = this._streamSegmentTreeMap.query(new Envelope((double)localPt.x, (double)localPt.x, (double)localPt.y, (double)localPt.y));
        GeometryFactory geometryFactory = new GeometryFactory();
        geometryFactory = geometryFactory.createPoint(new Coordinate((double)localPt.x, (double)localPt.y));
        namedTypeArray = namedTypeArray.iterator();
        while (namedTypeArray.hasNext()) {
            ReachWaterQualitySegment reachWaterQualitySegment = (ReachWaterQualitySegment)((Object)namedTypeArray.next());
            if (!reachWaterQualitySegment.getLocalGeometry().contains((Geometry)geometryFactory)) continue;
            this.objectSelect(localPt, n);
            HecClientFrame hecClientFrame = ClientApp.frame();
            hecClientFrame = hecClientFrame.getCurrentMode();
            namedTypeArray = this._selectedSegments.values().toArray(new ReachWaterQualitySegment[0]);
            return hecClientFrame.objectPopupMenu(namedTypeArray, localPt);
        }
        return false;
    }

    public NamedType objectSelect(LocalPt localPt, int n) {
        Object object2 = this._streamSegmentTreeMap.query(new Envelope((double)localPt.x, (double)localPt.x, (double)localPt.y, (double)localPt.y));
        GeometryFactory geometryFactory = new GeometryFactory();
        localPt = geometryFactory.createPoint(new Coordinate((double)localPt.x, (double)localPt.y));
        if (!ReachCellsGlyph.isShiftDown((int)n) && !ReachCellsGlyph.isControlDown((int)n)) {
            this._selectedSegments.clear();
        }
        for (Object object2 : object2) {
            if (!((ReachWaterQualitySegment)((Object)object2)).getLocalGeometry().contains((Geometry)localPt)) continue;
            this._selectedSegments.put(object2.getName(), (ReachWaterQualitySegment)((Object)object2));
            this._mapPanel.paintMap();
            return object2;
        }
        return null;
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        if (!this.isShown()) {
            return;
        }
        int n = WaterQualityDPData.b();
        WqGeometry wqGeometry = ((ReachCellsMapObject)this.getMap()).a();
        if (wqGeometry == null) {
            return;
        }
        Object object = wqGeometry.getRssWqGeometry();
        if (object == null) {
            return;
        }
        WQRegionSet wQRegionSet = object.getRegionSet();
        object = object.getSubDomainList();
        ReachCellsDrawPropData reachCellsDrawPropData = ReachCellsDrawPropData.b(n);
        Object object2 = RegionsDrawPropData.b(n);
        object2 = ((RegionsDrawPropData)object2).getColorContour();
        object2 = new WaterQualityDrawPropData(wqGeometry, wQRegionSet, Collections.EMPTY_LIST, (ColorContour)object2, (int)(255.0 * reachCellsDrawPropData.getTransparency()));
        mapScale.world2LocalTransform(null);
        graphics = (Graphics2D)graphics.create();
        this._streamSegmentTreeMap = new STRtree();
        this._streamSegmentMap.clear();
        wqGeometry = new GeometryFactory();
        int n2 = 0;
        for (Object object3 : object) {
            Element element;
            if ((object3 = (WQGeoSubDomain)object3).getType() != SubDomainType.REACH_1D || !((element = this._rssSystem.getElement(object3.getElementId())) instanceof ReachElement)) continue;
            element = (ReachElement)element;
            RssNode rssNode = element.getUpstreamNode();
            RssNode rssNode2 = element.getDownstreamNode();
            if (rssNode == null || rssNode2 == null) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("\nWarning, error in reach %s connectivity!", (Object)element.getName());
                continue;
            }
            StreamElement streamElement = rssNode.getStream();
            ShapeWriter shapeWriter = new ShapeWriter();
            if (streamElement == null) continue;
            if (rssNode.getStreamStation() == rssNode2.getStreamStation()) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("ReachCellsGlyph.drawReach: Warning, reach %s  has zero length!", (Object)element.getName());
                return;
            }
            ((WaterQualityDrawPropData)object2).getReachDrawData((ReachElement)element);
            double d = reachCellsDrawPropData.getWidth();
            object3 = object3.getXFace();
            Color color = reachCellsDrawPropData.getColor1();
            Color color2 = reachCellsDrawPropData.getColor2();
            for (int i = 0; object3 != null && i < ((SubDomain)object3).length - 1; ++i) {
                String string;
                double d2 = RmaMath.linearInterpolate((double)1.0, (double)rssNode.getStreamStation(), (double)0.0, (double)rssNode2.getStreamStation(), (double)object3[i]);
                double d3 = RmaMath.linearInterpolate((double)1.0, (double)rssNode.getStreamStation(), (double)0.0, (double)rssNode2.getStreamStation(), (double)object3[i + 1]);
                double d4 = streamElement.getCoordByStation(d2);
                double d5 = streamElement.getCoordByStation(d3);
                StreamPolyLine streamPolyLine = streamElement.getLineSegment(d5, d4);
                int n3 = streamPolyLine.getLocalRegionArrays(mapScale, xarray, yarray, d);
                Object object4 = new LocalPt();
                Object object5 = new WorldPt();
                if (n3 <= 0) continue;
                Polygon polygon = new Coordinate[n3 + 1];
                for (int j = 0; j < n3; ++j) {
                    object4.init(xarray[j], yarray[j]);
                    mapScale.lp2wp(object4, (WorldPt)object5);
                    polygon[j] = new Coordinate(((WorldPt)object5).e, ((WorldPt)object5).n);
                }
                Polygon polygon2 = polygon;
                polygon2[((Coordinate[])polygon2).length - 1] = polygon[0];
                Polygon polygon3 = wqGeometry.createPolygon((Coordinate[])polygon);
                shapeWriter.toShape((Geometry)polygon3);
                ((WaterQualityDrawPropData)object2).getReachDrawData((ReachElement)element);
                object4 = n2 % 2 == 0 ? color : color2;
                object5 = reachCellsDrawPropData.getOutlineColor();
                graphics.setColor((Color)object4);
                graphics.fillPolygon(xarray, yarray, n3);
                graphics.setColor((Color)object5);
                object4 = AlphaComposite.getInstance(3, (float)reachCellsDrawPropData.getTransparency());
                ((Graphics2D)graphics).setComposite((Composite)object4);
                graphics.drawPolygon(xarray, yarray, n3);
                int n4 = i;
                object5 = new ArrayList();
                for (int j = 0; j < n3; ++j) {
                    object5.add(new Coordinate((double)xarray[j], (double)yarray[j]));
                }
                object5.add(new Coordinate((double)xarray[0], (double)yarray[0]));
                polygon = wqGeometry.createPolygon(object5.toArray(new Coordinate[n3]));
                String string2 = string = element.getName() + i;
                object4 = this._streamSegmentMap.computeIfAbsent(string2, arg_0 -> ReachCellsGlyph.lambda$draw$0(string2, (ReachElement)element, n4, (Geometry)polygon3, polygon, arg_0));
                if (this._selectedSegments.get(string) != null) {
                    this._selectedSegments.put(string, this._streamSegmentMap.get(string));
                }
                this._streamSegmentTreeMap.insert(polygon.getEnvelopeInternal(), object4);
                ++n2;
            }
        }
        object = new ShapeWriter();
        ((Graphics2D)graphics).setTransform(mapScale.world2LocalTransform(null));
        this._selectedSegments.values().forEach(arg_0 -> ReachCellsGlyph.lambda$draw$1((ShapeWriter)object, (Graphics2D)graphics, arg_0));
        graphics.dispose();
    }

    public boolean isShown() {
        if (this._rcDas == null) {
            return false;
        }
        return this._rcDas.isShown();
    }

    private static /* synthetic */ void lambda$draw$1(ShapeWriter object, Graphics2D graphics2D, ReachWaterQualitySegment reachWaterQualitySegment) {
        object = object.toShape(reachWaterQualitySegment.getWorldGeometry());
        graphics2D.setColor(Color.yellow);
        graphics2D.fill((Shape)object);
        graphics2D.setColor(Color.red);
        graphics2D.draw((Shape)object);
    }

    private static /* synthetic */ ReachWaterQualitySegment lambda$draw$0(String string, ReachElement reachElement, int n, Geometry geometry, Polygon polygon, String string2) {
        return new ReachWaterQualitySegment(string, reachElement.getName(), n, geometry, (Geometry)polygon);
    }

    static {
        LayerSelectionFactory.addMapping((String)ReachCellsGlyph.class.getName(), (String)ReachCellsGlyphSelection.class.getName());
        ModelDrawingAttributeSetFactory.addMapping((String)"Reach Cells", (String)ReachCellsAttributeSet.class.getName());
    }
}

