/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$1;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$2;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$3;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$4;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$ColorComboBoxActionListener;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$ContourComboBoxRenderer;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$GrayColorContour;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel$ImageJPanel;
import hec.rss.wq.client.geometry.RegionsDrawPropData;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJFontButton;
import rma.swing.list.RmaListModel;
import rma.util.ColorContour;
import rma.util.GrayscaleColorContour;
import rma.util.PrecipColorContour;
import rma.util.RGBColorContour;
import rma.util.TerrainColorContour;
import rma.util.WaterDepthColorContour;

public class RegionsDrawDataPanel
extends JPanel {
    private RegionsDrawPropData _drawPropData;
    private final int _scale;
    RmaJComboBox<ColorContour> _colorContourRmaJComboBox;
    JSlider _transparencySlider;
    RmaJDecimalField _transparancyField;
    RmaJCheckBox _drawRegionName;
    RmaJFontButton _rmaJFontButton;
    RegionsDrawDataPanel$ImageJPanel _imageJPanel;
    Map<Class, String> nameMap = new HashMap<Class, String>();
    private boolean _keyTyped = false;

    public RegionsDrawDataPanel(RegionsDrawPropData regionsDrawPropData, int n) {
        this._drawPropData = regionsDrawPropData;
        this._scale = n;
        this.buildComponents();
        this.fillPanel();
    }

    public void savePanel() {
        this._drawPropData.setColorContour((ColorContour)this._colorContourRmaJComboBox.getSelectedItem());
        this._drawPropData.setDrawName(this._drawRegionName.isSelected());
        this._drawPropData.setFont(this._rmaJFontButton.getFont());
        this._drawPropData.setTransparency((double)this._transparencySlider.getValue() / 100.0);
        this._transparancyField.setValue(this._drawPropData.getTransparency());
        this._drawPropData.save(this._scale);
    }

    private ColorContour configureContour(ColorContour colorContour) {
        colorContour.setMaxValue(100.0);
        colorContour.setMinValue(0.0);
        return colorContour;
    }

    public void fillPanel(RegionsDrawPropData regionsDrawPropData) {
        this._drawPropData = regionsDrawPropData;
        this.fillPanel();
    }

    private void fillPanel() {
        RmaListModel rmaListModel = new ArrayList();
        rmaListModel.add(this.configureContour((ColorContour)new RGBColorContour()));
        rmaListModel.add(this.configureContour((ColorContour)new PrecipColorContour()));
        rmaListModel.add(this.configureContour((ColorContour)new TerrainColorContour()));
        rmaListModel.add(this.configureContour((ColorContour)new WaterDepthColorContour()));
        rmaListModel.add(this.configureContour((ColorContour)new GrayscaleColorContour()));
        this.nameMap.put(RGBColorContour.class, "Red-Green-Blue");
        this.nameMap.put(PrecipColorContour.class, "Precipitation");
        this.nameMap.put(TerrainColorContour.class, "Terrain");
        this.nameMap.put(WaterDepthColorContour.class, "Water Depth");
        this.nameMap.put(GrayscaleColorContour.class, "Grayscale");
        if (this._drawPropData == null) {
            return;
        }
        rmaListModel = new RmaListModel(false, rmaListModel);
        this._colorContourRmaJComboBox.setModel((ComboBoxModel)rmaListModel);
        for (int i = 0; i < rmaListModel.getSize(); ++i) {
            if (!((ColorContour)rmaListModel.getElementAt(i)).getClass().isAssignableFrom(this._drawPropData.getColorContour().getClass())) continue;
            this._colorContourRmaJComboBox.setSelectedIndex(i);
            break;
        }
        this._drawRegionName.setSelected(this._drawPropData.getDrawName());
        this._rmaJFontButton.setFont(this._drawPropData.getFont());
        this._transparencySlider.setValue((int)(100.0 * this._drawPropData.getTransparency()));
        this._transparancyField.setValue(this._drawPropData.getTransparency());
        SwingUtilities.invokeLater(new RegionsDrawDataPanel$1(this));
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        JComponent jComponent = new JLabel("Color Ramp:");
        this.add((Component)jComponent, gridBagConstraints);
        this._colorContourRmaJComboBox = new RmaJComboBox();
        this._colorContourRmaJComboBox.setRenderer((ListCellRenderer)new RegionsDrawDataPanel$ContourComboBoxRenderer(this));
        this._colorContourRmaJComboBox.addActionListener((ActionListener)new RegionsDrawDataPanel$ColorComboBoxActionListener(this));
        this._colorContourRmaJComboBox.setModifiable(true);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        RegionsDrawDataPanel regionsDrawDataPanel = this;
        regionsDrawDataPanel.add((Component)regionsDrawDataPanel._colorContourRmaJComboBox, gridBagConstraints);
        jComponent = new JLabel("Transparency(0.0-1.0)");
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        this._transparencySlider = new JSlider(0, 0, 100, 0);
        this._transparencySlider.setSize(this._transparencySlider.getPreferredSize());
        this._transparencySlider.setMinimumSize(this._transparencySlider.getPreferredSize());
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        jComponent.add((Component)this._transparencySlider, gridBagConstraints);
        this._transparancyField = new RmaJDecimalField();
        this._transparancyField.setValue(0.0);
        this._transparancyField.setMinimumSize(this._transparancyField.getPreferredSize());
        gridBagConstraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0);
        jComponent.add((Component)this._transparancyField, gridBagConstraints);
        this._drawRegionName = new RmaJCheckBox("Draw Region Name");
        new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this._rmaJFontButton = new RmaJFontButton("Font");
        new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        jComponent = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(3, 0, 1, 4, 0.0, 1.0, 12, 3, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        jComponent.setBorder(BorderFactory.createTitledBorder("Scale"));
        this._imageJPanel = new RegionsDrawDataPanel$2(this);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(1, 1, 1, 1), 0, 0);
        jComponent.add((Component)this._imageJPanel, gridBagConstraints);
        this._transparencySlider.addChangeListener(new RegionsDrawDataPanel$3(this));
        this._transparancyField.setMinValue(0.0);
        this._transparancyField.setMaxValue(1.0);
        this._transparancyField.addKeyListener((KeyListener)new RegionsDrawDataPanel$4(this));
    }

    public void setToDefaults() {
        ((WaterQualityDPData)this._drawPropData).setDefaults();
        this.fillPanel();
    }

    public RegionsDrawPropData copyData(int n) {
        return RegionsDrawPropData.a(n, this._drawPropData);
    }

    protected void paintScale() {
        int n = this._imageJPanel.getWidth();
        int n2 = this._imageJPanel.getHeight();
        int[] nArray = new int[n * n2];
        ColorContour colorContour = (ColorContour)this._colorContourRmaJComboBox.getSelectedItem();
        if (colorContour == null) {
            colorContour = new RegionsDrawDataPanel$GrayColorContour(this);
            colorContour.setMinValue(0.0);
            colorContour.setMaxValue(100.0);
        }
        double d = colorContour.getMaxValue();
        double d2 = colorContour.getMinValue();
        double d3 = (d - d2) / (double)n2;
        colorContour.getSaturation();
        colorContour.getBrightness();
        for (int i = 0; i < n2; ++i) {
            double d4 = d - (double)i * d3;
            Color color = colorContour.getColor(d4);
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = color.getRGB();
            }
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
        Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {}
        this._imageJPanel.setImage(image);
        this._imageJPanel.repaint();
    }
}

