/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.wq.client.WqUiUtils;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.geometry.GeometryEditorTab;
import hec.rss.wq.client.geometry.RegionsPanel$1;
import hec.rss.wq.client.geometry.RegionsPanel$RegionTableModel;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.region.WQRegion;
import hec.wqengineimpl.region.WQRegionSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Collection;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.table.ToolTipHeader;

public class RegionsPanel
extends AbstractEditorPanel
implements GeometryEditorTab {
    private String _tabName;
    private RmaJTable _regionTable;
    private GeometryEditor _editor;
    private WqGeometry _currentGeo;

    public RegionsPanel(GeometryEditor geometryEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = geometryEditor;
        this.buildControls();
        this.addListener();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("Geo.Regions.TabName").getText();
        RegionsPanel regionsPanel = this;
        this._regionTable = new RegionsPanel$1(regionsPanel, (Component)((Object)regionsPanel));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        RegionsPanel regionsPanel2 = this;
        regionsPanel2.add(regionsPanel2._regionTable.getScrollPane(), gridBagConstraints);
    }

    protected String getTableToolTip(Point point) {
        int n = this._regionTable.rowAtPoint(point);
        if (n == -1) {
            return null;
        }
        int n2 = this._regionTable.columnAtPoint(point);
        if (n2 == -1) {
            return null;
        }
        Object object = this._regionTable.getValueAt(n, n2);
        if (object instanceof SubDomain) {
            object = (SubDomain)object;
            return object.getType().toString().concat(" : ").concat(object.getName());
        }
        return null;
    }

    private void addListener() {
        this._regionTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.regionTableSelected());
    }

    private void regionTableSelected() {
        int n = this._regionTable.getSelectedRow();
        int n2 = this._regionTable.getSelectedColumn();
        if (n == -1 || n2 == -1) {
            return;
        }
        Object object = this._regionTable.getValueAt(n, n2);
        if (object instanceof SubDomain) {
            WqUiUtils.a((SubDomain)object, this._currentGeo);
        }
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType object) {
        this._regionTable.deleteCells();
        if (object instanceof ManagerProxyWrapper) {
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            this._currentGeo = (WqGeometry)object.loadManager(null, null);
        }
        if (this._currentGeo != null && (object = this._currentGeo.getRssWqGeometry()) != null) {
            object = object.getRegionSet();
            this.fillTable((WQRegionSet)object);
        }
    }

    private void fillTable(WQRegionSet object) {
        object = object.getRegions();
        object = new RegionsPanel$RegionTableModel(this, (Collection<WQRegion>)object);
        this._regionTable.setModel((TableModel)object);
        JTableHeader jTableHeader = this._regionTable.getTableHeader();
        if (jTableHeader instanceof ToolTipHeader) {
            jTableHeader = (ToolTipHeader)jTableHeader;
            jTableHeader.setToolTipStrings(((RegionsPanel$RegionTableModel)((Object)object)).getHeaderToolTips());
        }
    }

    public boolean savePanel(NamedType namedType) {
        return true;
    }

    public int getTabMnemonic() {
        return WqI18n.a("Geo.Regions.TabName").getMnemonic();
    }
}

