/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.ReservoirLayerHeightDefinition;
import hec.rss.plugins.waterquality.model.ReservoirLayerHeightDefinitionType;
import hec.rss.plugins.waterquality.model.ReservoirLayerSpacingType;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.geometry.ReservoirLayerHeightsEditorPanel$1;
import hec.rss.wq.client.geometry.ReservoirLayerVariableHeightsEditor;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.WQException;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import mil.army.usace.hec.metadata.Parameter;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ReservoirLayerHeightsEditorPanel
extends JPanel {
    public static final Logger logger = Logger.getLogger(ReservoirLayerHeightsEditorPanel.class.getName());
    private RmaJRadioButton _globalRadio;
    private RmaJDecimalField _globalFld;
    private JRadioButton _valueByResRadio;
    private RmaJTable _resHeightTable;
    private WqGeometry _currentGeo;
    private RmaJDialog _parent;
    private JComboBox _typeCombo;
    private RmaJButton _configureHeightsButton;
    private Map<Integer, ParamDouble> _heightsConstantMap = new HashMap<Integer, ParamDouble>();
    private Map<Integer, List<Double>> _heightsVariableMap = new HashMap<Integer, List<Double>>();

    public ReservoirLayerHeightsEditorPanel(RmaJDialog rmaJDialog) {
        super(new GridBagLayout());
        this._parent = rmaJDialog;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._globalRadio = (RmaJRadioButton)WqI18n.a("Geo.ResLayerHeightEditor.Radio.Global").createJRadioButton();
        this._globalRadio.setSelected(true);
        this._globalRadio.setParameterId(Parameter.PARAMID_ELEV);
        Serializable serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        ReservoirLayerHeightsEditorPanel reservoirLayerHeightsEditorPanel = this;
        reservoirLayerHeightsEditorPanel.add((Component)reservoirLayerHeightsEditorPanel._globalRadio, serializable);
        this._globalFld = new RmaJDecimalField();
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        ReservoirLayerHeightsEditorPanel reservoirLayerHeightsEditorPanel2 = this;
        reservoirLayerHeightsEditorPanel2.add((Component)reservoirLayerHeightsEditorPanel2._globalFld, serializable);
        this._valueByResRadio = WqI18n.a("Geo.ResLayerHeightEditor.Radio.ValueByRes").createJRadioButton();
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        ReservoirLayerHeightsEditorPanel reservoirLayerHeightsEditorPanel3 = this;
        reservoirLayerHeightsEditorPanel3.add((Component)reservoirLayerHeightsEditorPanel3._valueByResRadio, serializable);
        Object[] objectArray = new String[]{WqI18n.a("Geo.ResLayerHeightEditor.Table.Reservoir").getText(), WqI18n.a("Geo.ResLayerHeightEditor.Table.HeightType").getText(), WqI18n.a("Geo.ResLayerHeightEditor.Table.Height").getText()};
        ReservoirLayerHeightsEditorPanel reservoirLayerHeightsEditorPanel4 = this;
        this._resHeightTable = new ReservoirLayerHeightsEditorPanel$1(reservoirLayerHeightsEditorPanel4, reservoirLayerHeightsEditorPanel4, objectArray);
        this._configureHeightsButton = new RmaJButton(WqI18n.a("Geo.ResLayerHeightEditor.Table.ConfigureHeights").getText());
        this._resHeightTable.setUnitsHeaderRenderer();
        this._resHeightTable.setColumnParameters(new int[]{-1, -1, Parameter.PARAMID_ELEV});
        this._typeCombo = this._resHeightTable.setComboBoxEditor(1, (Object[])ReservoirLayerSpacingType.values());
        this._resHeightTable.setDoubleCellEditor(2);
        this._resHeightTable.removePopupMenuSumOptions();
        this._resHeightTable.removePopuMenuFillOptions();
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)5);
        ReservoirLayerHeightsEditorPanel reservoirLayerHeightsEditorPanel5 = this;
        reservoirLayerHeightsEditorPanel5.add((Component)reservoirLayerHeightsEditorPanel5._resHeightTable.getScrollPane(), serializable);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._globalRadio);
        ((ButtonGroup)serializable).add(this._valueByResRadio);
        this.heightRadioAction();
    }

    private void addListeners() {
        this._globalRadio.addActionListener(actionEvent -> this.heightRadioAction());
        this._valueByResRadio.addActionListener(actionEvent -> this.heightRadioAction());
        this._typeCombo.addActionListener(this::typeComboAction);
        this._configureHeightsButton.addActionListener(actionEvent -> this.configureHeightsAction());
    }

    private void configureHeightsAction() {
        int n2 = this._resHeightTable.getSelectedRow();
        if (n2 >= 0) {
            SubDomain subDomain = (SubDomain)this._resHeightTable.getValueAt(n2, 0);
            List list2 = this._heightsVariableMap.computeIfAbsent(n2, n -> new ArrayList());
            if (list2.isEmpty()) {
                int n3 = subDomain.getElementId();
                RssSystem rssSystem = this._currentGeo.getNetwork();
                if (rssSystem != null) {
                    ReservoirElement reservoirElement = (ReservoirElement)rssSystem.getElement(n3);
                    list2.add(RssWQGeometry.getReservoirMinElevation(reservoirElement));
                    list2.add(RssWQGeometry.getReservoirMaxElevation(reservoirElement));
                }
            }
            ReservoirLayerVariableHeightsEditor reservoirLayerVariableHeightsEditor = new ReservoirLayerVariableHeightsEditor((Window)this._parent, subDomain.getName(), list2, list -> this.updatedVariableHeights(n2, (List<Double>)list));
            reservoirLayerVariableHeightsEditor.setVisible(true);
        }
    }

    private void updatedVariableHeights(int n, List<Double> list) {
        this._heightsVariableMap.put(n, list);
    }

    private void typeComboAction(ActionEvent object) {
        int n = this._resHeightTable.getSelectedRow();
        if (n >= 0) {
            if (((EventObject)object).getSource() instanceof RmaJComboBox && ((RmaJComboBox)((EventObject)object).getSource()).getSelectedItem() == ReservoirLayerSpacingType.CONSTANT) {
                object = this._heightsConstantMap.get(n);
                if (object != null) {
                    this._resHeightTable.setValueAt(object, n, 2);
                }
            } else {
                object = this._resHeightTable.getValueAt(n, 2);
                if (object instanceof ParamDouble) {
                    this._heightsConstantMap.put(n, (ParamDouble)object);
                }
            }
        }
        this._resHeightTable.repaint();
    }

    private void heightRadioAction() {
        this._globalFld.setEnabled(this._globalRadio.isSelected());
        this._resHeightTable.repaint();
    }

    protected boolean savePanel() {
        this._resHeightTable.commitEdit(true);
        if (this._currentGeo != null) {
            ReservoirLayerHeightDefinition reservoirLayerHeightDefinition = this._currentGeo.getRssWqGeometry().getReservoirHeightDefinition();
            if (this._globalRadio.isSelected()) {
                reservoirLayerHeightDefinition.setType(ReservoirLayerHeightDefinitionType.Global);
            } else {
                reservoirLayerHeightDefinition.setType(ReservoirLayerHeightDefinitionType.SubDomain);
            }
            double d = this._globalFld.getValueUndefined();
            reservoirLayerHeightDefinition.setGlobalHeight(RMAConst.isValidValue((double)d) ? Double.valueOf(d) : null);
            int n = this._resHeightTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                SubDomain subDomain = (SubDomain)this._resHeightTable.getValueAt(i, 0);
                Object object = (ReservoirLayerSpacingType)((Object)this._resHeightTable.getValueAt(i, 1));
                reservoirLayerHeightDefinition.setSpacingType((WQSubDomainRef)subDomain.getRef(), (ReservoirLayerSpacingType)((Object)object));
                if (object == ReservoirLayerSpacingType.CONSTANT) {
                    object = this._resHeightTable.getValueAt(i, 2);
                    double d2 = RMAIO.parseDouble((Object)object);
                    reservoirLayerHeightDefinition.setConstantHeight((WQSubDomainRef)subDomain.getRef(), RMAConst.isValidValue((double)d2) ? Double.valueOf(d2) : null);
                    continue;
                }
                object = this._heightsVariableMap.get(i);
                reservoirLayerHeightDefinition.setVariableHeights((WQSubDomainRef)subDomain.getRef(), (List<Double>)object);
            }
            RssSystem rssSystem = this._currentGeo.getNetwork();
            try {
                this._currentGeo.getRssWqGeometry().applyReservoirHeightDefinition(rssSystem);
            }
            catch (WQException wQException) {
                logger.log(Level.WARNING, "Exception applying Reservoir Height Definition " + wQException.getMessage());
                JOptionPane.showMessageDialog(this, "Exception applying Reservoir Height Definition " + String.valueOf((Object)wQException), "Error", 0);
                return false;
            }
        }
        return true;
    }

    public void fillPanel(WqGeometry object) {
        int n = ClientApp.Workspace().getUnitSystem();
        this._currentGeo = object;
        this._resHeightTable.deleteCells();
        if (object != null) {
            ReservoirLayerHeightDefinition reservoirLayerHeightDefinition = ((WqGeometry)((Object)object)).getRssWqGeometry().getReservoirHeightDefinition();
            Object object2 = reservoirLayerHeightDefinition.getType();
            if (ReservoirLayerHeightDefinitionType.Global == object2) {
                this._globalRadio.setSelected(true);
            } else {
                this._valueByResRadio.setSelected(true);
            }
            this.heightRadioAction();
            object2 = reservoirLayerHeightDefinition.getGlobalHeight();
            double d = object2 != null ? (Double)object2 : Double.NEGATIVE_INFINITY;
            this._globalFld.setValue(new ParamDouble(d, Parameter.PARAMID_ELEV, n));
            object = ((WqGeometry)((Object)object)).getRssWqGeometry();
            object = object.getReservoirs();
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (SubDomain)object.next();
                Vector<Object> vector = new Vector<Object>(3);
                vector.add(object2);
                ReservoirLayerSpacingType reservoirLayerSpacingType = reservoirLayerHeightDefinition.getSpacingType((WQSubDomainRef)object2.getRef());
                vector.add((Object)reservoirLayerSpacingType);
                if (reservoirLayerSpacingType == ReservoirLayerSpacingType.CONSTANT) {
                    double d2 = (object2 = reservoirLayerHeightDefinition.getConstantHeight((WQSubDomainRef)object2.getRef())) != null ? (Double)object2 : Double.NEGATIVE_INFINITY;
                    vector.add(new ParamDouble(d2, Parameter.PARAMID_ELEV, n, 3));
                } else {
                    object2 = reservoirLayerHeightDefinition.getVariableHeights((WQSubDomainRef)object2.getRef());
                    this._heightsVariableMap.put(this._resHeightTable.getRowCount(), (List<Double>)object2);
                }
                this._resHeightTable.appendRow(vector);
            }
        }
        this._parent.setModified(false);
    }
}

