/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.rss.wq.client.geometry.ReservoirLayerHeightsEditorPanel;
import hec.rss.wq.client.geometry.ReservoirLayerVariableHeightsEditor$1;
import hec.rss.wq.client.geometry.ReservoirLayerVariableHeightsEditor$2;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Parameter;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

final class ReservoirLayerVariableHeightsEditor
extends RmaJDialog {
    private final List<Double> _variableHeights;
    private final Consumer<List<Double>> _consumer;
    private RmaJTable _variableHeightsTable;
    private ButtonCmdPanel _btnCmdPanel;

    ReservoirLayerVariableHeightsEditor(Window window, String string, List<Double> list, Consumer<List<Double>> consumer) {
        super(window, WqI18n.a("Geo.ResLayerVariableHeightsEditor.Title").getText() + " - " + string, true);
        this.setLayout(new GridBagLayout());
        this._variableHeights = list;
        this._consumer = consumer;
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(window);
        this.setSize(325, 225);
        this.buildComponents();
        this.fillTable();
        this.addListeners();
    }

    private void fillTable() {
        Vector<Number> vector;
        int n;
        this._variableHeightsTable.deleteCells();
        for (n = 0; n < this._variableHeights.size(); ++n) {
            vector = new Vector<Number>();
            vector.add(n + 1);
            vector.add(this._variableHeights.get(n));
            this._variableHeightsTable.appendRow(vector);
        }
        if (this._variableHeightsTable.getRowCount() < 10) {
            for (n = this._variableHeightsTable.getRowCount(); n < 10; ++n) {
                vector = new Vector<Integer>();
                vector.add(n + 1);
                vector.add(null);
                this._variableHeightsTable.appendRow(vector);
            }
        }
    }

    private void addListeners() {
        this._btnCmdPanel.getButton(8).addActionListener(actionEvent -> this.okAction());
        this._btnCmdPanel.getButton(4).addActionListener(actionEvent -> this.cancelAction());
        this.addWindowListener(new ReservoirLayerVariableHeightsEditor$1(this));
    }

    private void cancelAction() {
        this.dispose();
    }

    private void okAction() {
        this._variableHeightsTable.commitEdit(true);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this._variableHeightsTable.getRowCount(); ++i) {
            Object object = this._variableHeightsTable.getValueAt(i, 1);
            if (object == null || object.toString().isEmpty()) continue;
            arrayList.add(Double.parseDouble(object.toString()));
        }
        this._consumer.accept(arrayList);
        this.dispose();
    }

    private void buildComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Object[] objectArray = new String[]{WqI18n.a("Geo.ResLayerHeightEditor.Table.Layer").getText(), WqI18n.a("Geo.ResLayerVariableHeightsEditor.Col.Spacing").getText()};
        ReservoirLayerVariableHeightsEditor reservoirLayerVariableHeightsEditor = this;
        this._variableHeightsTable = new ReservoirLayerVariableHeightsEditor$2(reservoirLayerVariableHeightsEditor, (Component)((Object)reservoirLayerVariableHeightsEditor), objectArray);
        this._variableHeightsTable.setUnitsHeaderRenderer();
        this._variableHeightsTable.setColumnParameters(new int[]{-1, Parameter.PARAMID_ELEV});
        this._variableHeightsTable.setDoubleCellEditor(1);
        this._variableHeightsTable.setColumnEnabled(false, 0);
        this._variableHeightsTable.removePopupMenuSumOptions();
        this._variableHeightsTable.removePopuMenuFillOptions();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirLayerVariableHeightsEditor reservoirLayerVariableHeightsEditor2 = this;
        reservoirLayerVariableHeightsEditor2.add(reservoirLayerVariableHeightsEditor2._variableHeightsTable.getScrollPane(), gridBagConstraints);
        this._btnCmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ReservoirLayerVariableHeightsEditor reservoirLayerVariableHeightsEditor3 = this;
        reservoirLayerVariableHeightsEditor3.add((Component)reservoirLayerVariableHeightsEditor3._btnCmdPanel, gridBagConstraints);
    }

    private String getElevationUnits() {
        String string = "";
        try {
            string = Parameter.getParameter((int)Parameter.PARAMID_ELEV).getUnitsStringForSystem(ClientApp.Workspace().getUnitSystem());
        }
        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
            Logger.getLogger(ReservoirLayerHeightsEditorPanel.class.getName()).log(Level.WARNING, "Error getting elevation units", dataSetIllegalArgumentException);
        }
        return string;
    }
}

