/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ManagerProxy;
import hec.io.Identifier;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.geometry.SaveGeometryDialog$1;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.text.FilenameDocument;

public class SaveGeometryDialog
extends RmaJDialog {
    protected RmaJTextField _nameFld;
    protected JLabel _networkLabel;
    protected RmaJComboBox<Identifier> _networkCombo;
    protected RmaJDescriptionField _descFld;
    protected ButtonCmdPanel _cmdPanel;
    protected boolean _canceled = false;
    private String _mgrClass;

    public SaveGeometryDialog(Dialog dialog, String string, String string2) {
        super(dialog, string, true);
        this._mgrClass = string2;
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel jLabel = WqI18n.a("Geo.NewGeoDlg.Label.Name").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this._nameFld = new RmaJTextField(3);
        this._nameFld.setEmptyOk(false);
        this._nameFld.setDocument((Document)new FilenameDocument());
        jLabel.setLabelFor((Component)this._nameFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._nameFld, gridBagConstraints);
        jLabel = WqI18n.a("Geo.NewGeoDlg.Label.Desc").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this._descFld = new RmaJDescriptionField("", 20);
        jLabel.setLabelFor((Component)this._descFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._descFld, gridBagConstraints);
        this._networkLabel = WqI18n.a("Geo.NewGeoDlg.Label.Network").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._networkLabel, gridBagConstraints);
        this._networkCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
        this._networkLabel.setLabelFor((Component)this._networkCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._networkCombo, gridBagConstraints);
        this.addAccessoryPanel();
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this.fillForm();
        this.pack();
        SaveGeometryDialog saveGeometryDialog = this;
        saveGeometryDialog.setLocationRelativeTo(saveGeometryDialog.getParent());
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    protected void addAccessoryPanel() {
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new SaveGeometryDialog$1(this));
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void saveAndCloseDialog() {
        String string = this._nameFld.getText().trim();
        if (string.length() == 0) {
            string = WqI18n.a("Geo.NewGeoDlg.Msg.EnterName").getText();
            String string2 = WqI18n.a("Geo.NewGeoDlg.Msg.EnterName.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this), string, string2, 1);
            return;
        }
        if (!this.isUniqueAltName(string)) {
            string = WqI18n.a("Geo.NewGeoDlg.Msg.NotUniqueName").format((Object)string);
            String string3 = WqI18n.a("Geo.NewGeoDlg.Msg.NotUniqueName.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this), string, string3, 1);
            return;
        }
        if (this._networkCombo.getSelectedIndex() == -1) {
            string = WqI18n.a("Geo.NewGeoDlg.Msg.SelectNetwork").getText();
            String string4 = WqI18n.a("Geo.NewGeoDlg.Msg.SelectNetwork.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this), string, string4, 1);
            return;
        }
        if (!this.additionalValidation()) {
            return;
        }
        this.setVisible(false);
        this._canceled = false;
    }

    protected boolean additionalValidation() {
        return true;
    }

    protected boolean isUniqueAltName(String string) {
        Vector vector = ClientApp.Workspace().getManagerIDList("rss", this._mgrClass);
        for (int i = 0; i < vector.size(); ++i) {
            Identifier identifier = (Identifier)vector.get(i);
            if (identifier == null || !identifier.getName().equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    public void fillForm() {
        RmaListModel rmaListModel = (RmaListModel)this._networkCombo.getModel();
        rmaListModel.clear();
        Object object = ClientApp.Workspace();
        if (this._mgrClass != null) {
            object = object.getManagerIDList(ClientApp.app().getAppType(), RssSystem.class.getName());
            rmaListModel.addAll((Collection)object);
        }
        this._networkCombo.setSelectedIndex(-1);
    }

    public void setSelectedNetwork(Identifier identifier) {
        this._networkCombo.setSelectedItem((Object)identifier);
        this._networkCombo.setEnabled(false);
    }

    public void setDescription(String string) {
        this._descFld.setText(string);
    }

    public String getManagerName() {
        return this._nameFld.getText().trim();
    }

    public String getManagerDesc() {
        return this._descFld.getText();
    }

    public RssSystem getSelectedNetwork() {
        Identifier identifier = (Identifier)this._networkCombo.getSelectedItem();
        identifier = ClientApp.Workspace().getManagerProxy("rss", identifier);
        return (RssSystem)identifier.loadManager(null, null);
    }

    public void setGeometry(WqGeometry wqGeometry) {
        if (wqGeometry != null) {
            this._nameFld.setText(wqGeometry.getName());
            this._descFld.setText(wqGeometry.getDescription());
            int n = wqGeometry.getNetworkId();
            ManagerProxy managerProxy = ClientApp.Workspace().getManagerProxy("rss", RssSystem.class.getName(), n);
            if (managerProxy != null) {
                this._networkCombo.setSelectedItem((Object)managerProxy.getId());
                return;
            }
            this._networkCombo.setSelectedIndex(-1);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            EventQueue.invokeLater(() -> this._nameFld.requestFocusInWindow());
        }
        super.setVisible(bl);
    }
}

