/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry.actions;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ManagerProxy;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class DeleteGeoAction
extends AbstractAction {
    private GeometryEditor _editor;

    public DeleteGeoAction(GeometryEditor geometryEditor) {
        this._editor = geometryEditor;
        WqI18n.a("Geo.Editor.MenuItem.Delete").configureAction((Action)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.deleteGeometryAction();
    }

    public void deleteGeometryAction() {
        String string;
        Object object = this._editor.getSelectedGeometry();
        if (object == null) {
            return;
        }
        String string2 = WqI18n.a("Geo.NewGeoDlg.Msg.DeleteGeo").format((Object)object.getName());
        int n = JOptionPane.showConfirmDialog((Component)((Object)this._editor), string2, string = WqI18n.a("Geo.NewGeoDlg.Msg.DeleteGeo.Title").format((Object)object.getName()), 0);
        if (n == 0) {
            ManagerProxy managerProxy = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
            if (this.deleteGeometry((WqGeometry)((Object)object))) {
                object = new ManagerProxyWrapper(managerProxy);
                this._editor.geometryDeleted((ManagerProxyWrapper)((Object)object));
                object = (WaterQualityMode)ClientApp.frame().getCurrentMode();
                ((WaterQualityMode)object).geometryDeleted(managerProxy);
            }
        }
    }

    public boolean deleteGeometry(WqGeometry wqGeometry) {
        boolean bl = ClientApp.Workspace().deleteManager("rss", wqGeometry.getIdentifier(), true);
        return bl;
    }
}

