/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry.actions;

import com.vividsolutions.jts.geom.Geometry;
import hec.clientapp.model.StreamAlignment;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.model.StreamElement;
import hec.model.StreamSegment;
import hec.rss.model.Element;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.geometry.MetStationsPanel;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.metstation.MetStation;
import hec.wqengineimpl.metstation.WQMetStation;
import hec.wqengineimpl.metstation.WQMetStationSet;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class FillNearestElementByMet
extends AbstractAction {
    private MetStationsPanel _panel;
    private StreamAlignment _streamAlignment;

    public FillNearestElementByMet(MetStationsPanel metStationsPanel) {
        this._panel = metStationsPanel;
        WqI18n.a("Geo.MetStation.Button.FillNearest").configureAction((Action)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fillNearestElementWithMetAction();
    }

    public void fillNearestElementWithMetAction() {
        List<SubDomain> list = this._panel.getSubdomainElements();
        WQMetStationSet wQMetStationSet = this._panel.getSelectedMetStationSet();
        List list2 = wQMetStationSet.getActiveStations();
        Object object = this._panel.getGeometry();
        int n = object.getNetworkId();
        object = object.getProxyList().getManagerProxy(RssSystem.class.getName(), n);
        RssSystem rssSystem = null;
        if (object != null) {
            rssSystem = (RssSystem)object.loadManager(null, null);
        }
        if (rssSystem == null) {
            return;
        }
        if (wQMetStationSet != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                wQMetStationSet = list.get(i);
                int n2 = wQMetStationSet.getElementId();
                object = rssSystem.getElement(n2);
                object = this.findNearestMetStation((Element)object, (List<MetStation>)list2);
                this._panel.setMetStationFor((SubDomain)wQMetStationSet, (MetStation)object);
            }
        }
        this._panel.setModified(true);
    }

    public MetStation findNearestMetStation(Element element, List<MetStation> list) {
        Object object;
        block9: {
            MetStation metStation;
            block8: {
                block7: {
                    object = null;
                    if (!(element instanceof ReachElement)) break block7;
                    metStation = this.findNearestMetStation((ReachElement)element, list);
                    break block8;
                }
                if (!(element instanceof ReservoirElement)) break block9;
                element = (ReservoirElement)element;
                object = ((ReservoirElement)element).getStreamSegmentVector();
                double d = Double.MAX_VALUE;
                if (object == null || ((Vector)object).isEmpty()) {
                    metStation = null;
                } else {
                    double[] dArray = new double[1];
                    StreamSegment streamSegment = null;
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        StreamSegment streamSegment2 = (StreamSegment)((Vector)object).get(i);
                        if (streamSegment2.stream == null) {
                            StreamElement streamElement;
                            streamSegment2.stream = streamElement = element.getSystem().getAlignment().findReach(streamSegment2.streamIndex);
                        }
                        if (streamSegment2.stream == null) continue;
                        streamSegment2 = streamSegment2.stream.getLineSegment(streamSegment2.downstreamCoord, streamSegment2.upstreamCoord);
                        streamSegment2 = FillNearestElementByMet.a((WorldLine)streamSegment2, list, dArray);
                        if ((d = Math.min(d, dArray[0])) != dArray[0]) continue;
                        streamSegment = streamSegment2;
                    }
                    metStation = streamSegment;
                }
            }
            object = metStation;
        }
        return object;
    }

    private static MetStation a(WorldLine worldLine, List<MetStation> list, double[] dArray) {
        double d = Double.MAX_VALUE;
        WorldPt worldPt = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        WQMetStation wQMetStation = null;
        for (int i = 0; i < list.size(); ++i) {
            WQMetStation wQMetStation2 = (WQMetStation)list.get(i);
            Geometry geometry = wQMetStation2.getGeometry();
            geometry = geometry.getCentroid();
            worldPt.init(geometry.getX(), geometry.getY());
            double d2 = worldLine.getNearestLocation(worldPt, worldPt2);
            d = Math.min(d, d2);
            if (d != d2) continue;
            wQMetStation = wQMetStation2;
        }
        dArray[0] = d;
        return wQMetStation;
    }

    private MetStation findNearestMetStation(ReachElement reachElement, List<MetStation> list) {
        double[] dArray = new double[1];
        WorldLine worldLine = reachElement.getLine();
        if ((worldLine == null || worldLine.pts.isEmpty()) && (worldLine = this.getReachLine(reachElement)) == null) {
            return null;
        }
        reachElement = FillNearestElementByMet.a(worldLine, list, dArray);
        return reachElement;
    }

    private WorldLine getReachLine(ReachElement tSLocation) {
        RssNode rssNode = tSLocation.getUpstreamNode();
        tSLocation = tSLocation.getDownstreamNode();
        double d = rssNode.getStreamCoord();
        double d2 = tSLocation.getStreamCoord();
        tSLocation = rssNode.getStream();
        tSLocation = tSLocation.getLineSegment(d2, d);
        return tSLocation;
    }
}

