/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry.actions;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.io.Identifier;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.geometry.NewGeometryDialog;
import hec.rss.wq.client.geometry.SaveGeometryDialog;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WQProgress;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.ui.ProgressListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.exception.ExceptionUtils;
import rma.util.RMAIO;

public class NewGeoAction
extends AbstractAction {
    private GeometryEditor _editor;

    public NewGeoAction(GeometryEditor geometryEditor) {
        this._editor = geometryEditor;
        WqI18n.a("Geo.Editor.MenuItem.New").configureAction((Action)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.newGeometryAction();
    }

    public WqGeometry newGeometryAction() {
        WqGeometry wqGeometry;
        Object object = WqI18n.a("Geo.NewGeoDlg.Title").getText();
        object = new NewGeometryDialog((Dialog)((Object)this._editor), (String)object, WqGeometry.class.getName());
        ((SaveGeometryDialog)((Object)object)).setVisible(true);
        if (((SaveGeometryDialog)((Object)object)).isCanceled()) {
            return null;
        }
        String string = ((SaveGeometryDialog)((Object)object)).getManagerName();
        Object object2 = ((SaveGeometryDialog)((Object)object)).getManagerDesc();
        this._editor.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Object object3;
            WQProgress wQProgress = new WQProgress();
            Object object4 = RMAIO.userNameToFileName((String)string);
            File file = new File(ClientApp.Workspace().getWorkspacePath());
            file = new File(file, "rss");
            String string2 = "wq/geometry";
            String string3 = ".geometry";
            file = new File(file, string2);
            file = new File(file, object4 + (String)(string3.length() > 0 && string3.charAt(0) == '.' ? string3 : "." + string3));
            file = new Identifier(file.getAbsolutePath());
            file.setName(string);
            file.setClassName(WqGeometry.class.getName());
            file.setDescription((String)object2);
            object4 = (WqGeometry)ClientApp.Workspace().newManager("rss", WqGeometry.class.getName());
            if (object4 == null) {
                object3 = null;
            } else {
                object4.setIdentifier((Identifier)file);
                object4.setName(string);
                object4.setDescription((String)object2);
                string = ClientApp.Workspace();
                if (string == null) {
                    object3 = null;
                } else {
                    boolean bl = ClientApp.Workspace().saveManagerAs("rss", (Manager)object4, (Identifier)file);
                    if (!bl) {
                        String string4 = WqI18n.a("WqModule.Msg.FailedCreateMgr").format((Object)WqI18n.a("Geometry.Type").getText());
                        object2 = WqI18n.a("WqModule.Msg.FailedCreateMgr.Title").getText();
                        ClientApp.app().postError(string4, (String)object2);
                        object3 = null;
                    } else {
                        object3 = wqGeometry = object4;
                    }
                }
            }
            if (object3 != null) {
                try {
                    object2 = ((SaveGeometryDialog)((Object)object)).getSelectedNetwork();
                    int n = ((NewGeometryDialog)((Object)object)).getCrossSectionManagerId();
                    object = ((NewGeometryDialog)((Object)object)).getRasSteadyFlowFile();
                    if (object != null) {
                        wqGeometry.setSteadyFlowPath(new File((String)object).toPath());
                    }
                    wqGeometry.setNetworkId(object2.getIndex());
                    wqGeometry.setCrossSectionManagerId(n);
                    wqGeometry.importSystem((RssSystem)object2, wQProgress);
                }
                catch (Exception exception) {
                    object4 = WqI18n.a("Geo.ImportRasSteady.Msg.ImportException").format((Object)ExceptionUtils.getStackTrace((Throwable)exception));
                    wQProgress.progress((String)object4, ProgressListener.MessageType.ERROR);
                }
                if (wQProgress.a()) {
                    object2 = wQProgress.b();
                    String string5 = object2.stream().collect(Collectors.joining(System.lineSeparator()));
                    object = WqI18n.a("Geo.NewGeoDlg.Msg.ImportFailed.Title").getText();
                    JOptionPane.showMessageDialog((Component)((Object)this._editor), string5, (String)object, 0);
                    boolean bl = ClientApp.Workspace().deleteManager("rss", wqGeometry.getIdentifier(), true);
                    return null;
                }
                if (wQProgress.c()) {
                    object2 = wQProgress.d();
                    String string6 = object2.stream().collect(Collectors.joining(System.lineSeparator()));
                    object = WqI18n.a("Geo.NewGeoDlg.Msg.ImportFailed.Title").getText();
                    JOptionPane.showMessageDialog((Component)((Object)this._editor), string6, (String)object, 2);
                }
                object2 = ClientApp.Workspace().getManagerProxy("rss", wqGeometry.getIdentifier());
                this._editor.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object2), true);
                this._editor.selectDefaultCrossSections();
                ClientApp.Workspace().saveManager("rss", (Manager)wqGeometry);
                ClientApp.Workspace().saveWorkspace();
            }
            NewGeoAction.a(wqGeometry);
        }
        finally {
            this._editor.setCursor(Cursor.getDefaultCursor());
        }
        return wqGeometry;
    }

    public static void a(WqGeometry wqGeometry) {
        WaterQualityMode waterQualityMode = (WaterQualityMode)ClientApp.frame().getCurrentModule();
        waterQualityMode.setGeometry(wqGeometry);
    }

    private List<String> getExistingGeometryNames() {
        Vector vector = ClientApp.Workspace().getManagerProxyList("rss", WqGeometry.class.getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            ManagerProxy managerProxy = (ManagerProxy)vector.get(i);
            if (managerProxy == null) continue;
            arrayList.add(managerProxy.getName());
        }
        return arrayList;
    }
}

