/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.geometry.actions;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.gui.NameDialog;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;

public class RenameGeoAction
extends AbstractAction {
    private GeometryEditor _editor;

    public RenameGeoAction(GeometryEditor geometryEditor) {
        this._editor = geometryEditor;
        WqI18n.a("Geo.Editor.MenuItem.Rename").configureAction((Action)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.renameGeometryAction();
    }

    protected void renameGeometryAction() {
        WqGeometry wqGeometry = this._editor.getSelectedGeometry();
        String string = WqI18n.a("Geo.RenameGeoDlg.Title").getText();
        string = new NameDialog((Dialog)((Object)this._editor), string, true);
        string.setName(wqGeometry.getName());
        string.setDescription(wqGeometry.getDescription());
        Vector vector = ClientApp.Workspace().getManagerProxyList("rss", WqGeometry.class.getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            ManagerProxy managerProxy = (ManagerProxy)vector.get(i);
            if (managerProxy == null) continue;
            arrayList.add(managerProxy.getName());
        }
        string.setExistingNames(arrayList);
        string.setVisible(true);
        if (string.isCanceled()) {
            return;
        }
        this.renameGeometry(wqGeometry, string.getName(), string.getDescription());
    }

    private void renameGeometry(WqGeometry object, String string, String string2) {
        string = ClientApp.Workspace().getManagerIdentifier("rss", WqGeometry.class.getName(), string, ".geometry");
        Object object2 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        Identifier identifier = null;
        try {
            identifier = object2.newFile(UserId.getUserId(), (Identifier)string);
        }
        catch (RemoteException remoteException) {
            object2 = remoteException;
            remoteException.printStackTrace();
        }
        if (identifier == null) {
            object2 = WqI18n.a("Geo.RenameGeoDlg.Msg.ExistingFile").format((Object)string.getPath());
            object = WqI18n.a("Geo.RenameGeoDlg.Msg.ExistingFile.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this._editor), object2, (String)object, 2);
            return;
        }
        if (!ClientApp.Workspace().renameManager("rss", (Manager)object, identifier)) {
            object2 = WqI18n.a("Geo.RenameGeoDlg.RenameFailed").format((Object)object.getName());
            object = WqI18n.a("Geo.RenameGeoDlg.RenameFailed.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this._editor), object2, (String)object, 2);
            return;
        }
        object.setDescription(string2);
        this._editor.getSelectorPanel().setDescription(string2);
        this._editor.getSelectorPanel().getComboBox().repaint();
        object2 = (WaterQualityMode)ClientApp.frame().getCurrentMode();
        object2.refreshGeometryField();
    }
}

