/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.SelectorPanelEditor;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel;
import hec.rss.wq.client.initialcondition.JunctionsInitialConditionsTabPanel;
import hec.rss.wq.client.initialcondition.ReservoirInitialConditionsTabPanel;
import hec.rss.wq.client.initialcondition.ReservoirOutflowInitialConditionsTabPanel;
import hec.rss.wq.client.initialcondition.actions.DeleteInitialConditionAction;
import hec.rss.wq.client.initialcondition.actions.NewInitialCondionsSetAction;
import hec.rss.wq.client.initialcondition.actions.RenameInitialConditionSetAction;
import hec.rss.wq.client.initialcondition.actions.SaveInitialConditionSetAsAction;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.InterpolationType;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;

public class InitialConditionsEditor
extends SelectorPanelEditor {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private JTextField _geometryNameTxt;
    private JRadioButton _reservoirLinearRadio;
    private JRadioButton _reservoirLaplaceRadio;
    private JRadioButton _riverLaplaceRadio;
    private JRadioButton _riverOneWaySimulationRadio;
    private JTextField _wqConstituentNameText;
    private JPanel _riverInterpPanel;
    private JPanel _resInterpPanel;
    private InitialConditionsTabPanel _reservoirPanel;
    private InitialConditionsTabPanel _junctionsPanel;
    private InitialConditionsTabPanel _reservoirOutflowPanel;
    private JMenu _wqSetMenu;
    private JMenuItem _menuItemNew;
    private JMenuItem _menuItemSaveAs;
    private JMenuItem _menuItemDelete;
    private ManagerProxyListContainer _wksp;
    private String _title;
    private InitialConditionSetManager _icMgr;
    private JPanel _messagesPanel;
    private RmaJTextField _msgText;

    public InitialConditionsEditor(Frame frame) {
        super(frame, false);
        this.createControls();
        this.addListeners();
        this.setMinimumSize(new Dimension(700, 700));
    }

    private void createControls() {
        this._title = WqI18n.a("IC.InitialConditionsEditor.Title").getText();
        InitialConditionsEditor initialConditionsEditor = this;
        initialConditionsEditor.setTitle(initialConditionsEditor._title);
        this.buildMenubar();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.getSelectorPanel().add((Component)jPanel, (Object)gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = WqI18n.a("IC.InitialConditionsEditor.Label.ConstituentSet").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this._wqConstituentNameText = new RmaJTextField();
        this._wqConstituentNameText.setEditable(false);
        jLabel.setLabelFor(this._wqConstituentNameText);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel2.add((Component)this._wqConstituentNameText, gridBagConstraints);
        jLabel = WqI18n.a("IC.InitialConditionsEditor.Label.Geometry").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this._geometryNameTxt = new RmaJTextField();
        this._geometryNameTxt.setEditable(false);
        jLabel.setLabelFor(this._geometryNameTxt);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel2.add((Component)this._geometryNameTxt, gridBagConstraints);
        this.createRadioPanel(jPanel);
        this._reservoirPanel = new ReservoirInitialConditionsTabPanel();
        this._junctionsPanel = new JunctionsInitialConditionsTabPanel();
        this._reservoirOutflowPanel = new ReservoirOutflowInitialConditionsTabPanel();
        InitialConditionsEditor initialConditionsEditor2 = this;
        initialConditionsEditor2.addPanel(initialConditionsEditor2._reservoirPanel);
        InitialConditionsEditor initialConditionsEditor3 = this;
        initialConditionsEditor3.addPanel(initialConditionsEditor3._junctionsPanel);
        InitialConditionsEditor initialConditionsEditor4 = this;
        initialConditionsEditor4.addPanel(initialConditionsEditor4._reservoirOutflowPanel);
        this._messagesPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getBottomPanel().add((Component)this._messagesPanel, gridBagConstraints);
        this._msgText = new RmaJTextField();
        this._msgText.setEditable(false);
        this._msgText.setBorder(null);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._messagesPanel.add((Component)this._msgText, gridBagConstraints);
        this._messagesPanel.setVisible(false);
    }

    private void createRadioPanel(JPanel serializable) {
        int n;
        this._resInterpPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        Object object = WqI18n.a("IC.InitialConditionsEditor.Title.ResInterpType").getText();
        this._resInterpPanel.setBorder(BorderFactory.createTitledBorder((String)object));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._resInterpPanel, gridBagConstraints);
        this._reservoirLinearRadio = WqI18n.a("IC.InitialConditionsEditor.Radio.ResLinearInterp").createJRadioButton();
        this._reservoirLinearRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._resInterpPanel.add((Component)this._reservoirLinearRadio, gridBagConstraints);
        this._reservoirLaplaceRadio = WqI18n.a("IC.InitialConditionsEditor.Radio.ResLaplace").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._riverInterpPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        object = WqI18n.a("IC.InitialConditionsEditor.Title.RiverInterpType").getText();
        this._riverInterpPanel.setBorder(BorderFactory.createTitledBorder((String)object));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._riverInterpPanel, gridBagConstraints);
        this._riverLaplaceRadio = WqI18n.a("IC.InitialConditionsEditor.Radio.RiverLaplace").createJRadioButton();
        this._riverLaplaceRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._riverOneWaySimulationRadio = WqI18n.a("IC.InitialConditionsEditor.Radio.OneWayFlow").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._riverInterpPanel.add((Component)this._riverOneWaySimulationRadio, gridBagConstraints);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._reservoirLinearRadio);
        ((ButtonGroup)serializable).add(this._reservoirLaplaceRadio);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._riverLaplaceRadio);
        ((ButtonGroup)serializable).add(this._riverOneWaySimulationRadio);
        serializable = this._riverInterpPanel.getPreferredSize();
        object = this._resInterpPanel.getPreferredSize();
        ((Dimension)serializable).width = n = Math.max(((Dimension)serializable).width, ((Dimension)object).width);
        ((Dimension)object).width = n;
        this._riverInterpPanel.setPreferredSize((Dimension)serializable);
        this._resInterpPanel.setPreferredSize((Dimension)object);
        this._riverOneWaySimulationRadio.setSelected(true);
        this._reservoirLinearRadio.setSelected(true);
    }

    private void buildMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        this._wqSetMenu = WqI18n.a("IC.InitialConditionsEditor.Menu.InitialConditions").createMenu();
        this._menuItemNew = WqI18n.a("Dispersion.Editor.Menu.New").createMenuItem();
        this._wqSetMenu.add(this._menuItemNew);
        this._menuItemSaveAs = WqI18n.a("Dispersion.Editor.Menu.SaveAs").createMenuItem();
        this._wqSetMenu.add(this._menuItemSaveAs);
        this._menuItemDelete = WqI18n.a("Dispersion.Editor.Menu.Delete").createMenuItem();
        this._wqSetMenu.add(this._menuItemDelete);
        jMenuBar.add(this._wqSetMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void addListeners() {
        this._menuItemNew.addActionListener(actionEvent -> this.newInitialConditionsSetAction());
        this._menuItemSaveAs.addActionListener(actionEvent -> this.saveInitialConditionsSetAsAction());
        this._menuItemDelete.addActionListener(actionEvent -> this.deleteInitialConditionsSetAction());
    }

    private void deleteInitialConditionsSetAction() {
        ManagerProxyWrapper managerProxyWrapper = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (managerProxyWrapper == null) {
            return;
        }
        ManagerProxy managerProxy = managerProxyWrapper.getManagerProxy();
        managerProxy = managerProxy.getId();
        DeleteInitialConditionAction deleteInitialConditionAction = new DeleteInitialConditionAction((Dialog)((Object)this));
        if ((managerProxy = deleteInitialConditionAction.a((Identifier)managerProxy)) != null) {
            this.setModified(false);
            this.getSelectorPanel().getComboBox().removeItem((Object)managerProxyWrapper);
            if (this.getSelectorPanel().getSelectedItem() == null && !this.getSelectorPanel().getSelectorItems().isEmpty()) {
                this.getSelectorPanel().setSelectedIndex(0);
                return;
            }
            this.clearForm();
            this.setDialogEnabled(false);
            this.setModified(false);
        }
    }

    private void renameInitialConditionsSetAction() {
        Object object = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object == null) {
            return;
        }
        object = object.getManagerProxy();
        object = (InitialConditionSetManager)object.loadManager(null, null);
        RenameInitialConditionSetAction renameInitialConditionSetAction = new RenameInitialConditionSetAction((Dialog)((Object)this));
        if ((object = renameInitialConditionSetAction.a((InitialConditionSetManager)object, this.getSelectorPanel().getDescription())) != null) {
            this.getSelectorPanel().getComboBox().repaint();
            this.getSelectorPanel().setDescription(((JsonManager)((Object)object)).getDescription());
        }
    }

    private void saveInitialConditionsSetAsAction() {
        SaveInitialConditionSetAsAction saveInitialConditionSetAsAction;
        Object object;
        Object object2 = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object2 == null) {
            return;
        }
        object2 = object2.getManagerProxy();
        object2 = (InitialConditionSetManager)object2.loadManager(null, null);
        boolean bl = false;
        if (this.isModified() && object2 != null) {
            String string = WqI18n.a("IC.Save.Msg").format(object2);
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, (String)(object = WqI18n.a("IC.Save.Msg.Title").getText()), 1);
            if (n == 0) {
                if (!this.saveForm()) {
                    return;
                }
                bl = true;
            } else if (2 == n) {
                return;
            }
        }
        if ((object = (saveInitialConditionSetAsAction = new SaveInitialConditionSetAsAction((Dialog)((Object)this))).a((InitialConditionSetManager)object2, this.getSelectorPanel().getDescription())) != null) {
            saveInitialConditionSetAsAction = this._icMgr.getIdentifier();
            object2 = saveInitialConditionSetAsAction.getPath();
            object2 = ((String)object2).concat(".temp");
            saveInitialConditionSetAsAction = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            object2 = new Identifier((String)object2);
            Identifier identifier = null;
            if (!bl) {
                if (this._icMgr.isModified()) {
                    this._wksp.saveManager("rss", (Manager)this._icMgr);
                }
                if (!super.saveForm()) {
                    return;
                }
            }
            try {
                identifier = saveInitialConditionSetAsAction.newFile(UserId.getUserId(), (Identifier)object2);
                if (identifier == null) {
                    identifier = saveInitialConditionSetAsAction.openFile(UserId.getUserId(), (Identifier)object2);
                }
            }
            catch (RemoteException remoteException) {
                object2 = remoteException;
                remoteException.printStackTrace();
            }
            if (identifier != null) {
                this._icMgr.writeFile(identifier);
                if (!bl) {
                    this._icMgr.readFile(this._icMgr.getIdentifier());
                }
                object2 = ((JsonManager)((Object)object)).getName();
                String string = ((JsonManager)((Object)object)).getDescription();
                int n = ((JsonManager)((Object)object)).getIndex();
                ((JsonManager)((Object)object)).readFile(identifier);
                ((InitialConditionSetManager)object).setName((String)object2);
                ((InitialConditionSetManager)object).setDescription(string);
                object.setIndex(n);
                try {
                    saveInitialConditionSetAsAction.deleteFile(identifier.getPath());
                }
                catch (RemoteException remoteException) {
                    System.out.println("saveInitialConditionsSetAsAction: exception deleting file " + identifier.getPath() + " error:" + String.valueOf(remoteException));
                }
                this.setModified(false);
                object2 = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
                this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object2), true);
            }
        }
    }

    private void newInitialConditionsSetAction() {
        Object object = new NewInitialCondionsSetAction((Dialog)((Object)this));
        if ((object = ((NewInitialCondionsSetAction)object).h()) != null) {
            object = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
            this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object), true);
        }
    }

    public void fillForm(NamedType namedType) {
        super.fillForm(namedType);
        this.setErrorMessage(null);
        if (namedType instanceof ManagerProxyWrapper) {
            RssSystem rssSystem;
            namedType = (ManagerProxyWrapper)namedType;
            namedType = namedType.getManagerProxy();
            this._icMgr = (InitialConditionSetManager)namedType.loadManager(null, null);
            InitialConditionSet initialConditionSet = this._icMgr.getSet();
            int n = this._icMgr.getGeometryId();
            Object object = this._icMgr.getProxyList().getManagerProxy("rss", WqGeometry.class.getName(), n);
            if (object != null) {
                this._geometryNameTxt.setText(object.getName());
                object = (WqGeometry)object.loadManager(null, null);
                if (object != null && (rssSystem = ((WqGeometry)((Object)object)).getNetwork()) == null) {
                    object = WqI18n.a("IC.InitialConditionsEditor.Msg.FailedToFindNetwork").format((Object)((JsonManager)((Object)object)).getName());
                    this.setErrorMessage((String)object);
                }
            } else {
                this._geometryNameTxt.setText("");
                object = WqI18n.a("IC.InitialConditionsEditor.Msg.FailedToFindGeometry").format((Object)((JsonManager)this._icMgr).getName());
                this.setErrorMessage((String)object);
            }
            int n2 = this._icMgr.getConstituentSetId();
            ManagerProxy managerProxy = this._icMgr.getProxyList().getManagerProxy("rss", ConstituentSetManager.class.getName(), n2);
            if (managerProxy != null) {
                this._wqConstituentNameText.setText(managerProxy.getName());
            } else {
                this._wqConstituentNameText.setText("");
            }
            if (initialConditionSet != null) {
                managerProxy = initialConditionSet.getReachInterpolationType();
                rssSystem = initialConditionSet.getReservoirInterpolationType();
                if (managerProxy == InterpolationType.ONEWAYFORWARD) {
                    this._riverOneWaySimulationRadio.doClick(0);
                }
                if (rssSystem == InterpolationType.LINEAR) {
                    this._reservoirLinearRadio.doClick(0);
                }
            }
            InitialConditionsEditor initialConditionsEditor = this;
            initialConditionsEditor.setDialogEnabled(initialConditionsEditor._icMgr != null);
            this.setModified(false);
        }
    }

    public boolean saveForm(NamedType namedType) {
        InitialConditionSetManager initialConditionSetManager = this._icMgr;
        if (namedType instanceof InitialConditionSetManager) {
            initialConditionSetManager = (InitialConditionSetManager)namedType;
        }
        if (initialConditionSetManager == null) {
            return true;
        }
        boolean bl = super.saveForm(namedType);
        if (bl) {
            initialConditionSetManager = this._icMgr.getSet();
            this.setSelectedTypes((InitialConditionSet)initialConditionSetManager);
            this.setModified(false);
            this._icMgr.setModified(true);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSelectedTypes(InitialConditionSet initialConditionSet) {
        if (initialConditionSet instanceof WQInitialConditionSet) {
            initialConditionSet = (WQInitialConditionSet)initialConditionSet;
            if (this._riverOneWaySimulationRadio.isSelected()) {
                initialConditionSet.setReachInterpolationType(InterpolationType.ONEWAYFORWARD);
            } else {
                initialConditionSet.setReachInterpolationType(InterpolationType.LAPLACE);
            }
            if (this._reservoirLaplaceRadio.isSelected()) {
                initialConditionSet.setReservoirInterpolationType(InterpolationType.LAPLACE);
                return;
            }
            initialConditionSet.setReservoirInterpolationType(InterpolationType.LINEAR);
            return;
        }
        if (!(initialConditionSet instanceof WQInitialConditionSet2)) return;
        initialConditionSet = (WQInitialConditionSet2)initialConditionSet;
        if (this._riverOneWaySimulationRadio.isSelected()) {
            initialConditionSet.setReachInterpolationType(InterpolationType.ONEWAYFORWARD);
        } else {
            initialConditionSet.setReachInterpolationType(InterpolationType.LAPLACE);
        }
        if (this._reservoirLaplaceRadio.isSelected()) {
            initialConditionSet.setReservoirInterpolationType(InterpolationType.LAPLACE);
            return;
        }
        initialConditionSet.setReservoirInterpolationType(InterpolationType.LINEAR);
    }

    public void fillForm(ManagerProxyListContainer object) {
        this._wksp = object;
        this._wqSetMenu.setVisible(this._wksp instanceof ClientWorkspace);
        object = object.getManagerProxyList("rss", InitialConditionSetManager.class.getName());
        List list = object.stream().map(managerProxy -> new ManagerProxyWrapper((ManagerProxy)managerProxy)).collect(Collectors.toList());
        this.getSelectorPanel().setSelectionList(list);
        if (object.isEmpty()) {
            this.getSelectorPanel().setSelectedIndex(-1);
            this.setDialogEnabled(false);
            return;
        }
        this.getSelectorPanel().setSelectedIndex(0);
    }

    private void setDialogEnabled(boolean bl) {
        this._menuItemDelete.setEnabled(bl);
        this._menuItemSaveAs.setEnabled(bl);
        this._reservoirPanel.setEnabled(bl);
        this._reservoirOutflowPanel.setEnabled(bl);
        this._junctionsPanel.setEnabled(bl);
        this._resInterpPanel.setEnabled(bl);
        this._riverInterpPanel.setEnabled(bl);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        String string = this._title;
        if (bl) {
            string = string.concat("*");
        }
        this.setTitle(string);
    }

    public void setSelectedInitialConditionsSetMgr(InitialConditionSetManager object) {
        object = object.getProxyList().getManagerProxy(object.getIdentifier());
        object = new ManagerProxyWrapper((ManagerProxy)object);
        this.selectorPanel.setSelectedItem(object);
    }

    public void setErrorMessage(String string) {
        this._messagesPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atWarning()).log(string);
            this._msgText.setForeground(Color.RED);
            return;
        }
        this._msgText.setText("");
    }

    public void setMessage(String string) {
        this._messagesPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atInfo()).log(string);
            this._msgText.setForeground(UIManager.getColor("TextField.foreground"));
            return;
        }
        this._msgText.setText("");
    }
}

