/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.model.SimulationPeriod;
import hec.gui.AbstractEditorPanel;
import hec.gui.SelectorPanel;
import hec.model.RunTimeWindow;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSimulationRun;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.WqUiUtils;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel$1;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel$2;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel$3;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel$HeaderPanelVisibleRule;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel$IconTreeCellRenderer;
import hec.rss.wq.client.initialcondition.JunctionDataSource;
import hec.rss.wq.client.initialcondition.ReservoirTreeNode;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.PreventRootNodeFromCollapseListener;
import hec.rss.wq.ui.TreeView;
import hec.rss.wq.ui.View$SelectionListener;
import hec.rss.wq.ui.ViewDisplayHeader$VisibleRule;
import hec.rss.wq.ui.ViewPanel;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqengineimpl.WQConstituentSet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import rma.services.units.UnitsComponent;
import rma.swing.RmaJTable;

public abstract class InitialConditionsTabPanel
extends AbstractEditorPanel
implements UnitsComponent {
    private ViewPanel _viewPanel;
    protected final SelectorPanel _treeSelectorPanel;
    private TreeView _treeView;
    protected boolean _updatingTreeSelection;

    public InitialConditionsTabPanel() {
        super((LayoutManager)new GridBagLayout());
        this.initComponents();
        JPanel jPanel = new JPanel();
        this._treeSelectorPanel = new SelectorPanel();
        this._treeSelectorPanel.setDescriptionPanelVisible(false);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this._treeSelectorPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._viewPanel.setDisplayHeader(new InitialConditionsTabPanel$1(this, jPanel));
        this.addListeners();
    }

    protected ViewDisplayHeader$VisibleRule getHeaderVisibleRule() {
        return new InitialConditionsTabPanel$HeaderPanelVisibleRule();
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this._viewPanel = new ViewPanel();
        TreeView treeView = new TreeView(new DefaultTreeModel(null));
        treeView.a().addTreeWillExpandListener(new PreventRootNodeFromCollapseListener());
        this._viewPanel.setView(treeView);
        InitialConditionsTabPanel initialConditionsTabPanel = this;
        initialConditionsTabPanel.add(initialConditionsTabPanel._viewPanel, gridBagConstraints);
    }

    protected void addListeners() {
        this._treeSelectorPanel.addItemListener((ItemListener)new InitialConditionsTabPanel$2(this));
    }

    protected boolean updateTreeFromSelection() {
        return true;
    }

    protected void updateTreeWithSelection() {
        int n = this._treeSelectorPanel.getSelectedIndex();
        JTree jTree = this._treeView.a();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getModel().getRoot();
        Object object = (Object[])defaultMutableTreeNode.getChildAt(n);
        object = object.getPath();
        object = new TreePath((Object[])object);
        jTree.setSelectionPath((TreePath)object);
    }

    public void setData(TreeModel treeModel) {
        this._treeView = new TreeView(treeModel);
        this._viewPanel.setView(this._treeView);
        this._treeView.a(new InitialConditionsTabPanel$IconTreeCellRenderer(this));
        this._treeView.addSelectionListener((View$SelectionListener)new InitialConditionsTabPanel$3(this));
        EventQueue.invokeLater(() -> this._treeView.a().setSelectionRow(0));
    }

    protected void updateSelectorPanel(DataSource dataSource) {
        if (dataSource instanceof ReservoirTreeNode) {
            dataSource = (ReservoirTreeNode)dataSource;
            dataSource = ((ReservoirTreeNode)dataSource).getReservoir();
            this._treeSelectorPanel.setSelectedItem((Object)dataSource);
            return;
        }
        if (dataSource instanceof JunctionDataSource) {
            dataSource = (JunctionDataSource)dataSource;
            dataSource = ((JunctionDataSource)dataSource).getJunction();
            this._treeSelectorPanel.setSelectedItem((Object)dataSource);
        }
    }

    public boolean savePanel() {
        this._viewPanel.save();
        return true;
    }

    public void validatePanel() throws IOException {
        this._viewPanel.validateData();
    }

    public TreeView getTreeView() {
        return this._treeView;
    }

    public void clearPanel() {
        this._viewPanel.clearPanel();
    }

    static int a(RmaJTable rmaJTable) {
        return WqUiUtils.a(rmaJTable);
    }

    public void setDisplayScaleFactor(int n, double d) {
    }

    public String getDisplayUnitsString(int n) {
        return "";
    }

    protected void interpolateInitialConditions(RssWQGeometry rssWQGeometry, InitialConditionSet initialConditionSet, WQConstituentSet wQConstituentSet) {
        ArrayList<SubDomainBoundary> arrayList = new ArrayList<BoundaryType>();
        arrayList.add((SubDomainBoundary)BoundaryType.RIVER_INFLOW);
        arrayList.add((SubDomainBoundary)BoundaryType.RIVER_2_RIVER);
        arrayList.add((SubDomainBoundary)BoundaryType.RIVER_2_RESERVOIR);
        arrayList.add((SubDomainBoundary)BoundaryType.RIVER_OUTFLOW);
        arrayList.add((SubDomainBoundary)BoundaryType.RIVER_INFLOW_IN_NETWORK);
        arrayList.add((SubDomainBoundary)BoundaryType.RESERVOIR_2_RIVER);
        arrayList = rssWQGeometry.getBoundariesUnique(arrayList);
        BoundaryConditionSet boundaryConditionSet = InitialConditionsTabPanel.a();
        RunTimeWindow runTimeWindow = InitialConditionsTabPanel.c();
        RssSystem rssSystem = InitialConditionsTabPanel.b();
        rssWQGeometry.interpolateICSet(rssSystem, arrayList, initialConditionSet, wQConstituentSet, boundaryConditionSet, runTimeWindow);
    }

    private static RSimSimulationMode d() {
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        RSimSimulationMode rSimSimulationMode = null;
        if (clientMode instanceof RSimSimulationMode) {
            rSimSimulationMode = (RSimSimulationMode)clientMode;
        }
        return rSimSimulationMode;
    }

    private static SimulationPeriod e() {
        RSimSimulationMode rSimSimulationMode = InitialConditionsTabPanel.d();
        if (rSimSimulationMode != null) {
            return rSimSimulationMode.getSimulation();
        }
        return null;
    }

    private static RssAlt f() {
        RssAlt rssAlt = null;
        RSimSimulationMode rSimSimulationMode = InitialConditionsTabPanel.d();
        if (rSimSimulationMode != null && (rSimSimulationMode = rSimSimulationMode.getActiveRun()) instanceof RssSimulationRun) {
            rssAlt = ((RssSimulationRun)((Object)rSimSimulationMode)).getRssAlt();
        }
        return rssAlt;
    }

    protected static BoundaryConditionSet a() {
        BoundaryConditionSet boundaryConditionSet = null;
        Object object = InitialConditionsTabPanel.e();
        RssAlt rssAlt = InitialConditionsTabPanel.f();
        BoundaryConditionSetManager boundaryConditionSetManager = null;
        if (rssAlt != null && object != null && rssAlt.hasWaterQualityOptions()) {
            object = rssAlt.getWaterQualityOptions();
            boundaryConditionSetManager = object.getBcManager(rssAlt);
        }
        if (boundaryConditionSetManager != null) {
            boundaryConditionSet = boundaryConditionSetManager.getSet();
        }
        return boundaryConditionSet;
    }

    protected static RssSystem b() {
        SimulationPeriod simulationPeriod = InitialConditionsTabPanel.e();
        RssAlt rssAlt = InitialConditionsTabPanel.f();
        RssSystem rssSystem = null;
        if (rssAlt != null && simulationPeriod != null) {
            rssSystem = rssAlt.getSystem();
        }
        return rssSystem;
    }

    protected static RunTimeWindow c() {
        SimulationPeriod simulationPeriod = InitialConditionsTabPanel.e();
        RunTimeWindow runTimeWindow = null;
        if (simulationPeriod != null) {
            runTimeWindow = simulationPeriod.getRunTimeWindow();
        }
        return runTimeWindow;
    }
}

