/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.rss.client.RssSystemGlyph;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.initialcondition.IcSymbolIcon;
import hec.rss.wq.client.initialcondition.JunctionPanel;
import hec.rss.wq.ui.DataSource;
import hec.wqenginecore.InitialConditionSet;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.geometry.WQGeoSubDomainBoundary;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import rma.services.ServiceLookup;

public class JunctionDataSource
extends DefaultMutableTreeNode
implements DataSource {
    private JunctionPanel _panel;
    private WQGeoSubDomainBoundary _junction;
    private InitialConditionSet _wqSet;
    private IcSymbolIcon _icon;
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    private WQConstituentSet _wqConstituentSet;
    private RssWQGeometry _wqGeo;

    public JunctionDataSource(WQGeoSubDomainBoundary wQGeoSubDomainBoundary, InitialConditionSet initialConditionSet, WQConstituentSet wQConstituentSet, RssWQGeometry rssWQGeometry) {
        super(wQGeoSubDomainBoundary);
        this._junction = wQGeoSubDomainBoundary;
        this._wqSet = initialConditionSet;
        this._wqConstituentSet = wQConstituentSet;
        this._wqGeo = rssWQGeometry;
        this._icon = new IcSymbolIcon(3);
    }

    @Override
    public Icon getIcon() {
        return this._icon;
    }

    public WQGeoSubDomainBoundary getJunction() {
        return this._junction;
    }

    @Override
    public String getName() {
        return this._junction.getName();
    }

    @Override
    public JComponent getComponent() {
        if (this._panel == null) {
            this._panel = new JunctionPanel();
            this._panel.fillPanel(this._junction, (WQInitialConditionSet2)this._wqSet, this._wqConstituentSet, this._wqGeo);
        }
        return this._panel;
    }

    @Override
    public void validateData() throws IOException {
        if (this._panel != null) {
            this._panel.validateData();
        }
    }

    @Override
    public void save() throws IOException {
        if (this._panel != null) {
            this._panel.savePanel();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isModified() {
        if (this._panel == null) {
            return false;
        }
        return this._panel.isModified();
    }

    public boolean hasComponent() {
        return this._panel != null;
    }

    public void setDisplayUnitsSystem(int n) {
        if (this._panel != null) {
            ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)((Object)this._panel));
        }
    }

    static {
        RssSystemGlyph.initIcons();
    }
}

