/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.initialcondition.JunctionPanel$1;
import hec.rss.wq.client.initialcondition.JunctionPanel$JunctionTableModel;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.InterpICValue;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.geometry.WQGeoSubDomainBoundary;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RMASort;

public class JunctionPanel
extends RmaJPanel {
    private RmaJTable _junctionTable;
    private JunctionPanel$JunctionTableModel _tableModel;
    private WQInitialConditionSet2 _icSet;
    private WQGeoSubDomainBoundary _junction;

    public JunctionPanel() {
        super((LayoutManager)new GridBagLayout());
        this.initComponents();
    }

    private void initComponents() {
        JunctionPanel junctionPanel = this;
        this._junctionTable = new JunctionPanel$1(junctionPanel, (Component)((Object)junctionPanel));
        this._junctionTable.removePopupMenuRowEditingOptions();
        this._junctionTable.removePopupMenuSumOptions();
        this._junctionTable.setRowHeight(this._junctionTable.getRowHeight() + 5);
        this._junctionTable.setRowHeight(this._junctionTable.getRowHeight() + 5);
        this._tableModel = new JunctionPanel$JunctionTableModel(this);
        this._junctionTable.setModel((TableModel)((Object)this._tableModel));
        this._junctionTable.setDoubleCellEditor(2);
        this._junctionTable.setDoubleCellEditor(1);
        Serializable serializable = UIManager.getFont("ToolTip.font");
        Font font = this._junctionTable.getFont();
        serializable = new Font(serializable.getName(), font.getStyle(), font.getSize());
        this._junctionTable.setFont(serializable);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        JunctionPanel junctionPanel2 = this;
        junctionPanel2.add(junctionPanel2._junctionTable.getScrollPane(), serializable);
    }

    private String applyPrecisionToBoldedValue(Object object) {
        Object object2 = null;
        if (object != null) {
            String string = object.toString().replaceAll("<[^>]*>", "");
            double d = RMAIO.parseDouble((String)string);
            if (RMAConst.isValidValue((double)d)) {
                object2 = new DecimalFormat("#.####");
                object2 = ((NumberFormat)object2).format(d);
            }
            if (object.toString().startsWith("<")) {
                object2 = "<html><b>" + (String)object2 + "</b></html>";
            }
        }
        return object2;
    }

    public void fillPanel(WQGeoSubDomainBoundary wQGeoSubDomainBoundary, WQInitialConditionSet2 wQInitialConditionSet2, WQConstituentSet object, RssWQGeometry object2) {
        this._icSet = wQInitialConditionSet2;
        this._junction = wQGeoSubDomainBoundary;
        wQGeoSubDomainBoundary = object2.buildRef((SubDomainBoundary)wQGeoSubDomainBoundary);
        object = object.getConstituentList();
        object = new ArrayList(object);
        object2 = new ArrayList();
        RMASort.quickSort((List)object);
        object = object.iterator();
        while (object.hasNext()) {
            Object object3;
            Constituent constituent = (Constituent)object.next();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(constituent);
            InterpICValue interpICValue = wQInitialConditionSet2.getInterpolatedIC(Integer.valueOf(constituent.getId()), (SubDomainBoundaryRef)wQGeoSubDomainBoundary);
            if (interpICValue != null) {
                object3 = interpICValue.getValue();
                if (object3 != null) {
                    if (!interpICValue.isInterp()) {
                        arrayList.add("<html><b>" + (Double)object3 + "</b></html>");
                    } else {
                        arrayList.add(object3);
                    }
                } else {
                    arrayList.add("");
                }
            } else {
                arrayList.add("");
            }
            object3 = "";
            constituent = wQInitialConditionSet2.getCondition((SubDomainBoundaryRef)wQGeoSubDomainBoundary, constituent.getId());
            if (constituent != null && constituent.getOverride() != null) {
                object3 = String.valueOf(constituent.getOverride());
            }
            arrayList.add(object3);
            object2.add(arrayList);
        }
        this._junctionTable.setColumnPrecision(1, 4);
        this._junctionTable.setColumnPrecision(2, 4);
        this._tableModel.setData((List<List<Object>>)object2);
        this.setModified(false);
    }

    public void validateData() throws IOException {
    }

    public void savePanel() {
        this._junctionTable.commitEdit(true);
        this._tableModel.saveData();
        this.setModified(false);
    }

    public void setDisplayUnitSystem(int n) {
    }
}

