/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.initialcondition.JunctionDataSource;
import hec.rss.wq.client.initialcondition.JunctionSetDataSource;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.geometry.WQGeoSubDomainBoundary;
import java.io.IOException;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import rma.util.RMASort;

public class JunctionTreeModel
extends DefaultTreeModel {
    private RssWQGeometry _geo;
    private WQConstituentSet _constituentSet;
    private InitialConditionSet _icSet;
    private List<BoundaryType> _junctionTypes;

    public JunctionTreeModel(RssWQGeometry rssWQGeometry, WQConstituentSet wQConstituentSet, InitialConditionSet initialConditionSet, List<BoundaryType> list) {
        super(new JunctionSetDataSource(initialConditionSet, rssWQGeometry, wQConstituentSet, list));
        this._geo = rssWQGeometry;
        this._constituentSet = wQConstituentSet;
        this._icSet = initialConditionSet;
        this._junctionTypes = list;
        this.buildTree(rssWQGeometry);
    }

    private void buildTree(RssWQGeometry rssWQGeometry) {
        Object object = rssWQGeometry.getBoundariesUnique(this._junctionTypes);
        if (object != null) {
            RMASort.quickSort((List)object);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (WQGeoSubDomainBoundary)object.next();
            object2 = new JunctionDataSource((WQGeoSubDomainBoundary)object2, this._icSet, this._constituentSet, rssWQGeometry);
            defaultMutableTreeNode.add((MutableTreeNode)object2);
        }
    }

    public void saveModel() throws IOException {
        TreeNode treeNode = (TreeNode)this.getRoot();
        int n = treeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            JunctionDataSource junctionDataSource = (JunctionDataSource)treeNode.getChildAt(i);
            junctionDataSource.save();
        }
    }

    public void setDisplayUnitsSystem(int n) {
        TreeNode treeNode = (TreeNode)this.getRoot();
        int n2 = treeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            JunctionDataSource junctionDataSource = (JunctionDataSource)treeNode.getChildAt(i);
            if (!junctionDataSource.hasComponent()) continue;
            junctionDataSource.setDisplayUnitsSystem(n);
        }
    }
}

