/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.lang.NamedType;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel;
import hec.rss.wq.client.initialcondition.JunctionTreeModel;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqengineimpl.WQConstituentSet;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;

public class JunctionsInitialConditionsTabPanel
extends InitialConditionsTabPanel {
    private String _tabName;
    private InitialConditionSetManager _currentIcMgr;
    private JunctionTreeModel _treeModel;

    public JunctionsInitialConditionsTabPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("IC.JunctionIcTab.Tabname").getText();
        this._treeSelectorPanel.setNameLabel(WqI18n.a("IC.JunctionIcTab.Label.Junction").getText());
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType object) {
        this._currentIcMgr = null;
        if (object instanceof ManagerProxyWrapper) {
            this.setEnabled(true);
            object = (ManagerProxyWrapper)((Object)object);
            object = object.getManagerProxy();
            object = (InitialConditionSetManager)object.loadManager(null, null);
            this._currentIcMgr = object;
            this.fillPanelIC();
        }
    }

    private void fillPanelIC() {
        if (this._currentIcMgr == null) {
            return;
        }
        Object object = this._currentIcMgr.getGeometry();
        ConstituentSetManager constituentSetManager = this._currentIcMgr.getConstituentSet();
        if (object != null && constituentSetManager != null) {
            object = object.getRssWqGeometry();
            InitialConditionSet initialConditionSet = this._currentIcMgr.getSet();
            constituentSetManager = (WQConstituentSet)constituentSetManager.getSet();
            if (object != null) {
                this.interpolateInitialConditions((RssWQGeometry)object, initialConditionSet, (WQConstituentSet)constituentSetManager);
                ArrayList<BoundaryType> arrayList = new ArrayList<BoundaryType>();
                arrayList.add(BoundaryType.RIVER_INFLOW);
                arrayList.add(BoundaryType.RIVER_2_RIVER);
                arrayList.add(BoundaryType.RIVER_2_RESERVOIR);
                arrayList.add(BoundaryType.RIVER_OUTFLOW);
                arrayList.add(BoundaryType.RIVER_INFLOW_IN_NETWORK);
                List list = object.getBoundariesUnique(arrayList);
                this._treeModel = new JunctionTreeModel((RssWQGeometry)object, (WQConstituentSet)constituentSetManager, initialConditionSet, arrayList);
                JunctionsInitialConditionsTabPanel junctionsInitialConditionsTabPanel = this;
                junctionsInitialConditionsTabPanel.setData(junctionsInitialConditionsTabPanel._treeModel);
                this._treeSelectorPanel.setSelectionList((Collection)list);
            }
        }
    }

    public boolean savePanel(NamedType object) {
        try {
            if (this._treeModel == null) {
                return false;
            }
            object = this.getTreeView().a().getSelectionRows();
            this._treeModel.saveModel();
            this.fillPanelIC();
            if (((NamedType)object).length > 0) {
                EventQueue.invokeLater(() -> this.lambda$savePanel$0((int[])object));
            }
        }
        catch (IOException iOException) {
            String string = WqI18n.a("IC.JunctionIcTab.Msg.SaveFailed.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this), iOException.getMessage(), string, 0);
            return false;
        }
        return true;
    }

    public void setDisplayUnitsSystem(int n) {
    }

    private /* synthetic */ void lambda$savePanel$0(int[] nArray) {
        this.getTreeView().a().setSelectionRow(nArray[0]);
    }
}

