/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.InitialCondition;
import hec.wqenginecore.dataSource.pairedData.PairedData;
import hec.wqengineimpl.initialCondition.PairedDepth;
import hec.wqengineimpl.initialCondition.WQInitialCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ReservoirConstituentDepthModel
extends AbstractRmaTableModel {
    public static final int ELEVATION_COL = 0;
    private final int _constituentId;
    private final PairedData _data;
    private List<List<Object>> _rows = new ArrayList<List<Object>>();
    private Object[] _columnObjs;
    private ParamDouble _elevParamDouble;

    public ReservoirConstituentDepthModel(Object[] objectArray, PairedData pairedData, int n) {
        this._columnObjs = objectArray;
        this._data = pairedData;
        this._constituentId = n;
        int n2 = ClientApp.Workspace().getUnitSystem();
        this._elevParamDouble = new ParamDouble(0.0, Parameter.PARAMID_ELEV, n2);
        this._elevParamDouble.setPrecision(2);
        this.buildTableModel();
    }

    public List<List<Object>> getData() {
        return this._rows;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    private void buildTableModel() {
        Object object = new PairedDepth(this._data.getPairedDataContainer());
        Object object2 = object.getDepths();
        object2 = new ArrayList(object2);
        object = object.getConditions(this._constituentId);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Double d = (Double)object2.next();
            Object object3 = (InitialCondition)object.get(d);
            if (object3 == null || (object3 = object3.getOverride()) == null || !RMAConst.isValidValue((double)((Double)object3))) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(d);
            arrayList.add(object3);
            this._rows.add(arrayList);
        }
        this.fireTableDataChanged();
    }

    public int getColumnForConstituentId(int n) {
        for (int i = 1; i < this._columnObjs.length; ++i) {
            Constituent constituent = (Constituent)this._columnObjs[i];
            if (constituent.getId() != n) continue;
            return i;
        }
        return -1;
    }

    public void saveData() {
        PairedDepth pairedDepth = new PairedDepth(this._data.getPairedDataContainer());
        pairedDepth.clearConditions();
        for (int i = 0; i < this._rows.size(); ++i) {
            List<Object> list = this._rows.get(i);
            double d = RMAIO.parseDouble((Object)list.get(0));
            if (RMAConst.isValidValue((double)d)) {
                for (int j = 1; j < list.size(); ++j) {
                    double d2 = RMAIO.parseDouble((Object)list.get(j));
                    int n = ((Constituent)this._columnObjs[j]).getId();
                    WQInitialCondition wQInitialCondition = new WQInitialCondition(n);
                    wQInitialCondition.setOverride(RMAConst.isValidValue((double)d2) ? Double.valueOf(d2) : null);
                    pairedDepth.addCondition(Double.valueOf(d), (InitialCondition)wQInitialCondition);
                }
                continue;
            }
            System.out.println("Invalid depth: " + d);
        }
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this._rows.size() || n2 < 0 || n2 >= this.getColumnCount()) {
            return null;
        }
        List<Object> list = this._rows.get(n);
        if (n2 < list.size()) {
            if (n2 == 0) {
                double d = RMAIO.parseDouble((Object)list.get(0));
                this._elevParamDouble.setValue(d);
                this._elevParamDouble.setPrecision(2);
                try {
                    return this._elevParamDouble.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    return d;
                }
            }
            return list.get(n2);
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n >= this._rows.size() || n2 < 0 || n2 >= this.getColumnCount()) {
            return;
        }
        ParamDouble paramDouble = this._rows.get(n);
        if (n2 < paramDouble.size()) {
            if (n2 == 0 && object instanceof ParamDouble && paramDouble.get(n2) instanceof ParamDouble) {
                object = (ParamDouble)object;
                paramDouble = (ParamDouble)paramDouble.get(n2);
                paramDouble.setValue(object.getValue());
                this.fireTableCellUpdated(n, n2);
                return;
            }
            paramDouble.set(n2, (Object)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    public void addRow(Vector vector) {
        this._rows.add(vector);
        ReservoirConstituentDepthModel reservoirConstituentDepthModel = this;
        reservoirConstituentDepthModel.fireTableRowsInserted(reservoirConstituentDepthModel._rows.size(), this._rows.size());
    }

    public void clearAll() {
        this._rows.clear();
        this.fireTableDataChanged();
    }

    public void deleteRow(int n) {
        this._rows.remove(n);
        int n2 = n;
        this.fireTableRowsDeleted(n2, n2);
    }

    public int getColumnParameter(int n) {
        if (n == 0) {
            return Parameter.PARAMID_ELEV;
        }
        return -1;
    }

    public void insertRow(int n, Vector vector) {
        while (vector.size() < this.getColumnCount()) {
            vector.add("");
        }
        this._rows.add(n, vector);
        int n2 = n;
        this.fireTableRowsInserted(n2, n2);
    }

    public int getColumnCount() {
        if (this._columnObjs == null) {
            return 0;
        }
        return this._columnObjs.length;
    }

    public String getColumnName(int n) {
        if (this._columnObjs == null) {
            return null;
        }
        if (n < 0 || n > this._columnObjs.length) {
            return null;
        }
        ReservoirConstituentDepthModel reservoirConstituentDepthModel = this;
        return reservoirConstituentDepthModel.getColumnName(reservoirConstituentDepthModel._columnObjs[n]);
    }

    private String getColumnName(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Constituent) {
            object = (Constituent)object;
            return object.getDisplayName().concat(" (").concat(object.getUnit()).concat(")");
        }
        return null;
    }
}

