/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.clientapp.client.ClientApp;
import hec.rss.wq.client.initialcondition.ReservoirConstituentDepthModel;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.pairedData.PairedData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ReservoirConstituentDepthPanel
extends RmaJPanel {
    private ReservoirConstituentDepthModel _tableModel;
    private RmaJTable _resTable;
    private JButton _insertRowBtn;
    private JButton _appendRowBtn;
    private JButton _deleteRowBtn;
    private PairedData _data;

    public ReservoirConstituentDepthPanel() {
        super((LayoutManager)new GridBagLayout());
        this.initComponents();
        this.addListeners();
    }

    protected void initComponents() {
        this._resTable = new RmaJTable((Component)((Object)this));
        this._resTable.setUnitsHeaderRenderer();
        this._resTable.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        Serializable serializable = UIManager.getFont("ToolTip.font");
        Font font = this._resTable.getFont();
        serializable = new Font(serializable.getName(), font.getStyle(), font.getSize());
        this._resTable.setFont(serializable);
        this._resTable.removePopupMenuSumOptions();
        this._resTable.setRowHeight(this._resTable.getRowHeight() + 5);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        ReservoirConstituentDepthPanel reservoirConstituentDepthPanel = this;
        reservoirConstituentDepthPanel.add(reservoirConstituentDepthPanel._resTable.getScrollPane(), serializable);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5555;
        ReservoirConstituentDepthPanel reservoirConstituentDepthPanel2 = this;
        reservoirConstituentDepthPanel2.add(reservoirConstituentDepthPanel2.buildBottomButtons(), serializable);
    }

    private JPanel buildBottomButtons() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 3, 3));
        this._insertRowBtn = WqI18n.a("IC.ReservoirPanel.Button.InsertRow").createJButton();
        jPanel2.add(this._insertRowBtn);
        this._appendRowBtn = WqI18n.a("IC.ReservoirPanel.Button.AppendRow").createJButton();
        jPanel2.add(this._appendRowBtn);
        this._deleteRowBtn = WqI18n.a("IC.ReservoirPanel.Button.DeleteRow").createJButton();
        jPanel2.add(this._deleteRowBtn);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    protected void addListeners() {
        this._insertRowBtn.addActionListener(actionEvent -> this.insertTableRow());
        this._appendRowBtn.addActionListener(actionEvent -> this.appendTableRow());
        this._deleteRowBtn.addActionListener(actionEvent -> this.deleteTableRow());
        this._resTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.updateButtonStatus());
        this.updateButtonStatus();
    }

    private void deleteTableRow() {
        this._resTable.commitEdit(true);
        int n = this._resTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        this._tableModel.deleteRow(n);
        this.setModified(true);
    }

    private void appendTableRow() {
        this._resTable.commitEdit(true);
        int n = this._resTable.getRowCount();
        this._tableModel.insertRow(n, this.createEmptyRow());
        this.setModified(true);
    }

    private void insertTableRow() {
        this._resTable.commitEdit(true);
        int n = this._resTable.getSelectedRow();
        if (n < 0) {
            n = 0;
        }
        this._tableModel.insertRow(n, this.createEmptyRow());
        this.setModified(true);
    }

    private Vector<Object> createEmptyRow() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this._resTable.getModel().getColumnCount(); ++i) {
            vector.add("");
        }
        return vector;
    }

    private void updateButtonStatus() {
        int n = this._resTable.getSelectedRow();
        this._deleteRowBtn.setEnabled(n >= 0);
    }

    public void fillPanel(Constituent constituent, PairedData pairedData) {
        this._data = pairedData;
        this._tableModel = new ReservoirConstituentDepthModel(new Object[]{WqI18n.a("IC.ReservoirSummaryPanel.Header.Elevation").getText(), constituent}, this._data, constituent.getId());
        this._resTable.setModel((TableModel)((Object)this._tableModel));
        constituent = this._resTable.setDoubleCellEditor(0);
        constituent.setMinValue(0.0);
        for (int i = 1; i < this._resTable.getColumnCount(); ++i) {
            this._resTable.setDoubleCellEditor(i);
        }
        this._resTable.setUnitsHeaderRenderer();
        if (this._resTable.getRowCount() == 0) {
            this.appendTableRow();
            this.appendTableRow();
            this.appendTableRow();
            this.appendTableRow();
            this.appendTableRow();
        }
        this.setModified(false);
    }

    public void savePanel() throws IOException {
        this._resTable.commitEdit(true);
        List<List<Object>> list = this._tableModel.getData();
        for (int i = 1; i < this._resTable.getColumnCount(); ++i) {
            this.checkColumnValuesForCorrespondingElevationValue(list, i);
        }
        this._resTable.commitEdit(true);
        this._tableModel.saveData();
        this.setModified(false);
    }

    private void checkColumnValuesForCorrespondingElevationValue(List<List<Object>> object, int n) throws IOException {
        if (n == 0) {
            return;
        }
        for (int i = 0; i < object.size(); ++i) {
            List<Object> list = object.get(i);
            Object object2 = list.get(n);
            if (object2 == null || "".equals(object2) || list.get(0) != null && !"".equals(list.get(0))) continue;
            object = this._resTable.getColumnName(n);
            object = ReservoirConstituentDepthPanel.a((String)object);
            object = WqI18n.a("IC.ReservoirPanel.Msg.ConstituentMissingElevation").format(new Object[]{object2, object});
            throw new IOException((String)object);
        }
    }

    private static String a(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(40);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public void validateData() throws IOException {
        int n;
        this._resTable.commitEdit(true);
        Object object = this._tableModel.getData();
        int n2 = this._resTable.getColumnCount();
        for (n = 1; n < n2; ++n) {
            boolean bl;
            block3: {
                int n3 = n;
                List<List<Object>> list = object;
                for (int i = 0; i < list.size(); ++i) {
                    Object object2 = list.get(i);
                    if ((object2 = object2.get(n3)) == null || "".equals(object2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) continue;
            object = this._resTable.getColumnName(n);
            object = ReservoirConstituentDepthPanel.a((String)object);
            object = WqI18n.a("IC.ReservoirPanel.Msg.ConstituentOneValueDefined").format(object);
            throw new IOException((String)object);
        }
        for (n = 0; n < n2; ++n) {
            this.checkColumnValuesForCorrespondingElevationValue((List<List<Object>>)object, n);
        }
        this.checkThatThereIsAValueInEveryRowOfElevationColumn();
        this.checkThatElevationsAreMonotonicDecreasing();
    }

    private void checkThatThereIsAValueInEveryRowOfElevationColumn() throws IOException {
        Object object = this._tableModel.getData();
        boolean bl = false;
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = object.get(i);
            if ((object2 = object2.get(0)) == null) {
                bl = true;
                continue;
            }
            if ("".equals(object2)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            object = WqI18n.a("IC.ReservoirPanel.Msg.MissingElevation").format((Object)i);
            throw new IOException((String)object);
        }
    }

    private void checkThatElevationsAreMonotonicDecreasing() throws IOException {
        Object object;
        double d;
        int n = 0;
        int n2 = this._resTable.getRowCount();
        while (RMAConst.isUndefinedValue((double)(d = RMAIO.parseDouble((Object)(object = this._resTable.getValueAt(n, 0))))) && ++n < n2) {
        }
        if (n >= n2) {
            return;
        }
        while (n < n2) {
            double d2;
            Object object2 = this._resTable.getValueAt(n, 0);
            if (!("".equals(object2) || "".equals(object) || RMAConst.isUndefinedValue((double)(d2 = RMAIO.parseDouble((Object)object2))))) {
                if (d2 >= d) {
                    object = WqI18n.a("IC.ReservoirPanel.Msg.MonotonicallyDecreasing").format(new Object[]{object2, object, n + 1});
                    throw new IOException((String)object);
                }
                object = object2;
                d = d2;
            }
            ++n;
        }
    }
}

