/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.event.ModifiableListener;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.io.PairedDataContainer;
import hec.rss.client.RSimSimulationMode;
import hec.rss.wq.client.TimeSeriesDataSourcePlotUtil;
import hec.rss.wq.client.initialcondition.ReservoirConstituentDepthPanel;
import hec.rss.wq.dataSources.dss.BaseDssPanel;
import hec.rss.wq.dataSources.pairedData.PairedDataDSSPanel;
import hec.rss.wq.dataSources.pairedData.PairedDataPanel;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.pairedData.PairedCurveData;
import hec.wqenginecore.dataSource.pairedData.PairedData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.Entry;
import hec.wqengineimpl.initialCondition.InitialConditionsSourceSelection;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import hec.wqengineimpl.initialCondition.WQMap;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.lang.Modifiable;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;

public class ReservoirConstituentPanel
extends RmaJPanel {
    private static final FluentLogger b = FluentLogger.forEnclosingClass();
    private static final String c = WqI18n.a("IC.ReservoirConstituentPanel.User").getText();
    public static final String DSS = WqI18n.a("IC.ReservoirConstituentPanel.DSS").getText();
    private RmaJComboBox<String> _dataSourceCombo;
    private DefaultComboBoxModel<String> _comboModel;
    private JPanel _cardPanel;
    private PairedDataPanel _dssPanel;
    private ReservoirConstituentDepthPanel _tablePanel;
    private G2dPanel _dssPlot;
    private SubDomainRef _reservoir;
    private WQInitialConditionSet2 _icSet;
    private Constituent _constituent;
    private final transient List<ModifiableListener> d = new ArrayList<ModifiableListener>();
    protected transient boolean a = false;

    public ReservoirConstituentPanel() {
        super((LayoutManager)new GridBagLayout());
        this.initComponents();
        this.addListeners();
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(new JSeparator(), gridBagConstraints);
        String[] stringArray = WqI18n.a("IC.ReservoirConstituentPanel.Label.DataSource").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)stringArray, gridBagConstraints);
        stringArray = new String[]{DSS, c};
        this._comboModel = new DefaultComboBoxModel<String>(stringArray);
        this._comboModel.setSelectedItem(null);
        this._dataSourceCombo = new RmaJComboBox(this._comboModel);
        this._dataSourceCombo.setModifiable(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirConstituentPanel reservoirConstituentPanel = this;
        reservoirConstituentPanel.add((Component)reservoirConstituentPanel._dataSourceCombo, gridBagConstraints);
        this._cardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._cardPanel.setBorder(BorderFactory.createTitledBorder(""));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirConstituentPanel reservoirConstituentPanel2 = this;
        reservoirConstituentPanel2.add(reservoirConstituentPanel2._cardPanel, gridBagConstraints);
        this._tablePanel = this.buildTablePanel();
        this._cardPanel.add((Component)((Object)this._tablePanel), c);
        this._dssPanel = this.buildDssPanel(gridBagConstraints);
        this._cardPanel.add((Component)((Object)this._dssPanel), DSS);
    }

    private PairedDataPanel buildDssPanel(GridBagConstraints gridBagConstraints) {
        PairedDataPanel pairedDataPanel = new PairedDataPanel();
        this._dssPlot = new G2dPanel();
        this._dssPlot.buildDefaultComponents();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        pairedDataPanel.add((Component)this._dssPlot, gridBagConstraints);
        return pairedDataPanel;
    }

    private ReservoirConstituentDepthPanel buildTablePanel() {
        return new ReservoirConstituentDepthPanel();
    }

    protected void addListeners() {
        this._dataSourceCombo.addItemListener(this::dataSourceComboChanged);
        this._dssPanel.addPropertyChangeListener("DssData", propertyChangeEvent -> this.plotDssData());
    }

    private void plotDssData() {
        Object object = this._dssPanel.getPairedDataContainer();
        if (object == null) {
            this._dssPlot.clearPanel();
            return;
        }
        DssData dssData = new DssData();
        dssData.setDssFilePath(((PairedDataContainer)object).fileName);
        dssData.setDssPath(object.getFullName());
        dssData.setIsProfile(true);
        object = TimeSeriesDataSourcePlotUtil.a(dssData);
        dssData = TimeSeriesDataSourcePlotUtil.a((Data)dssData);
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, dssData);
        object = object.stream().map(timeSeriesDataSource -> ((DssDataSource)timeSeriesDataSource).getPairedData(parameterMap)).collect(Collectors.toList());
        dssData = new PlotLayout();
        TimeSeriesDataSourcePlotUtil.a(this._dssPlot, (PlotLayout)dssData, Map.of(this._constituent.getDisplayName(), object));
    }

    private void dataSourceComboChanged(ItemEvent object) {
        if (2 == ((ItemEvent)object).getStateChange()) {
            return;
        }
        object = (String)this._dataSourceCombo.getSelectedItem();
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, (String)object);
    }

    public void fillPanel(SubDomainRef subDomainRef, WQInitialConditionSet2 object, Constituent object2) {
        Entry entry;
        this._reservoir = subDomainRef;
        this._icSet = object;
        this._constituent = object2;
        if (subDomainRef == null || object == null || object2 == null) {
            ((FluentLogger.Api)b.atInfo()).log("fillPanel called with null parameter, reservoir: %s, icSet: %s, constituent: %s", (Object)subDomainRef, object, object2);
            return;
        }
        boolean bl = this.forwardModifiedEvents();
        this.setFowardModifiedEvents(false);
        object = this.getSourceSelection();
        if (!object.containsKey("Paired Data")) {
            object.put("Paired Data", (Object)new PairedData());
        }
        if (!object.containsKey("DSS")) {
            object.put("DSS", (Object)new PairedCurveData());
        }
        ParameterMap parameterMap = null;
        Object object3 = ClientApp.frame().getCurrentMode();
        if (object3 instanceof RSimSimulationMode && (object3 = ((RSimSimulationMode)object3).getSimTimeWindow()) != null) {
            parameterMap = new ParameterMap();
            parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, object3);
        }
        object3 = object.getEntries();
        object3 = object3.iterator();
        while (object3.hasNext()) {
            entry = (Entry)object3.next();
            String string = (String)entry.getKey();
            if (string.equals("Paired Data")) {
                this._tablePanel.fillPanel((Constituent)object2, (PairedData)entry.getValue());
                continue;
            }
            if (!string.equals("DSS")) continue;
            ((PairedDataDSSPanel)this._dssPanel).fillPanel((DssData)entry.getValue(), parameterMap);
        }
        object3 = object.getSelectedKey();
        if (object3 == null || !object.containsKey((String)object3)) {
            object3 = "Paired Data";
            object.setSelectedKey((String)object3);
        }
        object = object3;
        object2 = null;
        if ("DSS".equals(object)) {
            object2 = DSS;
        } else if ("Paired Data".equals(object)) {
            object2 = c;
        }
        entry = object2;
        this._dataSourceCombo.setSelectedItem((Object)entry);
        this.setFowardModifiedEvents(bl);
        this.setModified(false);
    }

    private InitialConditionsSourceSelection<Data> getSourceSelection() {
        Objects.requireNonNull(this._icSet, "WQInitialConditionSet2 must not be null");
        Objects.requireNonNull(this._constituent, "Constituent must not be null");
        Objects.requireNonNull(this._reservoir, "Reservoir must not be null");
        WQMap wQMap = this._icSet.getReservoirSourcesMap();
        wQMap = (WQMap)wQMap.computeIfAbsent((Object)this._constituent.getId(), n -> new WQMap());
        wQMap = (InitialConditionsSourceSelection)wQMap.computeIfAbsent((Object)this._reservoir, subDomainRef -> new InitialConditionsSourceSelection());
        return wQMap;
    }

    public void save() {
        try {
            this._tablePanel.savePanel();
            ((BaseDssPanel)this._dssPanel).save();
            String string = (String)this._dataSourceCombo.getSelectedItem();
            if (this._constituent != null && this._reservoir != null) {
                InitialConditionsSourceSelection<Data> initialConditionsSourceSelection = null;
                if (DSS.equals(string)) {
                    initialConditionsSourceSelection = "DSS";
                } else if (c.equals(string)) {
                    initialConditionsSourceSelection = "Paired Data";
                }
                string = initialConditionsSourceSelection;
                if (string != null) {
                    initialConditionsSourceSelection = this.getSourceSelection();
                    initialConditionsSourceSelection.setSelectedKey(string);
                }
                this.setModified(false);
                return;
            }
            ((FluentLogger.Api)b.atInfo()).log("Unexpected null constituent or reservoir, constituent: %s, reservoir: %s", (Object)this._constituent, (Object)this._reservoir);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void validateData() throws IOException {
        this._tablePanel.validateData();
    }

    public void setModified(boolean bl) {
        if (this.a) {
            return;
        }
        boolean bl2 = this.isModified();
        super.setModified(bl);
        if (bl2 != this.isModified()) {
            this.fireModifiedStateChanged();
        }
    }

    public void addModifiableListener(ModifiableListener modifiableListener) {
        if (modifiableListener == null) {
            return;
        }
        this.d.add(modifiableListener);
    }

    public void removeModifiableListener(ModifiableListener modifiableListener) {
        this.d.remove(modifiableListener);
    }

    protected void fireModifiedStateChanged() {
        for (int i = this.d.size() - 1; i >= 0; --i) {
            ModifiableListener modifiableListener = this.d.get(i);
            if (modifiableListener == null) continue;
            ReservoirConstituentPanel reservoirConstituentPanel = this;
            modifiableListener.modifiedStateChanged((Modifiable)reservoirConstituentPanel, reservoirConstituentPanel.isModified());
        }
    }
}

