/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.event.ModifiableListener;
import hec.rss.wq.client.initialcondition.ReservoirConstituentPanel;
import hec.rss.wq.ui.DataSource;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import rma.lang.Modifiable;
import rma.services.ServiceLookup;
import rma.util.RMAUtil;

public class ReservoirConstituentTreeNode
extends DefaultMutableTreeNode
implements DataSource,
Modifiable {
    public static final Logger logger = Logger.getLogger(ReservoirConstituentTreeNode.class.getName());
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    private WQSubDomainRef _reservoir;
    private Constituent _constituent;
    private InitialConditionSet _icSet;
    private ReservoirConstituentPanel _panel;
    private ModifiableListener _panelListener = (modifiable, bl) -> this.setModified(bl);

    public ReservoirConstituentTreeNode(InitialConditionSet initialConditionSet, Constituent constituent, WQSubDomainRef wQSubDomainRef) {
        super(constituent.getDisplayName());
        this._icSet = initialConditionSet;
        this._reservoir = wQSubDomainRef;
        this._constituent = constituent;
    }

    public Constituent getConstituent() {
        return this._constituent;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getName() {
        return this._constituent.getDisplayName() + (this.isModified() ? "*" : "");
    }

    public boolean hasComponent() {
        return this._panel != null;
    }

    @Override
    public JComponent getComponent() {
        if (this._panel == null) {
            if (this._icSet instanceof WQInitialConditionSet2) {
                WQInitialConditionSet2 wQInitialConditionSet2 = (WQInitialConditionSet2)this._icSet;
                this._panel = new ReservoirConstituentPanel();
                this._panel.addModifiableListener(this._panelListener);
                this._panel.fillPanel((SubDomainRef)this._reservoir, wQInitialConditionSet2, this._constituent);
                this.setModified(false);
            } else {
                String string = "null";
                if (this._icSet != null) {
                    string = this._icSet.getClass().getName();
                }
                logger.warning("Unknown InitialConditionSet: " + string);
            }
        }
        return this._panel;
    }

    @Override
    public void validateData() throws IOException {
        this._panel.validateData();
    }

    @Override
    public void save() throws IOException {
        ReservoirConstituentTreeNode reservoirConstituentTreeNode = this;
        reservoirConstituentTreeNode.save(reservoirConstituentTreeNode._icSet);
    }

    public void save(InitialConditionSet initialConditionSet) throws IOException {
        if (this._panel != null && RMAUtil.isChildrenModified((Container)((Object)this._panel))) {
            this._panel.save();
        }
    }

    public boolean isModified() {
        boolean bl = false;
        if (this._panel != null) {
            bl = this._panel.isModified();
        }
        return bl;
    }

    public void setModified(boolean bl) {
        boolean bl2;
        if (this._panel != null && (bl2 = this._panel.isModified()) != bl) {
            this._panel.setModified(bl);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setDisplayUnitsSystem(int n) {
        if (this._panel != null) {
            ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)((Object)this._panel));
        }
    }
}

