/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.lang.NamedType;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel;
import hec.rss.wq.client.initialcondition.ReservoirTreeModel;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.InitialConditionSet;
import hec.wqengineimpl.WQConstituentSet;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class ReservoirInitialConditionsTabPanel
extends InitialConditionsTabPanel {
    private Logger _logger = Logger.getLogger(ReservoirInitialConditionsTabPanel.class.getName());
    private String _tabName;
    private InitialConditionSetManager _currentIcMgr;
    private ReservoirTreeModel _treeModel;

    public ReservoirInitialConditionsTabPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("IC.ReservoirIcTab.Tabname").getText();
        this._treeSelectorPanel.setNameLabel(WqI18n.a("IC.ReservoirIcTab.Label.Reservoir").getText());
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType object) {
        this._currentIcMgr = null;
        if (object instanceof ManagerProxyWrapper) {
            this.setEnabled(true);
            object = (ManagerProxyWrapper)((Object)object);
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            object = (InitialConditionSetManager)object.loadManager(null, null);
            this._currentIcMgr = object;
            Object object2 = this._currentIcMgr.getGeometry();
            ConstituentSetManager constituentSetManager = this._currentIcMgr.getConstituentSet();
            if (object2 != null && constituentSetManager != null) {
                InitialConditionSet initialConditionSet = ((InitialConditionSetManager)object).getInitialConditionSet();
                constituentSetManager = (WQConstituentSet)constituentSetManager.getSet();
                if ((object2 = object2.getRssWqGeometry()) != null) {
                    object = object2.getReservoirs();
                    this._treeModel = new ReservoirTreeModel((RssWQGeometry)object2, (WQConstituentSet)constituentSetManager, initialConditionSet);
                    ReservoirInitialConditionsTabPanel reservoirInitialConditionsTabPanel = this;
                    reservoirInitialConditionsTabPanel.setData(reservoirInitialConditionsTabPanel._treeModel);
                    this._treeSelectorPanel.setSelectionList((Collection)object);
                    return;
                }
                this._logger.log(Level.INFO, "No Geometry found for InitialConditions Manager " + ((JsonManager)((Object)object)).getName());
            }
        }
    }

    public boolean savePanel(NamedType namedType) {
        if (this._treeModel != null) {
            return this._treeModel.saveModel((JComponent)((Object)this));
        }
        return true;
    }

    public void setDisplayUnitsSystem(int n) {
        if (this._treeModel != null) {
            this._treeModel.setDisplayUnitsSystem(n);
        }
    }
}

