/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.data.Parameter;
import hec.data.TimeWindow;
import hec.geometry.Axis;
import hec.geometry.AxisProp;
import hec.gfx2d.AxisLabel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.PlotLayout;
import hec.heclib.dss.DssDataType;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.rss.client.RSimSimulationMode;
import hec.rss.wq.client.TimeSeriesDataSourcePlotUtil;
import hec.rss.wq.client.initialcondition.ReservoirConstituentPanel;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.dataSources.pairedData.PairedCurveDataSource;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.PairedDataDataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.initialCondition.InitialConditionsSourceSelection;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import hec.wqengineimpl.initialCondition.WQMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import mil.army.usace.hec.metadata.UnitUtil;
import rma.swing.RmaInsets;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.util.RMAConst;

public class ReservoirPanel
extends RmaJPanel {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private JComponent _plotsPanel;

    public ReservoirPanel() {
        super((LayoutManager)new GridBagLayout());
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(new JSeparator(), gridBagConstraints);
        this._plotsPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this._plotsPanel);
        jScrollPane.setPreferredSize(this.getPreferredSize());
        this.add(jScrollPane, gridBagConstraints);
        this.addListeners();
    }

    protected void addListeners() {
    }

    public void fillPanel(SubDomainRef subDomainRef, WQInitialConditionSet2 wQInitialConditionSet2, WQConstituentSet wQConstituentSet) {
        if (wQInitialConditionSet2 != null) {
            Object object = wQInitialConditionSet2.getConstituentIds();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            int n = ClientApp.Workspace().getUnitSystem();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Integer)object.next();
                LinkedHashMap<String, List<DataContainer>> linkedHashMap = new LinkedHashMap<String, List<DataContainer>>();
                PlotLayout plotLayout = new PlotLayout();
                Constituent constituent = wQConstituentSet.getConstituent((Integer)object2);
                if (constituent == null) continue;
                WQMap wQMap = null;
                Object object3 = wQInitialConditionSet2.getReservoirSourcesMap();
                if (object3 != null) {
                    wQMap = (WQMap)object3.get(object2);
                }
                object2 = null;
                if (wQMap != null) {
                    object2 = (InitialConditionsSourceSelection)wQMap.get((Object)subDomainRef);
                }
                wQMap = null;
                object3 = null;
                if (object2 != null) {
                    wQMap = (Data)object2.getSelected();
                    object3 = object2.getSelectedKey();
                }
                object2 = DataSourceFactory.a((Data)wQMap);
                if (ReservoirConstituentPanel.DSS.equalsIgnoreCase((String)object3)) {
                    this.plotDssData(gridBagConstraints, linkedHashMap, plotLayout, constituent, (DataSource)object2);
                    continue;
                }
                this.plotUserEnteredData(constituent, (DataSource)object2, subDomainRef, (String)object3, (Data)wQMap, n, gridBagConstraints);
            }
        }
        this.setModified(false);
    }

    private void plotDssData(GridBagConstraints gridBagConstraints, Map<String, List<DataContainer>> map, PlotLayout plotLayout, Constituent constituent, DataSource dataSource) {
        Object object = new DssData();
        Object object2 = ((PairedCurveDataSource)dataSource).getPairedData(null);
        object.setDssFilePath(((PairedDataContainer)object2).fileName);
        object.setDssPath(object2.getFullName());
        object.setIsProfile(true);
        object2 = new ArrayList();
        map.put(constituent.getDisplayName(), (List<DataContainer>)object2);
        Object object3 = ClientApp.frame().getCurrentMode();
        TimeWindow timeWindow = null;
        if (object3 instanceof RSimSimulationMode) {
            timeWindow = ((RSimSimulationMode)object3).getSimTimeWindow();
        }
        if (timeWindow != null) {
            object3 = new ParameterMap();
            object3.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, timeWindow);
            object = TimeSeriesDataSourcePlotUtil.a(object);
            object.forEach(arg_0 -> ReservoirPanel.a((List)object2, (ParameterMap)object3, arg_0));
        } else {
            object3 = TimeSeriesDataSourcePlotUtil.a(object);
            object3.forEach(arg_0 -> ReservoirPanel.a((List)object2, arg_0));
        }
        if (!object2.isEmpty()) {
            object3 = (PairedDataContainer)object2.get(0);
            object = ((PairedDataDataSource)dataSource).getCurve(null);
            constituent = new RmaJLabel(constituent.getDisplayName());
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this._plotsPanel.add((Component)constituent, gridBagConstraints);
            constituent = ReservoirPanel.a((PairedDataContainer)object3, (Integer)object);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this._plotsPanel.add((Component)constituent, gridBagConstraints);
            TimeSeriesDataSourcePlotUtil.a((G2dPanel)constituent, plotLayout, map);
        }
    }

    private void plotUserEnteredData(Constituent object, DataSource object2, SubDomainRef object3, String string, Data data, int n, GridBagConstraints gridBagConstraints) {
        if (object2 instanceof PairedDataDataSource) {
            Object object4 = (PairedDataDataSource)object2;
            Object object5 = new RmaJLabel(object.getDisplayName());
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this._plotsPanel.add((Component)object5, gridBagConstraints);
            object5 = null;
            ClientMode clientMode = ClientApp.frame().getCurrentMode();
            if (clientMode instanceof RSimSimulationMode && (clientMode = ((RSimSimulationMode)clientMode).getSimTimeWindow()) != null) {
                object5 = new ParameterMap();
                object5.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, clientMode);
            }
            clientMode = object4.getPairedData((ParameterMap)object5);
            object4 = object4.getCurve(null);
            if (clientMode == null) {
                ((FluentLogger.Api)a.atFine()).log("Not plotting the PairedDataContainer for constituent: %s at %s with method %s because the returned pdc was null. Data: %s, DataSource: %s", (Object)object.getDisplayName(), object3, (Object)string, (Object)data, object2);
                return;
            }
            object2 = WqI18n.a("ReservoirPanel.Label.Elevation").getText();
            if (clientMode.fullName == null || clientMode.fullName.isEmpty()) {
                clientMode.location = ((WQSubDomainRef)object3).getName();
                object3 = "//" + clientMode.location + "/" + (String)object2 + "-" + object.getDisplayName() + "////";
                clientMode.fullName = object3;
                clientMode.yparameter = object.getDisplayName();
                clientMode.yunits = object.getUnit();
                if (clientMode.yparameter.toLowerCase().contains("temp")) {
                    object = object.getUnit();
                    clientMode.yunits = UnitUtil.getBestMatch((String)object);
                }
                clientMode.labelsUsed = false;
                clientMode.xparameter = object2;
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
                clientMode.xunits = object;
                clientMode.ytype = DssDataType.INST_VAL.toString();
            }
            clientMode.switchXyAxis = true;
            object3 = ReservoirPanel.a((PairedDataContainer)clientMode, (Integer)object4);
            if (!((String)object2).equals(clientMode.xparameter)) {
                EventQueue.invokeLater(() -> this.lambda$plotUserEnteredData$2((G2dPanel)object3));
            }
            EventQueue.invokeLater(() -> this.lambda$plotUserEnteredData$3((G2dPanel)object3, (PairedDataContainer)clientMode));
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this._plotsPanel.add((Component)object3, gridBagConstraints);
        }
    }

    private void fixAxisLabels(G2dPanel g2dPanel, PairedDataContainer pairedDataContainer) {
        AxisLabel axisLabel = g2dPanel.getViewports();
        AxisLabel axisLabel2 = g2dPanel.getViewportAxisLabel(axisLabel[0], 2);
        axisLabel2.setText(pairedDataContainer.xparameter + " (" + pairedDataContainer.xunits + ")");
        G2dLabelDrawProp g2dLabelDrawProp = axisLabel2.getProperties();
        axisLabel2.getProperties().text = pairedDataContainer.xparameter + " (" + pairedDataContainer.xunits + ")";
        axisLabel2.setProperties(g2dLabelDrawProp);
        axisLabel = g2dPanel.getViewportAxisLabel(axisLabel[0], 0);
        axisLabel.setText(pairedDataContainer.yparameter + " (" + pairedDataContainer.yunits + ")");
        g2dLabelDrawProp = axisLabel.getProperties();
        axisLabel.getProperties().text = pairedDataContainer.yparameter + " (" + pairedDataContainer.yunits + ")";
        axisLabel.setProperties(g2dLabelDrawProp);
        g2dPanel.setDirty();
        g2dPanel.invalidate();
        g2dPanel.doLayout();
        g2dPanel.paintGfx();
    }

    private void configureAxis(G2dPanel g2dPanel) {
        Axis axis = g2dPanel.getViewports();
        axis = g2dPanel.getViewportAxis(axis[0], 2);
        axis.setReversed(false);
        AxisProp axisProp = axis.getAxisProp();
        axisProp.setReversed(false);
        axis.setAxisProp(axisProp);
        g2dPanel.setDirty();
        g2dPanel.invalidate();
        g2dPanel.doLayout();
        g2dPanel.paintGfx();
    }

    private static G2dPanel a(PairedDataContainer g2dLineProperties, Integer n) {
        PairedDataSet pairedDataSet = new PairedDataSet((PairedDataContainer)g2dLineProperties);
        if (n != null && n >= 0) {
            int n2 = pairedDataSet.getCurveCount();
            for (int i = 0; i < n2; ++i) {
                pairedDataSet.setCurveDrawn(i, false);
            }
            pairedDataSet.setCurveDrawn(n.intValue(), true);
        }
        G2dPanel g2dPanel = new G2dPanel();
        Cloneable cloneable = g2dPanel.getMinimumSize();
        cloneable = new Dimension(cloneable.width, cloneable.height + 200);
        g2dPanel.setMinimumSize(cloneable);
        g2dPanel.setPreferredSize(cloneable);
        cloneable = new ArrayList<PairedDataSet>();
        cloneable.add(pairedDataSet);
        boolean bl = pairedDataSet.getName() != null && !pairedDataSet.getName().isEmpty();
        ArrayList<G2dLineProperties> arrayList = new ArrayList<G2dLineProperties>();
        if (ReservoirPanel.a((PairedDataContainer)g2dLineProperties, (int)n) <= 1) {
            g2dLineProperties = new G2dLineProperties();
            g2dLineProperties.setDrawPoints(true);
            g2dLineProperties.setDrawLine(false);
            arrayList.add(g2dLineProperties);
        } else {
            g2dLineProperties = G2dPanel.getLineColors();
            arrayList.add(g2dLineProperties[0]);
        }
        g2dPanel.buildComponents((List)((Object)cloneable), arrayList, true, bl);
        return g2dPanel;
    }

    private static int a(PairedDataContainer object, int n) {
        double[] dArray;
        int n2;
        int n3 = 0;
        if (object != null && ((PairedDataContainer)object).yOrdinates != null && ((PairedDataContainer)object).yOrdinates.length > n2 && (dArray = ((PairedDataContainer)object).yOrdinates[n2]) != null) {
            double[] dArray2 = dArray;
            n2 = dArray.length;
            for (int i = 0; i < n2; ++i) {
                double d = dArray2[i];
                if (!RMAConst.isValidValue((double)d)) continue;
                ++n3;
            }
        }
        return n3;
    }

    public void savePanel() throws IOException {
    }

    public void validateData() {
    }

    private /* synthetic */ void lambda$plotUserEnteredData$3(G2dPanel g2dPanel, PairedDataContainer pairedDataContainer) {
        this.fixAxisLabels(g2dPanel, pairedDataContainer);
    }

    private /* synthetic */ void lambda$plotUserEnteredData$2(G2dPanel g2dPanel) {
        this.configureAxis(g2dPanel);
    }

    private static /* synthetic */ void a(List list, TimeSeriesDataSource timeSeriesDataSource) {
        list.add(((DssDataSource)timeSeriesDataSource).e());
    }

    private static /* synthetic */ void a(List list, ParameterMap parameterMap, TimeSeriesDataSource timeSeriesDataSource) {
        list.add(((DssDataSource)timeSeriesDataSource).getPairedData(parameterMap));
    }
}

