/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.initialcondition.ReservoirConstituentTreeNode;
import hec.rss.wq.client.initialcondition.ReservoirSummaryTreeNode;
import hec.rss.wq.client.initialcondition.ReservoirTreeNode;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.WQConstituentSet;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import rma.util.RMASort;

public class ReservoirTreeModel
extends DefaultTreeModel {
    private RssWQGeometry _geo;
    private WQConstituentSet _constituentSet;
    private InitialConditionSet _icSet;

    public ReservoirTreeModel(RssWQGeometry rssWQGeometry, WQConstituentSet wQConstituentSet, InitialConditionSet initialConditionSet) {
        super(new ReservoirSummaryTreeNode(WqI18n.a("IC.TreeNode.Reservoirs").getText(), rssWQGeometry, wQConstituentSet, initialConditionSet));
        this._geo = rssWQGeometry;
        this._constituentSet = wQConstituentSet;
        this._icSet = initialConditionSet;
        this.buildTree(rssWQGeometry);
    }

    private void buildTree(RssWQGeometry iterator) {
        if ((iterator = iterator.getReservoirs()) instanceof List) {
            RMASort.quickSort((List)((List)((Object)iterator)));
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (SubDomain)iterator.next();
            object = new ReservoirTreeNode((SubDomain)object, this._icSet, this._constituentSet);
            defaultMutableTreeNode.add((MutableTreeNode)object);
        }
    }

    public boolean saveModel(JComponent jComponent) {
        TreeNode treeNode = (TreeNode)this.getRoot();
        int n = treeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ReservoirTreeNode reservoirTreeNode = (ReservoirTreeNode)treeNode.getChildAt(i);
            try {
                if (!reservoirTreeNode.isModified()) continue;
                reservoirTreeNode.validateData();
                reservoirTreeNode.save();
                continue;
            }
            catch (IOException iOException) {
                String string = WqI18n.a("IC.TreeNode.Reservoirs.Msg.SaveFailed.Title").format((Object)reservoirTreeNode.toString());
                JOptionPane.showMessageDialog(jComponent, iOException.getMessage(), string, 0);
                return false;
            }
        }
        return true;
    }

    public void setDisplayUnitsSystem(int n) {
        TreeNode treeNode = (TreeNode)this.getRoot();
        if (treeNode instanceof ReservoirSummaryTreeNode) {
            ((ReservoirSummaryTreeNode)treeNode).setDisplayUnitSystem(n);
        }
        this.setTreeNodesDisplayUnitSystem(n, (DefaultMutableTreeNode)treeNode);
    }

    private void setTreeNodesDisplayUnitSystem(int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (treeNode instanceof ReservoirTreeNode) {
                defaultMutableTreeNode2 = (ReservoirTreeNode)treeNode;
                if (((ReservoirTreeNode)defaultMutableTreeNode2).hasComponent()) {
                    ((ReservoirTreeNode)defaultMutableTreeNode2).setDisplayUnitsSystem(n);
                }
            } else if (treeNode instanceof ReservoirConstituentTreeNode && ((ReservoirConstituentTreeNode)(defaultMutableTreeNode2 = (ReservoirConstituentTreeNode)treeNode)).hasComponent()) {
                ((ReservoirConstituentTreeNode)defaultMutableTreeNode2).setDisplayUnitsSystem(n);
            }
            if (treeNode.getChildCount() <= 0) continue;
            this.setTreeNodesDisplayUnitSystem(n, (DefaultMutableTreeNode)treeNode);
        }
    }
}

