/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.initialcondition;

import hec.rss.client.RssSystemGlyph;
import hec.rss.wq.client.initialcondition.ConstituentComparator;
import hec.rss.wq.client.initialcondition.IcSymbolIcon;
import hec.rss.wq.client.initialcondition.ReservoirConstituentTreeNode;
import hec.rss.wq.client.initialcondition.ReservoirPanel;
import hec.rss.wq.ui.DataSource;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import rma.lang.Modifiable;
import rma.services.ServiceLookup;

public class ReservoirTreeNode
extends DefaultMutableTreeNode
implements DataSource,
Modifiable {
    private IcSymbolIcon _icon;
    private ReservoirPanel _reservoirPanel;
    private InitialConditionSet _icSet;
    private WQConstituentSet _cSet;

    public ReservoirTreeNode(SubDomain subDomain, InitialConditionSet initialConditionSet, WQConstituentSet wQConstituentSet) {
        super(subDomain);
        this._icSet = initialConditionSet;
        this._cSet = wQConstituentSet;
        this._icon = new IcSymbolIcon(5);
        this.addConstituentNodes(wQConstituentSet);
    }

    private void addConstituentNodes(WQConstituentSet object) {
        this.removeAllChildren();
        if (object == null) {
            return;
        }
        object = object.getConstituentList();
        object = new ArrayList<Constituent>((Collection<Constituent>)object);
        object.sort(new ConstituentComparator());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Constituent)object.next();
            SubDomainRef subDomainRef = this.getReservoir().getRef();
            object2 = new ReservoirConstituentTreeNode(this._icSet, (Constituent)object2, (WQSubDomainRef)subDomainRef);
            this.add((MutableTreeNode)object2);
        }
    }

    public void updateConstituentNodes() {
        ReservoirTreeNode reservoirTreeNode = this;
        reservoirTreeNode.addConstituentNodes(reservoirTreeNode._cSet);
    }

    @Override
    public Icon getIcon() {
        return this._icon;
    }

    @Override
    public String getName() {
        return ((SubDomain)this.getUserObject()).getName();
    }

    @Override
    public JComponent getComponent() {
        this._reservoirPanel = new ReservoirPanel();
        this._reservoirPanel.fillPanel(this.getReservoir().getRef(), (WQInitialConditionSet2)this._icSet, this._cSet);
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)((Object)this._reservoirPanel));
        return this._reservoirPanel;
    }

    public SubDomain getReservoir() {
        return (SubDomain)this.getUserObject();
    }

    @Override
    public void validateData() throws IOException {
        if (this._reservoirPanel != null) {
            this._reservoirPanel.validateData();
        }
    }

    @Override
    public void save() throws IOException {
        if (this._reservoirPanel != null) {
            this._reservoirPanel.savePanel();
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = this.getChildAt(i);
            if (!(treeNode instanceof ReservoirConstituentTreeNode)) continue;
            ((ReservoirConstituentTreeNode)treeNode).save();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public boolean isModified() {
        boolean bl = false;
        if (this._reservoirPanel != null) {
            bl = this._reservoirPanel.isModified();
        }
        int n = this.getChildCount();
        for (int i = 0; i < n && !bl; ++i) {
            TreeNode treeNode = this.getChildAt(i);
            if (!(treeNode instanceof Modifiable)) continue;
            bl = bl || ((Modifiable)treeNode).isModified();
        }
        return bl;
    }

    public void setModified(boolean bl) {
        this._reservoirPanel.setModified(bl);
    }

    public boolean hasComponent() {
        return this._reservoirPanel != null;
    }

    public void setDisplayUnitsSystem(int n) {
        if (this._reservoirPanel != null) {
            ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)((Object)this._reservoirPanel));
        }
    }

    static {
        RssSystemGlyph.initIcons();
    }
}

