/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import hec.rss.wq.client.DataEditorPanel;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.massinjection.MassInjectionConstituentData;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSiteData;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import rma.util.RMAUtil;

public class ConstituentTreeNode
extends DefaultMutableTreeNode
implements DataSource {
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    private Constituent _constituent;
    private WQMassInjectionSite _site;
    private WQMassInjectionSet _miSet;
    private DataEditorPanel _panel;
    private MassInjectionConstituentData _constituentData;

    public ConstituentTreeNode(WQMassInjectionSet wQMassInjectionSet, WQMassInjectionSite wQMassInjectionSite, Constituent constituent) {
        super(constituent.getDisplayName());
        this._miSet = wQMassInjectionSet;
        this._site = wQMassInjectionSite;
        this._constituent = constituent;
    }

    public Constituent getConstituent() {
        return this._constituent;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getName() {
        return this._constituent.getDisplayName();
    }

    @Override
    public JComponent getComponent() {
        if (this._panel == null) {
            Data data2;
            ArrayList arrayList = new ArrayList();
            Object object = (WQMassInjectionSiteData)this._miSet.getMassInjectionSiteData((MassInjectionSite)this._site);
            this._constituentData = object.getMassInjectionConstituentData(this._constituent);
            object = this._constituentData.getDataSources();
            if (object != null) {
                object = object.stream().filter(data -> data instanceof DssData || data instanceof ConstantData).collect(Collectors.toList());
                object = object.iterator();
                while (object.hasNext()) {
                    data2 = (Data)object.next();
                    if (data2 instanceof TableData) {
                        ((TableData)data2).setVariableName(this._constituent.getDisplayName());
                    }
                    String[] stringArray = new String[]{"mg s\u207b\u00b9"};
                    data2.setAvailableUnits(stringArray);
                    arrayList.add((TimeSeriesDataSource)DataSourceFactory.a(data2));
                }
            }
            this._panel = new DataEditorPanel(arrayList);
            object = WqI18n.a("MI.ConstituentPanel.Border").format((Object)this._constituent.getDisplayName());
            object = BorderFactory.createTitledBorder((String)object);
            this._panel.setBorder((Border)object);
            this._panel.setParameterLabel(this._constituent.getDisplayName());
            data2 = this._constituentData.getSelectedDataSource();
            if (data2 != null) {
                this._panel.setSelectedDataSourceName(data2.getName());
            }
        }
        return this._panel;
    }

    @Override
    public void validateData() throws IOException {
        if (this._panel != null) {
            this._panel.validateData();
        }
    }

    @Override
    public void save() throws IOException {
        ConstituentTreeNode constituentTreeNode = this;
        constituentTreeNode.save(constituentTreeNode._miSet);
    }

    public void save(WQMassInjectionSet object) throws IOException {
        if (this._panel != null && RMAUtil.isChildrenModified((Container)((Object)this._panel))) {
            this._panel.savePanel();
            for (Data data : this._constituentData.getDataSources()) {
                if (!data.getName().equals(this._panel.getSelectedDataSourceName())) continue;
                this._constituentData.setSelectedDataSource(data);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public WQMassInjectionSite getSite() {
        return this._site;
    }
}

