/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.wq.client.massinjection.MassInjectSiteTreeNode;
import hec.rss.wq.client.massinjection.SummaryPanel;
import hec.rss.wq.client.massinjection.SummaryPlotPanel;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.massinjection.MassInjectionReservoirType;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.massinjection.MassInjectionSiteData;
import hec.wqenginecore.massinjection.MassInjectionType;
import hec.wqengineimpl.geometry.WQSubDomainJunctionRef;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.massInjection.WQMassInjectionSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSiteData;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;

public class MassInjectSiteSummaryPanel
extends JPanel {
    private RmaJTextField _elementTypeFld;
    private JRadioButton _pointInjectionRadio;
    private JRadioButton _alongElemInjectionRadio;
    private JPanel _resInjectPanel;
    private RmaJRadioButton _resDepthRadio;
    private RmaJRadioButton _resElevRadio;
    private RmaJDecimalField _resDepthFld;
    private RmaJDecimalField _resElevFld;
    private JRadioButton _summaryRadio;
    private JRadioButton _stackedPlotRadio;
    private JPanel _cardPanel;
    private SummaryPanel _summaryPanel;
    private SummaryPlotPanel _summaryPlotPanel;
    private int _elemType = -1;
    private WQMassInjectionSiteData _data;
    private WQMassInjectionSet _miSet;
    private WQMassInjectionSite _site;
    private ConstituentSet _cSet;
    private MassInjectSiteTreeNode _node;

    public MassInjectSiteSummaryPanel(WQMassInjectionSet wQMassInjectionSet, MassInjectionSite massInjectionSite, MassInjectionSiteData massInjectionSiteData, MassInjectSiteTreeNode massInjectSiteTreeNode) {
        super(new GridBagLayout());
        this._node = massInjectSiteTreeNode;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        Serializable serializable = WqI18n.a("MI.MassInjectionSitePanel.Label.Element").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)5);
        this.add((Component)serializable, gridBagConstraints);
        this._elementTypeFld = new RmaJTextField();
        this._elementTypeFld.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MassInjectSiteSummaryPanel massInjectSiteSummaryPanel = this;
        massInjectSiteSummaryPanel.add((Component)massInjectSiteSummaryPanel._elementTypeFld, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this.add((Component)serializable, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = WqI18n.a("MI.MassInjectionSitePanel.Title.Type").getText();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jPanel, gridBagConstraints);
        this._pointInjectionRadio = WqI18n.a("MI.MassInjectionSitePanel.Radio.PointInjection").createJRadioButton();
        this._pointInjectionRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._pointInjectionRadio, gridBagConstraints);
        this._alongElemInjectionRadio = WqI18n.a("MI.MassInjectionSitePanel.Radio.AlongElemInjection").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._alongElemInjectionRadio, gridBagConstraints);
        this._resInjectPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        string = WqI18n.a("MI.MassInjectionSitePanel.Title.ResInjection").getText();
        this._resInjectPanel.setBorder(BorderFactory.createTitledBorder(string));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._resInjectPanel, gridBagConstraints);
        this._resDepthRadio = (RmaJRadioButton)WqI18n.a("MI.MassInjectionSitePanel.Radio.ResDepth").createJRadioButton();
        this._resDepthRadio.setSelected(true);
        this._resDepthRadio.setParameterId(Parameter.PARAMID_ELEV);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._resInjectPanel.add((Component)this._resDepthRadio, gridBagConstraints);
        this._resDepthFld = new RmaJDecimalField();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._resInjectPanel.add((Component)this._resDepthFld, gridBagConstraints);
        this._resElevRadio = (RmaJRadioButton)WqI18n.a("MI.MassInjectionSitePanel.Radio.ResElevation").createJRadioButton();
        this._resElevRadio.setParameterId(Parameter.PARAMID_ELEV);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._resInjectPanel.add((Component)this._resElevRadio, gridBagConstraints);
        this._resElevFld = new RmaJDecimalField();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._resInjectPanel.add((Component)this._resElevFld, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)serializable, gridBagConstraints);
        this._summaryRadio = new JRadioButton(WqI18n.a("BC.BoundaryConditionsEditor.JunctionSummaryCardPanel.Summary").getText());
        this._summaryRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._summaryRadio, gridBagConstraints);
        this._stackedPlotRadio = new JRadioButton(WqI18n.a("BC.BoundaryConditionsEditor.JunctionSummaryCardPanel.StackedPlot").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._stackedPlotRadio, gridBagConstraints);
        this._summaryPanel = new SummaryPanel();
        this._summaryPlotPanel = new SummaryPlotPanel();
        this._cardPanel = new JPanel(new CardLayout());
        this._cardPanel.add((Component)this._summaryPanel, "SUMMARY");
        this._cardPanel.add((Component)this._summaryPlotPanel, "PLOT");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        MassInjectSiteSummaryPanel massInjectSiteSummaryPanel2 = this;
        massInjectSiteSummaryPanel2.add((Component)massInjectSiteSummaryPanel2._cardPanel, gridBagConstraints);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._summaryRadio);
        ((ButtonGroup)serializable).add(this._stackedPlotRadio);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._pointInjectionRadio);
        ((ButtonGroup)serializable).add(this._alongElemInjectionRadio);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._resDepthRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this._resElevRadio);
        this.injectionTypeRadioAction();
        this.resInjectionPointRadioAction();
    }

    protected void addListeners() {
        this._pointInjectionRadio.addActionListener(actionEvent -> this.injectionTypeRadioAction());
        this._alongElemInjectionRadio.addActionListener(actionEvent -> this.injectionTypeRadioAction());
        this._resDepthRadio.addActionListener(actionEvent -> this.resInjectionPointRadioAction());
        this._resElevRadio.addActionListener(actionEvent -> this.resInjectionPointRadioAction());
        this._summaryRadio.addActionListener(this::summaryRadioButtonActionPerformed);
        this._stackedPlotRadio.addActionListener(actionEvent -> this.stackedPlotRadioButtonActionPerformed());
    }

    private void summaryRadioButtonActionPerformed(ActionEvent actionEvent) {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "SUMMARY");
    }

    private void stackedPlotRadioButtonActionPerformed() {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "PLOT");
    }

    private void injectionTypeRadioAction() {
        boolean bl = this._pointInjectionRadio.isSelected();
        bl = bl && this.getElementType() == 0;
        this._resInjectPanel.setEnabled(bl);
        if (bl) {
            this.resInjectionPointRadioAction();
        }
    }

    private int getElementType() {
        return this._elemType;
    }

    private void resInjectionPointRadioAction() {
        boolean bl = this._resDepthRadio.isSelected() && this._resInjectPanel.isEnabled();
        this._resDepthFld.setEnabled(bl && this._resInjectPanel.isEnabled());
        this._resElevFld.setEnabled(!bl && this._resInjectPanel.isEnabled());
    }

    public void fillPanel(WQMassInjectionSet wQMassInjectionSet, WQMassInjectionSite object, WQMassInjectionSiteData wQMassInjectionSiteData, ConstituentSet constituentSet) {
        this._miSet = wQMassInjectionSet;
        this._site = object;
        this._data = wQMassInjectionSiteData;
        this._cSet = constituentSet;
        if (wQMassInjectionSiteData == null) {
            return;
        }
        wQMassInjectionSet = (WQSubDomainJunctionRef)wQMassInjectionSiteData.getSubDomainJunctionRef();
        if (wQMassInjectionSet != null) {
            this._elementTypeFld.setText("Junction - ".concat(wQMassInjectionSet.getName()));
            this._elemType = 2;
            this._pointInjectionRadio.setSelected(true);
            this._alongElemInjectionRadio.setEnabled(false);
        } else {
            wQMassInjectionSet = (WQSubDomainRef)wQMassInjectionSiteData.getSubDomainRef();
            if (wQMassInjectionSet != null) {
                object = "Reach";
                this._elemType = 1;
                if (wQMassInjectionSet.getType() == SubDomainType.RESERVOIR_1DV) {
                    this._elemType = 0;
                    object = "Reservoir";
                }
                this._elementTypeFld.setText(object.concat(" - ").concat(wQMassInjectionSet.getName()));
                this._alongElemInjectionRadio.setEnabled(true);
            } else {
                wQMassInjectionSet = (WQSubDomainJunctionRef)wQMassInjectionSiteData.getSubDomainJunctionRef();
                if (wQMassInjectionSet != null) {
                    this._elementTypeFld.setText("Junction - " + wQMassInjectionSet.getName());
                    this._elemType = 2;
                    this._pointInjectionRadio.setSelected(true);
                    this._alongElemInjectionRadio.setEnabled(false);
                }
            }
        }
        wQMassInjectionSet = wQMassInjectionSiteData.getMassInjectionType();
        object = wQMassInjectionSiteData.getMassInjectionReservoirType();
        double d = wQMassInjectionSiteData.getReservoirInjectionDepth();
        double d2 = wQMassInjectionSiteData.getReservoirInjectionElevation();
        if (wQMassInjectionSet == MassInjectionType.Distrbuted && this._elemType != 2) {
            this._alongElemInjectionRadio.setSelected(true);
        } else {
            this._pointInjectionRadio.setSelected(true);
        }
        if (object == MassInjectionReservoirType.Elevation) {
            this._resElevRadio.setSelected(true);
        } else {
            this._resDepthRadio.setSelected(true);
        }
        int n = ClientApp.Workspace().getUnitSystem();
        this._resDepthFld.setValue(new ParamDouble(d, Parameter.PARAMID_ELEV, n, 3));
        this._resElevFld.setValue(new ParamDouble(d2, Parameter.PARAMID_ELEV, n, 3));
        this.fillSummaryPanels();
        this.injectionTypeRadioAction();
        this.resInjectionPointRadioAction();
    }

    private void fillSummaryPanels() {
        this._summaryPanel.fillPanel(this._miSet, this._site, this._data, this._cSet, this._node);
        this._summaryPlotPanel.fillPanel(this._miSet, this._site, this._data, this._cSet, this._node);
    }

    public void savePanel(WQMassInjectionSet wQMassInjectionSet) {
        WQMassInjectionSiteData wQMassInjectionSiteData = this._data;
        if (wQMassInjectionSet != null) {
            wQMassInjectionSiteData = (WQMassInjectionSiteData)wQMassInjectionSet.getMassInjectionSiteData((MassInjectionSite)this._site);
        }
        if (wQMassInjectionSiteData == null) {
            return;
        }
        wQMassInjectionSet = MassInjectionType.Point;
        if (this._alongElemInjectionRadio.isSelected()) {
            wQMassInjectionSet = MassInjectionType.Distrbuted;
        }
        MassInjectionReservoirType massInjectionReservoirType = MassInjectionReservoirType.Depth;
        if (this._resElevRadio.isSelected()) {
            massInjectionReservoirType = MassInjectionReservoirType.Elevation;
        }
        double d = this._resDepthFld.getValue();
        double d2 = this._resElevFld.getValue();
        wQMassInjectionSiteData.setMassInjectionType((MassInjectionType)wQMassInjectionSet);
        wQMassInjectionSiteData.setMassInjectionReservoirType(massInjectionReservoirType);
        wQMassInjectionSiteData.setReservoirInjectionDepth(d);
        wQMassInjectionSiteData.setReservoirInjectionElevation(d2);
    }

    public void updatePanel() {
        this.fillSummaryPanels();
    }
}

