/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import hec.rss.wq.client.initialcondition.ConstituentComparator;
import hec.rss.wq.client.massinjection.ConstituentTreeNode;
import hec.rss.wq.client.massinjection.MassInjectSiteSummaryPanel;
import hec.rss.wq.ui.DataSource;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.massinjection.MassInjectionSiteData;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSiteData;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import rma.services.ServiceLookup;
import rma.swing.RmaImage;
import rma.util.RMASort;

public class MassInjectSiteTreeNode
extends DefaultMutableTreeNode
implements DataSource {
    private static ImageIcon a = RmaImage.getImageIcon((String)"Images/rss/wq/massInjectionTool23.png");
    private WQMassInjectionSiteData _data;
    private WQConstituentSet _cset;
    private WQMassInjectionSet _miSet;
    private MassInjectSiteSummaryPanel _panel;

    public MassInjectSiteTreeNode(WQMassInjectionSite wQMassInjectionSite, WQMassInjectionSet wQMassInjectionSet, WQConstituentSet wQConstituentSet, WQMassInjectionSiteData wQMassInjectionSiteData) {
        super(wQMassInjectionSite);
        this._data = wQMassInjectionSiteData;
        this._cset = wQConstituentSet;
        this._miSet = wQMassInjectionSet;
        this.addConstituentNodes(wQConstituentSet, (MassInjectionSiteData)wQMassInjectionSiteData);
    }

    private void addConstituentNodes(WQConstituentSet object, MassInjectionSiteData object2) {
        this.removeAllChildren();
        if (object == null || object2 == null) {
            return;
        }
        object = object.getConstituentList();
        object = new ArrayList(object);
        object2 = ((WQMassInjectionSiteData)object2).getConstituents((List)object);
        Collections.sort(object2, new ConstituentComparator());
        for (int i = 0; i < object2.size(); ++i) {
            object = (Constituent)object2.get(i);
            object = new ConstituentTreeNode(this._miSet, this.getSite(), (Constituent)object);
            this.add((MutableTreeNode)object);
        }
    }

    public void updateConstituentNodes() {
        MassInjectSiteTreeNode massInjectSiteTreeNode = this;
        massInjectSiteTreeNode.addConstituentNodes(massInjectSiteTreeNode._cset, (MassInjectionSiteData)this._data);
    }

    @Override
    public Icon getIcon() {
        return a;
    }

    @Override
    public String getName() {
        return this.getSite().getName();
    }

    @Override
    public JComponent getComponent() {
        if (this._panel == null) {
            this._panel = new MassInjectSiteSummaryPanel(this._miSet, (MassInjectionSite)this.getSite(), (MassInjectionSiteData)this._data, this);
        }
        this._panel.fillPanel(this._miSet, this.getSite(), this._data, (ConstituentSet)this._cset);
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)this._panel);
        return this._panel;
    }

    @Override
    public void validateData() throws IOException {
    }

    @Override
    public void save() throws IOException {
        MassInjectSiteTreeNode massInjectSiteTreeNode = this;
        massInjectSiteTreeNode.save(massInjectSiteTreeNode._miSet);
    }

    public void save(WQMassInjectionSet wQMassInjectionSet) throws IOException {
        ConstituentTreeNode constituentTreeNode;
        int n;
        WQMassInjectionSet wQMassInjectionSet2 = this._miSet;
        WQMassInjectionSiteData wQMassInjectionSiteData = this._data;
        if (wQMassInjectionSet != null) {
            wQMassInjectionSet2 = wQMassInjectionSet;
            wQMassInjectionSiteData = (WQMassInjectionSiteData)wQMassInjectionSet2.getMassInjectionSiteData((MassInjectionSite)this.getSite());
        }
        int n2 = this.getChildCount();
        if (this._panel != null) {
            this._panel.savePanel(wQMassInjectionSet2);
        }
        ArrayList<ConstituentTreeNode> arrayList = new ArrayList<ConstituentTreeNode>();
        for (n = 0; n < n2; ++n) {
            constituentTreeNode = (ConstituentTreeNode)this.getChildAt(n);
            if ((constituentTreeNode = constituentTreeNode.getConstituent()) == null) continue;
            arrayList.add(constituentTreeNode);
        }
        wQMassInjectionSiteData.setConstituents(arrayList);
        for (n = 0; n < n2; ++n) {
            constituentTreeNode = (ConstituentTreeNode)this.getChildAt(n);
            constituentTreeNode.save(wQMassInjectionSet2);
        }
        this.updatePanel();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public WQMassInjectionSite getSite() {
        return (WQMassInjectionSite)this.getUserObject();
    }

    public void selectSiteConstituentsAction() {
    }

    public WQConstituentSet getConstituentSet() {
        return this._cset;
    }

    public MassInjectionSiteData getSiteData() {
        return this._data;
    }

    public void setConstituents(List<Constituent> list) {
        int n;
        Object object = this.getExistingConstituentNodes(list);
        this.removeAllChildren();
        if (list == null) {
            return;
        }
        Collections.sort(list, new ConstituentComparator());
        ArrayList<Constituent> arrayList = new ArrayList<Constituent>();
        arrayList.addAll((Collection<Constituent>)object);
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            object = new ConstituentTreeNode(this._miSet, this.getSite(), (Constituent)object);
            arrayList.add((Constituent)object);
        }
        RMASort.quickSort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            this.add((MutableTreeNode)arrayList.get(n));
        }
    }

    private List<ConstituentTreeNode> getExistingConstituentNodes(List<Constituent> list) {
        ArrayList<ConstituentTreeNode> arrayList = new ArrayList<ConstituentTreeNode>();
        if (list == null) {
            return arrayList;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ConstituentTreeNode constituentTreeNode = (ConstituentTreeNode)this.getChildAt(i);
            if (!list.contains(constituentTreeNode.getConstituent())) continue;
            arrayList.add(constituentTreeNode);
            list.remove(constituentTreeNode.getConstituent());
        }
        return arrayList;
    }

    public void updatePanel() {
        if (this._panel != null) {
            this._panel.fillPanel(this._miSet, this.getSite(), this._data, (ConstituentSet)this._cset);
        }
    }

    public List<Constituent> getConstituents() {
        return this.getConstituentsFromNodes();
    }

    private List<Constituent> getConstituentsFromNodes() {
        int n = this.getChildCount();
        ArrayList<Constituent> arrayList = new ArrayList<Constituent>();
        for (int i = 0; i < n; ++i) {
            ConstituentTreeNode constituentTreeNode = (ConstituentTreeNode)this.getChildAt(i);
            constituentTreeNode = constituentTreeNode.getConstituent();
            arrayList.add((Constituent)constituentTreeNode);
        }
        return arrayList;
    }

    public void setDisplayUnitsSystem(int n) {
        if (this._panel != null) {
            ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)this._panel);
        }
    }

    public boolean hasComponent() {
        return this._panel != null;
    }
}

