/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.massinjection.MassInjectionDrawPropData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJFontButton;

public class MassInjectionDrawPropDataPanel
extends JPanel {
    private MassInjectionDrawPropData _miDrawPropData;
    private final int _scale;
    RmaJColorComboBox _miColorComboBox;
    RmaJCheckBox _drawNameCB;
    RmaJFontButton _nameFontBtn;

    public MassInjectionDrawPropDataPanel(MassInjectionDrawPropData massInjectionDrawPropData, int n) {
        this._miDrawPropData = massInjectionDrawPropData;
        this._scale = n;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JComponent jComponent = new JLabel("Mass Injection Color:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        this._miColorComboBox = new RmaJColorComboBox();
        this._miColorComboBox.setModifiable(true);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        MassInjectionDrawPropDataPanel massInjectionDrawPropDataPanel = this;
        massInjectionDrawPropDataPanel.add((Component)massInjectionDrawPropDataPanel._miColorComboBox, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        this.add((Component)jComponent, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
        this._drawNameCB = new RmaJCheckBox("Draw Station Name");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        jComponent.add((Component)this._drawNameCB, gridBagConstraints);
        this._nameFontBtn = new RmaJFontButton("Font...");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jComponent.add((Component)this._nameFontBtn, gridBagConstraints);
    }

    private void fillPanel() {
        if (this._miDrawPropData == null) {
            return;
        }
        this._miColorComboBox.setSelectedColor(this._miDrawPropData.getColor());
        this._drawNameCB.setSelected(this._miDrawPropData.getDrawName());
        this._nameFontBtn.setFont(this._miDrawPropData.getNameFont());
    }

    public void savePanel() {
        if (this._miDrawPropData == null) {
            return;
        }
        this._miDrawPropData.setDrawName(this._drawNameCB.isSelected());
        this._miDrawPropData.setNameFont(this._nameFontBtn.getFont());
        this._miDrawPropData.setColor(this._miColorComboBox.getSelectedColor());
        this._miDrawPropData.save(this._scale);
    }

    public void setToDefaults() {
        ((WaterQualityDPData)this._miDrawPropData).setDefaults();
        this.fillPanel();
    }

    public MassInjectionDrawPropData copyData(int n) {
        return MassInjectionDrawPropData.a(n, this._miDrawPropData);
    }

    public void fillPanel(MassInjectionDrawPropData massInjectionDrawPropData) {
        this._miDrawPropData = massInjectionDrawPropData;
        this.fillPanel();
    }
}

