/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.SelectorPanelEditor;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.massinjection.MassInjectSiteTreeNode;
import hec.rss.wq.client.massinjection.MassInjectionPanel;
import hec.rss.wq.client.massinjection.actions.DeleteMassInjectionSetAction;
import hec.rss.wq.client.massinjection.actions.NewMassInjectionSetAction;
import hec.rss.wq.client.massinjection.actions.RenameMassInjectionSetAction;
import hec.rss.wq.client.massinjection.actions.SaveMassInjectionSetAsAction;
import hec.rss.wq.client.massinjection.actions.SelectMassInjectionSitesAction;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;

public class MassInjectionEditor
extends SelectorPanelEditor {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private String _title;
    private RmaJTextField _wqConstituentNameText;
    private RmaJTextField _geometryNameTxt;
    private JMenu _wqSetMenu;
    private JMenuItem _menuItemNew;
    private JMenuItem _menuItemSaveAs;
    private JMenuItem _menuItemDelete;
    private ManagerProxyListContainer _wksp;
    private MassInjectionSetManager _miMgr;
    private MassInjectionPanel _massInjectionPanel;
    private JMenuItem _menuItemSetActiveSites;
    private JPanel _messagesPanel;
    private RmaJTextField _msgText;

    public MassInjectionEditor(JFrame jFrame) {
        super((Frame)jFrame, false);
        this.createControls();
        this.addListeners();
        this.setSize(730, 530);
        this.setLocationRelativeTo(jFrame);
    }

    private void createControls() {
        this._title = WqI18n.a("MI.MassInjectionEditor.Title").getText();
        MassInjectionEditor massInjectionEditor = this;
        massInjectionEditor.setTitle(massInjectionEditor._title);
        this.buildMenubar();
        JComponent jComponent = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.getSelectorPanel().add((Component)jComponent, (Object)gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jComponent.add((Component)jPanel, gridBagConstraints);
        jComponent = WqI18n.a("IC.InitialConditionsEditor.Label.ConstituentSet").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._wqConstituentNameText = new RmaJTextField();
        this._wqConstituentNameText.setEditable(false);
        ((JLabel)jComponent).setLabelFor((Component)this._wqConstituentNameText);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._wqConstituentNameText, gridBagConstraints);
        jComponent = WqI18n.a("IC.InitialConditionsEditor.Label.Geometry").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._geometryNameTxt = new RmaJTextField();
        this._geometryNameTxt.setEditable(false);
        ((JLabel)jComponent).setLabelFor((Component)this._geometryNameTxt);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._geometryNameTxt, gridBagConstraints);
        this._massInjectionPanel = new MassInjectionPanel();
        MassInjectionEditor massInjectionEditor2 = this;
        massInjectionEditor2.addPanel(massInjectionEditor2._massInjectionPanel);
        this._messagesPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getBottomPanel().add((Component)this._messagesPanel, gridBagConstraints);
        this._msgText = new RmaJTextField();
        this._msgText.setEditable(false);
        this._msgText.setBorder(null);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._messagesPanel.add((Component)this._msgText, gridBagConstraints);
        this._messagesPanel.setVisible(false);
    }

    private void buildMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        this._wqSetMenu = WqI18n.a("MI.MassInjectionEditor.Menu.MassInjection").createMenu();
        this._menuItemNew = WqI18n.a("Dispersion.Editor.Menu.New").createMenuItem();
        this._wqSetMenu.add(this._menuItemNew);
        this._wqSetMenu.addSeparator();
        this._menuItemSetActiveSites = WqI18n.a("MI.MassInjectionEditor.Menu.SetActiveSites").createMenuItem();
        this._wqSetMenu.add(this._menuItemSetActiveSites);
        this._wqSetMenu.addSeparator();
        this._menuItemSaveAs = WqI18n.a("Dispersion.Editor.Menu.SaveAs").createMenuItem();
        this._wqSetMenu.add(this._menuItemSaveAs);
        this._menuItemDelete = WqI18n.a("Dispersion.Editor.Menu.Delete").createMenuItem();
        this._wqSetMenu.add(this._menuItemDelete);
        jMenuBar.add(this._wqSetMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void addListeners() {
        this._menuItemNew.addActionListener(actionEvent -> this.newMassInjectionSetAction());
        this._menuItemSaveAs.addActionListener(actionEvent -> this.saveMassInjectionSetAsAction());
        this._menuItemDelete.addActionListener(actionEvent -> this.deleteMassInjectionSetAction());
        this._menuItemSetActiveSites.addActionListener(actionEvent -> this.setActiveMassInjectionSitesAction());
    }

    private void setActiveMassInjectionSitesAction() {
        MassInjectionEditor massInjectionEditor = this;
        new SelectMassInjectionSitesAction(massInjectionEditor, massInjectionEditor._miMgr).a();
    }

    private void deleteMassInjectionSetAction() {
        ManagerProxyWrapper managerProxyWrapper = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (managerProxyWrapper == null) {
            return;
        }
        ManagerProxy managerProxy = managerProxyWrapper.getManagerProxy();
        managerProxy = managerProxy.getId();
        DeleteMassInjectionSetAction deleteMassInjectionSetAction = new DeleteMassInjectionSetAction((Dialog)((Object)this));
        if ((managerProxy = deleteMassInjectionSetAction.a((Identifier)managerProxy)) != null) {
            this.setModified(false);
            this.getSelectorPanel().getComboBox().removeItem((Object)managerProxyWrapper);
            if (this.getSelectorPanel().getSelectedItem() == null && this.getSelectorPanel().getSelectorItems().size() > 0) {
                this.getSelectorPanel().setSelectedIndex(0);
                return;
            }
            this.clearForm();
            this.setDialogEnabled(false);
            this.setModified(false);
        }
    }

    public void clearForm() {
        MassInjectionEditor massInjectionEditor = this;
        massInjectionEditor.clearForm((Container)((Object)massInjectionEditor));
    }

    private void renamemassInjectionSetAction() {
        Object object = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object == null) {
            return;
        }
        object = object.getManagerProxy();
        object = (MassInjectionSetManager)object.loadManager(null, null);
        RenameMassInjectionSetAction renameMassInjectionSetAction = new RenameMassInjectionSetAction((Dialog)((Object)this));
        if ((object = renameMassInjectionSetAction.a((MassInjectionSetManager)object, this.getSelectorPanel().getDescription())) != null) {
            this.getSelectorPanel().getComboBox().repaint();
            this.getSelectorPanel().setDescription(((JsonManager)((Object)object)).getDescription());
        }
    }

    private void saveMassInjectionSetAsAction() {
        Object object;
        boolean bl;
        MassInjectionSetManager massInjectionSetManager;
        int n;
        Identifier identifier;
        RmiFileManager rmiFileManager;
        Object object2;
        block21: {
            object2 = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
            if (object2 == null) {
                return;
            }
            object2 = object2.getManagerProxy();
            object2 = (MassInjectionSetManager)object2.loadManager(null, null);
            Object object3 = this._miMgr.getIdentifier();
            object3 = object3.getPath();
            object3 = object3.concat(".temp");
            rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            object3 = new Identifier((String)object3);
            identifier = null;
            try {
                identifier = rmiFileManager.newFile(UserId.getUserId(), object3);
                if (identifier == null) {
                    identifier = rmiFileManager.openFile(UserId.getUserId(), object3);
                }
            }
            catch (RemoteException remoteException) {
                object3 = remoteException;
                remoteException.printStackTrace();
            }
            n = this.isModified();
            massInjectionSetManager = this._miMgr;
            if (identifier != null) {
                this._miMgr.writeFile(identifier);
                if (this.isModified()) {
                    if (!super.saveForm()) {
                        return;
                    }
                    this._miMgr.setModified(true);
                }
            }
            bl = false;
            if (n == 0 || object2 == null) break block21;
            String string = WqI18n.a("MI.MassInjectionEditor.Msg.SaveMgr").format(object2);
            int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), string, (String)(object = WqI18n.a("MI.MassInjectionEditor.Msg.SaveMgr.Title").getText()), 1);
            if (n2 == 0) {
                bl = true;
                break block21;
            }
            if (2 != n2) break block21;
            massInjectionSetManager.readFile(identifier);
            this._wksp.saveManager("rss", (Manager)massInjectionSetManager);
            try {
                rmiFileManager.deleteFile(identifier.getPath());
            }
            catch (RemoteException remoteException) {
                System.out.println("saveInitialConditionsSetAsAction: exception deleting file " + identifier.getPath() + " error:" + String.valueOf(remoteException));
            }
            EventQueue.invokeLater(() -> this.setCursor(Cursor.getDefaultCursor()));
            return;
        }
        try {
            Object object4 = new SaveMassInjectionSetAsAction((Dialog)((Object)this));
            object = ((SaveMassInjectionSetAsAction)object4).a((MassInjectionSetManager)object2, this.getSelectorPanel().getDescription());
            if (object != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (n != 0) {
                    this._wksp.saveManager("rss", (Manager)this._miMgr);
                }
                object4 = ((JsonManager)((Object)object)).getName();
                object2 = ((JsonManager)((Object)object)).getDescription();
                n = ((JsonManager)((Object)object)).getIndex();
                ((JsonManager)((Object)object)).readFile(this._miMgr.getIdentifier());
                ((MassInjectionSetManager)object).setName((String)object4);
                ((MassInjectionSetManager)object).setDescription((String)object2);
                object.setIndex(n);
                this._wksp.saveManager("rss", (Manager)object);
                this.setModified(false);
                object2 = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
                this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object2), true);
                MassInjectionEditor.a((MassInjectionSetManager)object);
            }
            return;
        }
        finally {
            if (!bl) {
                massInjectionSetManager.readFile(identifier);
                this._wksp.saveManager("rss", (Manager)massInjectionSetManager);
            }
            try {
                rmiFileManager.deleteFile(identifier.getPath());
            }
            catch (RemoteException remoteException) {
                System.out.println("saveInitialConditionsSetAsAction: exception deleting file " + identifier.getPath() + " error:" + String.valueOf(remoteException));
            }
            EventQueue.invokeLater(() -> this.setCursor(Cursor.getDefaultCursor()));
        }
    }

    private void newMassInjectionSetAction() {
        Object object = new NewMassInjectionSetAction((Dialog)((Object)this));
        if ((object = ((NewMassInjectionSetAction)object).h()) != null) {
            ManagerProxy managerProxy = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
            this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper(managerProxy), true);
            MassInjectionEditor.a((MassInjectionSetManager)object);
        }
    }

    private static void a(MassInjectionSetManager massInjectionSetManager) {
        WaterQualityMode waterQualityMode = (WaterQualityMode)ClientApp.frame().getCurrentModule();
        waterQualityMode.setMassInjectionSet(massInjectionSetManager);
    }

    public void fillForm(NamedType namedType) {
        super.fillForm(namedType);
        this.setErrorMessage(null);
        if (namedType instanceof ManagerProxyWrapper) {
            namedType = (ManagerProxyWrapper)namedType;
            namedType = namedType.getManagerProxy();
            this._miMgr = (MassInjectionSetManager)namedType.loadManager(null, null);
            MassInjectionEditor massInjectionEditor = this;
            massInjectionEditor.setDialogEnabled(massInjectionEditor._miMgr != null);
            if (this._miMgr != null) {
                this._miMgr.getSet();
                int n = this._miMgr.getGeometryId();
                Object object = this._miMgr.getProxyList().getManagerProxy("rss", WqGeometry.class.getName(), n);
                if (object != null) {
                    RssSystem rssSystem;
                    this._geometryNameTxt.setText(object.getName());
                    this._geometryNameTxt.setForeground(UIManager.getColor("TextField.foreground"));
                    object = (WqGeometry)object.loadManager(null, null);
                    if (object != null && (rssSystem = ((WqGeometry)((Object)object)).getNetwork()) == null) {
                        object = WqI18n.a("Mi.MassInjectionEditor.Msg.FailedToFindNetwork").format((Object)((JsonManager)((Object)object)).getName());
                        this.setErrorMessage((String)object);
                    }
                } else {
                    object = WqI18n.a("MI.MassInjectionEditor.Geo.NotFound").getText();
                    this._geometryNameTxt.setText((String)object);
                    this._geometryNameTxt.setForeground(Color.RED);
                    String string = WqI18n.a("Mi.MassInjectionEditor.Msg.FailedToFindGeometry").format((Object)((JsonManager)this._miMgr).getName());
                    this.setErrorMessage(string);
                }
                int n2 = this._miMgr.getConstituentSetId();
                Object object2 = this._miMgr.getProxyList().getManagerProxy("rss", ConstituentSetManager.class.getName(), n2);
                if (object2 != null) {
                    this._wqConstituentNameText.setText(object2.getName());
                } else {
                    this._wqConstituentNameText.setText("");
                    object2 = WqI18n.a("Mi.MassInjectionEditor.Msg.FailedToFindConstituentSet").format((Object)((JsonManager)this._miMgr).getName());
                    this.setErrorMessage((String)object2);
                }
            }
            this.setModified(false);
        }
    }

    public boolean saveForm(NamedType namedType) {
        MassInjectionSetManager massInjectionSetManager = this._miMgr;
        if (namedType instanceof MassInjectionSetManager) {
            massInjectionSetManager = (MassInjectionSetManager)namedType;
        }
        if (massInjectionSetManager == null) {
            return true;
        }
        boolean bl = super.saveForm(namedType);
        if (bl) {
            this.setModified(false);
            this._miMgr.setModified(true);
        }
        return bl;
    }

    public void fillForm(ManagerProxyListContainer object) {
        this._wksp = object;
        Component[] componentArray = this._wqSetMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == this._menuItemSetActiveSites) continue;
            componentArray[i].setVisible(this._wksp instanceof ClientWorkspace);
        }
        Vector vector = object.getManagerProxyList("rss", MassInjectionSetManager.class.getName());
        object = vector.stream().map(managerProxy -> new ManagerProxyWrapper((ManagerProxy)managerProxy)).collect(Collectors.toList());
        this.getSelectorPanel().setSelectionList((Collection)object);
        if (vector.isEmpty()) {
            this.getSelectorPanel().setSelectedIndex(-1);
            this.setDialogEnabled(false);
            return;
        }
        this.getSelectorPanel().setSelectedIndex(0);
    }

    private void setDialogEnabled(boolean bl) {
        this._menuItemDelete.setEnabled(bl);
        this._menuItemSaveAs.setEnabled(bl);
        this._menuItemSetActiveSites.setEnabled(bl);
    }

    public void setSelectedMassInjection(MassInjectionSetManager object) {
        if (object != null) {
            object = object.getProxyList().getManagerProxy(object.getIdentifier());
            object = new ManagerProxyWrapper((ManagerProxy)object);
            this.selectorPanel.setSelectedItem(object);
        }
    }

    public void setSelectedMassInjectionSite(WQMassInjectionSite wQMassInjectionSite) {
        if (wQMassInjectionSite == null || this.getSelectorPanel().getSelectedItem() == null) {
            return;
        }
        this._massInjectionPanel.setSelectedMassInjectionSite(wQMassInjectionSite);
    }

    public void siteNodeChanged(WQMassInjectionSite wQMassInjectionSite) {
        if (wQMassInjectionSite == null || this.getSelectorPanel().getSelectedItem() == null) {
            return;
        }
        this._massInjectionPanel.siteNodeChanged(wQMassInjectionSite);
    }

    public void removeMassInjectionSite(WQMassInjectionSite wQMassInjectionSite) {
        this._massInjectionPanel.removeMassInjectionSite(wQMassInjectionSite);
    }

    public void setSites(List<MassInjectionSite> list) {
        this._massInjectionPanel.setSites(list);
    }

    public List<MassInjectSiteTreeNode> getSiteNodes() {
        return this._massInjectionPanel.getSiteNodes();
    }

    public void setErrorMessage(String string) {
        this._messagesPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atWarning()).log(string);
            this._msgText.setForeground(Color.RED);
            return;
        }
        this._msgText.setText("");
    }

    public void setMessage(String string) {
        this._messagesPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atInfo()).log(string);
            this._msgText.setForeground(UIManager.getColor("TextField.foreground"));
            return;
        }
        this._msgText.setText("");
    }
}

