/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.lang.NamedType;
import hec.rss.client.RSimSimulationMode;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.WqUiUtils;
import hec.rss.wq.client.initialcondition.ConstituentComparator;
import hec.rss.wq.client.initialcondition.InitialConditionsTabPanel;
import hec.rss.wq.client.massinjection.ConstituentTreeNode;
import hec.rss.wq.client.massinjection.CopyFromSiteDialog;
import hec.rss.wq.client.massinjection.MassInjectSiteSummaryPanel;
import hec.rss.wq.client.massinjection.MassInjectSiteTreeNode;
import hec.rss.wq.client.massinjection.MassInjectionPanel$1;
import hec.rss.wq.client.massinjection.MassInjectionPanel$2;
import hec.rss.wq.client.massinjection.MassInjectionPanel$HeaderPanelVisibleRule;
import hec.rss.wq.client.massinjection.MassInjectionSetPanel;
import hec.rss.wq.client.massinjection.MassInjectionSummaryTreeNode;
import hec.rss.wq.client.massinjection.MassInjectionTreeModel;
import hec.rss.wq.client.massinjection.SelectConstituentTopPanel;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.massinjection.MassInjectionManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.PreventRootNodeFromCollapseListener;
import hec.rss.wq.ui.ToggleableFilterMoverDialog;
import hec.rss.wq.ui.ViewDisplayHeader$VisibleRule;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.massinjection.MassInjectionSiteData;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSiteData;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.swing.FormManagementListener;
import rma.util.RMASort;

public class MassInjectionPanel
extends InitialConditionsTabPanel
implements FormManagementListener {
    private MassInjectionSetManager _currentMiMgr;
    private String _tabName;
    private MassInjectionTreeModel _treeModel;
    private MassInjectionManager _massInjectionMgr;
    private MouseAdapter _popupMouseAdapter;
    private boolean _updateTree = true;
    private PreventRootNodeFromCollapseListener _rootNodeCantCollapse;
    private TreeNode _selectedTreeNode;
    private TreeSelectionListener _treeSelectionListener;

    public MassInjectionPanel() {
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._tabName = WqI18n.a("MI.MassInjectionPanel.TabName").getText();
        this._treeSelectorPanel.setNameLabel(WqI18n.a("MI.MassInjectionPanel.Label.MassInjection").getText());
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof WaterQualityMode) {
            WaterQualityMode cfr_ignored_0 = (WaterQualityMode)clientMode;
            this._massInjectionMgr = this.getMassInjectionManager();
            return;
        }
        if (clientMode instanceof RSimSimulationMode) {
            RSimSimulationMode cfr_ignored_1 = (RSimSimulationMode)clientMode;
            this._massInjectionMgr = this.getMassInjectionManager();
        }
    }

    private MassInjectionManager getMassInjectionManager() {
        Object object = ClientApp.frame().getCurrentMode();
        if (object instanceof WaterQualityMode) {
            object = (WaterQualityMode)object;
            return object.getMassInjectionManager();
        }
        if (object instanceof RSimSimulationMode) {
            object = (RSimSimulationMode)object;
            return object.getMassInjectionMgr();
        }
        return null;
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this._popupMouseAdapter = new MassInjectionPanel$1(this);
        this._rootNodeCantCollapse = new PreventRootNodeFromCollapseListener();
        this._treeSelectionListener = new MassInjectionPanel$2(this);
    }

    @Override
    protected void updateSelectorPanel(DataSource dataSource) {
        if (dataSource instanceof ConstituentTreeNode) {
            dataSource = (ConstituentTreeNode)dataSource;
            dataSource = ((ConstituentTreeNode)dataSource).getSite();
            try {
                this._treeSelectorPanel.setSelectedItem((Object)dataSource);
            }
            finally {
                this._updateTree = true;
            }
        } else if (dataSource instanceof MassInjectSiteTreeNode) {
            dataSource = (MassInjectSiteTreeNode)dataSource;
            dataSource = ((MassInjectSiteTreeNode)dataSource).getSite();
            this._treeSelectorPanel.setSelectedItem((Object)dataSource);
            this.selectSiteInMap((WQMassInjectionSite)dataSource);
        }
    }

    private void selectSiteInMap(WQMassInjectionSite wQMassInjectionSite) {
        if (wQMassInjectionSite == null) {
            return;
        }
        WqUiUtils.a(wQMassInjectionSite);
    }

    @Override
    protected boolean updateTreeFromSelection() {
        return this._updateTree;
    }

    @Override
    protected void updateTreeWithSelection() {
        int n = this._treeSelectorPanel.getSelectedIndex();
        if (n == -1) {
            return;
        }
        JTree jTree = this.getTreeView().a();
        Object object = (TreeNode[])jTree.getModel().getRoot();
        if (((DefaultMutableTreeNode)object).getChildCount() > n) {
            Object object2 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(n);
            if (this._selectedTreeNode instanceof ConstituentTreeNode) {
                object = this._selectedTreeNode.toString();
                if ((object = this.findChildOfName((DefaultMutableTreeNode)object2, (String)object)) != null) {
                    object2 = object;
                }
            }
            object = ((DefaultMutableTreeNode)object2).getPath();
            object = new TreePath((Object[])object);
            this._selectedTreeNode = (TreeNode)((TreePath)object).getLastPathComponent();
            jTree.setSelectionPath((TreePath)object);
        }
    }

    private DefaultMutableTreeNode findChildOfName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode == null || string == null) {
            return null;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!string.equals(treeNode.toString())) continue;
            return (DefaultMutableTreeNode)treeNode;
        }
        return null;
    }

    protected void treePopupMenu(Point point) {
        JTree jTree = this.getTreeView().a();
        TreePath treePath = jTree.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        jTree.setSelectionPath(treePath);
        if (object instanceof MassInjectionSummaryTreeNode) {
            this.summaryTreeNodePopup(point, jTree);
            return;
        }
        if (object instanceof MassInjectSiteTreeNode) {
            this.siteTreeNodePopup(point, jTree, (MassInjectSiteTreeNode)object);
        }
    }

    private void siteTreeNodePopup(Point point, JTree jTree, MassInjectSiteTreeNode massInjectSiteTreeNode) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = WqI18n.a("MI.MassInjectionEditor.Menu.SelectConstituents").createMenuItem();
        jMenuItem.addActionListener(actionEvent -> this.selectSiteConstituentsAction(massInjectSiteTreeNode));
        jPopupMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("MI.MassInjectionEditor.Menu.CopyFrom").createMenuItem();
        jMenuItem.addActionListener(actionEvent -> this.copyFromSiteAction(massInjectSiteTreeNode));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(jTree, point.x, point.y);
    }

    private void copyFromSiteAction(MassInjectSiteTreeNode objectArray) {
        Object object = this._massInjectionMgr.getMassInjectionSites();
        object = new ArrayList<WQMassInjectionSite>((Collection<WQMassInjectionSite>)object);
        object = this._currentMiMgr.getSet().getMassInjectionSiteList(object);
        WQMassInjectionSite wQMassInjectionSite = objectArray.getSite();
        object = new CopyFromSiteDialog(SwingUtilities.windowForComponent((Component)((Object)this)), (List<MassInjectionSite>)object, wQMassInjectionSite);
        object.setVisible(true);
        if (((CopyFromSiteDialog)((Object)object)).isCanceled()) {
            return;
        }
        if ((object = ((CopyFromSiteDialog)((Object)object)).getCopyFromSite()) != null) {
            WQMassInjectionSet wQMassInjectionSet = (WQMassInjectionSet)this._currentMiMgr.getSet();
            wQMassInjectionSite = wQMassInjectionSet.getMassInjectionSiteData((MassInjectionSite)wQMassInjectionSite);
            object = wQMassInjectionSet.getMassInjectionSiteData((MassInjectionSite)object);
            wQMassInjectionSite.copyFrom((MassInjectionSiteData)object, (List)this._currentMiMgr.getConstituentSet().getSet().getConstituentList());
            objectArray.updateConstituentNodes();
            this._treeModel.nodeStructureChanged((TreeNode)objectArray);
            objectArray.updatePanel();
            objectArray = objectArray.getPath();
            this.getTreeView().a().expandPath(new TreePath(objectArray));
            this.setModified(true);
        }
    }

    private void selectSiteConstituentsAction(MassInjectSiteTreeNode serializable) {
        Object object = (JDialog)SwingUtilities.windowForComponent((Component)((Object)this));
        object = new ToggleableFilterMoverDialog((JDialog)object, true, false);
        object.setTitle(WqI18n.a("MI.SelectConstituentPanel.Title").getText());
        Object object2 = serializable.getConstituentSet();
        SelectConstituentTopPanel selectConstituentTopPanel = new SelectConstituentTopPanel((MassInjectionSite)serializable.getSite(), (WQConstituentSet)object2);
        object.addTopPanel(selectConstituentTopPanel);
        object.setAvailableListLabel(WqI18n.a("MI.SelectConstituentPanel.Label.AvailableConstituents").getText());
        object.setSelectedListLabel(WqI18n.a("MI.SelectConstituentPanel.Label.SelectedConstituents").getText());
        object2 = object2.getConstituentList();
        object2 = object2.stream().filter(constituent -> constituent.getIsInjected()).collect(Collectors.toList());
        object2 = new ArrayList(object2);
        WQMassInjectionSiteData cfr_ignored_0 = (WQMassInjectionSiteData)serializable.getSiteData();
        Object object3 = serializable.getConstituents();
        object2.removeAll((Collection<?>)object3);
        object.setData((List)object2, (List)object3);
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        object = object.getSelectedObjectsList();
        object2 = new ConstituentComparator();
        Collections.sort(object, object2);
        boolean bl = selectConstituentTopPanel.addToAllSites();
        if (bl) {
            MassInjectionSummaryTreeNode massInjectionSummaryTreeNode = (MassInjectionSummaryTreeNode)this._treeModel.getRoot();
            int n = massInjectionSummaryTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                object3 = (MassInjectSiteTreeNode)massInjectionSummaryTreeNode.getChildAt(i);
                ((MassInjectSiteTreeNode)object3).setConstituents(new ArrayList<Constituent>((Collection<Constituent>)object));
                Object[] objectArray = ((DefaultMutableTreeNode)object3).getPath();
                this.getTreeView().a().expandPath(new TreePath(objectArray));
                this._treeModel.nodeStructureChanged((TreeNode)object3);
            }
        } else {
            serializable.setConstituents((List<Constituent>)object);
            this._treeModel.nodeStructureChanged((TreeNode)((Object)serializable));
            Object[] objectArray = serializable.getPath();
            this.getTreeView().a().expandPath(new TreePath(objectArray));
            serializable = (MassInjectSiteSummaryPanel)serializable.getComponent();
            ((MassInjectSiteSummaryPanel)serializable).updatePanel();
        }
        this.setModified(true);
    }

    private void summaryTreeNodePopup(Point point, JTree jTree) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = WqI18n.a("MI.MassInjectionEditor.Menu.CollapseAll").createMenuItem();
        jMenuItem.addActionListener(actionEvent -> this.collapseTreeNodesAction());
        jPopupMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("MI.MassInjectionEditor.Menu.ExpandAll").createMenuItem();
        jMenuItem.addActionListener(actionEvent -> this.expandAllTreeNodesAction());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(jTree, point.x, point.y);
    }

    private void expandAllTreeNodesAction() {
        JTree jTree = this.getTreeView().a();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode));
    }

    private void expandAll(JTree jTree, TreePath treePath) {
        Object object = (TreeNode)treePath.getLastPathComponent();
        if (object.getChildCount() >= 0) {
            object = object.children();
            while (object.hasMoreElements()) {
                Object object2 = (TreeNode)object.nextElement();
                object2 = treePath.pathByAddingChild(object2);
                this.expandAll(jTree, (TreePath)object2);
            }
        }
        jTree.expandPath(treePath);
    }

    private void collapseTreeNodesAction() {
        JTree jTree = this.getTreeView().a();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.collapseAll(jTree, new TreePath(treeNode));
    }

    private void collapseAll(JTree jTree, TreePath treePath) {
        Object object = (TreeNode)treePath.getLastPathComponent();
        if (object.getChildCount() >= 0) {
            object = object.children();
            while (object.hasMoreElements()) {
                Object object2 = (TreeNode)object.nextElement();
                object2 = treePath.pathByAddingChild(object2);
                this.collapseAll(jTree, (TreePath)object2);
            }
        }
        if (treePath.getPathCount() > 1) {
            jTree.collapsePath(treePath);
        }
    }

    public String getTabname() {
        return this._tabName;
    }

    public void fillPanel(NamedType object) {
        this._currentMiMgr = null;
        if (object instanceof ManagerProxyWrapper) {
            this.setEnabled(true);
            object = (ManagerProxyWrapper)((Object)object);
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            object = (MassInjectionSetManager)object.loadManager(null, null);
            this._currentMiMgr = object;
            Object object2 = this._currentMiMgr.getGeometry();
            Object object3 = this._currentMiMgr.getConstituentSet();
            WQConstituentSet wQConstituentSet = null;
            if (object3 != null) {
                wQConstituentSet = (WQConstituentSet)object3.getSet();
            }
            if ((object = (WQMassInjectionSet)((MassInjectionSetManager)object).getSet()) == null) {
                return;
            }
            object3 = null;
            if (object2 != null) {
                object3 = object2.getRssWqGeometry();
            }
            object2 = null;
            if (this._massInjectionMgr != null) {
                object2 = this._massInjectionMgr.getMassInjectionSites();
            }
            this._treeModel = new MassInjectionTreeModel((RssWQGeometry)object3, wQConstituentSet, (WQMassInjectionSet)object, (List<WQMassInjectionSite>)object2);
            object2 = new ArrayList(object2);
            object = object.getMassInjectionSiteList((List)object2);
            object = new ArrayList(object);
            RMASort.quickSort(object);
            MassInjectionPanel massInjectionPanel = this;
            massInjectionPanel.setData(massInjectionPanel._treeModel);
            this.getTreeView().a().removeMouseListener(this._popupMouseAdapter);
            this.getTreeView().a().addMouseListener(this._popupMouseAdapter);
            this.getTreeView().a().removeTreeWillExpandListener(this._rootNodeCantCollapse);
            this.getTreeView().a().addTreeWillExpandListener(this._rootNodeCantCollapse);
            this.getTreeView().a().removeTreeSelectionListener(this._treeSelectionListener);
            this.getTreeView().a().addTreeSelectionListener(this._treeSelectionListener);
            this._treeSelectorPanel.setSelectionList((Collection)object);
        }
    }

    @Override
    protected ViewDisplayHeader$VisibleRule getHeaderVisibleRule() {
        return new MassInjectionPanel$HeaderPanelVisibleRule();
    }

    public boolean savePanel(NamedType namedType) {
        MassInjectionSetManager massInjectionSetManager = this._currentMiMgr;
        if (namedType instanceof MassInjectionSetManager) {
            massInjectionSetManager = (MassInjectionSetManager)namedType;
        }
        if (massInjectionSetManager == null) {
            return true;
        }
        this._treeModel.saveModel((JComponent)((Object)this), massInjectionSetManager);
        return true;
    }

    public void setDisplayUnitsSystem(int n) {
        if (this._treeModel != null) {
            this._treeModel.setDisplayUnitsSystem(n);
        }
    }

    public void setSelectedMassInjectionSite(WQMassInjectionSite object) {
        if (object == null) {
            return;
        }
        MassInjectionSummaryTreeNode massInjectionSummaryTreeNode = (MassInjectionSummaryTreeNode)this._treeModel.getRoot();
        object = massInjectionSummaryTreeNode.getNodeForSite((WQMassInjectionSite)object);
        if (object != null) {
            object = ((DefaultMutableTreeNode)object).getPath();
            object = new TreePath((Object[])object);
            EventQueue.invokeLater(() -> this.lambda$setSelectedMassInjectionSite$5((TreePath)object));
        }
    }

    public void siteNodeChanged(WQMassInjectionSite object) {
        if (object == null) {
            return;
        }
        MassInjectionSummaryTreeNode massInjectionSummaryTreeNode = (MassInjectionSummaryTreeNode)this._treeModel.getRoot();
        object = massInjectionSummaryTreeNode.getNodeForSite((WQMassInjectionSite)object);
        if (object != null) {
            this._treeModel.nodeChanged((TreeNode)object);
        }
    }

    public void removeMassInjectionSite(WQMassInjectionSite wQMassInjectionSite) {
        this._treeModel.removeMassInjectionSite(wQMassInjectionSite);
    }

    public void clearPerformed() {
        if (this.getTreeView() != null && this.getTreeView().a() != null) {
            this.getTreeView().a().setModel(new MassInjectionTreeModel(null, null, null, null));
            super.clearPanel();
        }
    }

    public void setSites(List<MassInjectionSite> object) {
        Serializable serializable;
        TreePath treePath = null;
        if (this.getTreeView() != null) {
            serializable = this.getTreeView().a();
            treePath = serializable.getSelectionPath();
        }
        this._treeModel.setSites((List<MassInjectionSite>)object);
        RMASort.quickSort(object);
        serializable = (MassInjectionSummaryTreeNode)this._treeModel.getRoot();
        object = ((MassInjectionSummaryTreeNode)serializable).getSiteNodes();
        object = object.stream().map(massInjectSiteTreeNode -> massInjectSiteTreeNode.getSite()).collect(Collectors.toList());
        this._treeSelectorPanel.setSelectionList(object);
        object = treePath;
        EventQueue.invokeLater(() -> this.lambda$setSites$7((TreePath)object));
    }

    private void updatePanelAndSelectedPath(TreePath object) {
        JTree jTree;
        if (object != null) {
            jTree = this.getTreeView().a();
            jTree.setSelectionPath((TreePath)object);
        }
        if (this.getTreeView() != null && (object = (jTree = this.getTreeView().a()).getSelectionPath()) != null && (object = ((TreePath)object).getLastPathComponent()) instanceof MassInjectionSummaryTreeNode && (object = (MassInjectionSetPanel)((Object)((MassInjectionSummaryTreeNode)object).getComponent())) != null) {
            ((MassInjectionSetPanel)((Object)object)).updatePanel();
        }
    }

    public List<MassInjectSiteTreeNode> getSiteNodes() {
        return this._treeModel.getSiteNodes();
    }

    private /* synthetic */ void lambda$setSites$7(TreePath treePath) {
        this.updatePanelAndSelectedPath(treePath);
    }

    private /* synthetic */ void lambda$setSelectedMassInjectionSite$5(TreePath treePath) {
        this.getTreeView().a().setSelectionPath(treePath);
    }
}

