/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.massinjection.MassInjectSiteTreeNode;
import hec.rss.wq.client.massinjection.MassInjectionSummaryTreeNode;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSiteData;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.util.RMASort;

public class MassInjectionTreeModel
extends DefaultTreeModel
implements PropertyChangeListener {
    private RssWQGeometry _geo;
    private WQConstituentSet _constituentSet;
    private WQMassInjectionSet _miSet;
    private List<MassInjectionSite> _allSites;

    public MassInjectionTreeModel(RssWQGeometry rssWQGeometry, WQConstituentSet wQConstituentSet, WQMassInjectionSet wQMassInjectionSet, List<WQMassInjectionSite> list) {
        super(wQMassInjectionSet != null ? new MassInjectionSummaryTreeNode(wQMassInjectionSet.getName(), rssWQGeometry, wQConstituentSet, wQMassInjectionSet) : new DefaultMutableTreeNode());
        this._geo = rssWQGeometry;
        this._constituentSet = wQConstituentSet;
        this._miSet = wQMassInjectionSet;
        if (list != null) {
            this._allSites = new ArrayList<WQMassInjectionSite>(list);
        }
        if (this._miSet != null && this._constituentSet != null) {
            this.buildTree();
        }
    }

    private void buildTree() {
        Object object = this._miSet.getMassInjectionSiteList(this._allSites);
        RMASort.quickSort((List)object);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (WQMassInjectionSite)object.next();
            WQMassInjectionSiteData wQMassInjectionSiteData = (WQMassInjectionSiteData)this._miSet.getMassInjectionSiteData((MassInjectionSite)object2);
            object2 = new MassInjectSiteTreeNode((WQMassInjectionSite)object2, this._miSet, this._constituentSet, wQMassInjectionSiteData);
            defaultMutableTreeNode.add((MutableTreeNode)object2);
        }
        this._miSet.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public boolean saveModel(JComponent jComponent, MassInjectionSetManager object) {
        TreeNode treeNode = (TreeNode)this.getRoot();
        int n = treeNode.getChildCount();
        WQMassInjectionSet wQMassInjectionSet = null;
        if (object != null) {
            wQMassInjectionSet = (WQMassInjectionSet)((MassInjectionSetManager)object).getSet();
        }
        object = this.getSiteNodes();
        object = object.stream().map(massInjectSiteTreeNode -> massInjectSiteTreeNode.getSite()).collect(Collectors.toList());
        ArrayList arrayList = new ArrayList(object);
        for (int i = 0; i < n; ++i) {
            object = (MassInjectSiteTreeNode)treeNode.getChildAt(i);
            try {
                ((MassInjectSiteTreeNode)object).validateData();
                ((MassInjectSiteTreeNode)object).save(wQMassInjectionSet);
                continue;
            }
            catch (IOException iOException) {
                object = WqI18n.a("IC.TreeNode.Reservoirs.Msg.SaveFailed.Title").format((Object)((DefaultMutableTreeNode)object).toString());
                JOptionPane.showMessageDialog(jComponent, iOException.getMessage(), (String)object, 0);
                return false;
            }
        }
        wQMassInjectionSet.setMassInjectionSiteList(arrayList);
        return true;
    }

    public boolean removeMassInjectionSite(WQMassInjectionSite wQMassInjectionSite) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            MassInjectSiteTreeNode massInjectSiteTreeNode = (MassInjectSiteTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (massInjectSiteTreeNode.getSite() != wQMassInjectionSite) continue;
            new TreePath(massInjectSiteTreeNode.getPath());
            int n2 = defaultMutableTreeNode.getIndex(massInjectSiteTreeNode);
            defaultMutableTreeNode.remove(massInjectSiteTreeNode);
            MassInjectionTreeModel massInjectionTreeModel = this;
            massInjectionTreeModel.nodesWereRemoved(massInjectionTreeModel.root, new int[]{n2}, new Object[]{massInjectSiteTreeNode});
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent serializable) {
        if ("siteadded".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
            serializable = (Integer)((PropertyChangeEvent)serializable).getNewValue();
            if ((serializable = (WQMassInjectionSite)this._miSet.getMassInjectionSite(((Integer)serializable).intValue(), this._allSites)) != null) {
                WQMassInjectionSiteData wQMassInjectionSiteData = (WQMassInjectionSiteData)this._miSet.getMassInjectionSiteData((MassInjectionSite)serializable);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
                serializable = new MassInjectSiteTreeNode((WQMassInjectionSite)serializable, this._miSet, this._constituentSet, wQMassInjectionSiteData);
                defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
                new TreePath(((DefaultMutableTreeNode)serializable).getPath());
                int n = defaultMutableTreeNode.getIndex((TreeNode)((Object)serializable));
                this.nodesWereInserted(defaultMutableTreeNode, new int[]{n});
            }
        }
    }

    public void setDisplayUnitsSystem(int n) {
        TreeNode treeNode = (TreeNode)this.getRoot();
        int n2 = treeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            MassInjectSiteTreeNode massInjectSiteTreeNode = (MassInjectSiteTreeNode)treeNode.getChildAt(i);
            if (!massInjectSiteTreeNode.hasComponent()) continue;
            massInjectSiteTreeNode.setDisplayUnitsSystem(n);
        }
    }

    public void setSites(List<MassInjectionSite> list) {
        int n;
        Object object;
        if (list == null) {
            return;
        }
        ArrayList<MassInjectSiteTreeNode> arrayList = new ArrayList<MassInjectSiteTreeNode>();
        WQMassInjectionSiteData wQMassInjectionSiteData = list.iterator();
        MassInjectionSummaryTreeNode massInjectionSummaryTreeNode = (MassInjectionSummaryTreeNode)this.getRoot();
        while (wQMassInjectionSiteData.hasNext()) {
            object = (WQMassInjectionSite)wQMassInjectionSiteData.next();
            MassInjectSiteTreeNode massInjectSiteTreeNode = massInjectionSummaryTreeNode.getNodeForSite((WQMassInjectionSite)object);
            if (massInjectSiteTreeNode == null) continue;
            arrayList.add(massInjectSiteTreeNode);
            wQMassInjectionSiteData.remove();
        }
        for (n = 0; n < list.size(); ++n) {
            object = (WQMassInjectionSite)list.get(n);
            wQMassInjectionSiteData = (WQMassInjectionSiteData)this._miSet.getMassInjectionSiteData((MassInjectionSite)object);
            object = new MassInjectSiteTreeNode((WQMassInjectionSite)object, this._miSet, this._constituentSet, wQMassInjectionSiteData);
            arrayList.add((MassInjectSiteTreeNode)object);
        }
        RMASort.quickSort(arrayList);
        massInjectionSummaryTreeNode.removeAllChildren();
        for (n = 0; n < arrayList.size(); ++n) {
            massInjectionSummaryTreeNode.add((MutableTreeNode)arrayList.get(n));
        }
        EventQueue.invokeLater(() -> this.nodeStructureChanged(massInjectionSummaryTreeNode));
    }

    public List<MassInjectSiteTreeNode> getSiteNodes() {
        new ArrayList();
        MassInjectionSummaryTreeNode massInjectionSummaryTreeNode = (MassInjectionSummaryTreeNode)this.getRoot();
        return massInjectionSummaryTreeNode.getSiteNodes();
    }
}

