/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.massinjection;

import hec.gui.NameDialog;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.rss.model.JunctionElement;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class PlaceMassInjectionSiteDialog
extends NameDialog {
    private RmaJComboBox _locationCombo;
    private StreamJunction _streamJunction;
    private JPanel _locationPanel;
    private JunctionElement _sysJunc;
    private StreamElement _stream;

    public PlaceMassInjectionSiteDialog(Frame frame, boolean bl, StreamElement streamElement) {
        super(frame, bl);
        this._stream = streamElement;
        this.buildControls();
    }

    protected void buildControls() {
        this.setTitle("Name new Mass Injection Site");
        this._locationPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Select the placement of the Mass Injection Site:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        this._locationPanel.add((Component)jLabel, gridBagConstraints);
        this._locationCombo = new RmaJComboBox();
        this._locationCombo.setToolTipText(null);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        this._locationPanel.add((Component)this._locationCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._locationPanel, gridBagConstraints);
        this.pack();
        this.setLocation();
    }

    public void setJunctions(StreamJunction streamJunction, JunctionElement junctionElement) {
        this._streamJunction = streamJunction;
        this._sysJunc = junctionElement;
        if (streamJunction == null && junctionElement == null) {
            this._locationCombo.setModel((ComboBoxModel)new RmaListModel(true));
            return;
        }
        RmaListModel rmaListModel = new RmaListModel(false);
        if (streamJunction != null) {
            rmaListModel.addElement((Object)"At the Stream Junction");
            Vector vector = new Vector();
            streamJunction.getInflowingStreams(vector);
            for (int i = 0; i < vector.size(); ++i) {
                rmaListModel.addElement(vector.get(i));
            }
            vector.clear();
            streamJunction.getOutflowingStreams(vector);
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                if (rmaListModel.contains(e)) continue;
                rmaListModel.addElement(e);
            }
        }
        if (junctionElement != null) {
            rmaListModel.addElement((Object)"At the Network Junction");
        }
        rmaListModel.addElement((Object)("Closest Water Quality Cell on the " + String.valueOf(this._stream)));
        this._locationCombo.setModel((ComboBoxModel)rmaListModel);
    }

    public Object getSelectedObject() {
        Object object = this._locationCombo.getSelectedItem();
        if (object instanceof StreamElement) {
            return object;
        }
        if ("At the Stream Junction".equals(object)) {
            return this._streamJunction;
        }
        if ("At the Network Junction".equals(object)) {
            return this._sysJunc;
        }
        return null;
    }
}

