/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.metstation;

import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CRSException;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.geometry.GeometryMapGlyph;
import hec.rss.wq.client.metstation.AbstractMetStationSetGlyph$Circle;
import hec.rss.wq.client.metstation.AbstractMetStationSetGlyph$Diamond;
import hec.rss.wq.client.metstation.AbstractMetStationSetGlyph$HalfDiamondLeft;
import hec.rss.wq.client.metstation.AbstractMetStationSetGlyph$HalfDiamondRight;
import hec.rss.wq.client.metstation.AbstractMetStationSetGlyph$OpenMetEditorAction;
import hec.rss.wq.client.metstation.StationSetDrawPropData;
import hec.rss.wq.model.MetData;
import hec.wqengineimpl.metstation.WQMetStation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Action;
import rma.swing.event.ReflectMultiListener;

public abstract class AbstractMetStationSetGlyph
extends MapGlyph {
    private static final int STATION_ICON_WIDTH = 25;
    private static final Shape HALF_DIAMOND_LEFT = new AbstractMetStationSetGlyph$HalfDiamondLeft(25.0, 25.0);
    private static final Shape HALF_DIAMOND_RIGHT = new AbstractMetStationSetGlyph$HalfDiamondRight(25.0, 25.0);
    private static final Shape DIAMOND = new AbstractMetStationSetGlyph$Diamond(25.0, 25.0);
    private static final Shape CIRCLE = new AbstractMetStationSetGlyph$Circle(12.0);
    private ReflectMultiListener _objectPopupListener;
    private WQMetStation _selectedStation;
    GeometryFactory _geometryFactory = new GeometryFactory();

    public AbstractMetStationSetGlyph(MapPanel mapPanel, MetData metData) {
        super(mapPanel, (MapObjectInterface)metData);
    }

    public WorldRect getBounds() {
        WorldRect worldRect = super.getBounds();
        MapScale mapScale = this._mapPanel.scale((MapGlyph)this);
        worldRect = mapScale.wr2lr(worldRect);
        worldRect.l -= 25;
        worldRect.r += 25;
        worldRect.t -= 25;
        worldRect.b += 25;
        return mapScale.lr2wr((LocalRect)worldRect);
    }

    public String getToolTipText(WorldPt worldPt, MouseEvent mouseEvent) {
        worldPt = this.getMapPanel().scale((MapGlyph)this).wp2lp(worldPt);
        if ((worldPt = this.findStation((LocalPt)worldPt)) == null) {
            return null;
        }
        return "Met Station: " + worldPt.getName();
    }

    public WQMetStation findStation(LocalPt object) {
        object = new Point2D.Double(((LocalPt)object).x, ((LocalPt)object).y);
        object = arg_0 -> this.lambda$findStation$0((Point2D)object, arg_0);
        MetData metData = (MetData)this.getMap();
        object = metData.getStations((Predicate<WQMetStation>)object);
        if (!object.isEmpty()) {
            return (WQMetStation)object.get(0);
        }
        return null;
    }

    public List<Action> getMenuActions(LocalPt object) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        object = new Point2D.Double(((LocalPt)object).x, ((LocalPt)object).y);
        object = arg_0 -> this.lambda$getMenuActions$1((Point2D)object, arg_0);
        MetData metData = (MetData)this.getMap();
        object = metData.getStations((Predicate<WQMetStation>)object);
        if (object == null || object.isEmpty()) {
            return arrayList;
        }
        if ((object = (WQMetStation)object.get(0)).isMetStation()) {
            object = new AbstractMetStationSetGlyph$OpenMetEditorAction(this);
            arrayList.add((Action)object);
        }
        return arrayList;
    }

    private Shape computeLocalBoundGeometry(WQMetStation object) {
        if (object == null) {
            return new ShapeWriter().toShape((Geometry)this._geometryFactory.createPoint(new Coordinate(0.0, 0.0)));
        }
        Object object2 = object.getGeometry().getCentroid();
        object2 = this.getMapPanel().scale((MapGlyph)this).wp2lp(new WorldPt(object2.getX(), object2.getY()));
        object.getGeometry();
        object = this.stationToShape((WQMetStation)object);
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = object2.x;
        nArray2[1] = object2.y;
        object2 = AffineTransform.getTranslateInstance(nArray2[0] - 12, nArray2[1] - 12);
        object = object2.createTransformedShape((Shape)object);
        return object;
    }

    protected abstract Predicate<WQMetStation> stationDrawQuery();

    private Shape stationToShape(WQMetStation wQMetStation) {
        if (wQMetStation.isMetStation() && !wQMetStation.isObserved()) {
            return DIAMOND;
        }
        if (wQMetStation.isMetStation() && wQMetStation.isObserved()) {
            return HALF_DIAMOND_RIGHT;
        }
        return null;
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        Font font;
        Object object = (GeometryMapGlyph)this.getMapPanel().findGlyphOfClass(GeometryMapGlyph.class, true);
        RssSystem rssSystem = null;
        RssSystemGlyph rssSystemGlyph = null;
        if (object != null) {
            rssSystemGlyph = ((GeometryMapGlyph)((Object)object)).getSystemGlyph();
            object = rssSystemGlyph.getMap();
            rssSystem = (RssSystem)object;
        }
        object = (MetData)this.getMap();
        object = ((MetData)object).getMetStationSet().getStations(this.stationDrawQuery());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        WorldPt worldPt = new WorldPt();
        int[] nArray = new int[2];
        Color color = new Color(162, 94, 200);
        int n = WaterQualityDPData.b();
        StationSetDrawPropData stationSetDrawPropData = StationSetDrawPropData.b(n);
        if (stationSetDrawPropData != null) {
            color = stationSetDrawPropData.getMetStationColor();
        }
        if ((font = stationSetDrawPropData.getNameFont()) == null) {
            font = new Font("SansSerif", 0, 10);
        }
        object = object.iterator();
        while (object.hasNext()) {
            WQMetStation wQMetStation = (WQMetStation)object.next();
            arrayList.clear();
            arrayList2.clear();
            if (!wQMetStation.isActive()) continue;
            Object object2 = wQMetStation.getGeometry();
            Shape shape = this.stationToShape(wQMetStation);
            try {
                object2 = object2.getCentroid();
                worldPt.e = object2.getX();
                worldPt.n = object2.getY();
                object2 = this.transformPointToLocal(worldPt);
                nArray[0] = object2.x;
                nArray[1] = object2.y;
            }
            catch (CRSException cRSException) {
                object2 = cRSException;
                cRSException.printStackTrace();
                return;
            }
            object2 = AffineTransform.getTranslateInstance(nArray[0] - 12, nArray[1] - 12);
            object2 = object2.createTransformedShape(shape);
            graphics.setColor(color);
            if (this._selectedStation != null && this._selectedStation.equals(wQMetStation)) {
                graphics.setColor(Color.yellow);
                ((Graphics2D)graphics).fill((Shape)object2);
                graphics.setColor(Color.black);
                ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f));
                ((Graphics2D)graphics).draw((Shape)object2);
            } else {
                ((Graphics2D)graphics).fill((Shape)object2);
            }
            if (rssSystem != null && (object2 = rssSystem.findJunction(worldPt, 5.0)) != null) {
                rssSystemGlyph.drawJunction(graphics, mapScale, (JunctionElement)object2);
            }
            float f = this._glyphLevel + 0.5f;
            if (!stationSetDrawPropData.isDrawName()) continue;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(wQMetStation.getName(), nArray[0], nArray[1], 0, 16, f, font, Color.black, null, false, graphics));
        }
    }

    public void setSelectedStation(WQMetStation wQMetStation) {
        this._selectedStation = wQMetStation;
    }

    WQMetStation getSelectedStation() {
        return this._selectedStation;
    }

    private /* synthetic */ boolean lambda$getMenuActions$1(Point2D point2D, WQMetStation wQMetStation) {
        return this.computeLocalBoundGeometry(wQMetStation).contains(point2D);
    }

    private /* synthetic */ boolean lambda$findStation$0(Point2D point2D, WQMetStation wQMetStation) {
        return this.computeLocalBoundGeometry(wQMetStation).contains(point2D);
    }
}

