/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.metstation;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.io.TimeSeriesContainer;
import hec.rss.client.RSimSimulationMode;
import hec.rss.wq.client.metstation.MetStationEditorPanel$1;
import hec.rss.wq.client.metstation.MetStationEditorPanel$2;
import hec.rss.wq.client.metstation.MetStationEditorPanel$MeridianCellRenderer;
import hec.rss.wq.client.metstation.MetStationEditorPanel$RefreshRunnable;
import hec.rss.wq.client.metstation.MetStationEditorSummaryTableModel;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.metstation.MetStation;
import hec.wqenginecore.metstation.MetVariable;
import hec.wqengineimpl.metstation.WQMetStation;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;
import rma.util.RMAIO;

public class MetStationEditorPanel
extends JPanel {
    JTable summaryTable;
    JPanel summaryTablePanel;
    JPanel summaryPlotPanel;
    ButtonGroup buttonGroup = new ButtonGroup();
    G2dPanel _g2dPanel;
    private JPanel _cardPanel;
    private RmaJDecimalField _latitudeText;
    private RmaJDecimalField _longitudeText;
    private JComboBox<String[]> _meridianComboBox;
    private RmaJDecimalField _referenceElevationDecimalField;
    private JRadioButton _stackedPlotRadioButton;
    private JRadioButton _summaryRadioButton;
    private JLabel refElevationLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    MetStation _selectedStation;
    Map<String, String[]> indexMap = new HashMap<String, String[]>();
    private static final String[][] a = new String[][]{{"-165", "165W Zone X (-11 hours)"}, {"-150", "150W Zone W (-10 hours) "}, {"-135", "135W Zone V (-9 hours)"}, {"-120", "120W Zone U (-8 hours) HEC, Davis CA"}, {"-105", "105W Zone T (-7 hours)"}, {"-90", " 90W Zone S (-6 hours)"}, {"-75", " 75W Zone R (-5 hours)"}, {"-60", " 60W Zone Q (-4 hours)"}, {"-45", " 45W Zone P (-3 hours)"}, {"-30", " 30W Zone O (-2 hours)"}, {"-15", " 15W Zone N (-1 hours)"}, {"0", "  0W Zone Z (0 hours) Greenwich Mean Time"}, {"15", " 15E Zone A (1 hours)"}, {"30", " 30E Zone B (2 hours)"}, {"45", " 45E Zone C (3 hours)"}, {"60", " 60E Zone D (4 hours)"}, {"75", " 75E Zone E (5 hours) Karachi"}, {"90", " 90E Zone F (6 hours) Dhaka"}, {"105", "105E Zone G (7 hours) Bangkok"}, {"120", "120E Zone H (8 hours) Hong Kong"}, {"135", "135E Zone I (9 hours) Tokyo"}, {"150", "150E Zone K (10 hours) AU Eastern Standard"}, {"165", "165E Zone L (11 hours)"}, {"180", "180E Zone M (12 hours) Wellington"}};

    public MetStationEditorPanel() {
        this.initComponents();
        this._g2dPanel = new G2dPanel();
        Object object = a;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = object[i];
            this.indexMap.put(stringArray[0], stringArray);
        }
        object = new DefaultComboBoxModel((E[])a);
        this._meridianComboBox.setModel((ComboBoxModel<String[]>)object);
        this._meridianComboBox.setRenderer(new MetStationEditorPanel$MeridianCellRenderer());
        this.summaryTable = new RmaJTable();
        this.summaryTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new MleHeadRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.summaryTable);
        this._meridianComboBox.setEnabled(false);
        jScrollPane.setPreferredSize(new Dimension(650, 150));
        jScrollPane.setMinimumSize(new Dimension(650, 150));
        this.summaryTablePanel = new JPanel();
        this.summaryTablePanel.setLayout(new BorderLayout());
        this.summaryTablePanel.add((Component)jScrollPane, "Center");
        this.summaryPlotPanel = new JPanel();
        this._cardPanel.add((Component)this.summaryTablePanel, "SUMMARY");
        this._cardPanel.add((Component)this.summaryPlotPanel, "PLOT");
        this.buttonGroup.add(this._stackedPlotRadioButton);
        this.buttonGroup.add(this._summaryRadioButton);
        this._stackedPlotRadioButton.setSelected(true);
        this._stackedPlotRadioButton.addActionListener(new MetStationEditorPanel$1(this));
        this._referenceElevationDecimalField.setEnabled(false);
        this._latitudeText.setEnabled(false);
        this._longitudeText.setEnabled(false);
    }

    private void initComponents() {
        this.refElevationLabel = new RmaJLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this._longitudeText = new RmaJDecimalField();
        this._latitudeText = new RmaJDecimalField();
        this._referenceElevationDecimalField = new RmaJDecimalField();
        this._referenceElevationDecimalField.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        this._meridianComboBox = new JComboBox();
        this._cardPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this._summaryRadioButton = new JRadioButton();
        this._stackedPlotRadioButton = new JRadioButton();
        this.refElevationLabel.setText("Reference Elevation (%S):");
        this.refElevationLabel.setLabelFor((Component)this._referenceElevationDecimalField);
        this.jLabel2.setText("Latitude (fractional degrees):");
        this.jLabel3.setText("Longitude (fractional degrees):");
        this.jLabel4.setText("Nearest Standard Meridian:");
        this._longitudeText.setText("rmaJDecimalField1");
        this._latitudeText.setText("rmaJDecimalField2");
        this._referenceElevationDecimalField.setText("rmaJDecimalField3");
        this._cardPanel.setLayout(new CardLayout());
        this._summaryRadioButton.setText("Summary");
        this._summaryRadioButton.addActionListener(new MetStationEditorPanel$2(this));
        this._stackedPlotRadioButton.setText("Stacked Plot");
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this._summaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._stackedPlotRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._summaryRadioButton).addComponent(this._stackedPlotRadioButton)).addGap(0, 0, Short.MAX_VALUE)));
        groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        GroupLayout groupLayout4 = groupLayout;
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.refElevationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._longitudeText, -2, 126, -2).addComponent((Component)this._latitudeText, -2, 131, -2).addComponent((Component)this._referenceElevationDecimalField, -2, 131, -2)).addContainerGap(94, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(163, 163, 163).addComponent(this._meridianComboBox, 0, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this._cardPanel, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addGap(10, 10, 10)));
        groupLayout.linkSize(0, new Component[]{this._latitudeText, this._longitudeText, this._referenceElevationDecimalField});
        GroupLayout groupLayout5 = groupLayout;
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refElevationLabel).addComponent((Component)this._referenceElevationDecimalField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this._latitudeText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this._longitudeText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this._meridianComboBox, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._cardPanel, -1, -1, Short.MAX_VALUE).addGap(8, 8, 8)));
    }

    private void _summaryRadioButtonActionPerformed(ActionEvent actionEvent) {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "SUMMARY");
    }

    private void stackedPlotRadioButtonActionPerformed() {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "PLOT");
    }

    public void fillPanel(MetStation metStation) {
        this._selectedStation = metStation;
        this.clearPanel();
        if (this._selectedStation == null) {
            return;
        }
        String string = Double.toString(metStation.getLatitude());
        this._latitudeText.setText(string);
        string = Double.toString(metStation.getLongitude());
        this._longitudeText.setText(string);
        string = new ParamDouble(metStation.getReferenceElevation(), Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem());
        this._referenceElevationDecimalField.setValue((ParamDouble)string);
        int n = metStation.getNearestMeridian();
        Object object = this.indexMap.get(Integer.toString(n));
        if (object != null) {
            this._meridianComboBox.setSelectedItem(object);
        }
        this._summaryRadioButton.setSelected(true);
        this.summaryPlotPanel.setLayout(new BorderLayout());
        object = new JScrollPane((Component)this._g2dPanel);
        this.summaryPlotPanel.add((Component)object, "Center");
        MetStationEditorPanel metStationEditorPanel = this;
        metStationEditorPanel.fillSummaryTable(metStationEditorPanel._selectedStation);
        MetStationEditorPanel metStationEditorPanel2 = this;
        metStationEditorPanel2.plotTimeSeries(metStationEditorPanel2._selectedStation);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            MetStationEditorPanel metStationEditorPanel = this;
            metStationEditorPanel.plotTimeSeries(metStationEditorPanel._selectedStation);
        }
        super.setVisible(bl);
    }

    private void clearPanel() {
        this._longitudeText.setText("");
        this._latitudeText.setText("");
        this._referenceElevationDecimalField.setText("");
        this._meridianComboBox.setSelectedIndex(-1);
    }

    public void validatePanel() throws IOException {
    }

    public void savePanel() throws IOException {
        if (this._selectedStation instanceof WQMetStation) {
            WQMetStation wQMetStation = (WQMetStation)this._selectedStation;
            wQMetStation.setReferenceElevation(RMAIO.parseDouble((String)this._referenceElevationDecimalField.getText(), (double)0.0));
            wQMetStation.setLongitude(RMAIO.parseDouble((String)this._longitudeText.getText(), (double)0.0));
            wQMetStation.setLatitude(RMAIO.parseDouble((String)this._latitudeText.getText(), (double)0.0));
            String[] stringArray = (String[])this._meridianComboBox.getSelectedItem();
            if (stringArray != null) {
                wQMetStation.setNearestMeridian(RMAIO.parseInt((String)stringArray[0], (int)0));
            } else {
                wQMetStation.setNearestMeridian(0);
            }
        }
        SwingUtilities.invokeLater(new MetStationEditorPanel$RefreshRunnable(this));
    }

    private void fillSummaryTable(MetStation metStation) {
        MetStationEditorSummaryTableModel metStationEditorSummaryTableModel = new MetStationEditorSummaryTableModel();
        metStationEditorSummaryTableModel.setMetStation(metStation);
        this.summaryTable.setModel(metStationEditorSummaryTableModel);
    }

    private void plotTimeSeries(MetStation object) {
        DataSource dataSource;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this._g2dPanel.setVisible(false);
        PlotLayout plotLayout = new PlotLayout();
        if (object == null) {
            return;
        }
        MessageFormat messageFormat = new MessageFormat("{0}\n({1})");
        object = object.getVariables();
        Object object6 = null;
        Object object7 = object.iterator();
        while (object7.hasNext()) {
            object5 = (MetVariable)object7.next();
            object4 = object5.getDataSources();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (Data)object3.next();
                if (!object2.getName().equals(object5.getSelectedDataSourceName()) || !((dataSource = DataSourceFactory.a((Data)object2)) instanceof TimeSeriesDataSource) || (dataSource = ((TimeSeriesDataSource)dataSource).getTimeWindow()) == null) continue;
                if (object6 == null) {
                    object6 = dataSource;
                    continue;
                }
                if (dataSource.getStartDate().before(object6.getStartDate())) {
                    object6.setStartDate(dataSource.getStartDate());
                }
                if (!dataSource.getEndDate().after(object6.getEndDate())) continue;
                object6.setEndDate(dataSource.getEndDate());
            }
        }
        object7 = ClientApp.frame().getCurrentMode();
        if (object7 instanceof RSimSimulationMode && (object5 = ((RSimSimulationMode)object7).getSimTimeWindow()) != null) {
            object6 = object5;
        }
        object5 = object.iterator();
        while (object5.hasNext()) {
            object4 = (MetVariable)object5.next();
            object3 = object4.getDataSources();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                dataSource = (Data)object2.next();
                if (!dataSource.getName().equals(object4.getSelectedDataSourceName()) || !((dataSource = DataSourceFactory.a((Data)dataSource)) instanceof TimeSeriesDataSource)) continue;
                if (object6 != null) {
                    object7 = new ParameterMap();
                    object7.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, object6);
                    object = ((TimeSeriesDataSource)dataSource).getTimeSeries((ParameterMap)object7);
                } else {
                    object = ((TimeSeriesDataSource)dataSource).getTimeSeries();
                }
                if (object.isEmpty()) continue;
                object7 = plotLayout.addViewport();
                object = object.iterator();
                while (object.hasNext()) {
                    object3 = (TimeSeriesContainer)object.next();
                    TimeSeriesDataSet timeSeriesDataSet = new TimeSeriesDataSet((TimeSeriesContainer)object3);
                    timeSeriesDataSet.setName(dataSource.getName());
                    timeSeriesDataSet.setName(object4.getType() + " - " + dataSource.getName());
                    object7.setAxisLabel("Y1", messageFormat.format(new String[]{object4.getType(), ((TimeSeriesContainer)object3).units}));
                    object7.addCurve("Y1", (Object)timeSeriesDataSet);
                    object7.setAxisName("Y1", messageFormat.format(new String[]{object4.getType(), ((TimeSeriesContainer)object3).units}));
                }
            }
        }
        this._g2dPanel.buildComponents(plotLayout);
        MetStationEditorPanel metStationEditorPanel = this;
        object5 = metStationEditorPanel.collectLabels((Container)metStationEditorPanel._g2dPanel);
        object4 = object5.iterator();
        while (object4.hasNext()) {
            object3 = (G2dLabel)object4.next();
            object2 = object3.getProperties();
            object2.setMaxFontSize(12);
            object2.setFontSize(12);
            object2.setMinFontSize(12);
            object3.setProperties((G2dLabelDrawProp)object2);
        }
        this._g2dPanel.setVisible(true);
        this._g2dPanel.revalidate();
    }

    private List<G2dLabel> collectLabels(Container componentArray) {
        ArrayList<G2dLabel> arrayList = new ArrayList<G2dLabel>();
        Component[] componentArray2 = componentArray.getComponents();
        componentArray = componentArray2;
        componentArray = componentArray2;
        int n = componentArray2.length;
        for (int i = 0; i < n; ++i) {
            Component component = componentArray[i];
            if (component instanceof G2dLabel) {
                arrayList.add((G2dLabel)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            arrayList.addAll(this.collectLabels((Container)component));
        }
        return arrayList;
    }
}

