/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.metstation;

import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.metstation.MetStation;
import hec.wqenginecore.metstation.MetVariable;
import javax.swing.table.AbstractTableModel;
import rma.util.RMAIO;

public class MetStationEditorSummaryTableModel
extends AbstractTableModel {
    private static final String[] a = new String[]{"Variable", "Data Source", "Value or Pathname"};
    private MetStation _station;

    public void setMetStation(MetStation metStation) {
        this._station = metStation;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this._station.getVariables().size();
    }

    @Override
    public int getColumnCount() {
        return a.length;
    }

    @Override
    public String getColumnName(int n) {
        return a[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MetVariable metVariable = (MetVariable)this._station.getVariables().get(n);
        if (n2 == 0) {
            return metVariable.getType();
        }
        if (n2 == 1) {
            String string = metVariable.getSelectedDataSourceName();
            if (string != null) {
                return string;
            }
            return "";
        }
        if (n2 == 2) {
            Object object = metVariable.getDataSources();
            object = object.iterator();
            while (object.hasNext()) {
                Data data = (Data)object.next();
                if (!data.getName().equals(metVariable.getSelectedDataSourceName())) continue;
                metVariable = data;
                if (!(metVariable instanceof TableData)) {
                    if (metVariable instanceof ConstantData) {
                        double d = ((ConstantData)metVariable).getConstantValue();
                        return RMAIO.toTable((double)d);
                    }
                    if (metVariable instanceof ElevationData) {
                        return RMAIO.toTable((double)((ElevationData)metVariable).getElevation());
                    }
                    if (metVariable instanceof DssData) {
                        return ((DssData)metVariable).getDssFilePath();
                    }
                    if (metVariable instanceof ExcelData) {
                        return ((ExcelData)metVariable).getExcelFilePath() + ":" + ((ExcelData)metVariable).getWorksheetName();
                    }
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }
}

