/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.metstation;

import hec.lang.NamedType;
import hec.map.LayerSelectionFactory;
import hec.map.LocalPt;
import hec.map.MapPanel;
import hec.rss.wq.client.metstation.AbstractMetStationSetGlyph;
import hec.rss.wq.client.metstation.MetStationMapGlyphSelection;
import hec.rss.wq.client.observeddataset.ObsStationMapGlyph;
import hec.rss.wq.model.MetData;
import hec.wqengineimpl.metstation.WQMetStation;
import hec.wqengineimpl.observed.WQObsStation;
import java.awt.Component;
import java.util.function.Predicate;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rma.swing.RmaJMenuLabel;

public class MetStationMapGlyph
extends AbstractMetStationSetGlyph {
    public MetStationMapGlyph(MapPanel mapPanel, MetData metData) {
        super(mapPanel, metData);
    }

    @Override
    protected Predicate<WQMetStation> stationDrawQuery() {
        return wQMetStation -> wQMetStation.isMetStation();
    }

    public NamedType objectSelect(LocalPt localPt, int n) {
        MetStationMapGlyph metStationMapGlyph = (MetStationMapGlyph)this._mapPanel.findGlyphOfClass(MetStationMapGlyph.class, true);
        if (metStationMapGlyph != null) {
            this.setSelectedStation(metStationMapGlyph.findStation(localPt));
            this._mapPanel.paintMap();
        }
        return super.objectSelect(localPt, n);
    }

    public boolean objectPopupMenu(LocalPt localPt, int n) {
        ObsStationMapGlyph obsStationMapGlyph = (ObsStationMapGlyph)this._mapPanel.findGlyphOfClass(ObsStationMapGlyph.class, true);
        this.findStation(localPt);
        WQObsStation wQObsStation = null;
        WQMetStation wQMetStation = this.findStation(localPt);
        if (obsStationMapGlyph != null) {
            wQObsStation = obsStationMapGlyph.findStation(localPt);
        }
        boolean bl = this.handlePopupMenu(localPt, obsStationMapGlyph, wQMetStation, wQObsStation);
        this.handleStationSelected(obsStationMapGlyph, wQMetStation, wQObsStation);
        return bl;
    }

    private boolean handlePopupMenu(LocalPt localPt, ObsStationMapGlyph obsStationMapGlyph, WQMetStation object, WQObsStation wQObsStation) {
        boolean bl = false;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (object != null) {
            object = new RmaJMenuLabel(object.getName());
            jPopupMenu.add((JMenuItem)object);
            jPopupMenu.addSeparator();
            object = this.getMenuActions(localPt);
            object = object.iterator();
            while (object.hasNext()) {
                Action action = (Action)object.next();
                jPopupMenu.add(action);
            }
            bl = true;
        }
        if (wQObsStation != null) {
            object = new RmaJMenuLabel(wQObsStation.getName());
            jPopupMenu.add((JMenuItem)object);
            jPopupMenu.addSeparator();
            object = obsStationMapGlyph.getMenuActions(localPt);
            object = object.iterator();
            while (object.hasNext()) {
                Action action = (Action)object.next();
                jPopupMenu.add(action);
            }
            bl = true;
        }
        jPopupMenu.show((Component)this._mapPanel, localPt.x, localPt.y);
        return bl;
    }

    private void handleStationSelected(ObsStationMapGlyph obsStationMapGlyph, WQMetStation wQMetStation, WQObsStation wQObsStation) {
        boolean bl = false;
        WQMetStation wQMetStation2 = this.getSelectedStation();
        if (wQMetStation2 != wQMetStation) {
            this.setSelectedStation(wQMetStation);
            bl = true;
        }
        if (obsStationMapGlyph != null && (wQMetStation = obsStationMapGlyph.getSelectedStation()) != wQObsStation) {
            obsStationMapGlyph.setSelectedStation(wQObsStation);
            bl = true;
        }
        if (bl) {
            this._mapPanel.paintMap();
        }
    }

    static {
        LayerSelectionFactory.addMapping((String)MetStationMapGlyph.class.getName(), (String)MetStationMapGlyphSelection.class.getName());
    }
}

